/*
File:	qlex.pl
Date:	Mon Apr  4 15:48:05 1988
By:	Jo

Lexical entry routines for protolexicon

*/


/*
q_lexical_entry(( Item :- Definition), Result, Key) :-
	debug(3,['Trying:	',Item]),
	q_commas_to_list(Definition, List),
	q_strip_lrs(List, L1, LRs),
	q_strip_outwith_network(L1, L2, OutWith),
	q_expanded_entry(L2, L3),
	q_strip_info(L3, Ts),

The next line adds the information about the string form to the 
current list of properties

	eccs_append(Ts, OutWith, L0),
	q_add_template_equivalences([string(Item)|L0], Ts1),
	q_make_set(Ts1, TsString),
	q_delete_all(string(Item), TsString, Ts2),
	(eccs_verify(eccs_q_templates(Ts2, Struct, Morph)) ->
		eccs_q_templates(Ts2, Struct, Morph);
		eccs_error([inconsistent, set, of, templates, '$nl$'|Ts2])),
	q_apply_lexical_rules(Ts2, LRs, L4, Struct, Struct1),
	Result = basic_entry(Item, L4, Struct1, Morph),
	concat('#', Item, Key).
*/

eccs_q_strip_lrs([], [], []) :- !.
eccs_q_strip_lrs([H|T], [H|R], LRs) :- 
	eccs_not_eq(H, * _LR),
	eccs_q_strip_lrs(T, R, LRs).
eccs_q_strip_lrs([ *H|T], R, [H|LRs]) :- 
	eccs_q_strip_lrs(T, R, LRs).

eccs_q_strip_info(L, L1) :-
    eccs_q_strip_info(L, L1, []).

eccs_q_strip_info(nothing, A, A) :- !.
eccs_q_strip_info([], A, A) :- !.
eccs_q_strip_info(node(Val, L), [Val|R], A) :-
    eccs_q_strip_info(L, R, A).
eccs_q_strip_info([node(A, L)|T], [A|RT], R) :-
    eccs_q_strip_info(L, RT, RT1),
    eccs_q_strip_info(T, RT1, R).
eccs_q_strip_info([_Dim = node(A, L)|T], [A|RT], R) :-
    eccs_q_strip_info(L, RT, RT1),
    eccs_q_strip_info(T, RT1, R).
/* 

Turn a bag into a set

*/

eccs_q_make_set([], []) :- !.
eccs_q_make_set([E|T], [E|R]) :- 
    eccs_q_delete_all(E, T, T1),
    eccs_q_make_set(T1, R).

eccs_q_delete_all(_, [], []) :- !.
eccs_q_delete_all(E, [E|T], R) :- !,
    eccs_q_delete_all(E, T, R).
eccs_q_delete_all(E, [A|T], [A|R]) :- !,
    eccs_q_delete_all(E, T, R).

/*

eccs_q_add_template_equivalences(Ts, Ts2)

Ts2 possibly differs from Ts in that information about 
template equivalences is included in Ts2

?? There is a hack here, just to get the current grammar to work

*/
eccs_q_add_template_equivalences([], []) :- !.
eccs_q_add_template_equivalences([T|Ts], Ts3) :-
    (T = morphology(regular); T = morphology(strong)),
    !,
    L = [string(X), morph_stem(X), morph_root(X)], 
    eccs_q_add_template_equivalences(Ts, Ts2),
    eccs_append(L, Ts2, Ts3).
eccs_q_add_template_equivalences([T|Ts], [T|Ts2]) :-
    eccs_q_add_template_equivalences(Ts, Ts2).

eccs_pl_basic_entry(Word, Ts, Struct, File, Morph) :-
    eccs_get_from_databasef(plexical_entry, Word, basic_entry(Word, Ts, Struct, Morph), File).

eccs_q_load_and_close_lexicon(File) :-
    eccs_q_load_lexicon(File),
    eccs_q_compute_lexicon_closure(File).

eccs_q_compute_lexicon_closure :-
    eccs_q_compute_lexicon_closure(_).

eccs_q_compute_lexicon_closure(File) :-
    get_stats(Heap, Cpu),
    (pimple_keys(L), 
    eccs_q_basic_lexical_entry(Key, Word, Ts, Struct, File, Morph),
    eccs_q_lexical_closure(Key, Word, Ts, Struct, Morph, NewPhon, NewTs, NewStruct, NewMorph),
    concat('#', NewPhon, NewKey),
    eccs_note_def(NewKey, File, dict(NewPhon, NewStruct)),
    eccs_storekey(L, File, NewKey),
    fail;
    get_stats(Heap1, Cpu1),
    HTotal is Heap1 -Heap, CTotal is Cpu1 -Cpu,
    debug(1, [computed, closure, of, lexicon, HTotal, heap, CTotal, cpu])).

% eccs_q_lexical_closure(Key, Word, Ts, Struct, Morph, Word, Ts, Struct, Morph).

eccs_q_lexical_closure(Word, Ts, Struct, M, Phon, Tems, NewStruct, MOut) :-
    M = m(Cl, St0, Rt0, MS0, MR0),
    eccs_atom_to_chars(Word, Str, []),
%    atom_to_chars(St0,St,[]),
%    atom_to_chars(Rt0,Rt,[]),
%    atom_to_chars_assoc_list(MS0,MS),
%    atom_to_chars_assoc_list(MR0,MR),
%    M1 = m(Cl,St,Rt,MS,MR), 
    eccs_comp_tbl(table(Id,Tem,[],Spe,[],M,[],[]), 
		ctable(Id,Tem,[],Spe,[],M1,[],[])),
    expand_entry0(Str, PhonOut, Struct, NewStruct,Ts,Tems,Spe,[],[],M1, Hist),
/*

The following line added to allow user control of whether the closure of the 
lexicon contains the input lexicon.  JC Thu Jan 12 12:05:10 1989
This won't be expensive because the identity mapping is just computed by 
unification.

*/
    eccs_sys_if_then_else(eccs_global_variable(expanded_lexicon_contains_basic_lexicon, false),
	Hist = [_|_], true),
    eccs_chars_to_atom(PhonOut, Phon),
    eccs_global_variable(path_for_lex_symbol, Lex),
    eccs_user_term(FS, Phon),
    eccs_path_value(Lex, _Type, NewStruct, FS),
    Message = [computed, new, lexical, entry, Phon|RestMsg],
    eccs_sys_if_then_else(Hist = [], RestMsg = [], RestMsg = ['$nl$', via, tables|Hist]),
    eccs_debug(3, eccs_message(Message)).



eccs_q_test(Word) :- 
    eccs_global_variable(debugging_level, Old),
    eccs_set_variable(debugging_level, 3),
    (eccs_pl_basic_entry(Word, Ts, Struct, File, M),
    eccs_q_lexical_closure(Word, Ts, Struct, M, Phon, Tems, NewStruct, MOut),
    eccs_do_menu(more), fail;
    eccs_set_variable(debugging_level, Old)).

eccs_q_check_for_entry(Key, Phon, Struct) :-
    pimple_obj(Key, dict(Phon, Struct1)),
    verify(  eccs_user_unify(Struct, Struct1, _) ),
    variant(Struct, Struct1).
    

eccs_q_test_templates(T) :-
    eccs_q_strip_undefined(T, T1),
    eccs_q_test_templates(T1, C),
    eccs_q_inform_compat(C).


eccs_q_strip_undefined([], []) :- !.
eccs_q_strip_undefined([H|T], [H|T1]) :- 
    pimple_obj('&template', template(H, _, _)), !,
    eccs_q_strip_undefined(T, T1).
eccs_q_strip_undefined([H|T], T1) :- 
    eccs_q_strip_undefined(T, T1).


eccs_q_test_templates(T, Compatibles) :-
    findall(S, 
	(eccs_q_generate_subset(S, T), eccs_q_templates(S, M, N)), Ss),
    eccs_q_filter_subsets(Ss, Compatibles).

/*

eccs_q_generate_subset(?Subset, +Set).

Subset is a subset of Set

This is arranged not to produce duplicate subsets.  It will work in the 
reverse direction (i.e. + +) if elements are guaranteed to be in the same 
order in both sets.

*/
eccs_q_generate_subset([], []).
eccs_q_generate_subset([H|Subset], [H|T]) :-
    eccs_q_generate_subset(Subset, T).
eccs_q_generate_subset(Subset, [H|T]) :-
    eccs_q_generate_subset(Subset, T).

eccs_q_filter_subsets(List, L1) :-
    eccs_q_filter_subsets0(List, List, L0),
    eccs_q_make_set(L0, L1).

eccs_q_filter_subsets0([], L, L).
eccs_q_filter_subsets0([H|T], L, L1) :-
    eccs_member(E, L),
    eccs_q_generate_subset(H, E), eccs_not_eq(H, E), !,
    eccs_q_delete_all(H, L, L0),
    eccs_q_filter_subsets0(T, L0, L1).
eccs_q_filter_subsets0([H|T], L, L1) :-
    eccs_q_filter_subsets0(T, L, L1).

eccs_q_inform_compat([L]) :-
    eccs_message([templates, are, all, compatible]), !.
eccs_q_inform_compat([H|T]) :-
    eccs_message([the, following, subsets, of, templates, are, compatible]),
    eccs_write_list_nl([H|T]).

eccs_write_list_nl([]) :- !.
eccs_write_list_nl([H|T]) :-
    eccs_sys_write(H), eccs_sys_nl,
    eccs_write_list_nl(T).

eccs_q_system_speller("spell -b").

eccs_q_system_spell_test(Word) :-
    eccs_q_system_spell_test0(Word), !.
eccs_q_system_spell_test(Word) :- 
    eccs_warning(['WARNING:', Word, not, in, system, dictionary]).

eccs_q_system_spell_test0(Word) :-
    eccs_sys_name(Word, L),
    Command1 = "word=`echo ",
    eccs_q_system_speller(Speller),
    eccs_append(Speller, "| head -1`; test $word", Command0),
    eccs_append(" | ", Command0, Command2),
    eccs_append(L, Command2, C2),
    eccs_append(Command1, C2, C),
    \+ system(C).
