% disjunctively select members of the set of disjunctive templates and
% apply them.

apply_disj_templates([],_,[]).
apply_disj_templates([H|T],LE,[Tem|Tems]) :-
	eccs_member(Tem,H),
	apply_template(Tem,LE),
	apply_disj_templates(T,LE,Tems).

% apply a template to a lexical entry.

apply_templates(Ts, Struct) :-
    eccs_q_templates(Ts, Struct, _Morph).


% apply the obligatory lexical rules specified in a lexical entry.

apply_lexical_rules(Lex,Lex,Tems,Tems,[]).
apply_lexical_rules(Lex0,Lex,Tems0,Tems,[R0|R]) :-
	apply_lexical_rule(R0,Lex0,Lex1,Tems0,Tems1),
	apply_lexical_rules(Lex1,Lex,Tems1,Tems,R).

% apply an obligatory lexical rule specified in a lexical entry.
% subset_subtract is called instead of subset because we want to
% require that every element in In must be an element of Tems0.

apply_lexical_rule(Name,Lex0,Lex,Tems0,Tems) :-
    eccs_get_from_database(plexical_rule, Name, lr(Name, (In -> Out), InFS, OutFS)),
    eccs_user_unify(Lex0, InFS, _),
    eccs_user_unify(_, OutFS, Lex),
    eccs_subset_subtract(Tems0,In,Tems1),
    eccs_union(Tems1,Out,Tems).

% apply the closure of the tables to a lexical entry.  this code only
% generates one application at a time but will give the closure on
% backtracking due to the combination of findall, list_to_set and member.

expand_entry0(Str,Str,Lex,Lex,Tems,Tems,Spe,C,C,M, []).
expand_entry0(Str,Ph,Lex0,Lex,Tems0,Tems,Spe,C0,C,M, [(Id, LexRule)|History]) :-
	findall(Id,find_table(Id,Tems0,Spe,M),IdList),
	eccs_list_to_set(IdList,IdSet),
	eccs_member(Id,IdSet),
	apply_table(Id,Ph1,Lex0,Lex1,Tems0,Tems1,Spe,C0,C1,M, LexRule),
	eccs_q_pre_assert_check(Ph1, Tems1, Lex1, M),
	expand_entry0(Ph1,Ph,Lex1,Lex,Tems1,Tems,Spe,C1,C,M, History).

% find a table which is compatible with the lexical entry that
% subsumes no other table which is also consistent with the entry.

find_table(Id,Tem,Spe,M) :-
    eccs_get_from_database(top_table, top_table, Top),
    find_table0(Tem,Spe,M,Top,Id).

% recursively find a "most specific" table which is compatible with
% the lexical entry.  this code could be modularised considerably by
% judicious use of m_subsumes.

find_table0(Tem,Spe,m(Cl,St,Rt,MS,MR),Id0,Id) :-
    eccs_get_from_database(ctable, Id0, ctable(Id0,Tem0,D0,Spe0,C,m(Cl,St0,Rt0,MS0,MR0),_,_)),
    eccs_subset(Tem0,Tem),
    disj_subsumes(D0,[],Tem),
    term_subsumes(Spe0,Spe),
    Spe0 = Spe,
    su(St,St0),
    su(Rt,Rt0),
    sunify_assoc_list(MS0,MS),
    sunify_assoc_list(MR0,MR),
    eccs_q_morph_check_constraints(C,_),
    eccs_sys_if_then_else(eccs_verify( ( suc(Id0,IdList), eccs_member(Id1,IdList),find_table_check(Tem,Spe,m(Cl,St,Rt,MS,MR),Id1,Id))),
	(suc(Id0, IdList),
	eccs_member(Id1, IdList),
	find_table0(Tem,Spe,m(Cl,St,Rt,MS,MR),Id1,Id)),
        Id = Id0 ).

/*

find_table_check(Tem, Spe, Morph, Id0, Id)

There is a table Id0 compatible with Spe but more specific than Id

This is identical to find_table0 except that it doesn't recurse

*/
find_table_check(Tem,Spe,m(Cl,St,Rt,MS,MR),Id0,Id) :-
    eccs_get_from_database(ctable, Id0, ctable(Id0,Tem0,D0,Spe0,C,m(Cl,St0,Rt0,MS0,MR0),_,_)),
    eccs_subset(Tem0,Tem),
    disj_subsumes(D0,[],Tem),
    term_subsumes(Spe0,Spe),
    Spe0 = Spe,
    su(St,St0),
    su(Rt,Rt0),
    sunify_assoc_list(MS0,MS),
    sunify_assoc_list(MR0,MR),
    eccs_q_morph_check_constraints(C,_).

% apply table Id to the arguments from the lexical entry choosing one
% of the lexical rules to further expand the entry.

apply_table(Id,Ph,Lex0,Lex,Tems0,Tems,Spe,C0,C,m(Cl,St,Rt,MS,MR), LR0) :-
    eccs_get_from_database(ctable, Id0, ctable(Id,Tem0,D0,Spe,C1,m(Cl,St0,Rt0,MS0,MR0),LR,F)),
    su(St,St0),
    su(Rt,Rt0),
    sunify_assoc_list(MS,MS0),
    sunify_assoc_list(MR,MR0),
    eccs_append(C0, C1, NewC),
    eccs_q_morph_check_constraints(NewC,C),
    apply_templates(Tems0,Lex0),
    choose_lexical_rule(Lex0,Lex,Tems0,Tems,Ph,LR,F, LR0).

% choose a lexical rule and apply it to the lexical entry.

choose_lexical_rule(Lex0,Lex,Tems0,Tems,Ph,LR,F, LR0) :-
	eccs_member_pair(LR0,F0,LR,F),
	apply_lexical_rule(LR0,Lex0,Lex,Tems0,Tems),
	su(Ph,F0).

% map entry takes a lexical entry and generates its canonial form.

map_entry((String:CList),String,Templates,Disj,LexRules,Specials,M0,M) :-
	eccs_comma_to_list(CList,List),
	map_entry_list(List,Templates,Disj,LexRules,Specials,[],M0,M).

% map_entry_list takes the "comma list" making up a lexical entry and
% generates the canonical parts of a lexical entry.  equations are not
% allowed in the lexical entries although they could be with no bother.

map_entry_list([],[],[],[],S,[],M,M) :- !.
map_entry_list([{X0}|L],T,[X|D],LR,S,Eq,M0,M) :- !,
	eccs_comma_to_list(X0,X),
	map_entry_list(L,T,D,LR,S,Eq,M0,M).
map_entry_list([*X|L],T,D,[X|LR],S,Eq,M0,M) :- !,
	map_entry_list(L,T,D,LR,S,Eq,M0,M).
map_entry_list([Left=Right|L],T,D,LR,S,[Left=Right|Eq],M0,M) :- !,
	map_entry_list(L,T,D,LR,S,Eq,M0,M).
map_entry_list([Left\=Right|L],T,D,LR,S,[Left\=Right|Eq],M0,M) :- !,
	map_entry_list(L,T,D,LR,S,Eq,M0,M).
map_entry_list([X|L],T,D,LR,S,Eq,M0,M) :-
	special(X,S), !,
	map_entry_list(L,T,D,LR,S,Eq,M0,M).
map_entry_list([X|L],T,D,LR,S,Eq,M0,M) :-
	morph_template(X,M0,M1), !,
	map_entry_list(L,T,D,LR,S,Eq,M1,M).
map_entry_list([Tem|L],[Tem|T],D,LR,S,Eq,M0,M) :-
	map_entry_list(L,T,D,LR,S,Eq,M0,M).

% special/3 takes kb parameterised templates and maps them onto the
% canonical special functor "s".

special(sub_entry(N),s(N,_,_)).
special(kb_pred(Atom),s(_,Atom,_)).
special(kb_class(Id),s(_,_,Id)).

% morph_template takes parameterised morphology templates and maps
% them onto the canonical special functor "m".

morph_template(morphology(Cl),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,MR)).
morph_template(morph_stem(St),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,MR)).
morph_template(morph_root(R),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,MR)).
morph_template(morph_stem(K,St0),m(Cl,St,R,MS,MR), m(Cl,St,R,[K-St0|MS],MR)).
morph_template(morph_root(K,R0),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,[K-R0|MR])).

% sunify_assoc_list string unifies two assoc lists consisting of
% morph_stem/root keys as keys and compiled morph specs as values.

sunify_assoc_list([],_).
sunify_assoc_list([K-S|M],M0) :-
	assoc(K-S0,M0),
	su(S,S0),
	sunify_assoc_list(M,M0).

% atom_to_chars_assoc_list takes an assoc list consisting of
% morph_stem/root keys as keys and atoms as values and maps it onto
% the corresponding assoc list with compiled morph specs as values.

atom_to_chars_assoc_list([],[]).
atom_to_chars_assoc_list([K-M0|T0],[K-(M)|T]) :-
	atom_to_chars(M0,M,[]),
	atom_to_chars_assoc_list(T0,T).

% term_subsumes is the traditional version of term subsumption
% (without any notion of constraints).

term_subsumes(T1,T2) :-
	eccs_verify((T1=T2)),
	eccs_verify((
	  numbervars(T2,0,_),
	  T1 = T2)).
	  
