:- eccs_new_variable(ignore_unknown_templates, true, protolexicon, run, 
		"Treat unknown templates as having the empty definition").
:- eccs_new_variable(expanded_lexicon_contains_basic_lexicon, protolexicon, boolean, run, 
		"Basic entries defined in the Protolexicon do not count as derived entries").

/* This should really go in the FB */

eccs_file_of_type(File, Type) :-
    eccs_current_file(File, Specs),
    eccs_memberchk(type=Type, Specs).

:- eccs_srcload(['qops.pl',
    'su_utils.pl',
    'q_subsumes.pl', 
    'qprocess.pl', 
    'qbuildnetwork.pl', 
    'qclasses.pl', 
    'qstrip.pl', 
    'qsu.pl', 
    'qlex.pl', 
    'qsystemic.pl', 
    'qtablesubsumption.pl', 
    'qnumbervars.pl', 
    'qtemplates.pl',
    'qexpandtables.pl',
    'qmorphtables.pl']).


eccs_read_morph_tables(_, Name, Type, Definition) :-
    eccs_sys_read(X),
    (X == end_of_file, X = Name -> X = Definition; 
    	(X = source(File) -> Definition = source(File); 
	    eccs_morpht_or_cclass(X, Name, Type, Definition))).

eccs_morpht_or_cclass(X, Name, Type, Definition) :-
    X = table(Id,C0,LR,F),
    Name = Id,
    Type = table,
    Definition = table(Id,Tem,D,Spe,Eq,m(Cl,St,Rt,MS,MR),LR,F),
    mklist(C0,C),
    map_entry_list(C,Tem,D,[],Spe,Eq,m(Cl,St,Rt,[],[]),m(Cl,St,Rt,MS,MR)).
eccs_morpht_or_cclass(X, Name, Type, Definition) :-
    X = class(Abb, {Class}),
    Type = cclass,
    Definition = table_class(Abb, C),
    eccs_commas_to_list(Class, C).
eccs_morpht_or_cclass(X, Name, Type, Definition) :-
    X = class(Abb, {}),
    Type = cclass,
    Definition = table_class(Abb, []).

eccs_read_network(_, Name, Type, Definition) :-
    eccs_sys_read(X),
    (X == end_of_file, X = Name -> X = Definition; 
    	(X = source(File) -> Definition = source(File); 
	    eccs_well_formed_network_statement(X, Name, Type, Definition))).

eccs_well_formed_network_statement(fulfils(Dimension, F), fulfils, fulfils, fulfils(Dimension, F)).
eccs_well_formed_network_statement(requires(T, R), requires, requires, requires(T, R)).
eccs_well_formed_network_statement(default(Dim, Df), default, default, default(Dim, Df, no_condition)).
eccs_well_formed_network_statement((default(Dim, Df) :- Condition), default, default, default(Dim, Df, Condition)).

eccs_read_plex(Args, Name, Type, Definition) :-
    eccs_sys_read(X),
    (X == end_of_file, X = Name -> X = Definition; 
    	(X = source(File) -> Definition = source(File); 
	    eccs_well_formed_plex_entry(X, Name, Type, Definition))).

eccs_well_formed_plex_entry(( Item :- Definition), Item, plexical_entry, Definition).

eccs_read_plexrules(_, Name, Type, Definition) :-
    eccs_sys_read(X),
    (X == end_of_file, X = Name -> X = Definition; 
    	(X = source(File) -> Definition = source(File); 
	    eccs_well_formed_plex_rule(X, Name, Type, Definition))).

eccs_well_formed_plex_rule(lexical_rule(Name, Map, Defn), Name, plexical_rule, lexical_rule(Name, (ICL -> OCL), Defn)) :-
    Map = (IC -> OC),
    eccs_commas_to_list(IC, ICL),
    eccs_commas_to_list(OC, OCL).



/*

compilers for the protolexicon

*/


eccs_compile_tables(morph_tables, _Type, _Name, _Args, Defn, Defn, []).
eccs_compile_network(network, _Type, _Name, _Args, Defn, Defn, []).
eccs_compile_plex_entry(protolexical_entries, _Type, Item, _Args, Defn, Result, []) :- 
    eccs_debug(3,eccs_message(['Trying:       ',Item])),
    eccs_commas_to_list(Defn, List),
    eccs_q_strip_lrs(List, L1, LRs),
    eccs_q_strip_outwith_network(L1, L2, OutWith),
    eccs_q_expanded_entry(L2, L3),
    eccs_q_strip_info(L3, Ts),
    /*
    The next line adds the information about the string form to the
    current list of properties
    */
    eccs_append(Ts, OutWith, L0),
    eccs_q_add_template_equivalences([string(Item)|L0], Ts1),
    eccs_q_make_set(Ts1, TsString),
    eccs_q_delete_all(string(Item), TsString , Ts2),
    (eccs_verify(eccs_q_templates(Ts2, Struct, Morph)) ->
    	eccs_q_templates(Ts2, Struct, Morph);
	eccs_error([inconsistent, set, of, templates, '$nl$'|Ts2])),
    eccs_q_apply_lexical_rules(Ts2, LRs, L4, Struct, Struct1),
    Result = basic_entry(Item, L4, Struct1, Morph).


eccs_compile_plex_rule(protolexical_rules, _Type, _Name, _Args, Defn, DefnOut, []) :-
    Defn = lexical_rule(Name, Map, FSDefn),
    DefnOut = lr(Name, Map, In, Out),
    eccs_user_empty_structure(In1),
    eccs_user_empty_structure(Out1),
    eccs_lexical_rule(FSDefn, New1, Out1, _, 0, _, In, Out).



eccs_close_lexicons :- 
    eccs_close_lexicons(_).

eccs_close_lexicons(FName) :-
    eccs_plexicon_file_unclosed(FName),
    eccs_store_in_database(FName, pderived_entry, bogus, _, bogus, []),
    eccs_pl_basic_entry(Word, Ts, Struct, FName, Morph),
    eccs_q_lexical_closure(Word, Ts, Struct, Morph, NewPhon, NewTs, NewStruct, NewMorph),
    eccs_q_pre_assert_check(NewPhon, NewTs, NewStruct, NewMorph),
    eccs_store_in_database(FName, pderived_entry, NewPhon, _, NewStruct, []), fail.
eccs_close_lexicons(_).

    
    
/* 

eccs_plexicon_file_unclosed(FName)

FName is a protolexicon file which has not been expanded out.  

The way we tell is a hack---enumerate those files for which we have a plexical_entry but 
no pderived_entry.  See the routine above.  
*/

eccs_plexicon_file_unclosed(FName) :-
    eccs_file_of_type(FName, protolexical_entries),
    eccs_get_from_databasef(plexical_entry, _, _, FName),
    \+     eccs_get_from_databasef(pderived_entry, _, _, FName). % But it's not a derived lexical entry




eccs_q_pre_assert_check(NewPhon, NewTs, NewStruct, NewMorph) :-
    eccs_chars_to_atom(NewPhon, Phon),
    eccs_global_variable(path_for_lex_symbol, Path),
    eccs_user_term(FS, Phon),
    eccs_path_value(Path, _Type, NewStruct, FS),
    eccs_get_from_database(pderived_entry, Phon, Defn),

    eccs_verify(Defn = NewStruct),
    eccs_variant(Defn, NewStruct), !,
    fail.
eccs_q_pre_assert_check(_, _, _, _).

eccs_reclose_lexicon(File) :-
    eccs_get_from_databaserf(_Key, pderived_entry, _, [], Object, DBRef, File), 
    eccs_sys_erase(DBRef),
    fail.
    
eccs_reclose_lexicon(FName) :-
    eccs_close_lexicons(FName).

