% A modified CKY parser for domain union style grammars.
% Fri Aug 31 14:09:35 1990

% Basically, this is fairly faithful to the original paper with a few
% exceptions.





A \= B :- dif(A, B).

example(1,[es,ihm,jemand,zu_lesen,versprochen,hat]).
example(2,[hat,versprochen,zu_lesen,jemand,ihm,es]).
example(3,[hat,versprochen,zu_helfen,jemand,ihr,ihm]).
example(4,[es,zu_lesen]).
example(5,[es,ihm,zu_lesen,versprochen]).
example(6,[ihr,ihm,jemand,zu_helfen,versprochen,hat]).

test(Num) :- example(Num,Ex), go(Ex).

% The rest should be pretty self-evident.  Since I'm not checking the
% domain against the original order or any LP constraints I currently
% have cuts in sequence_union and insert_in_list where I shouldn't.
% But it should get the basic idea across.  In fact, the only cuts are in
% these two predicates and they shouldn't be there at all.

build_mom(Mom,Kids) :-
  Mom <=> [phon = Phon, dom = Dom|_],
  build_dom(Mom,[],Dom,Kids),
  instantiate_phonology(Phon,Dom),
  instantiate_positions(Mom,Dom).

instantiate_positions(Mom, Dom) :-
  get_pos(Mom, Beg, End),
  first(Dom,First),
  get_pos(First, Beg, _),
  last(Dom,Last),
  get_pos(Last, _, End).

first([],[]).
first([H|T],H).

last([X],X) :- !.
last([_|T],X) :-
  last(T,X).

build_dom(Mom,Dom,Dom,[]).
build_dom(Mom,Dom,Dom2,[Kid|Kids]) :-
  add_kids_domain_to_moms_domain(Mom,Dom,Kid,Dom1),
  build_dom(Mom,Dom1,Dom2,Kids).
  
% distribution of 'unioned' attribute

unioned(Cat):-
	Cat <=> [syn = [loc = [head = [maj = v|_],
 	       		       lex = min|_]|_]|_].

instantiate_phonology(Phon,Dom) :-
  i_s(Phon, Dom).

i_s([],[]).
i_s(Phon,[H|T0]) :-
  H <=> [phon = Phon0|_],
  i_s(T,T0),
  append(Phon0,T,Phon).

add_kids_domain_to_moms_domain(Mom,Dom,Kid,NewDom) :-
  Kid <=> [syn = [loc = [lex = plus|_]|_]|_], !,
  add_to_domain(Mom,Dom,Kid,NewDom).
add_kids_domain_to_moms_domain(Mom,Dom,Kid,NewDom) :-
  unioned(Kid), !,
  Kid <=> [dom = KDom|_],
  sequence_union(Mom,Dom,KDom,NewDom).
add_kids_domain_to_moms_domain(Mom,Dom,Kid,NewDom) :-
  add_to_domain(Mom,Dom,Kid,NewDom).

sequence_union(M,Dom,[],Dom).
sequence_union(M,Dom0,[H|T],Dom) :-
  add_to_domain(M,Dom0,H,Dom1), !,
  sequence_union(M,Dom1,T,Dom).

add_to_domain(M,D0,X,D) :-
  get_pos(X,B,E),
  insert(X,B,E,D0,L,R,D),
  lp_left(M,X,L),
  lp_right(M,X,R).

/*
insert(Element, BeginPosition, End Position, Domain, Left, Right, DomainOut)

There should be a test for guaranteeing that an inserted element is
continuous but it would require some extra work.  Instead the last
clause of insert makes sure that the last word in the inserted element
is before the next word in the domain.  This accomplishes the same
affect (albeit a bit more inefficiently.)

*/

insert(X,_,_,[],[],[],[X]).
insert(X,B,E,[H|T],[H|L],R,[H|Tx]) :-
  get_pos(H,HB,_),
  HB < B,
  insert(X,B,E,T,L,R,Tx).
insert(X,B,E,[H|T],[],[H|T],[X,H|T]) :-
  get_pos(H,_,HE),
  E < HE.

/*

forall X,Y . P = 
forall X,forall Y . P = 
not exists X not not exists Y. (not P) =
not exists X exists Y. (not P) =
not exists X,Y . (not P)

Therefore,

forall X,Y . (X < Y) iff not exists X,Y . not(X < Y)

I.e.,

forall X,Y . (prec(X,Y)) iff not exists X,Y . (not prec(X,Y))

Remember that X and Y are implicitly universally quantified in the
notation X <= Y.

*/

lp_left(_,_,[]).
lp_left(M,X,[Y|T]) :-
  \+ precedence(M,X,Y),  % not exists X,Y . (not prec(X,Y))
  lp_left(M,X,T).

lp_right(_,_,[]).
lp_right(M,Y,[X|T]) :-
  \+ precedence(M,X,Y),  % not exists X,Y . (not prec(X,Y))
  lp_right(M,Y,T).

precedence(M,X,Y) :-
  prec(M1,X1,Y1),
  M <=> M1,
  X <=> X1,
  Y <=> Y1.


prec(X1, Y1, Z1) :-
    eccs_get_from_database(lp_statement, _Name, prec(X1, Y1, Z1)).

add_kids_code_to_moms_code(Code,KidsCode,NewCode) :-
  or_list(Code,KidsCode,NewCode).

or_list([],[],[]).
or_list([1|X],[0|Y],[1|Z]) :-
  or_list(X,Y,Z).
or_list([0|X],[1|Y],[1|Z]) :-
  or_list(X,Y,Z).
or_list([1|X],[1|Y],[1|Z]) :-
  or_list(X,Y,Z).
or_list([0|X],[0|Y],[0|Z]) :-
  or_list(X,Y,Z).

% Utilities

append([],L,L).
append([H|T0],L0,[H|L]) :-
  append(T0,L0,L).

once(X) :- X, !.

re :- retractall(edge(_,_)).
  
l :- listing(edge).

% graph unification

X <=> X :- !.
[A=V1|R1] <=> F2 :-
        del(A=V2,F2,R2),
        V1 <=> V2,
        R1 <=> R2.

del(F,[F|X],X) :- !.
del(F,[E|X],[E|Y]) :-
  del(F,X,Y).

list_all :-
  list_rules,
  list_precedences,
  list_templates,
  list_words.

list_rules :-
  rule(Mom,Cons),
  write('rule('), nl,
  pdag(Mom),
  write(','),
  write(Cons),
  write(').'), nl, nl,
  fail.
list_rules.

list_precedences :-
  prec(F0,X0,Y0),
  findunifs([F0,X0,Y0],[F,X,Y]),
  write('prec('),
  once( (pp_print(F) ; write('_')) ),
  write(','),
  once( (pp_print(X) ; write('_')) ),
  write(','),
  once( (pp_print(Y) ; write('_')) ),
  write(').'), nl, nl,
  fail.
list_precedences.

list_templates :-
  temp(X,Name),
  write('temp('), nl,
  pdag(X),
  write(', '), write(Name), write(').'), nl, nl,
  fail.
list_templates.

list_words :-
  word(X,Name),
  write('word('), nl,
  pdag(X),
  write(', '), write(Name), write(').'), nl, nl,
  fail.
list_words.

clup :-
  abolish(rule),
  abolish(prec),
  abolish(temp),
  abolish(word).
