#include "/usr/local2/sicstus2.1/Runtime/runtime.h"
#include <stdio.h>
#include <string.h>

main()
{
  char command[12];
  char parameter[256];
  SP_pred_ref th, gram;
  SP_qid goal;
  SP_term grammar, sentence, semantics;


  if (SP_initialize()
     && SP_load("/sx/HPSG/PL/main.ql")
     && SP_load("/sx/HPSG/PL/lex.ql")
     && SP_load("/sx/HPSG/PL/parser.ql")
     && SP_load("/sx/HPSG/PL/constraints.ql")
     && SP_load("/sx/HPSG/PL/utils.ql")
     && SP_load("/sx/HPSG/PL/io.ql")
     && SP_load("/sx/HPSG/PL/treetool.ql")
     && SP_load("/sx/HPSG/PL/rogers.ql")
     && SP_load("/sx/HPSG/PL/rogers2.ql")
     && SP_load("/sx/HPSG/PL/th.ql"))
  {

/*  Read in a command */


     while (EOF != scanf("%s %[^\r\n]",command, parameter))
     {
       if (strcmp("parse",command) == 0)
       {
         SP_put_string(&sentence, parameter);
         SP_put_variable(&semantics);

         if ((th = SP_predicate("th",2,""))
             && (goal = SP_open_query(th,&sentence,&semantics)))
         {
           while (SP_next_solution(goal)) write_semantics(semantics);
           SP_cut_query(goal);
         }
       } 

       else if (strcmp("gram",command) == 0)
       {
         SP_put_string(&grammar, parameter);
         if (!(gram = SP_predicate("gram",1,""))
             || !SP_query_cut_fail(gram, &grammar))
           fprintf(stderr,"Unable to load grammar\n");
       }
       else
       {
           fprintf(stderr,"Unknown command\n");
       }

       printf("\\");      /* Signal to caller that we are done! */

     }
  } else
  {
    fprintf(stderr," Unable to initialize Prolog system \n");
  }
}

write_semantics(sem)
  SP_term sem;
{
  char *text;

  SP_get_atom(sem, &text);
  printf("%s\\", text);
}
