
% Output routines 

writetime(_, _) :- flag(silent), !.

writetime(Message,Start)  :-
  cputime(End),
  X is ((End-Start) / 1000),
  nl, write(Message), write(X), write(' secs.'), nl, !.

writemessage(_, _) :- flag(silent), !.

writemessage(Message, N) :- 
  write(Message), write(N), nl.

:- dynamic indexvar/1.

writesem(_) :- flag(silent), !.

/*

Tue Mar 30 17:41:54 1993 JC 

changed the unclear

abolish(indexvar) 

in second line to 

retractall(indexvar(_))

Added the dynamic spec. above for this predicate. 

This way, we won't get errors if we try to call indexvar/1 and it's
not defined.

*/

writesem(Sign) :-
  abolish(indexvar),
  flag(printsem), !,
  assert(indexvar(1)),       %  used by indexgen
  path(Sign,sem,Sem),
  reduce_sem(Sem,NewSem),  %  retain only significant features
  retract(indexvar(_)),
  pp(NewSem), nl.

writesem(_). 

/*

Comment by JC Tue Mar 30 12:56:17 1993

The following changes down to the definition of talker/5 and relative
to 1.2 made by Fred, prior to the COLING '92 demo.

reduce_sem/2 now explicitly checks the indices attribute and does a
`reduce' on that.

*/

% reduce_sem(+Sem,-ReducedSem)
% 
% Throws away irrelevant features in sem:cont value for clearer display.
% This version requires the following structure:
%   sem type [!indices, !cont], cont type [!quant, !scope, !index, !rlt]
%
% Could be omitted or modified.
    
reduce_sem([[indices,I], [cont,C]], [[indices,NewI] ,[cont,NewC]]):-
  reduce_inds(I,NewI),
  reduce_cont(C,NewC),!.

reduce_sem(Sem,Sem). % if the structure of SEM attribute is not as expected,
                                                 % leave it as it is
reduce_cont([[quant,Q],_,_,[rlt,Rlt]],Rlt):- 
  var(Q),!.

% inner most "quant" becomes "det"

reduce_cont([[quant,QC], _, [index,I]|_], [[det,QC], [var,V]]):- 
  atomic(QC),
  !,
  path(I, var, V).
  
reduce_cont([[quant,QC], [scope, SC]|_], [[quant,NewQC], [scope,NewSC]]):-
  reduce_cont(QC,NewQC),
  reduce_cont(SC,NewSC).

reduce_inds([], []).
reduce_inds([I|Rest], [NewI|NewRest]) :- 
   reduce_ind(I, NewI),
   reduce_inds(Rest, NewRest).
  
reduce_ind(I, I) :- \+ flag(pp), !.

reduce_ind(I, NewI) :-             % Convert the AVM into a TERM
  path(I, var, V),
  fixvar(V),
  path(I, restriction, R),
  avm2list(R, List),
  NewI =.. List.

% For converting variables into a readable form.

fixvar(X) :- var(X), !, fixaux(Y), concat_atom([x,Y],X).
fixvar(_).

fixaux(X) :- retract(indexvar(X)), Y is X+1, assert(indexvar(Y)), !.

avm2list([[_,A]], [A]) :- !,
  ( var(A) -> A = '?'; true ).    % this should never happen

avm2list([[_, A]|Rest], [A|NewRest]) :-
  ( var(A) -> A = '?'; true ),    % this should never happen
  avm2list(Rest, NewRest).

  
% Used to trace the behaviour of the parser.  Checks to see if the "tracer"
% flag has been defined.

talker(Step,L,R,Expects,Components) :-
  flag(tracer),
  write(Step),
  say_status(Expects),
  concat(Phonology,R,L),
  write(' ('), write(Phonology), write(')'),
  say_components(Components),
  nl, !.

talker(_,_,_,_,_).

say_status([]) :-
  num(N), write(':  create inactive edge '), write(N).

say_status([_|_]) :-
  num(N), write(':  create active edge '), write(N).

say_components([]).
say_components([N]) :- write(', built from '), write(N), write('.').
say_components([A,B]) :- 
   write(', built from '), 
   write(A), write(' and '), write(B), write('.').

% For pretty printing signs...

pedge(N) :- edge(_, Sign, _, _, _, _, N), pp(Sign).   % Print edge number N

/*

Tue Mar 30 12:52:58 1993 JC

Following advice of Fred, the following three routines have been
changed so that their behaviour is like listing/{0,1}.

*/

pentry(Word) :- 
   entry(Word, AVM, Constraints), 
   paux(AVM, Constraints), nl, fail.
pentry(_).

psign(Sign) :- 
   sign(Sign, AVM, Constraints), 
   paux(AVM, Constraints),
   nl, fail.
psign(_).

prule(Sign) :- 
   rule(Sign, AVM, Constraints), 
   paux(AVM, Constraints),
   nl, fail.
prule(_).

paux(AVM, Constraints) :-
   pp(AVM), nl,
   write('Constraints: '),
   write(Constraints).

pp(X) :- pp(X, 0).

pp(X, Level) :-        % Level is for indentation
   value_type(Type, X),
   pp(Type, X, Level).

pp(avm, [], _) :- !.
pp(avm, [AVP|Rest], Level) :- !,
   pp(avp, AVP, Level), 
   pp(avm, Rest, Level).

pp(avp, [F,V], Level) :- !,
   nl, 
   tab(Level), 
   write(F), 
   write(' '),
   NewLevel is Level + 1,
   pp(V, NewLevel).

pp(list, List, Level) :- !,
   write('< '),
   pplist(List, Level),
   write(' >').

pp(set, lset(Name,List), Level) :- !,
   write('{ '),
   list2set(Name, List, Set),
   pplist(Set,Level),
   write(' }').

pp(_, V, _) :-
   write(V).

pplist([], _) :- !.
pplist([H|T], _):- var(H), var(T), !,
   write(H), write(' | '), write(T). 
pplist([F], Level) :- !, pp(F, Level).
pplist([F|R], Level) :-
   pp(F, Level),
   write(', '),
   pplist(R, Level).

value_type(var, V) :- var(V), !.
value_type(avm, [[F,_]|_]) :- atomic(F), !.
value_type(list, []) :- !.
value_type(list, [_|_]) :- !.
value_type(set, lset(_,_)) :- !.
value_type(atom, _).


%  Input routine from Pereira & Shieber - Prolog and Natural Language Analysis

read_sent(Words) :-
  get_char(Char),                 %prime lookahead
  read_sent(Char, Words), !.  %get words

% Period terminates input.
read_sent(C,[]) :- period(C),!.
read_sent(C,[]) :- q_mark(C),!.

% Stuff is ignored.
read_sent(C,Words) :-
  ignore(C),!,
  get_char(Char),
  read_sent(Char, Words).

% An Appos may start a word, in which case, it does not terminate it.

read_sent(39, [Word|Words]) :- !,
  get_char(Char),                  %prime lookahead
  read_word(Char, Chars, Next),    %get the word
  name(Word, [39|Chars]),          %pack the characters into an atom
  read_sent(Next, Words).          %get some more words


% Everything else starts a word.
read_sent(Char, [Word|Words]) :-
  read_word(Char, Chars, Next),    %get the word
  name(Word, Chars),               %pack the characters into an atom
  read_sent(Next, Words).          %get some more words

% Certain stuff is to be ignored.
ignore(C) :- space(C).
ignore(C) :- newline(C).

% Space, period, question mark, apostrophe and newline end a word.
read_word(C,[],C) :- space(C),!.
read_word(C,[],C) :- period(C),!.
read_word(C,[],C) :- q_mark(C),!.
read_word(C,[],C) :- newline(C),!.
read_word(C,[],C) :- appos(C),!.

% All other chars are added to the list.

read_word(Char, [Char|Chars], Last) :- get_char(Next), read_word(Next, Chars, Last).

get_char(C0) :- get0(C),  lowercase(C,C0).

lowercase(C, L) :- C > 64, C < 91, L is C + 32, !.
lowercase(C, C).

space(32).
newline(10).
period(46).
q_mark(63).
appos(39).

