/*

File:	/home/dk2/jcalder/Pleuk/HPSG/hpsgprint.pl
Date:	Thu Mar  4 16:29:35 1993
By:	Jo Calder

*/


/*

Printing

We use the following strategy, derived in part from SLE, but hopefully
simpler. It's a two-pass 

We compute a binary tree of all values, storing with each a list of
paths to that value.  We use the fake names '$$FIRST' and '$$REST' to
refer to elements of lists.  At the same time we make a note of
constraints that hold at a particular node.

We then go through the feature structure a second time, computing SPF.
When we hit a reentrant structure, we check whether we should place it
where we are at the moment, or put in a tag.  

We make use of a counter hpsg_specials to track some objects, namely
those special terms introduced in SystemX compatible version of the
system.

First printers for objects

*/

hpsg_print(Type, Name,  Compiled, SPF) :-
    hpsg_print1(Type, Name, Compiled, SPF).

hpsg_print1(type, Name, Compiled, captioned(Caption, SPF)) :-
    (eccs_sys_atomic(Name) -> 
    	N1 = Name
      ; (Name=F/N, eccs_concat_list([F, '/', N], N1)
        ; Name = [N1|_])), !,
    eccs_concat_list(['the type: "', N1, '"'], Caption),
    Compiled = sign(SName, Matrix, Constraints),
    hpsg2spf_type(SName, Matrix, Constraints, SPF).

hpsg_print1(has, Name, Compiled, captioned(Caption, SPF)) :-
    eccs_concat_list(['has statement for: "', Name, '"'], Caption),
    Compiled = sign(_Name, Matrix, Constraints),
    hpsg2spf(Matrix+Constraints, SPF).

hpsg_print1(domain, Name, Set, SPF) :-
    SPF = captioned(Caption, set(S1)),
    eccs_concat_list(['the domain: "', Name, '"'], Caption), 
    hpsg2vt1_atomicset2list(Set, S1).




hpsg_print1(entry, +Empty, Entry, SPF) :-
    SPF = captioned(Caption, SPF1),
    (eccs_sys_atomic(Empty) -> 
	true
      ; eccs_warning([nonatomic, empty, category, name, Empty]), fail),
    eccs_concat_list(['the empty category "', Empty, '"'], Caption),
    Entry = entry(_Name, Matrix, Constraints),
    hpsg2spf(Matrix+Constraints, SPF1).


hpsg_print1(entry, Name, Entry, SPF) :-
    SPF = captioned(Caption, SPF1),
    (eccs_sys_atomic(Name) -> 
	true
      ; eccs_warning([nonatomic, lexical, entry, name, Name]), fail),
    eccs_concat_list(['the lexical entry "', Name, '"'], Caption),
    Entry = entry(_Name, Matrix, Constraints),
    hpsg2spf(Matrix+Constraints, SPF1).

hpsg_print1(ideal, ideal, ideal_sign(Matrix, Constraints), SPF) :-
    Caption = 'the description of all successful parses ("ideal sign" )',
    SPF = captioned(Caption, SPF1),
    hpsg2spf(Matrix+Constraints, SPF1).

hpsg_print1(rule, RuleNo, rule(_, Matrix, Constraints), SPF) :-
    eccs_concat_list(['rule ', RuleNo], Caption),
    SPF = captioned(Caption, SPF1),
    hpsg2spf(Matrix+Constraints, SPF1).

hpsg2spf_type(SName, Matrix, Constraints, SPF) :-
    eccs_sys_atomic(SName), !,		% ignore atomic names
    hpsg2spf(Matrix+Constraints, SPF).
hpsg2spf_type(SName, Matrix, Constraints, SPF) :-
    eccs_zero(hpsg_specials),
    SName =.. [F|Args],
    hpsg2vt(Matrix, Constraints, [], VT),
    hpsg2vt_head(Args, Constraints, ['$$HEAD'], 0, VT),
    hpsgvt2frame(Matrix, Constraints, VT, [], Frame),
    hpsgvt2frame_list(Args, Constraints, ['$$HEAD'], 0, VT, AsFrame),
    SPF1 = infix(atomic(type), TName, Frame),
    TName = relation(atomic(F), AsFrame),
    hpsgframe2spf(SPF1, _, _, SPF), 
    eccs_spf_number_tags(SPF).

hpsg2vt_head([], _, _, _, _).
hpsg2vt_head([A|As], Cs, Path, Count, VT) :-
    hpsg2vt(A, Cs, [Count|Path], VT),
    eccs_succ(Count, Count1),
    hpsg2vt_head(As, Cs, Path, Count1, VT).


hpsg2spf_list(In, Constraints, Out) :-
    eccs_zero(hpsg_specials),
    hpsg2vt_list(In, VT, 0, Constraints),
    hpsgvt2frame_list(In, Constraints, VT, 0, Frame),
    hpsgframe2spf_list(Frame, Constraints, VT, 0, Out),
    eccs_spf_number_tags(Out).



hpsg2vt_list([], _VT, _N, _).
hpsg2vt_list([In|Ins], VT, Count, Constraints) :-
    hpsg2vt(In, Constraints, [Count], VT),
    eccs_succ(Count, Count1),
    hpsg2vt_list(Ins, VT, Count1, Constraints).

hpsgvt2frame_list([], _, _, _, []).
hpsgvt2frame_list([I|Is], Constraints, VT, Count, [O|Os]) :-
    hpsgvt2frame(I, Constraints, VT, [Count], O),
    eccs_succ(Count, Count1),
    hpsgvt2frame_list(Is, Constraints, VT, Count1, Os).

hpsgvt2frame_list([], _, _, _, _, []).
hpsgvt2frame_list([A|Args], Cs, Path, Count, VT, [AF|AsFrame]) :-
    hpsgvt2frame(A, Cs, VT, [Count|Path], AF),
    eccs_succ(Count, Count1),
    hpsgvt2frame_list(Args, Cs, Path, Count1, VT, AsFrame).

hpsgframe2spf_list([], _, _, _, []).
hpsgframe2spf_list([F|Fs], FS, VT, Count, [O|Out]) :-
    hpsgframe2spf(F, FS, VT, O),
    eccs_succ(Count, Count1),
    hpsgframe2spf_list(Fs, FS, VT, Count1, Out).
    

hpsg_printfs_from_parse(_Args, Caption, Parse, captioned(Caption, Out)) :-
    hpsg2spf(Parse, Out),
    eccs_spf_number_tags(Out).

hpsg2spf(FS+Cs, Out) :- 
    eccs_zero(hpsg_specials),
    hpsg2vt(FS, Cs, [], VT),		% *** Have to add constrained vars in too!
    hpsgvt2frame(FS, Cs, VT, [], Frame),
    hpsgframe2spf(Frame, FS, VT, Out),
    eccs_spf_number_tags(Out).


hpsgframe2spf(SPFIn, _, _, SPFOut) :- 
    !,
    (eccs_global_variable(delete_uninstantiated_attributes, true) ->
	hpsgframe2spf_strip_boring(SPFIn, SPF1)
      ; SPFIn = SPF1),
    hpsg_check_something_left(SPFIn, SPF1, SPFOut1),
    (hpsg_att_ordering(Atts) ->
	eccs_spf_order_attributes(SPFOut1, Atts, SPFOut)
      ; SPFIn = SPFOut).

hpsgframe2spf_strip_boring(SPFIn, SPFOut) :-
    eccs_spf_strip_boring(SPFIn, SPFOut).

hpsg_check_something_left(SPFIn, SPF1, SPFOut1) :-
    eccs_memberchk(SPF1, [uninstantiated, avm([])]),
    \+ eccs_memberchk(SPFIn, [uninstantiated, avm([])]),
    eccs_global_variable(delete_uninstantiated_attributes, true),
    !,
    SPFIn = SPFOut1,
    eccs_message([showing, all, structure, otherwise, deleting, all, 
		  attributes]),
    eccs_message([results, in, an, empty, 'AVM']).
hpsg_check_something_left(_, SPF1, SPF1).



    

hpsg_att_ordering(Atts) :-
    eccs_global_variable(attribute_ordering, Atts).

/*

hpsgframe2spf(SPFIn, _, _, SPFOut) :-
    hpsgframe2spf(SPFIn, SPFOut).

hpsgframe2spf(SPFIn, SPFOut) :-
    (eccs_sys_atomic(SPFIn); eccs_sys_var(SPFIn)), 
    !,
    SPFIn = SPFOut.
hpsgframe2spf(In, Out) :-
    hpsgframe2spf_filter_target(In, InToDo, Out, OutToDo), 
    !,
    hpsgframe2spf_filter_unins(InToDo, OutToDo).
hpsgframe2spf(In, Out) :-
    In =.. [F|Args],
    hpsgframe2spf_list(Args, ArgsOut),
    Out =.. [F|ArgsOut].

hpsgframe2spf_filter_unins([], []).
hpsgframe2spf_filter_unins([_Att = uninstantiated|In], Out) :-
    !,
    hpsgframe2spf_filter_unins(In, Out).
hpsgframe2spf_filter_unins([A|As], [O|Out]) :-
    hpsgframe2spf(A, O),
    hpsgframe2spf_filter_unins(As, Out).


hpsgframe2spf_list([], []).
hpsgframe2spf_list([A|As], [O|Os]) :-
    hpsgframe2spf(A, O),
    hpsgframe2spf_list(As, Os).

    
hpsgframe2spf_filter_target(avm(InToDo), InToDo, avm(OutToDo), OutToDo).
hpsgframe2spf_filter_target(tagged_avm(Tag, InToDo), InToDo, 
			    tagged_avm(Tag, OutToDo), OutToDo).

*/

/*

Only store non-atomic values in VT

*/

hpsg2vt(Atom, _Cs, _, _) :-
    eccs_sys_atomic(Atom), 
    !.
hpsg2vt(FS, Cs, Path, VT) :- 
    hpsg_in_vt(FS, VT, There, Info),
    hpsg_printaddpath(Path, Info),
    (There = true -> 
	true
      ; value_type(Type, FS),
        hpsg2vt_do_cs_here(FS, Cs, Path, Info, VT),
        hpsg2vt_do_value(Type, FS, Cs, VT, Path)).
    
hpsg_printaddpath(Path, Info) :-
    eccs_memberchk(paths = Ps, Info),
    hpsg_instantiate_tail(Ps, Path).

hpsg_instantiate_tail(Var, P) :-
    eccs_sys_var(Var), !,
    Var = [P|_].
hpsg_instantiate_tail([_|T], P) :-
    !,
    hpsg_instantiate_tail(T, P).
hpsg_instantiate_tail(_, _) :-
    eccs_warning([wrong, format, for, paths, in, printer]).

/*

Work out constraints that hold at the current node

We have to do a little bit of massaging of the representation, so that
we turn arguments of the form:

concat(X, Y, Z) 

into 

concat(X, Y)

so that only the other nodes references by some constraint are
represented.

*/

hpsg2vt_do_cs_here(FS, Cs, Path, Info, VT) :-
    hpsg2vt_findcs(FS, Cs, CsHere),
    eccs_memberchk(constraints = CsHere, Info),
    (CsHere = [] -> 
    	true
      ; hpsg_2vt_do_cs(Cs, Path, VT, CsHere)).

hpsg_2vt_do_cs(_, _, _, []) :-
    !.
hpsg_2vt_do_cs(AllCs, Path, VT, [C|Cs]) :-
    hpsg_2vt_do_c(AllCs, Path, VT, C),
    hpsg_2vt_do_cs(AllCs, Path, VT, Cs).

hpsg_2vt_do_c(AllCs, Path, VT, C) :-
    C =.. [_Name|Args],
    hpsg_2vt_do_c1(Args, AllCs, ['$$CONSTRAINT'|Path], 0, VT),
    !.
hpsg_2vt_do_c(_, _, _, C) :-
    eccs_warning([problems, decoding, constraint, C]).

hpsg_2vt_do_c1([], _, _, _, _) :- 
    !.
hpsg_2vt_do_c1([Arg|Args], AllCs, Path, Count, VT) :-
    eccs_succ(Count, Count1),
    hpsg2vt(Arg, AllCs, [Count1|Path], VT),
    hpsg_2vt_do_c1(Args, AllCs, Path, Count1, VT).



hpsg2vt_findcs(_FS, [], []) :- !.
hpsg2vt_findcs(FS, [C|Cs], [COut|CsHere]) :-
    eccs_sys_nonvar(C),
    eccs_sys_functor(C, F, N),
    eccs_sys_arg(N, C, LastArg),
    LastArg == FS, !,
    C =.. [F|Args],
    eccs_append(AllButLast, [_], Args),
    COut =.. [F|AllButLast],
    hpsg2vt_findcs(FS, Cs, CsHere).
hpsg2vt_findcs(FS, [_|Cs], CsHere) :-
    hpsg2vt_findcs(FS, Cs, CsHere).

    


    

/*

Add constraints to the info associated with some node

Unlike, path info,  this should only be called once.  

*/

hpsg_printaddcs([], _Info).
hpsg_printaddcs(Cs, Info) :-
    eccs_memberchk(constraints = Cs, Info).  

/*

This is where most of the work gets done.   

value_type/2 says that thing which look like x(_) are of type atom,
when in fact they're probably co-instantiated variables.  As they show
up in grammars designed to produce LISP-readable output, I think we
can assume that it's ok to print them more or less verbatim.

*/

hpsg2vt_do_value(var,  _FS, _Cs, _VT, _Path).
hpsg2vt_do_value(atom, FS, Cs, VT, Path) :-
    eccs_sys_nonvar(FS), 
    (eccs_sys_atomic(FS) -> 
        true
      ; hpsg2vt_do_special_value(FS, Cs, VT, Path)),
    !.
hpsg2vt_do_value(avm, FS, Cs, VT, Path) :-
    hpsg2vt1_avpairs(FS, Cs, VT, Path).
hpsg2vt_do_value(list, FS, Cs, VT, Path) :-
    hpsg2vt1_list(FS, Cs, VT, Path).
hpsg2vt_do_value(set, _FS, _Cs, _VT, _Path).


hpsg2vt1_avpairs([], _cs, _VT, _Path) :- !.
hpsg2vt1_avpairs([AVP|AVPs], Cs, VT, Path) :-
    AVP = [A, _],
    hpsg_shadowed_atts(As),
    eccs_memberchk(A, As), !,
    hpsg2vt1_avpairs(AVPs, Cs, VT, Path).
hpsg2vt1_avpairs([AVP|AVPs], Cs, VT, Path) :-
    AVP = [A, V],
    hpsg2vt(V, Cs, [A|Path], VT),
    hpsg2vt1_avpairs(AVPs, Cs, VT, Path).


hpsg_shadowed_atts(As) :-
    (eccs_global_variable(shadowed_attributes, As); As = []).


/*

When we get here, we know that FS has the form [_|_]

*/
hpsg2vt1_list(Var, _, _, _) :-	% Should never get here
    eccs_sys_var(Var), !.
hpsg2vt1_list([], _, _, _Path).
hpsg2vt1_list([E|Es], Cs, VT, Path) :-
    hpsg2vt(E, Cs, ['$$FIRST'|Path], VT),
    RestPath = ['$$REST'|Path],
    ((eccs_sys_var(Es); \+ (eccs_member(Es, [[], [_|_]]))) ->
	hpsg2vt(Es, Cs, RestPath, VT)
      ; hpsg2vt1_list(Es, Cs, VT, RestPath)).

hpsg2vt1_set(FS, Out) :-
    FS = lset(Name, List), 
    list2set(Name, List, Set),
    hpsg2vt1_atomicset2list(Set, Out).

hpsg2vt1_atomicset2list([], []).
hpsg2vt1_atomicset2list([A|As], [atomic(A)|Ats]) :-
    hpsg2vt1_atomicset2list(As, Ats).

/*

When we get here, we know that FS is not an avm, var, or list, but we do 
know that it's instantiated and that a record exists for it in VT.

*/

hpsg2vt_do_special_value(string(S), Cs, VT, Path) :-
    hpsg2vt(S, Cs, VT, ['$$SPECIAL'|Path]),
    !.
hpsg2vt_do_special_value(x(X), Cs, VT, Path) :-
    hpsg2vt(X, Cs, VT, ['$$SPECIAL'|Path]),
    !.
hpsg2vt_do_special_value(value(X), Cs, VT, Path) :-
    hpsg2vt(X, Cs, VT, ['$$SPECIAL'|Path]),
    !.
hpsg2vt_do_special_value(var(X, Y), Cs, VT, Path) :-
    hpsg2vt(X, Cs, VT, [0, '$$SPECIAL'|Path]),
    hpsg2vt(Y, Cs, VT, [1, '$$SPECIAL'|Path]),
    !.
hpsg2vt_do_special_value(v(V), Cs, VT, Path) :-
    hpsg2vt(V, Cs, VT, [1, '$$SPECIAL'|Path]),
    !.
hpsg2vt_do_special_value(_, _, _, _).

/*

Second walk through representation

hpsgvt2frame(FS, Cs, VT, Path, Frame)

*/

hpsgvt2frame(FS, _, _, _, sequence([])) :-
    FS == [],
    !.
hpsgvt2frame(Atom, _, _, _, atomic(Atom)) :-
    eccs_sys_atomic(Atom), 
    !.
hpsgvt2frame(FS, Cs, VT, Path, Frame) :-
    value_type(Type, FS),
    hpsgpaths_to_here(FS, VT, Paths),
    hpsgvt2frame_do_value(Path, Paths, Type, FS, Cs, VT, Frame).

hpsgpaths_to_here(FS, VT, Paths) :-
    hpsg_in_vt(FS, VT, _, Info),
    eccs_memberchk(paths = Paths, Info),
    eccs_closed_list(Paths), !.
hpsgpaths_to_here(FS, VT, Paths) :- trace.
    

/*

Note the lack of coinstantiation in the first clause between the path
we are given and the path we are currently at.  This is because we are
only interested in whether there is a unique path to the current node.

The first clause above traps a few special cases: these are System X
specific, and represent ways of talking to LISP.

x(X) - The term used to represent a value that will later be passed
onto LISP.

string(S) - the term used to represent a string.

var(X, Y)
var(v(V), Y).

When we get here, we know that FS is not a var, atom, or list.  It is
definitely instantiated.

*/

hpsgvt2frame_do_value(Path, Paths, Type, FS, Cs, VT, Frame) :-
    eccs_sys_nonvar(Type), Type = atom,
    (eccs_sys_atomic(FS) -> 
	fail		% should never get here
      ; hpsgvt2frame_do_value_special(Path, Paths, FS, Cs, VT, Frame)).

/*
    ((FS = x(Var); FS = var(Var)) -> 
	    !, hpsgvt2frame(Var, Cs, VT, Path, Frame)
      ; (FS = string(S) ->
      	    hpsgvt2frame(S, Cs, VT, Path, Frame1), 
	    hpsgvt2frame_fix_string(Frame1, Frame), !
	    ; eccs_message(['WARNING:', unable, to, 
			make, sense, of, element, to, be, printed]),
	      eccs_message([FS]), !, fail)).

        
hpsgvt2frame_fix_string(Var,  relation(atomic(string), tag(Var))):-
    eccs_sys_var(Var),
    !.
hpsgvt2frame_fix_string(atomic(Atom), concat([atomic('"'), atomic(Atom), atomic('"')])) :-
    eccs_sys_atomic(Atom), 
    !.
hpsgvt2frame_fix_string(_,  concat([atomic('"'), atomic('?'), atomic('"')])) :-
    eccs_message(['WARNING:', unable, to, format, string]).

*/  

hpsgvt2frame_do_value(Path, [_Path], Type, FS, Cs, VT, Frame) :-
    !,
    hpsgvt2frame_do_value_nore(Type, FS, Cs, Path, VT, Frame).
hpsgvt2frame_do_value(Path, Paths, Type, FS, Cs, VT, Frame) :-
    hpsg_in_vt(FS, VT, _, Info),
    eccs_memberchk(best_path = BP, Info),
    eccs_memberchk(tag = Tag, Info),
%     (Paths = [_, _|_] -> trace; true),
    (eccs_sys_var(BP) -> hpsg_best_path(Paths, BP); true),
    (BP = [Path|_] -> 
	hpsgvt2frame_do_tag_full_value(Tag, Type, FS, Cs, _Path, VT, Frame)
      ; Frame = tag(Tag)).

/*

Deal with the special terms introduced by some versions of the HPSG-PL
system.  These are listed above.  

*/

hpsgvt2frame_do_value_special(_Path, _Paths, FS, _, VT, Frame) :-
    hpsgvt2frame_do_value_special(FS, VT, Frame),
    !.

hpsgvt2frame_do_value_special(string(S), _, relation(atomic(string), [A])) :-
    A = atomic(Str),
    (eccs_sys_atomic(S) -> 
	S = Str
      ; (is_list_of_atoms(S) -> 
	    eccs_concat_list(S, Str)
	  ; eccs_warning([unable, to, make, sense, of, string, S]),
	    S = Str)).
hpsgvt2frame_do_value_special(x(X), _, relation(atomic(x), [atomic(A)])) :-
    (eccs_sys_atomic(X) -> 
	X = A
      ; (eccs_sys_var(X) -> 
	    hpsg_gen_var(X),
	    X = A
	  ; eccs_warning([unable, to, make, sense, of, element, x(X)]),
	    A = '?')).
hpsgvt2frame_do_value_special(var(X, Y), _, relation(atomic(var), [AX, AY])) :-
    (eccs_sys_nonvar(X) -> 
	hpsgvt2frame_do_value_special_var_v_instantiated(X, AX)
      ; hpsg_gen_var(X), 
	AX = atomic(X)),
    (eccs_sys_var(Y) ->
	hpsg_gen_var(Y),
        AY = atomic(Y)
      ; (eccs_sys_atomic(Y) ->
	    AY = atomic(Y)
	  ; eccs_warning([unable, to, make, sense, of, element, var(X, Y)]),
	    AY = atomic('?'))).

hpsgvt2frame_do_value_special_var_v_instantiated(Var, atomic(Var)) :-
    eccs_sys_var(Var), !,
    hpsg_gen_var(Var).
hpsgvt2frame_do_value_special_var_v_instantiated(Atom, atomic(Atom)) :-
    eccs_sys_atomic(Atom), 
    !.
hpsgvt2frame_do_value_special_var_v_instantiated(v(X), relation(atomic(v), [VA])) :-
    (hpsgvt2frame_do_value_special_var_v_instantiated(X, VA) ->
	true
      ; eccs_warning([unable, to, make, sense, of, v(X)]),
        VA = '?').

	

hpsg_gen_var(X) :-
    eccs_sys_atomic(X), !.
hpsg_gen_var(Var) :-
    eccs_sys_var(Var),
    eccs_increment(hpsg_specials, I),
    eccs_succ(J, I),
    eccs_spf_prolog_nv2atom(J, Var).

    


/*

Decode constraints should be here. 

*/

hpsgvt2frame_do_tag_full_value(Tag, _Type, Var, _, _Path, VT, Frame) :-
    eccs_sys_var(Var), 
    hpsg_in_vt(Var, VT, _, Info), 
    (eccs_memberchk(constraints = [], Info) -> true; trace),
    Frame = tag(Tag).
hpsgvt2frame_do_tag_full_value(Tag, Type, FS, Cs, Path, VT, Frame):-
    Frame = tagged(Tag, SubFrame),
    hpsgvt2frame_do_value_nore(Type, FS, Cs, Path, VT, SubFrame).


/*

The following routine computes the best path under which info should
be printed, this appears as the first element of the list Sorted.

*/

hpsg_best_path(Paths, Sorted) :-	
    hpsg_sort_paths(Paths, Sorted).

/*


hpsgvt2frame_do_value_nore(Type, FS, Cs, Path, Frame).    

Handle non-reentrant cases.

*/

hpsgvt2frame_do_value_nore(var, Var, AllCs, Path, VT, SPF) :-
    hpsg_in_vt(Var, VT, _, Info),
    eccs_memberchk(constraints = CsHere, Info),
    (CsHere = [] -> 
	SPF = uninstantiated
      ; hpsgvt2frame_format_cs(CsHere, AllCs, Path, VT, CsOut),
        hpsgvt2frame_var_format_cs(CsOut, SPF)).
hpsgvt2frame_do_value_nore(list, FS, Cs, Path, VT, sequence(Frame)) :-
    hpsgvt2frame_dv_list(FS, Cs, Path, VT, Frame).
hpsgvt2frame_do_value_nore(avm, FS, Cs, Path, VT, avm(Frame)) :-
    hpsgvt2frame_dv_avm(FS, Cs, Path, VT, AVPs),
    hpsg_in_vt(FS, VT, _, Info),
    eccs_memberchk(constraints = CsHere, Info),
    (CsHere = [] -> 
	CsOut = []
      ; hpsgvt2frame_format_cs(CsHere, Cs, Path, VT, CsOut)),
    eccs_append(CsOut, AVPs, Frame).
hpsgvt2frame_do_value_nore(set, FS, _Cs, _Path, _VT, set(Frame)) :-
    FS = lset(Name, List), 
    list2set(Name, List, Set),
    hpsg2vt1_atomicset2list(Set, Frame).

/*

How to format constraints in case there is no avm at this node

*/

hpsgvt2frame_var_format_cs([C], C) :- !.	% single constraint
hpsgvt2frame_var_format_cs(Cs, conj(Cs)).	% probably not the best we can do. 

/*

hpsgvt2frame_format_cs(CsHere, AllCs, Path, VT, CsOut) 

Return a list of SPF formatted constraints.

*/
hpsgvt2frame_format_cs(CsHere, AllCs, Path, VT, CsOut) :-
    hpsgvt2frame_format_cs1(CsHere, AllCs, ['$$CONSTRAINT'|Path], VT, CsOut).
    

hpsgvt2frame_format_cs1([], _, _, _, []).
hpsgvt2frame_format_cs1([C|Cs], AllCs, Path, VT, [C1|Cs1]) :-
    C1 = relation(atomic(Name), Args1),
    C =.. [Name|Args],
    hpsgvt2frame_format_cs2(Args, AllCs, VT, Path, 0, Args1),
    hpsgvt2frame_format_cs1(Cs, AllCs, Path, VT, Cs1).

hpsgvt2frame_format_cs2([], _, _, _, _, []).
hpsgvt2frame_format_cs2([A|As], AllCs, VT, Path, Count, [ASPF|ASPFs]) :-
    hpsgvt2frame(A, AllCs, VT, [Count|Path], ASPF),
    eccs_succ(Count, Count1),
    hpsgvt2frame_format_cs2(As, AllCs, VT, Path, Count1, ASPFs).


/*

As we come here immediately from the type test, the first arg is
always a prolog list.

*/

hpsgvt2frame_dv_list(Var, _, _, _, []) :-  % Should never get here
    eccs_sys_var(Var), !.
hpsgvt2frame_dv_list([], _, _, _, []) :- !.
hpsgvt2frame_dv_list([E|Es], Cs, Path, VT, Out) :-
    hpsgvt2frame(E, Cs, VT, ['$$FIRST'|Path], H),
    RestPath = ['$$REST'|Path],
    ((eccs_sys_var(Es); \+ (eccs_member(Es, [[], [_|_]]))) ->
    	Out = [infix(symbol(degree), H, T)],
	hpsgvt2frame(Es, Cs, VT, RestPath, T)
      ; Out = [H|T],
        hpsgvt2frame_dv_list(Es, Cs, RestPath, VT, T)).


hpsgvt2frame_dv_avm([], _, _, _, []).
hpsgvt2frame_dv_avm([AVP|AVPs], Cs, Path, VT, Frame) :-
    AVP = [A, _],
    hpsg_shadowed_atts(As),
    eccs_memberchk(A, As), !,
    hpsgvt2frame_dv_avm(AVPs, Cs, Path, VT, Frame).
hpsgvt2frame_dv_avm([AVP|AVPs], Cs, Path, VT, [A= Val|Frame]) :-
    AVP = [A, V],
    hpsgvt2frame(V, Cs, VT, [A|Path], Val),
    hpsgvt2frame_dv_avm(AVPs, Cs, Path, VT, Frame).

hpsg_format_and_place([path(P, Root)], Cs, Var, F) :-
    eccs_sys_var(Var),			% single path to var
    !,
    hpsg_decode_constraints(Var, Cs, PrintValue),
    hpsg_follow_path(P, Root, PrintValue).

hpsg_decode_constraints(_Var, [], uninstantiated).

hpsg_follow_path(RevPath, Dag, Value) :-
    eccs_reverse(RevPath, Path),
    hpsg_follow_path1(Path, Dag, Value).

hpsg_follow_path1([], Dag, Dag1) :- !,
    merge_value_into_dag(Dag, Dag1).
hpsg_follow_path1(['$HEAD'|R], [Dag|_], Value) :- !,
    hpsg_follow_path1(R, Dag, Value).  
hpsg_follow_path1(['$TAIL'|R], [_|Dag], Value) :- !,
    hpsg_follow_path1(R, Dag, Value).
hpsg_follow_path1([Att|Atts], Dag, SubDag) :-
    delayed_memberchk(Att = Val, Dag),
    hpsg_follow_path1(Atts, Val, SubDag).

delayed_memberchk(A = Value, D) :-
    freeze(D, ( D = [A1 = V1|R],
    (A ==A1 -> Value = V1; 
	       delayed_memberchk(A = Value, R)))).




hpsg_sort_paths(Ps, SortedPs) :-
    eccs_once(eccs_closed_list(Ps)),
    hpsg_sort_paths1(Ps, SortedPs).

hpsg_sort_paths1([], []).
hpsg_sort_paths1([Ps], [Ps]) :- !.
hpsg_sort_paths1(Ps, SortedPs) :-
    hpsg_sort_paths2(Ps, [], SortedPs).


hpsg_sort_paths2([P], Rest, [P|Rest]) :- !.
hpsg_sort_paths2([P, P1|Rest], Others, Out) :-
    (hpsg_better_path(P, P1) -> 
	hpsg_sort_paths2([P|Rest], [P1|Others], Out)
      ; hpsg_sort_paths2([P1|Rest], [P|Others], Out)).



/*

Pairwise comparison of paths

We first check whether P1 contains any ``really bad attributes''; if
it does, and P doesn't, prefer P.

Otherwise if P1 is longer than P, prefer P.  (Note that because we
only store full paths the first time we come across a reentrant
structure, we will tend to place tags inside reentrant structures and
have the full AVM displayed outside; this is probably good behaviour.)

*/

hpsg_better_path(P, P1) :-
    hpsg_path_contains_bad_att(P1),
    \+ hpsg_path_contains_bad_att(P), !.

hpsg_better_path(P, P1) :-
    hpsg_path_contains_bad_att(P),
    \+ hpsg_path_contains_bad_att(P1), !,
    fail.



hpsg_better_path(P, P1) :-
    eccs_length(P, PN),
    eccs_length(P1, P1N),
    PN < P1N, !.

hpsg_path_contains_bad_att(Path) :-
    hpsg_really_bad_atts(Atts),
    eccs_member(A, Atts),
    eccs_memberchk(A, Path).


hpsg_really_bad_atts(Atts) :- 
    Atts = ['$$FIRST', '$$CONSTRAINT', '$$HEAD', 0].

/*

hpsg_sort_paths2(Ps, SortedPs) :-
    hpsg_path_ordering(POrder), 
    (POrder = [] -> 
	Ps = SortedPs
      ; hpsg_sort_paths_by_ordering(POrder, Ps, SortedPs)).

hpsg_path_ordering(POrder) :-
    (eccs_global_variable(preferred_attributes, POrder) -> true; POrder = []).
    

spf_instantiate_vars(Out) :-
    eccs_sys_var(Out), !,
    Out = tag(_).
spf_instantiate_vars(tag(_)) :- !.
spf_instantiate_vars(A) :-
    eccs_sys_atomic(A), !.
spf_instantiate_vars(X) :-
    X =.. [_|Args],
    spf_instantiate_vars_list(Args).

spf_instantiate_vars_list([]) :- !.
spf_instantiate_vars_list([A|As]) :-
    spf_instantiate_vars(A),
    spf_instantiate_vars_list(As).

*/    

/*

Binary tree of values for feature structures

*/

hpsg_in_vt(T, VT, There, Info) :-
    eccs_sys_var(VT), !,
    There = false,
    VT = t(T, _L, _R, Info).
hpsg_in_vt(T, VT, There, Info) :-
    VT = t(T1, _, _, _),
    eccs_sys_compare(Rel, T, T1),
    hpsg_in_vt1(Rel, T, VT, There, Info).

hpsg_in_vt1((=), _,  VT, true, Info) :-
    VT = t(_, _L, _R, Info).
hpsg_in_vt1((<),  T, VT, There, Info) :-
    VT = t(_, L, _R, _),
    hpsg_in_vt(T, L, There, Info).
hpsg_in_vt1((>),  T, VT, There, Info) :-
    VT = t(_, _L, R, _),
    hpsg_in_vt(T, R, There, Info).

