/*

File:	/home/dk2/jcalder/Pleuk/HPSG-PL/hpsgdc.pl
Date:	Mon Mar 15 16:29:48 1993
By:	Jo Calder


Interaction with the derivation checker --- 
based on ../SLE/sledc.pl


*/

:- eccs_set_variable(eccs_spec_supports_dc, true).

:- multifile hpsg_dc_table/2.
:- dynamic hpsg_dc_table/2.

/*

hpsg_dc_table/2

should give the following info:

hpsg_dc_table(Name, ListOfKeyValuePairs)

where Name is the name of the grammar and ListOfKeyValuePairs has the
top level structure

[Key = Value, ... Keyn = Valuen].

Here are keys and what they mean.  Fpath means a colon separated
sequence of feature names.

schema_types = [SName-DtrsType-Range]

where SName is the name of the schema in the grammar, DtrsType is the
type of dtrs introduced (i.e. comp_dtrs, adj_dtrs, etc) and Range
takes the form [I1, I2, ...In], Ii an integer, meaning that for each
Ii, the schema may introduce Ii dtrs of type DtrsType.

name_for_head_dtr = <FeatureNameforHeadDtrs>

head_dtr_alias = PrologAtom  (e.g. 'H')

dtrs_path = Fpath to daughters

other_dtrs = ListOfAllNonHeadDtrs

a list of prolog atoms which represent non-head daughters,
e.g. [comp_dtrs, adj_dtrs, ...]

other_dtrs_aliases = ListOfPrologAtoms

where the order matches that of other_dtrs. e.g. ['C', 'A', ...]

lex_path   = Fpath leading to lex value (e.g. synsem:local:lex)

phon_path  = Fpath leading to phon value (e.g. phon)

plus_value = Atom representing positive value of feature 
minus_value = ditto for negative


e.g.

hpsg_dc_table(env,
	[schema_types = [1-comp_dtrs-[1], 
			 2-comp_dtrs-[0, 1, 2, 3],
			 3-comp_dtrs-[0, 1, 2, 3],
			 4-adj_dtrs-[1],
			 5-adj_dtrs-[1]],
	 name_for_head_dtr = head_dtr,
	 head_dtr_alias    = 'H',
	 dtrs_path 	   = dtrs,
	 other_dtrs	   = [comp_dtrs, adj_dtrs, filler_dtrs],
	 other_dtrs_aliases = ['C', 'A', 'F'],
	 lex_path	   = syn:loc:lex,
	 phon_path	   = phon,
	 plus_value	   = '+',
	 minus_value	   = '-']).


*/

hpsg_dc_binding_info(Key, Value) :-
    eccs_global_variable(grammar_name, Name),
    hpsg_dc_table(Name, KVPairs),
    eccs_memberchk(Key=Value, KVPairs).



spec_dc_start_ok :-
    (eccs_get_from_database(_, _, _) -> true;
    	eccs_message([no, files, are, loaded]), fail),
    (hpsg_dc_binding_info(_, _) -> true;
        eccs_message([this, grammar, does, not, work, with, the, 
			derivation, checker]), fail).


spec_dc_prepare(schema, _, Tag, Result) :-
    hpsg_dc_binding_info(schema_types, STs),
    eccs_get_from_databaser(rule, SNo, rule(SNo, Object,_Cs), DBRef),
    eccs_member(SNo-Type-Range, STs),
    eccs_member(NumberOfDs, Range),
    Tag = schema(DBRef-SNo-Type-NumberOfDs),
    hpsg_expand_schema(Object, Tag, Type, NumberOfDs, _),
    hpsg_obj2spf(Object, schema(SNo), [], Tag, Result).

spec_dc_prepare(lexical_entry, Name, lexical(DBRef), Result) :-
    hpsg_dc_lex_lookup_all(Name, DBRef, _),
%    Result = tree(atomic('H'), [atomic(Name)]).
    Result = atomic(Name).

spec_dc_prepare(empty_category, +Name, empty_category(DBRef), Result) :-
    eccs_get_from_databaser(entry, +Name, _, DBRef),
    Result = atomic(Name).

spec_dc_prepare(derivation(Tag), SPF) :-
    hpsg_dc_lookup(derivation(Tag), Deriv),
    Deriv = M+_Cs,
    hpsg_obj2spf(M, _Name, [], derivation(Tag), SPF).

spec_dc_prepare(lexical(Tag), SPF) :-
    spec_dc_prepare(lexical_entry, _Name, lexical(Tag), SPF).
spec_dc_prepare(schema(Tag), SPF) :-
    spec_dc_prepare(schema, _Name, schema(Tag), SPF).
spec_dc_prepare(empty_category(DBRef), SPF) :-
    eccs_get_from_databaser(entry, +Name, _, DBRef),
    SPF = atomic(Name).


hpsg_expand_schema(Object, schema(_-SNo-Type-NumberOfDs), Type, NumberOfDs, _) :-
    hpsg_add_dtrs(SNo, Object, Type, NumberOfDs).
    
hpsg_dc_schema_name(FS, N) :-
    eccs_memberchk(schema = N, FS),
    eccs_sys_nonvar(FS), !.
hpsg_dc_schema_name(_, '?').

hpsg_dc_lex_lookup_all(Name, DBRef, Def) :-
    findall(N1+DBRef1, 
    	    (eccs_get_from_databaser(entry, Name, _IntDef, DBRef1),
	     hpsg_massage_name(Name, N1)),
	    Names),
    eccs_sort(Names, NSorted),
    eccs_reverse(NSorted, NS1),
    eccs_member(Name+DBRef, NS1),
    \+ (Name = ' ' ; Name = +(_)),
    Def = atomic(Name). 

hpsg_massage_name(Name, N1) :-
    eccs_sys_atomic(Name), !, 
    N1 = Name,
    \+ N1 = ' '.



hpsg_dc_lex_lookup(Name, DBRef, Def) :-
    eccs_sys_nonvar(DBRef),
    eccs_get_from_databaser(entry, Name, IntDef, DBRef),
    IntDef  = entry(_, M, Cs),
    Def = M+Cs.

/*

hpsg_add_dtrs(SchemaNumber, FS, DtrsType, NumberOfDs)

instantiate schema in feature structure FS with NumberOfDs of DtrsType.


*/

hpsg_add_dtrs(_SName, FS, Type, N) :-
    (eccs_sys_var(Type) -> 
	eccs_error([variable, appears, as, type, of, daughter])
      ; true),
    hpsg_dc_binding_info(dtrs_path, DF),
    (hpsg_path_really_there(DF:Type, FS, List) ->
	true
      ; eccs_error([unable, to, instantiate, DF:Type])),
    hpsg_instantiate_list(N, List).



hpsg_instantiate_list(0, []) :- !.
hpsg_instantiate_list(N, G) :-
    N > 0,
    G = [_|T],
    eccs_succ(M, N),
    hpsg_instantiate_list(M, T).



hpsg_obj2spf(FS, Name, Path, Tag, SPF) :-
    (eccs_sys_nonvar(Name), Name = schema(N) -> 
	eccs_concat_list([schema, ' ', N], PrintName)
      ; PrintName = ''),
    hpsg_do_dtr(FS, PrintName, Tag, Path, SPF).


hpsg_feature_really_there(_FName, FSG, _Value) :-
    eccs_sys_var(FSG), 
    !,
    fail.
hpsg_feature_really_there(_FName, [], _) :-
    !,
    fail.
hpsg_feature_really_there(FName, [[FN, V]|_], Value) :-
    FName == FN, !,
    V = Value.
hpsg_feature_really_there(FName, [_|Rest], Value) :-
    hpsg_feature_really_there(FName, Rest, Value).

hpsg_path_really_there(FName, _FS, _Value) :-
    eccs_sys_var(FName),
    !,
    eccs_error([variable, name, in, path]).
hpsg_path_really_there(FName, FS, Value) :-
    eccs_sys_atomic(FName),
    hpsg_path_really_there1(FName, FS, Value).
hpsg_path_really_there(FName:FNames, FS, Value) :-
    hpsg_path_really_there(FName, FS, FValue),
    hpsg_path_really_there(FNames, FValue, Value).

hpsg_path_really_there1(_, FS, _) :-
    (eccs_sys_var(FS); FS == []),
    !,
    fail.
hpsg_path_really_there1(FName, [[FName1, Value]|_], V1) :-
    FName == FName1,
    !,
    Value = V1.
hpsg_path_really_there1(FName, [_|Rest], V) :-
    hpsg_path_really_there1(FName, Rest, V).
	
	


hpsg_do_dtr(D, Alias, _Tag, _Path, SPF) :-
    hpsg_dc_lexical(D),
    hpsg_dc_phon_instantiated(D),
    !,
    hpsg_dc_binding_info(phon_path, PP),
    hpsg_path_really_there(PP, D, Phon),
    hpsg_dc_massage_phon(Phon, PhonSPF),
    SPF = tree(atomic(Alias), [PhonSPF]).
hpsg_do_dtr(D, Alias, _Tag, _Path, SPF) :-
    hpsg_dc_phon_value(D, Value),
    Value == [], !,			% We have an empty category
    SPF = tree(atomic(Alias), [symbol(epsilon)]).
hpsg_do_dtr(D, Alias, Tag, Path, SPF) :-
    hpsg_dc_insertion_point(D), !,
    SPF = sensitize(triangle(atomic(Alias)), insert_selection(Path, Tag)).
hpsg_do_dtr(D, Alias, Tag, Path, SPF) :-
    hpsg_dc_binding_info(dtrs_path, DP),
    hpsg_path_really_there(DP, D, DTRS),
    hpsg_do_dtrs(DTRS, Tag, [DP|Path], SPFDs),
    SPF = tree(atomic(Alias), SPFDs).

hpsg_do_dtrs(DTRS, Tag, Path, [SPFH|SPFOs]) :-
    hpsg_dc_binding_info(name_for_head_dtr, HDN),
    hpsg_path_really_there(HDN, DTRS, HD),
    hpsg_dc_binding_info(head_dtr_alias, HDA),
    hpsg_do_dtr(HD, HDA, Tag, [HDN|Path], SPFH),
    hpsg_do_other_dtrs(DTRS, Tag, Path, SPFOs).

hpsg_do_other_dtrs(Var, _, _, []) :-
    (eccs_sys_var(Var); Var == []), !.
hpsg_do_other_dtrs([[DType, _]|Rest], Tag, Path, SPFList) :-
    hpsg_dc_binding_info(name_for_head_dtr, HDN),
    HDN == DType,
    !,
    hpsg_do_other_dtrs(Rest, Tag, Path, SPFList).
hpsg_do_other_dtrs([[DType, ListofDs]|Rest], Tag, Path, SPFList) :-
    hpsg_do_these_dtrs(DType, ListofDs, Tag, Path, SPFList, Tail),
    hpsg_do_other_dtrs(Rest, Tag, Path, Tail).


hpsg_do_these_dtrs(_, Var, _, _, Tail, Tail) :- 
    (eccs_sys_var(Var); Var == []), !.
hpsg_do_these_dtrs(DType, ListofDs, Tag, Path, SPFList, Tail) :-
    (hpsg_dc_dtr_alias(DType, Alias) -> 
	true
      ; eccs_error([problems, with, mapping, DType, daughters])),
    hpsg_dc_list2spf(ListofDs, Alias, Tag, [DType|Path], SPFList, Tail).

hpsg_dc_list2spf(Var, _, _, _, Tail, Tail) :-
    (eccs_sys_var(Var); Var == []), !.
hpsg_dc_list2spf([D|Ds], Alias, Tag, Path, [SPFD|Rest], Tail) :-
    hpsg_do_dtr(D, Alias, Tag, ['$$FIRST'|Path], SPFD),
    hpsg_dc_list2spf(Ds, Alias, Tag, ['$$REST'|Path], Rest, Tail).

   
	
/*

Various properties of elements.

*/

hpsg_dc_lexical(FS) :-
    hpsg_dc_binding_info(lex_path, Path),
    hpsg_dc_binding_info(plus_value, PV),
    hpsg_path_really_there(Path, FS, Value),
    Value == PV.

hpsg_dc_non_lexical(FS) :-
    hpsg_dc_binding_info(lex_path, Path),
    hpsg_dc_binding_info(minus_value, PV),
    hpsg_path_really_there(Path, FS, Value),
    Value == PV.




hpsg_dc_has_dtrs(FS) :-
    hpsg_dc_binding_info(dtrs_path, DP),
    hpsg_path_really_there(DP, FS, DTRS),
    eccs_sys_nonvar(DTRS),
    DTRS = [_|_].

hpsg_dc_may_have_dtrs(FS) :-
    hpsg_dc_binding_info(dtrs_path, DP),
    hpsg_path_really_there(DP, FS, DTRS),
    eccs_sys_var(DTRS).

hpsg_dc_no_dtrs(FS) :-
    hpsg_dc_binding_info(dtrs_path, DP),
    hpsg_path_really_there(DP, FS, DTRS),
    DTRS == [].
    


hpsg_dc_phon_instantiated(FS) :-
    hpsg_dc_phon_value(FS, Value),
    eccs_sys_nonvar(Value),
    (eccs_sys_atomic(Value);
     Value = [F|_], eccs_sys_nonvar(F)), !.
    
hpsg_dc_phon_value(FS, Value) :-
    hpsg_dc_binding_info(phon_path, Path),
    hpsg_path_really_there(Path, FS, Value).

hpsg_dc_massage_phon(EList, symbol(epsilon)) :- 
    EList == [], !.
hpsg_dc_massage_phon(Phon, italic(PhonSPF)) :-
    Phon = [Atom],
    eccs_sys_atomic(Atom),
    PhonSPF = Atom, !.
hpsg_dc_massage_phon(Phon, italic(PhonSPF)) :-
    Phon = [_, _|_],
    eccs_interpolate_char(' ', Phon, P1),
    eccs_concat_list(P1, PhonSPF).

hpsg_dc_insertion_point(Var) :-
    eccs_sys_var(Var),
    !.
hpsg_dc_insertion_point(FS) :-	% trap for elements with empty phon
    hpsg_dc_phon_value(FS, V), 
    V == [], !, fail.
hpsg_dc_insertion_point(FS) :-
    hpsg_dc_lexical(FS),
    \+ hpsg_dc_phon_instantiated(FS).
hpsg_dc_insertion_point(FS) :-
    hpsg_dc_may_have_dtrs(FS).





spec_dc_do_insert(Key, InsertTag, SelTag, derivation(Tag, SPFTree)) :-
    hpsg_dc_lookup(SelTag, Sel),
    hpsg_dc_lookup(InsertTag, Insert),
    hpsg_interpret_insert(Key, Sel, Insert, Result),
    hpsg_note_derivation(Result, Tag),
    Result = M+_Cs,
    hpsg_obj2spf(M, _Name, [], Tag, SPFTree).


hpsg_dc_lookup(Tag, Schema) :- 
    Tag = schema(DBRef-SNo-Type-NumberOfDs),
    eccs_get_from_databaser(rule, SNo, Def, DBRef),
    Def = rule(_, M, Cs),
    Schema = M+Cs,
    hpsg_expand_schema(M, Tag, Type, NumberOfDs, _FS).


hpsg_dc_lookup(lexical(DBRef), FS) :- !,
    hpsg_dc_lex_lookup(_Name, DBRef, FS).
hpsg_dc_lookup(derivation(DBRef), Derivation) :-
    eccs_sys_clause(hpsg_deriv_table(Derivation), _, DBRef).
hpsg_dc_lookup(empty_category(DBRef), M+Cs) :-
    eccs_get_from_databaser(entry, +_, entry(_, M, Cs), DBRef).

:- dynamic hpsg_deriv_table/1.

hpsg_note_derivation(Result, derivation(Tag)) :-
    eccs_sys_assert(hpsg_deriv_table(Result), Tag).

/*

hpsg_interpret_insert(Key, Selection, Target, Result)

Here, Selection is the structure currently selected and Target is the 
structure in which Selection is to be inserted at a position determined by
Key.  

We pull the graphs and constraints apart and look for the material at the 
insertion point.  We graph unify the selection and insertion point, assuming 
that this will have side effect back into the target.  If successful, we 
then proceed to check constraints.  

*/

hpsg_interpret_insert(Key, Sel+SelCs, Target+TCs, Result) :-
    (Key = [_|_] -> eccs_reverse(Key, Key1); Key1 = Key),
    hpsg_interpret_key(Key1, Target, TarSubG),
    (Sel = TarSubG -> 
	true
      ; hpsg_why_fail_term_unify(Sel, TarSubG), fail),
    eccs_append(SelCs, TCs, Cs),
    findall(Target+NewCs, hpsg_constraint_satis(Cs, NewCs), NewCsList),
    (NewCsList = [_|_] ->
	true
      ; hpsg_why_fail_constraints(Cs, Sel, Target), fail),
    eccs_message([insertion, succeeds]),
    eccs_member(Result, NewCsList).



hpsg_interpret_key([], G, G) :- !.
hpsg_interpret_key([K|Ks], G, G1) :-
    hpsg_interpret_key(K, G, G2),
    hpsg_interpret_key(Ks, G2, G1).
hpsg_interpret_key('$$FIRST', [F|_], F) :-
    !.
hpsg_interpret_key('$$REST',  [_|R], R) :-
    !.
hpsg_interpret_key(F, FS, SubGraph) :-
    eccs_sys_atomic(F),
    eccs_memberchk([F, SubGraph], FS).


    		  
hpsg_constraint_satis([], []). 
hpsg_constraint_satis(X, XOut) :-
    hpsg_constraint_satis0(X, XNew),
    (XNew == X -> 
	XOut = X
      ; hpsg_constraint_satis(XNew, XOut)).

hpsg_constraint_satis0([], []) :- !.
hpsg_constraint_satis0([C|Rest], Out) :-
    !,
    (hpsg_constraint_satis_deterministic(C) ->
    	eccs_sys_call(C),
	hpsg_constraint_satis0(Rest, Out)
      ; hpsg_constraint_satis0(Rest, O1),
        Out = [C|O1]).
hpsg_constraint_satis0([Other|Rest], [Other|Satis]) :-
    hpsg_constraint_satis0(Rest, Satis).

hpsg_constraint_satis_deterministic(concat(X, Y, Z)) :-
    hpsg_list_of_known_length(Z),
    (hpsg_list_of_known_length(X); hpsg_list_of_known_length(Y)).
hpsg_constraint_satis_deterministic(concat(X, Y, _Z)) :-
    hpsg_list_of_known_length(X),
    hpsg_list_of_known_length(Y).
%hpsg_constraint_satis_deterministic(order(_DTRS, Phon)) :-
%    hpsg_list_of_known_length(Phon).
hpsg_constraint_satis_deterministic(order(DTRS, _Phon)) :-
    DTRS = [[_H,Head], [_C,Comps], [_A,Adjs], [_F,Fillers]], % from constraints.pl
    (Head = DTR; eccs_member(DTR, Comps); Adjs = [DTR]; Fillers = [DTR]),
    (hpsg_feature_really_there(phon, DTR, Value), hpsg_list_of_known_length(Value) ->
	fail
      ; !, fail).
hpsg_constraint_satis_deterministic(order(_, _)).      

hpsg_list_of_known_length(Var) :- 
    eccs_sys_var(Var), !,
    fail.
hpsg_list_of_known_length([]).
hpsg_list_of_known_length([_|T]) :-
    hpsg_list_of_known_length(T).


hpsg_why_fail_term_unify(Sel, Tar) :-
    hpsg_term_failing_paths(Ps, Sel, Tar),
    (Ps = [] -> 
	eccs_message([unable, to, determine, cause, of, unification, failure])
      ; (Ps = [_] -> 
	    Reasons = reason
	  ; Reasons = reasons)),
    eccs_message([unification, fails, for, the, following, Reasons]),
    hpsg_report_term_fails(Ps).

hpsg_report_term_fails([]).
hpsg_report_term_fails([p(Path, Sel, Tar)|Ps]) :-
    eccs_reverse(Path, P),
    hpsg_report_term_fail1(P, Sel, Tar),
    hpsg_report_term_fails(Ps).

hpsg_report_term_fail1(Path, Sel, Tar) :-
    Sel = [], Tar = [_|_],
    !,
    hpsg_report_term_fail_lists(Path, Sel, Tar).
hpsg_report_term_fail1(Path, Sel, Tar) :-
    Tar = [], Sel = [_|_],
    !,
    hpsg_report_term_fail_lists(Path, Sel, Tar).

hpsg_report_term_fail1(Path, A1, A2) :-
    eccs_sys_atomic(A1),
    eccs_sys_atomic(A2),
    eccs_message(['As', value, for, the, path|Path]),
    eccs_message([the, selection, has, A1, while]),
    eccs_message(['   the', target, has, A2]).
    
hpsg_report_term_fail1(Path, Atom, Comp) :-
    eccs_sys_atomic(Atom),
    \+ eccs_sys_atomic(Comp),
    eccs_message(['As', value, for, the, path|Path]),
    eccs_message([the, selection, has, Atom, while]),
    eccs_message([the, target, has, features, and, values]).
hpsg_report_term_fail1(Path, Comp, Atom) :-
    eccs_sys_atomic(Atom),
    \+ eccs_sys_atomic(Comp),
    eccs_message(['As', value, for, the, path|Path]),
    eccs_message([the, selection, has, features, and, values, while]),
    eccs_message([the, target, has, Atom]).

hpsg_report_term_fail_lists(Path, [], _) :-
    eccs_message(['As', value, for, the, path|Path]),
    eccs_message([the, selection, has, the, empty, list, while]),
    eccs_message([the, target, has, a, 'non-empty', list]).
hpsg_report_term_fail_lists(Path, _, []) :-
    eccs_message(['As', value, for, the, path|Path]),
    eccs_message([the, selection, has, a, 'non-empty', list, while]),
    eccs_message([the, target, has, the, empty, list]).

    


hpsg_term_failing_paths(Ps, Sel, Tar) :-
    hpsg_term_failing_paths(Sel, Tar, [], [], Ps).

hpsg_term_failing_paths(X, X, _, Ps, Ps) :- 
    !.
hpsg_term_failing_paths(X, Y, Path, Ps, [p(Path,X,Y)|Ps]) :-
    ( eccs_sys_atomic(X), eccs_sys_atomic(Y)
    ; eccs_sys_atomic(X), value_type(T, Y), \+ (T = atom)
    ; eccs_sys_atomic(Y), value_type(T, X), \+ (T = atom)).
hpsg_term_failing_paths(X, Y, Path, Ps, PsOut) :-
    value_type(avm, X),
    value_type(avm, Y), !,
    hpsg_term_failing_paths_avm(X, Y, Path, Ps, PsOut).
hpsg_term_failing_paths(X, Y, Path, Ps, PsOut) :-
    value_type(list, X),
    value_type(list, Y), !,
    hpsg_term_failing_paths_list(X, Y, Path, Ps, PsOut).

hpsg_term_failing_paths_avm([], [], _, Ps, Ps) :- 
    !.
hpsg_term_failing_paths_avm([[F1, V1]|R1], [[F2, V2]|R2], Path, PsIn, PsOut) :-
    (F1 == F2 -> 
	true
      ; eccs_message(['HPSG-PL', 'error:', different, feature, names, F1, F2,
			appear, in, corresponding, positions]), fail),
    hpsg_term_failing_paths(V1, V2, [F1|Path], PsIn, Ps1),
    hpsg_term_failing_paths_avm(R1, R2, Path, Ps1, PsOut).

hpsg_term_failing_paths_list([], [H|T], Path, Ps, [p(Path,[],[H|T])|Ps]) :-
    !.
hpsg_term_failing_paths_list([H|T], [], Path, Ps, [p(Path,[H|T],[])|Ps]) :-
    !.
hpsg_term_failing_paths_list([], [], _, Ps, Ps) :- 
    !.
hpsg_term_failing_paths_list([F1|R1], [F2|R2], Path, PsIn, PsOut) :-
    hpsg_term_failing_paths(F1, F2, ['$$FIRST'|Path], PsIn, Ps1),
    hpsg_term_failing_paths_list(R1, R2, ['$$REST'|Path], Ps1, PsOut).


hpsg_why_fail_constraints(_Cs, _Sel, _Target) :-
    eccs_message([a, constraint, fails]).


/*

If there is an entry in the database for a lexical item whose name
begins with +, this represents an empty category, and we bring up a
separate window.

*/

spec_windows([window('Schemata', [900, 150], type(schema)), 
	      window('Lexical entries', [900, 200], type(lexical_entry)),
	      window('Derivation Window', [400, 400])|ECs]) :-
   (eccs_get_from_database(entry, +_, _) ->
	ECs = [window('Empty categories', [900, 100], type(empty_category))]
      ; ECs = []). 



spec_report(selection(Tag)) :-
    hpsg_tag_to_name_and_type(Tag, Type, Name),
    eccs_message([Type, Name, selected]).
spec_report(insertion_attempt(Sel, Key, Target)) :-
    hpsg_tag_to_name_and_type(Sel, SelType, SelName),
    hpsg_tag_to_name_and_type(Target, TType, TName),
    (Key = [_|_] -> eccs_reverse(Key, K1) ; K1 = [Key]),
    hpsg_print_form_of_key(K1, PF),
    eccs_message([attempting, to, insert, SelType, SelName, as,
		PF, TType, TName]).

hpsg_print_form_of_key(K, K) :-
    eccs_sys_atomic(K), !.
hpsg_print_form_of_key(K, PF) :-
    hpsg_print_form_of_key1(K, K1),
    eccs_interpolate_char(' ', K1, K2),
    eccs_concat_list(K2, PF).

hpsg_print_form_of_key1(L, L).

hpsg_tag_to_name_and_type(empty_category(Tag), 'empty category', Name) :-
    eccs_get_from_databaser(entry, +Name, _, Tag).
hpsg_tag_to_name_and_type(lexical(Tag), 'lexical entry', Name) :-
    hpsg_dc_lex_lookup(Name, Tag, _).
hpsg_tag_to_name_and_type(schema(DBRef-SNo-_Type-_Dtrs), schema, SNo).


hpsg_tag_to_name_and_type(derivation(Tag), derivation, '') :-
    hpsg_dc_lookup(derivation(Tag), _Deriv).


spec_delete_object(lexical(_)).
spec_delete_object(rule(_)).
spec_delete_object(derivation(Tag)) :-
    eccs_sys_erase(Tag).

spec_add_lexical(Tag, SPF)  :-
   eccs_do_menu(dbox, [ fields = [field('Lexical entry to add', '')],
	 		command=hpsg_prep_lexical('$$', Tag, SPF)]).

hpsg_prep_lexical(Atom, Tag, SPF) :-
    spec_dc_prepare(lexical_entry, Atom, Tag, SPF).



spec_add_parse(Tag, SPF) :-
    eccs_do_menu(dbox, [ fields = [field('String to parse', '')],
    			 command=hpsg_prep_parse('$$', Tag, SPF)]).

hpsg_prep_parse(Atom, derivation(Tag), SPF) :-
    eccs_sys_name(Atom, L),
    eccs_massage_input(L, list, eccs_generic_tokenizer, Massaged),
    eccs_hpsg_budc(Massaged, Parses),
    eccs_length(Parses, N),
    (N = 0 -> eccs_message([no, parses, found, for, Atom]), fail;
    	      eccs_message([N, 'parse(s)', found, for, Atom])),
    eccs_member(P, Parses),
    eccs_hpsg_parse2dc(P, Deriv),
    hpsg_note_derivation(Deriv, derivation(Tag)),
    Deriv = M+_Cs,
    hpsg_obj2spf(M, Name, [], derivation(Tag), SPF).

    
    


eccs_hpsg_budc(L, Results) :-
    Results = [_|_],
    parse([], L, Results), !.
eccs_hpsg_budc(_, []).

eccs_hpsg_parse2dc(P, P).



    
spec_tag2strictspf(Tag, SPF) :-
    spec_dc_prepare(Tag, SPF1),
    dc_filter_sensitive(SPF1, SPF).

spec_dc_options(
	[option('show full avm for selection', 
			hpsg_show_fs, dc_last_selection(_)),
	 option('print full avm for selection',
			hpsg_print_fs, dc_last_selection(_))]).

hpsg_show_fs :-
    dc_last_selection(Sel),
    hpsg_dc2fullspf(Sel, SPF, Name),
    dc_display_object(Name, SPF).
    
    
hpsg_dc2fullspf(derivation(Tag), SPF, 'Full form of derivation') :-
    hpsg_dc_lookup(derivation(Tag), Deriv),
    hpsg2spf(Deriv, SPF).
hpsg_dc2fullspf(lexical(DBRef), SPF, Cap) :-
    hpsg_dc_lex_lookup(Name, DBRef, Def),    
    eccs_concat_list(['lexical entry "', Name, '"'], Cap),
    hpsg2spf(Def, SPF).
hpsg_dc2fullspf(schema(Tag), SPF, Cap) :-
    Tag = DBRef-Name-Type-NumberOfDs,
    eccs_concat_list([schema, ' ', Name], Cap),
    eccs_get_from_databaser(rule, Name, rule(Name, M, Cs), DBRef),
    hpsg_expand_schema(M, schema(Tag), Type, NumberOfDs, _FS),
    hpsg2spf(M+Cs, SPF).
hpsg_dc2fullspf(empty_category(DBRef), SPF, Cap) :-
    eccs_concat_list(['empty category "', Name], Cap),
    eccs_get_from_databaser(entry, +Name, entry(_, M, Cs), DBRef),
    hpsg2spf(M+Cs, SPF).


hpsg_dc_dtr_alias(DType, Alias) :-
    hpsg_dc_binding_info(other_dtrs, ODs),
    hpsg_dc_binding_info(other_dtrs_aliases, ODAs),
    eccs_member_pair(DType, Alias, ODs, ODAs).

/*

PostScript output

*/

hpsg_print_fs :-
    dc_last_selection(Sel),
    hpsg_dc2fullspf(Sel, SPF, Cap), !,
    eccs_dc_hardcopy(captioned(Cap, SPF)).


