%$Header: /usr/chrisbr/Pleuk/Grammars/HPSG-PL/RCS/example.typ,v 1.0 1993/04/27 16:36:59 pleuk Exp $
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%    examples of type declarations for use with HPSG-PL system, V1.2
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%% AV Types %%%%%


/*
   Declare the structure of the signs (feature matrices)
   --- declare the AV types --- using the "has" operator
   as opposed to explicitly with the "type" command as
   described in Popowich and Vogel (1991)
   
   Note:   
            A   has B   is equivalent to   A   type [A, B].
            A-x has B   is equivalent to   A-x type [A, B].
            !A          is equivalent to   [A, _]
*/

% Semantics - based on Pollard and Sag Chapter 4

index	has  [!var, !restriction].
cont    has  [!quant, !scope, @index, !rlt].
sem	has  [!indices, @cont].

% Syntax

agr	has  [!num, !per, !gen].
maj	has  [!n,!v].
head    has  [@maj, !min, !form, !inv, !aux, !case, !agr, !heads].
loc	has  [@head, !subcat, !lex].
inher   has  [!slash, !rel, !que].
to_bind has  [!slash, !rel, !que].
non_loc	has  [@inher, @to_bind].
syn 	has  [@loc, @non_loc].

/*
  Define the domains for our set-valued features...  We only allow
  sets of atoms
*/

form	domain	[fin, bse, inf, prp, psp, pas].
case	domain	[nom, acc, gen].

fin	type	form set [fin].
bse	type	form set [bse].
inf	type	form set [inf].
prp	type	form set [prp].
psp	type	form set [psp].
pas	type	form set [pas].
part	type	form set [prp,psp].

nom	type	case set [nom].
obj	type	case set [acc].


%%%%% Lexical Types (the lexical hierarchy) %%%%%

% Different types of signs

sign	type [!dtrs, !phon, @sem, @syn].

sign(Loc,Cont) type @sign with
   syn:loc = Loc with
   sem:cont = Cont.

/* 
  Observe that in the declaration of the "sign" type above, we did not
  spell out the structure of the "dtrs" attribute.  Here we show how
  it can be done within a subsequent type declaration.
*/

lsign	type @sign with dtrs = [].

psign	type @sign  with % Phrasal Sign
   dtrs = [!head_dtr, !comp_dtrs, !adj_dtrs, !filler_dtrs] with
   dtrs:head_dtr = @sign.

sat	type @sign with % Saturated
   syn:loc:subcat = [].

unsat	type @sign with % Unsaturated
   syn:loc:subcat = [_|_].

not_adjn type @sign with % A sign that cannot be an adjunct
   syn:loc:head:heads = [].

%%%% Basic semantic macros

reln1(Reln,Arg1) type [!reln, !arg1] with
   reln = Reln with
   arg1 = Arg1.

reln2(Reln,Arg1,Arg2) type [!reln, !arg1, !arg2] with
   reln = Reln with
   arg1 = Arg1 with
   arg2 = Arg2.

reln3(Reln,Arg1,Arg2,Arg3) type [!reln, !arg1, !arg2, !arg3] with
   reln = Reln with
   arg1 = Arg1 with
   arg2 = Arg2 with
   arg3 = Arg3.

idx type @sign with
   sem:cont:index = I with
   sem:indices = [I].

idcs_empty type @sign with
   sem:indices = []. 
 
%%%% Non-local Feature Principle related signs

% We introduce an alternative definition for the "syn" feature which contains
% only "loc" information.  This avoids the definition of a recursive type.

syn-1 	has  [@loc].

slash(Loc,Cont) type [@syn-1, @sem] with
  syn:loc = Loc with
  sem:cont = Cont.

% Macros for accessing NONLOC values

inh(Slash,Rel,Que)  type @sign with
   syn:non_loc:inher:slash = Slash with
   syn:non_loc:inher:rel = Rel with
   syn:non_loc:inher:que = Que.

tob(Slash,Rel,Que) type @sign with
   syn:non_loc:to_bind:slash = Slash with
   syn:non_loc:to_bind:rel = Rel with
   syn:non_loc:to_bind:que = Que.

htob(Slash,Rel,Que) type @psign with
   dtrs:head_dtr:syn:non_loc:to_bind:slash = Slash with
   dtrs:head_dtr:syn:non_loc:to_bind:rel = Rel with
   dtrs:head_dtr:syn:non_loc:to_bind:que = Que.

nloc_empty type @inh([],[],[]) & @tob([],[],[]).  

% Trace (replaces dislocated object)

trace type @sign(Loc,Cont) & @inh([@slash(Loc,Cont)],[],[]) & @idcs_empty with
   phon = [] with
   syn:loc:head:case = @obj.

not_trace type @sign with phon = [_|_].            % ...and not a relativizer

% Various constraints on the head daughter of the phrase

hnot_trace type @psign with 
   dtrs:head_dtr:phon = [_|_].

hnot_gappy type @psign with 
   dtrs:head_dtr:syn:non_loc:inher:slash = [].

htob_empty  type @htob([],[],[]). 

% Category class definitions

det(Q,X) type @sat & @not_adjn & @idcs_empty with
   syn:loc:head:maj:n = undef with
   syn:loc:head:maj:v = undef with
   syn:loc:head:min = d with
   sem:cont:quant = Q with
   sem:cont:index:var = X.

noun(X) type @sign with
   syn:loc:head:form = norm with
   syn:loc:head:min = undef with
   syn:loc:head:maj:n = plus with
   syn:loc:head:maj:v = minus with
   sem:cont:index:var = X.

nlexnoun(X) type @noun(X) with
   syn:loc:lex = minus with
   syn:loc:head:heads = [_].

nominal(X,Rel) type @nlexnoun(X) & @unsat & @tob(_,Rel,_) & @inh(_,[],_) with
   syn:loc:head:heads = [@nlexnoun(X)].
   
adj(Reln) type @sat & @idx with
   syn:loc:head:heads = [@nominal(X,[])] with
   syn:loc:head:maj:n = plus with
   syn:loc:head:maj:v = plus with
   syn:loc:head:min = undef with
   sem:cont:index:var = X with 
   sem:cont:index:restriction = @reln1(Reln,X). 

prep	type @unsat with
   syn:loc:head:min = undef with
   syn:loc:head:maj:n = minus with
   syn:loc:head:maj:v = minus.

verb(Form) type @sign with
   syn:loc:head:min = undef with
   syn:loc:head:maj:n = minus with
   syn:loc:head:maj:v = plus with
   syn:loc:head:form = Form.

relativizer type @sign with
   syn:loc:head:min = undef with
   syn:loc:head:maj:n = undef with
   syn:loc:head:maj:v = undef.

% Definitions for types appearing on SUBCAT lists

np(Case,X) type @noun(X) & @sat with
   syn:loc:head:case = Case.

gintrans(X) type @unsat with
   syn:loc:subcat = [@np(@nom,X)].

xcomp(Form,X,Rlt) type @verb(Form) & @gintrans(X) with
   syn:loc:lex = minus with
   syn:loc:head:aux = minus with
   sem:cont:rlt = Rlt.

vp(Loc,Cont,Rlt) type @verb(@fin) & @inh([],[],[]) with
   syn:loc:lex = minus with
   syn:loc:subcat = [@sign(Loc,Cont)] with
   sem:cont:rlt = Rlt.

% SUBCAT class definitions

intrans	type @gintrans(X) with
   sem:cont:rlt = @reln1(_,X).

% Preposition class definitions

prep(Form) type @prep & @idx with
   syn:loc:head:heads = [@nominal(Subj,[]), 
                         @vp(_,_,_) & @gintrans(Subj) with
                               sem:cont:rlt = Rlt] with
   syn:loc:head:form = Form with
   syn:loc:subcat = [@np(@obj,Obj),@np(@nom,Subj)] with
   sem:cont:rlt = Rlt with
   sem:cont:index:var = Subj with
   sem:cont:index:restriction = @reln2(Form,Obj,Subj).

pp(Form,Obj,Subj) type @prep & @gintrans(Subj) with 
   syn:loc:lex = minus with
   syn:loc:head:form = Form with
   sem:cont:index:var = Subj with
   sem:cont:index:restriction = @reln2(Form,Obj,Subj).

% more SUBCAT stuff

trans	type @unsat with
   sem:cont:rlt = @reln2(_,X,Y) with
   syn:loc:subcat = [@np(@obj,Y),@np(@nom,X)].

intrans_pp(Form) type @unsat with      % verbs that subcategorize for a PP
   sem:cont:rlt = @reln2(_,X,Y) with   % like "rely", "depend" etc.
   syn:loc:subcat = [@pp(Form,Y,X),@np(@nom,X)].

ditrans	type @unsat with
   sem:cont:rlt = @reln3(_,X,Y,Z) with
   syn:loc:subcat = [@np(@obj,Z),@np(@obj,Y) & @not_trace,@np(@nom,X)].

icontrol(Form) type @unsat with                   % intrans-control
   sem:cont:rlt = @reln2(_,X,Z) with
   syn:loc:subcat = [@xcomp(Form,X,Z),@np(@nom,X)].

tcontrol(Form) type @unsat with                   % trans-control
   sem:cont:rlt = @reln3(_,X,Y,Z) with
   syn:loc:subcat = [@xcomp(Form,Y,Z),@np(@obj,Y),@np(@nom,X)]. 

% Types for lexical entries

lexentry  type @lsign & @nloc_empty with    
   syn:loc:lex = plus.

word(Phon) type @lexentry with
   phon = [Phon] with
   syn:loc:head:inv = minus.

% Noun class definitions

common(Reln) type @noun(X) & @unsat & @idx with % Common nouns
   syn:loc:subcat = [@det(_,X)] with
   syn:loc:head:heads = [@nominal(X,[])] with   % semantics of noun-noun 
   sem:cont:index:restriction = @reln1(Reln,X). % compounds not resolved

proper(Name) type @np(_,X) & @not_adjn & @idx with       % Proper Nouns
   sem:cont:index:restriction = @reln2(naming,X,Name).

% Verb class definitions

mainv(Form,Pred) type @verb(Form) & @idcs_empty & @not_adjn with
   syn:loc:head:aux = minus with
   syn:loc:head:inv = minus with
   sem:cont:rlt = [!reln|_] with
   sem:cont:rlt:reln = Pred.

auxil(Phon) type @verb(@fin) & @lexentry & @not_adjn & @idcs_empty with
   phon = [Phon] with
   syn:loc:head:aux = plus.

% Potential adjunct

adjunct(Heads) type @sign with
   syn:loc:head:min = undef with
   syn:loc:head:heads = Heads.

% Relative clause types

rel_pron(Case) type @np(Case,X) & @inh([],[X],[]) & @idcs_empty & @not_adjn.

gs(Loc,Cont,Rlt) type @verb(@fin) & @sat & 		    % `gappy' S (S/X)
                      @inh([@slash(Loc,Cont)],[],_) & @not_trace with		
   sem:cont:rlt = Rlt.

relat_adjunct(X,Rlt) type @adjunct([@nominal(X,[X])]) 
                          & @idx & @relativizer with
   sem:cont:index:var = X with
   sem:cont:index:restriction = Rlt with
   syn:loc:lex = plus with
   syn:loc:head:inv = minus.

% Relativizers according to Pollard & Sag, Volume 2

rltvzr_obj type @relat_adjunct(X,Rlt) & @inh([],[],[]) &
                @tob([@slash(Loc,Cont)],[],[]) with
   syn:loc:subcat = [@gs(Loc,Cont,Rlt),@sign(Loc,Cont) & @inh(_,[X],_)].

rltvzr_subj type @relat_adjunct(X,Rlt) & @sign(_,Cont) & @inh([],[],[]) & 
  		 @tob([],[],[]) with	            % not the same as in Vol 2!
   syn:loc:subcat = [@vp(Loc,Cont,Rlt),@sign(Loc,Cont) & @inh(_,[X],_)].

rltvzr_prep type @relat_adjunct(X,Rlt) & @inh([],[X],[]) 
      & @tob([@slash(Loc,Cont) with 
                 sem:cont:index:var = X with
                 syn:loc:head:maj:n = plus],[],[]) with
   syn:loc:subcat = [@gs(Loc,Cont,Rlt), 
                     @sign with syn:loc:lex=undef]. % unifies with nothing
                                % but must be here to be applied by Rule 2

% Parameterized lexical types for use in dictionary

adject(Phon)	type @word(Phon) & @adj(Phon).
det(Phon)	type @word(Phon) & @det(Phon,_).
cn(Phon)	type @word(Phon) & @common(Phon).
pn(Phon)	type @word(Phon) & @proper(Phon).
auxv(Phon)	type @auxil(Phon) & @icontrol(@bse).
transv(Phon,Form)          type @word(Phon) & @trans & @mainv(Form,Phon).

intransv_pp(Phon,Form,PForm) type @word(Phon) & @intrans_pp(PForm)
                                 & @mainv(Form,Phon).

intransv(Phon,Form)        type @word(Phon) & @intrans & @mainv(Form,Phon).
ditransv(Phon,Form)        type @word(Phon) & @ditrans & @mainv(Form,Phon).
icontrolv(Phon,Form,XForm) type @word(Phon) & @icontrol(XForm) 
                              & @mainv(Form,Phon).
tcontrolv(Phon,Form,XForm) type @word(Phon) & @tcontrol(XForm) 
                              & @mainv(Form,Phon).
preposition(P)	type @word(P) & @prep(P).
rpron(Phon,Case) type @rel_pron(Case) & @lsign & @tob([],[],[]) with
  phon = [Phon] with
  syn:loc:lex = plus with 
  syn:loc:head:inv = minus.

%%%%%  Principles %%%%%

% Head Feature Principle

hfp	type @psign with
   syn:loc:head = Sign with
   dtrs:head_dtr:syn:loc:head = Sign.

% Subcategorization Principle

subp	type @psign with
   syn:loc:subcat = Rest with
   syn:loc:lex = minus with        % modification to SUBCAT principle
   dtrs:comp_dtrs = Comps with
   dtrs:head_dtr:syn:loc:subcat = append(Comps,Rest).

% Constituent Ordering Principle

cop	type @psign with
   dtrs = Dtrs with
   phon = order(Dtrs).

% Semantics Principle 

semp	type @psign with
   dtrs:head_dtr:sem:indices = HInd with
   dtrs:head_dtr:sem:cont = HCont with
   dtrs:comp_dtrs = Comps with
   dtrs:adj_dtrs = Adjs with
   dtrs:filler_dtrs = Fillers with
   sem:indices = collect(HInd,Comps,Adjs,Fillers) with
   sem:cont = combine(HCont,Comps,Adjs).

% Nonlocal Feature Principle

nfp	type @psign with
   dtrs:head_dtr:syn:non_loc:inher = HInh with
   dtrs:head_dtr:syn:non_loc:to_bind = HToB with
   dtrs:comp_dtrs = Comps with
   dtrs:adj_dtrs = Adjs with
   dtrs:filler_dtrs = Fillers with 
   syn:non_loc:inher = nfp(HInh,HToB,Comps,Adjs,Fillers).

principles type @hfp & @subp & @cop & @semp & @nfp.

%%%%% Rules %%%%%

csign	type @psign with 
	dtrs:adj_dtrs = [] with   % Complement sign
	dtrs:filler_dtrs = [].

asign	type @psign with 
	dtrs:comp_dtrs = [] with  % Adjunct Sign 
	dtrs:filler_dtrs = [] with 
	dtrs:adj_dtrs = [@inh([],_,_) & @not_trace].

fsign	type @psign with          % Filler Sign
	dtrs:comp_dtrs = [] with
	dtrs:adj_dtrs = [] with
        dtrs:filler_dtrs = [@inh([],[],[])].

% Nonlexical Head daughter combines with final complement

1	rule	@principles & @csign & @htob_empty & @hnot_trace with
                dtrs:head_dtr:syn:loc:lex = minus with
                syn:loc:subcat = [] with
                dtrs:comp_dtrs = [@not_trace]. % 'trace' can't be the last comp

% Lexical Head daughter combines with all but final complement

2	rule	@principles & @csign & @hnot_gappy with 
		dtrs:head_dtr:syn:loc:lex =  plus with	    % relativizer can 
		dtrs:head_dtr:syn:loc:head:inv = minus with % be the head
		syn:loc:subcat = [_].

% Lexical Head daughter combines with all complements

3	rule	@principles & @csign & @sat & @hnot_trace with 
		dtrs:head_dtr:syn:loc:lex =  plus with
		dtrs:head_dtr:syn:loc:head:inv = plus.

% Unsaturated head combines with one adjunct at a time

4	rule	@principles  & @asign & @unsat &  @hnot_trace 
                  & @htob([],_,[]) with    % REL must be imposed by the adjunct!
                dtrs:adj_dtrs = [@adjunct([H|Heads])] with
		dtrs:head_dtr:syn:loc:lex = minus with
         	dtrs:head_dtr = select1([H|Heads]).

% Topicalization; 'gappy' head combines with filler 

5	rule	@principles & @fsign & @hnot_trace & @verb(@fin)
                  & @htob([@slash(Loc,Cont)],[],[]) with
                dtrs:head_dtr:syn:loc:subcat = [] with
		dtrs:head_dtr:syn:non_loc:inher:slash = [S|Slash] with
                dtrs:head_dtr:syn:non_loc:to_bind:slash = select([S|Slash]) with
		dtrs:filler_dtrs = [@sign(Loc,Cont)].
