/*

English UCG Grammar

Copyright 1986, 1989 
University of Edinburgh,
Centre for Cognitive Science

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('det.lex', '1.2', '1').

*/
/*---------------------------------------------------------------------------+
|        								     |
|	 Unchanged version of                                                |
|        /mnt1/jo/Acord/PIMPLE/Protolexicon/Lexicon/UCG/det.lex		     |
|        Created:           Mon Nov 24 18:36:44 1986			     |
|        By:                Jo Calder					     |
|        date of last edit: Thu Feb 11 16:00:24 1988	mkr                  |
|        		    Tue Jan 17 1988 (more numbers added mm)          |
|									     |
|        QUANTIFIERS. DETERMINERS.  NEW VERSION				     |
|        								     |
+---------------------------------------------------------------------------*/

/*
Thu Feb 11 16:00:24 1988	mkr

In the following four definitions, the indices I and J used to be
instantiated.  This meant that sentences like "he is everywhere"
failed to parse because I:P:L would be instantiated by the copula to
@'Sta':true:[_].  Since the second clause of Copula1 is meant to be
predicative, the index of the subject NP would end up getting
instantiated with I as well.  Since an NP is not stative, unification
failed.  I would expect this fix to overgenerate NPs like "the
drivers everywhere go to Paris" but it doesn't for some reason.
*/

everywhere : [@ 'PP',
	      @ 'State',
	      : category = [: active = [: category = [: active = [: category = [: feature = loc or adj],
								  : semantics = # 1]],
					: semantics = # 3,
					: out = # 4]],
	      : semantics = [: predicate = imp,
			     binary([: index = 2 # (@ 'Ne'),
				      : predicate = true,
				      : arglist = `[]], [: index = # 1,
							 : predicate = and,
							  binary([: index = # 1,
								   : predicate = [: first = inloc,
										  : rest = [: first = togoal,
											    : rest = `[]]],
								   unary(# 2)], # 3)])],
	      : out = # 4].

nowhere : [@ 'PP',
	   @ 'State',
	   : category = [: active = [: category = [: active = [: category = [: feature = loc or adj],
							       : semantics = # 2]],
			: semantics = [: index = # 1] # 4,
			: out = # 5]],
	   : semantics = [: predicate = imp,
	   		  binary([: index = # 1,
		       	  : predicate = and,
		       	  binary([: index = # 3,
		       		   : predicate = true,
				   : arglist = `[]], [: index = # 2,
						      : predicate = and,
						      binary([: index = # 2,
							       : predicate = [: first = inloc,
									      : rest = [: first = togoal,
											: rest = `[]]],
							       unary(# 3)], # 4)])], [: index = @ 'Sta',
										      : predicate = absurdum,
										      : arglist = `[]])],
	    : out = # 5].

anywhere : [@ 'PP', 
	    : category = [: active = [: category = [: active = [: category = [: feature = loc or adj],
						 	        : semantics = # 2]],
				      : semantics = [: index = # 1] # 4,
				      : out = # 5]],
	    : semantics = [: index = # 1,
			   : predicate = and,
			   binary([: index = 3 # (@ 'Ne'),
			 	    : predicate = true,
				    : arglist = `[]], [: index = # 2,
						       : predicate = and,
					    	       binary([: index = # 2,
						     		: predicate = [: first = inloc,
									       : rest = [: first = togoal,
									      		 : rest = `[]]],
						     		unary(# 3)], # 4)])],
 : out = # 5].

somewhere : [@ 'PP',
	     : category = [: active = [: category = [: active = [: category = [: feature = loc or adj],
							         : semantics = # 2]],
				       : semantics = [: index = # 1] # 4,
			   	       : out = # 5]],
	     : semantics = [: index = # 1,
			    : predicate = and,
			    binary([: index = 3 # (@ 'Ne'),
				     : predicate = true,
				     : arglist = `[]], [: index = # 2,
							: predicate = and,
							binary([: index = # 2,
								 : predicate = [: first = inloc,
										: rest = [: first = togoal,
											  : rest = `[]]],
								 unary(# 3)], # 4)])],
	     : out = # 5].

everybody : [@ 'NP',
	     @ 'State',
	     : category = [: active = [: category = [: active = [: semantics = # 1,
								 : occlist = [: term = # 1,
									      : position = # 5,
									      : class = indef] # 2]],
				       : semantics = # 3,
				       : out = # 4]],
	     : semantics = [: predicate = imp,
			    binary([: index = # 1,
				     : predicate = and,
				     binary(# 2, [: index = 1 # (@ 'Hum'),
						  : predicate = human,
						  : arglist = `[]])], # 3)],
	     : out = # 4,
	     : occnumber = # 5].

nobody : [@ 'NP',
	  @ 'State',
	  : category = [: active = [: category = [: active = [: semantics = # 1,
							      : occlist = [: term = # 1,
									   : position = # 6,
								 	   : class = indef] # 3]],
				    : semantics = [: index = # 2] # 4,
				    : out = # 5]],
	  : semantics = [: predicate = imp,
			 binary([: index = # 2,
				  : predicate = and,
				  binary([: index = # 1,
					   : predicate = and,
					   binary(# 3, [: index = 1 # (@ 'Hum'),
							 : predicate = human,
							 : arglist = `[]])], # 4)], [: index = @ 'Sta',
										     : predicate = absurdum,
										     : arglist = `[]])],
	  : out = # 5,
	  : occnumber = # 6].

% Tue Oct 24 20:41:34 1989 JC added number specification

anybody : [@ 'NP',
	   : category = [: active = [: category = [: active = [: semantics = # 1,
							       : occlist = [: term = # 1,
									    : position = # 6,
									    : class = indef] # 3]],
				     : semantics = [: index = # 2] # 4,
				     : out = # 5]],
	   : semantics = [: index = # 2,
			  : predicate = and,
			  binary([: index = # 1,
				   : predicate = and,
				   binary(# 3, [: index = 1 # (@ 'Hum'),
						 : predicate = human,
						 : arglist = `[]])], # 4)],
	   : out = # 5,
	   : occnumber = # 6].

somebody : [@ 'NP',
	    : category = [: active = [: category = [: active = [: semantics = # 1,
								: occlist = [: term = # 1,
									     : position = # 6,
									     : class = indef] # 3]],
				      : semantics = [: index = # 2] # 4,
				      : out = # 5]],
	    : semantics = [: index = # 2,
			   : predicate = and,
			   binary([: index = # 1,
				    : predicate = and,
				    binary(# 3, [: index = 1 # (@ 'Hum'),
						  : predicate = human,
						  : arglist = `[]])], # 4)],
	    : out = # 5,
	    : occnumber = # 6].

everything : [@ 'NP',
	      @ 'State',
	      : category = [: active = [: category = [: active = [: semantics = # 1,
								  : occlist = [: term = # 1,
									       : position = # 5,
									       : class = indef] # 2]],
					: semantics = # 3,
					: out = # 4]],
	      : semantics = [: predicate = imp,
			     binary([: index = # 1,
				      : predicate = and,
				      binary(# 2, [: index = 1 # (@ 'Ne'),
						    : predicate = true,
						    : arglist = `[]])], # 3)],
	      : out = # 4,
	      : occnumber = # 5].

nothing : [@ 'NP',
	   @ 'State',
	   : category = [: active = [: category = [: active = [: semantics = # 1,
							       : occlist = [: term = # 1,
									    : position = # 6,
								  	    : class = indef] # 3]],
				     : semantics = [: index = # 2] # 4,
			  	     : out = # 5]],
	   : semantics = [: predicate = imp,
	  		  binary([: index = # 2,
				   : predicate = and,
				   binary([: index = # 1,
					    : predicate = and,
					    binary(# 3, [: index = 1 # (@ 'Ne'),
						          : predicate = true,
							  : arglist = `[]])], # 4)], [: index = @ 'Sta',
										      : predicate = absurdum,
										      : arglist = `[]])],
	   : out = # 5,
	   : occnumber = # 6].

anything : [@ 'NP',
	    : category = [: active = [: category = [: active = [: semantics = # 1,
								: occlist = [: term = # 1,
									     : position = # 6,
									     : class = indef] # 3]],
				      : semantics = [: index = # 2] # 4,
				      : out = # 5]],
	    : semantics = [: index = # 2,
			   : predicate = and,
			   binary([: index = # 1,
				    : predicate = and,
				    binary(# 3, [: index = 1 # (@ 'Ne'),
						  : predicate = true,
						  : arglist = `[]])], # 4)],
	    : out = # 5,
	    : occnumber = # 6].

something : [@ 'NP',
	     : category = [: active = [: category = [: active = [: semantics = # 1,
								 : occlist = [: term = # 1,
									      : position = # 6] # 3]],
				       : semantics = [: index = # 2] # 4,
				       : out = # 5]],
	     : semantics = [: index = # 2,
			    : predicate = and,
			    binary([: index = # 1,
				     : predicate = and,
				     binary(# 3, [: index = 1 # (@ 'Ne'),
						   : predicate = true,
						   : arglist = `[]])], # 4)],
	     : out = # 5,
	     : occnumber = # 6].

everyone : [@ 'NP',
	    @ 'State',
	    : category = [: active = [: category = [: active = [: semantics = # 1,
								: occlist = [: term = # 1,
									     : position = # 5,
									     : class = indef] # 2]],
				      : semantics = # 3,
				      : out = # 4]],
	    : semantics = [: predicate = imp,
			   binary([: index = # 1,
				    : predicate = and,
				    binary(# 2, [: index = 1 # (@ 'Hum'),
						  : predicate = human,
						  : arglist = `[]])], # 3)],
	    : out = # 4,
	    : occnumber = # 5].

noone : [@ 'NP',
	 @ 'State',
	 : category = [: active = [: category = [: active = [: semantics = # 1,
							     : occlist = [: term = # 1,
									  : position = # 6,
									  : class = indef] # 3]],
			   	   : semantics = [: index = # 2] # 4,
				   : out = # 5]],
	 : semantics = [: predicate = imp,
			binary([: index = # 2,
				 : predicate = and,
				 binary([: index = # 1,
					  : predicate = and,
					  binary(# 3, [: index = 1 # (@ 'Hum'),
							: predicate = human,
							: arglist = `[]])], # 4)], [: index = @ 'Sta',
										    : predicate = absurdum,
										    : arglist = `[]])],
	 : out = # 5,
	 : occnumber = # 6].

anyone : [@ 'NP',
	  : category = [: active = [: category = [: active = [: semantics = # 1,
							      : occlist = [: term = # 1,
									   : position = # 6,
									   : class = indef] # 3]],
				    : semantics = [: index = # 2] # 4,
				    : out = # 5]],
	  : semantics = [: index = # 2,
			 : predicate = and,
			 binary([: index = # 1,
				  : predicate = and,
				  binary(# 3, [: index = 1 # (@ 'Hum'),
						: predicate = human,
						: arglist = `[]])], # 4)],
	  : out = # 5,
	  : occnumber = # 6].

someone : [@ 'NP',
	   : category = [: active = [: category = [: active = [: semantics = # 1,
							       : occlist = [: term = # 1,
									    : position = # 6,
									    : class = indef] # 3]],
				     : semantics = [: index = # 2] # 4,
				     : out = # 5]],
	   : semantics = [: index = # 2,
			  : predicate = and,
			  binary([: index = # 1,
				   : predicate = and,
				   binary(# 3, [: index = 1 # (@ 'Hum'),
						 : predicate = human,
						 : arglist = `[]])], # 4)],
	   : out = # 5,
	   : occnumber = # 6].

/*

Mon Nov  6 15:27:00 1989 JC

More fun with sets

*/
1 : [@ 'Determiner',
     @ 'Indef',
     : cat2 : cat1 = @ 'Sing1'].

one : [@ 'Determiner',
       @ 'Indef',
       : cat2 : cat1 = @ 'Sing1'].

a : [@ 'Determiner',
     @ 'Indef',
     : cat2 : cat1 = @ 'Sing1'].

generic : [@ 'Determiner',
	   @ 'Indef',
	   : cat2 : cat1 = @ 'Mpl1'].

generic : [@ 'PluralDeterminer',
	   : semantics : arg2 : arg5 = generic,
	   : semantics : arg1 : class = indef].

an : [@ 'Determiner',
      @ 'Indef',
      : cat2 : cat1 = @ 'Sing1'].

any : [@ 'Determiner',
       @ 'Indef',
       : cat2 : cat1 = @ 'Object1'].

any : [@ 'PluralQuant'].

other : [@ 'PluralDeterminer',
	 : semantics : arg2 : arg5 = some,
	 : semantics : arg1 : class = indef].

some : [@ 'Determiner',
	@ 'Indef',
	: cat2 : cat1 = @ 'Object1'].

some : [@ 'PluralDeterminer',
	: semantics : arg2 : arg5 = some,
	: semantics : arg1 : class = indef].

2 : [@ 'Cardinal'].
3 : [@ 'Cardinal'].
4 : [@ 'Cardinal'].
5 : [@ 'Cardinal'].
6 : [@ 'Cardinal'].
7 : [@ 'Cardinal'].
8 : [@ 'Cardinal'].
9 : [@ 'Cardinal'].
10 : [@ 'Cardinal'].
11 : [@ 'Cardinal'].
12 : [@ 'Cardinal'].
13 : [@ 'Cardinal'].
14 : [@ 'Cardinal'].
15 : [@ 'Cardinal'].
16 : [@ 'Cardinal'].
17 : [@ 'Cardinal'].
18 : [@ 'Cardinal'].
19 : [@ 'Cardinal'].
20 : [@ 'Cardinal'].
25 : [@ 'Cardinal'].
30 : [@ 'Cardinal'].
40 : [@ 'Cardinal'].
50 : [@ 'Cardinal'].
100 : [@ 'Cardinal'].
150 : [@ 'Cardinal'].
200 : [@ 'Cardinal'].
250 : [@ 'Cardinal'].
500 : [@ 'Cardinal'].
750 : [@ 'Cardinal'].
1000 : [@ 'Cardinal'].

the : [@ 'Determiner',
       @ 'Definite',
       : cat2 : cat1 : category : feature : number = sg].

the : [@ 'PluralDef'].

every : [@ 'Quantifier',
	 : semantics : arg1 : arg2 = : cat1 : semantics,
	 : cat2 : cat1 = @ 'Sing1',
	 : semantics : arg2 = : cat2 : semantics].

each : [@ 'Quantifier',
	: semantics : arg1 : arg2 = : cat1 : semantics,
	: semantics : arg2 = : cat2 : semantics,
	: cat2 : cat1 = @ 'Sing1'].

no : [@ 'PluralQuant'].

all : [@ 'All'].

