/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/unix.pl,v $',
	'$State: Exp $').

$Log: unix.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:11:31  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:20:30  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:18:36  kwh
% calls to 'new_variable' modified to include variable class.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pos.pl
Date:	Wed May  9 15:20:11 1990
By:	Jonathan Calder

Interaction with UNIX

*/


% :- eccs_new_variable(eccs_os, 'unix', private, install, "Operating system").
% not used (SLE)

eccs_system(Command) :-
    unix(system(Command)).

eccs_command_args(Argv) :-
    unix(argv(Argv)).

eccs_user_editor(X) :-
    eccs_global_variable(editor, X), !.
eccs_user_editor(X) :-
    eccs_environment('EDITOR', X).

/*
????
eccs_edit_clause(X) :-
    eccs_make_temporary_unique_filename(FName),
    eccs_sys_telling(Old),
    eccs_sys_tell(FName),
    listing(X),
    eccs_sys_told, eccs_sys_tell(Old),
    eccs_user_editor(Ed),
    eccs_unix_format_and_call([Ed,FName]).
*/


eccs_edit_object(ObjType) :-
	\+ eccs_have_grammar_desc_file,
	eccs_get_from_databasef(ObjType, _, _, FileName), !,
	eccs_edit_file([FileName], ObjType, _).

eccs_edit_object(ObjType) :-
	eccs_have_grammar_desc_file,
	eccs_current_context(Context),
	eccs_get_from_databasef(ObjType, Context, _, FileName), !,
	eccs_edit_file([FileName], ObjType, _).

eccs_edit_object(ObjType) :-
	eccs_have_grammar_desc_file,
	eccs_current_context(Context),
	eccs_error(['No objects of type', ObjType, 'defined in current context:', Context]).
	


eccs_edit_file(Files) :-
    eccs_edit_file(Files, _, _).

eccs_edit_file([File], ObjType, Name) :- 
	eccs_check_file_types([File], ObjType, Name, _Type),
	(eccs_have_grammar_desc_file ->
	    (eccs_current_context_dir(Dir), 
	     eccs_context_name_gname_dir(_Context, GName, Dir),
	     eccs_sys_name(GName, GNameChars),
	     eccs_sys_name(File, FileChars),
	     eccs_append(GNameChars, [46|_Ext], FileChars));  /* ASCII '.' */
	    eccs_global_variable(grammar_directory, Dir)),
	eccs_os_list_to_path_name([Dir, File], Path),
	eccs_absolute_file_name(Path, AbsPath),
	eccs_file_exists(AbsPath),
	eccs_user_editor(X),
	eccs_unix_format_and_call([X, AbsPath]),
	eccs_once(eccs_maybe_recompile_file(File, ObjType, Name)), !.

eccs_edit_file([File], _ObjType, _Name) :-
	eccs_error(['File not found:', File]).

/*
eccs_edit_file(Files, ObjType, Name) :-
    eccs_check_file_types(Files, ObjType, Name, _Type),
    eccs_user_editor(X),
    (eccs_have_grammar_desc_file -> 
	(eccs_current_context(Context), 
	 eccs_context_name_gname_dir(Context, _GName, Dir));
    	eccs_global_variable(grammar_directory, Dir)),
    eccs_call_command_in_directory(Dir, 
    	(eccs_unix_format_and_call([X|Files]),
	 (eccs_member(FName, Files),
          eccs_once(eccs_maybe_recompile_file(FName, ObjType, Name)), fail;
	 true))), !.
*/

eccs_check_file_types([], _, _, _) :- !.
eccs_check_file_types([F|R], ObjType, Name, Type) :-
    eccs_sys_if_then_else(eccs_file_type(F, Type), true,
				eccs_error([cannot, determine, type, of, F])),
    eccs_sys_if_then_else((eccs_sys_var(Name), eccs_sys_var(ObjType); 
			   eccs_file_gives_rise_to_objects(Type, TList),
			   eccs_memberchk(ObjType, TList)), 
			  true,
			  eccs_error(['Confusion', over, types, of, object, ObjType,
			  	      and, file, Type, name, F])),
    eccs_check_file_types(R, ObjType, Name, Type).


/* Following predicate fails in Quintus (SLE)    

eccs_make_temporary_unique_filename(X) :-
    unix(mktemp('/tmp/pleukXXXXXX', X)).

Use foreign function instead: */

eccs_make_temporary_unique_filename(X) :-
    (eccs_environment('PLEUKTMP', Template) -> true;
       Template = '/tmp/pleukXXXXXX'),
    eccs_mktemp1(Template, X).

eccs_mktemp1(Template, X) :-
    eccs_global_variable(prolog_type, Sic), 
    eccs_sys_name(Sic, SicList),
    eccs_sys_name(sicstus, Sic1),
    eccs_append(Sic1, _, SicList), !,
    unix(mktemp(Template, X)).
eccs_mktemp1(Template, X) :-
    eccs_mktemp(Template, X).


eccs_temporary_filename(X) :-
    eccs_sys_atomic(X),
    eccs_sys_name(X, L),
    eccs_sys_name('/tmp/pleuk', L1),
    eccs_append(L1, [F|R], L), !,
    eccs_alpha(F),
    eccs_word(N, R, []),
    eccs_sys_integer(N).
    

/*
eccs_make_writeable_pipe(FName, Stream) :-
    eccs_sys_if_then_else(eccs_sys_var(FName), eccs_make_temporary_unique_filename(FName), true),
    eccs_unix_format_and_call(['/etc/mknod', F, p, ';', cat, F, '&']),
    open(FName, write, Stream).
*/
eccs_os_directory_char('/').


eccs_os_current_directory('.').
eccs_os_home_directory(Dir) :-
%    eccs_absolute_file_name('$HOME', Dir).    % fails in Quintus (SLE)
    eccs_absolute_file_name('~', Dir).

eccs_os_this_directory('./').

/*

eccs_os_list_to_path_name(L, Path) 

Path is the unix specific pathname which points to an object in the 
file system.  It does *not* have a trailing directory character.

*/

eccs_os_list_to_path_name(L, Path) :-
    eccs_os_directory_char(Char),
    eccs_interpolate_char(Char, L, List),
    eccs_concat_list(List, Path).

/*

eccs_normalized_path_name(PathName, List) 

List is a normalized form of the os specific path name

*/

eccs_normalized_path_name(PathName, List) :-
    eccs_sys_if_then_else(eccs_sys_nonvar(PathName), eccs_sys_name(PathName, Chars), true),
    eccs_os_directory_char(Ch), eccs_sys_name(Ch, [Char]),
    eccs_normalized_path_name(Chars, Char, String, String, List),
    eccs_sys_name(PathName,Chars).

eccs_normalized_path_name(String, Char, [], [], [Last]) :- 
    eccs_sys_if_then_else(eccs_sys_nonvar(String), \+ eccs_memberchk(Char, String), true), !,
    eccs_sys_name(Last, String).
eccs_normalized_path_name([Char1|Cs], Char, String, [], [Atom|R]) :-
    eccs_sys_name(Atom, String), R = [_|_],
    eccs_sys_if_then_else(eccs_sys_nonvar(Char1), Char = Char1,  true),	% for reversibility
    eccs_normalized_path_name(Cs, Char, NewString, NewString, R),
    Char = Char1,
    !.
eccs_normalized_path_name([Char1|Cs], Char, String, [Char1|RCs], List) :-
    eccs_normalized_path_name(Cs, Char, String, RCs, List).


/*

eccs_unix_format_and_call(List) 

List is interpreted as a unix command

*/

eccs_unix_format_and_call(List) :-
    eccs_interpolate_char(' ', List, L),
    eccs_concat_list(L, Command),
    eccs_system(Command).




/*

eccs_unix_call_in_environment(List) 

List is interpreted as a unix command and is called in a 
standard environment.

*/

eccs_unix_call_in_environment(List) :-
    eccs_global_variable(pleuk_etc, Dir),
    eccs_concat_list(['PATH=', Dir, ':$PATH'], Paths),
    eccs_concat_list(['PLEUKETC=', Dir], PLEUKDIR),
%    eccs_global_variable(eccs_unix_standard_env, File),
%    eccs_os_list_to_path_name([Dir, File], SFile),
    eccs_unix_format_and_call(['export PATH PLEUKETC;', Paths, ';', PLEUKDIR, ';' | List]).



/*

eccs_unix_trap_standard_output(Command, Output).

run command and return its standard Output as a string.  
We truncate it to a maximum length of eccs_input_buffer_length
so that we don't end up with something unmanageable.  

*/

eccs_unix_trap_standard_output(Command, Output) :-
    eccs_make_unique_temporary_file(FName),
    eccs_unix_format_and_call([Command, '>', FName, ';', '(sleep 10; rm ', FName, ')&']),
    eccs_sys_if_then_else(eccs_file_exists(FName), true,
    	eccs_error([cannot, read, temporary, file, FName])), % Probably the victim of a timeout
    eccs_read_first_line(FName, Output).



eccs_input_buffer_length(256).

eccs_read_first_line(Filename, Line) :-
    eccs_input_buffer_length(MAX),
    eccs_sys_seeing(Old, Filename),
    eccs_sys_get0(Char),
    eccs_line_terminator(EOL),
    eccs_end_of_file_char(EOF),
    eccs_read_first_line(0, MAX, EOL, EOF, Char, Line),
    eccs_sys_seen,
    eccs_sys_see(Old).

eccs_read_first_line(MAX, MAX, _, _, _, []) :- !.
eccs_read_first_line(_, _, Char, _, Char, []) :- !.
eccs_read_first_line(_, _, _, Char, Char, []) :- !.
eccs_read_first_line(Current, MAX, EOL, EOF, Char, [Char|Line]) :- 
    Current < MAX,
    eccs_sys_get0(Next),
    eccs_succ(Current, Count),
    eccs_read_first_line(Count, MAX, EOL, EOF, Next, Line).


eccs_os_delete_file(FName) :-
    eccs_unix_format_and_call([rm, FName]).

eccs_edit_object(ObjType, Name) :-
    findall(File, 
	(eccs_current_file(File, _), 
	 eccs_once(eccs_get_from_databasef(ObjType, Name, _, File))), Files),
    eccs_sys_if_then_else(Files = [], 
    	eccs_message([unable, to, find, definition, for, ObjType, Name]),
	(eccs_message([ObjType, Name, is, defined, in, the, 'file(s)'|Files]),
	 eccs_edit_file(Files, ObjType, Name))).


/*

Call a UNIX command and write to its standard input

JC Wed Dec 11 13:39:41 1991 This had /usr/etc/mknod as the program to
make named pipes. This is Sun speak for /etc/mknod which appears to be
more standard. Under SunOS, the former is a symbolic link to the
latter.

*/



eccs_unix_command_to_stdin(Command, Goal) :-
    eccs_make_temporary_unique_filename(X),
    eccs_append(Command, [' ) &'], C1),
    eccs_append(['/etc/mknod', X, p, '; (', cat, X, '|'], C1, C2),
    eccs_unix_format_and_call(C2),
    eccs_open(X, write, S),
    eccs_current_output(Old),
    eccs_set_output(S),
    (eccs_once(Goal); true), !,
    eccs_flush_output(S),
    eccs_sys_close(S),
    eccs_set_output(Old),
    eccs_unix_format_and_call(['(', sleep, 1, ';', rm, '-f', X, ')', '&']).

