/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pwindows.pl,v $',
	'$State: Exp $').


/*

File:	/home/user2/jo/Pleuk/Code/pwindows.pl
Date:	Sat May 19 12:46:40 1990
By:	Jonathan Calder

Generic interface to windows.

*/

/*

eccs_windows_available(Sys) -- true when Sys is the name of a window system

*/
eccs_windows_available(Sys) :-
    eccs_global_variable(use_windows, true),
    eccs_global_variable(eccs_window_system, Sys),
    \+ (Sys = none).

/*

eccs_determine_window_system/0 -- detect window system, set its name 
in a global variable

*/

eccs_determine_window_system :-
    eccs_global_variable(use_windows, true),
    eccs_environment('DISPLAY', _),
    eccs_set_variable(eccs_window_system, 'X'), !.
eccs_determine_window_system :-
    eccs_set_variable(eccs_output_mode, dumb),
    eccs_set_variable(eccs_input_mode, dumb).



/*

eccs_window_start_up

Get file and output windows running

*/

eccs_window_start_up :-
    eccs_make_file_window,
    eccs_make_output_window,
    eccs_datestamp(Date),
    Goal = eccs_format_to_current_stream(
    	"/* Start of Pleuk session ~a */~n", Date),
    eccs_output_file_goal(Goal), !,
    eccs_window_default_state.
eccs_window_start_up.

/*

eccs_make_output_window/0

*/
eccs_make_output_window :-
    eccs_make_window(output, _BufferName, Stream),
    eccs_set_variable(eccs_output_file_handle, Stream).


/*

eccs_close_output_window/0

*/

eccs_close_output_window :-
    eccs_global_variable(eccs_output_file_handle, BufferName),
    eccs_close_window(BufferName).

/*

eccs_make_file_window/0

*/

eccs_make_file_window :-
    eccs_make_window(file, _BufferName, Stream),
    eccs_set_variable(eccs_file_window_handle, Stream).

/*

eccs_close_file_window/0

*/
eccs_close_file_window :-
    eccs_global_variable(eccs_file_window_handle, Handle),
    eccs_close_window(Handle).

/*

eccs_make_window(Handle)

a window is opened. Handle is a way of identifying how to write.


*/

eccs_make_window(Type, Stream, Stream) :-
    eccs_global_variable(eccs_output_mode, dumb), !,
    eccs_user_output_stream(Stream).
eccs_make_window(Type, _, Stream) :-
    eccs_interface_make_window(Type, Stream).


/*

eccs_window_command(WindowSystem, PrologType, PrologVersion, Command) 

Command is what is needed to fake a window

*/

eccs_window_command('X', sicstus, _, xfakewindow).
eccs_window_command('X', quintus, _, 'xfakewindow.quintus').

eccs_reset_windows :-
    eccs_close_all_windows, 
    eccs_window_start_up.

eccs_close_all_windows :-
    eccs_global_variable(eccs_output_mode, dumb), !.
eccs_close_all_windows :-
    eccs_interface_close_all_windows.

eccs_check_window_state :- 
    eccs_global_variable(eccs_output_mode, dumb), !.

/*

eccs_window_default_state

*/

eccs_window_default_state :-
    eccs_user_output_stream(Stream),
    eccs_set_output(Stream).
