/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/psys.pl,v $',
	'$State: Exp $').

$Log: psys.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:33  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:31:10  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/06/07  11:40:19  pleuk
% Changes for additional file window
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/psys.pl
Date:	Wed May  9 11:39:41 1990
By:	Jonathan Calder

Build the basic system.  This file is for the Pleuk 
functional backbone.  

*/


/*

The files we need at configure time

Should correspond to CONFIGUREFILES in ./Makefile

*/

eccs_pleuk_configure_files(
    ['pconfigure.pl']).
     

/*

The files we need at run time

pmenus.pl removed by kwh: Wed Sep 18 19:37:34 BST 1991

Should correspond to RUNTIMEFILES in ./Makefile

*/


eccs_pleuk_source_files(
    ['Code/pfiles.pl',			% File handling
     'Code/pdatabase.pl',			% Database operations
     'Code/pruntime.pl',			% Run time predicates
     'Code/pgenericargs.pl',			% 
     'Code/pbanners.pl',			% Welcome messages etc.
     'Code/pdump.pl',			% Write compiled versions out to file.
     'Code/pprinting.pl',			% Routines for preparing objects to print
     'Code/pparser.pl',			% Interface to parser
     'Code/pread_in.pl',			% User input reading routines
     'Code/pwindows.pl',			% Generic window stuff
     'Code/pcounter.pl',			% Counters
     'Code/pmessages.pl',			% 
     'Code/ppostscript.pl',			% PostScript support
     'Code/pstreams.pl',
     'Code/pstream_filters.pl', 		% support for formatting streams
     'Code/pdumb_filter.pl',			% dumb output routine
     'Code/pmenutty.pl',			% dumb terminal menu interpreter
     'Code/pmenux.pl',			% general menu stuff
     'Code/pmenuvars.pl',			% routines for menu expansion
     'Code/pmenudefs.pl',			% menu definitions
     OUTWINDOWS]) :-
     eccs_global_variable(eccs_output_mode, OP),
     eccs_concat(OP, 'windows.pl', OUTWINDOWS1),
     eccs_concat('Code/', OUTWINDOWS1, OUTWINDOWS).

eccs_srcload(ListOfFiles) :-
    eccs_global_variable(prolog_consult_mode, Pred),
    eccs_srcload1(Pred, ListOfFiles).

eccs_srcload1(_Pred, []) :- !.
eccs_srcload1(Pred, [library(F)|R]) :-
    !,
    (eccs_absolute_file_name(library(F), FName) -> true;
	eccs_sys_write('cannot resolve name of library file: '),
	write(F), nl, fail),
    eccs_srcload1(Pred, [FName|R]).
eccs_srcload1(Pred, [F|R]) :- 
    (Pred = compile; Pred = ensure_loaded),
    eccs_global_variable(prolog_type, sicstus), 
    eccs_global_variable(prolog_version, Vers), Vers @>= 0.9,
    eccs_file_exists(F),
    eccs_sys_name(F, FL),
    eccs_append(FBase, ".pl", FL),
    eccs_sys_name(FB, FBase),
    !,
    eccs_sys_ensure_loaded(FB),
    eccs_srcload1(Pred, R).

eccs_srcload1(Pred, [F|R]) :- 
    eccs_sys_if_then_else(eccs_sys_atomic(F), ( eccs_construct_and_call([Pred, F]), eccs_srcload1(Pred, R)),
    	eccs_error(['Invalid', file, 'name: ', F])).

    
eccs_pleuk_build(Config, Out) :-
    eccs_pleuk_configure_files(ListOfFiles),
    eccs_srcload(ListOfFiles),
    eccs_maybe_load_contexts,
    eccs_pleuk_configure(Config, Out).


/*

Wed Oct 14 12:25:43 1992 JC
Mon Jan 18 16:07:50 1993 JC

For compatibility with Quintus, we can no longer use save/2 directly.
See sicstus-020106.pl for details of eccs_sys_save/2.

*/

eccs_install(PleukInfo, Program, Save) :-
    eccs_pleuk_source_files(Files),
    eccs_files_to_library_files(Files, LibFiles),
    eccs_srcload(LibFiles),
    eccs_maybe_load_contexts,
    eccs_srcload([PleukInfo]),
    eccs_sys_if_then_else(Save == save, 
    	(eccs_sys_write('saving pleuk to file '), 
	 eccs_sys_write(Program), eccs_sys_nl),
	true),
    StartGoal = eccs_start_up_hook,
    eccs_sys_if_then_else(Save == save, 
    	eccs_sys_save(Program, StartGoal),
	  eccs_sys_call(StartGoal)).


eccs_files_to_library_files([], []).
eccs_files_to_library_files([F|Fs], [library(F)|LFs]) :-
    eccs_files_to_library_files(Fs, LFs).


eccs_maybe_load_contexts :-
    eccs_absolute_file_name(library('Code/pcontexts.pl'), F),
    !,
    eccs_srcload([F]).
eccs_maybe_load_contexts.

/*

Hooks that are called at start up and saves.

*/


eccs_configure_save_hook :-
    eccs_unset_variable(eccs_system_state),
    eccs_new_variable(eccs_system_state, start_up, private, run, "Current state of system, i.e. install, configure, start_up, or run."),
    eccs_sys_if_then_else(eccs_global_variable(configuration_save_hook, X), call(X), 
      true).

/*

Wed Oct 14 12:27:48 1992 JC The following no longer needed.

eccs_sys_save_hook.


eccs_save_and_restore(File, SaveFlag, RestoreGoal) :-
    eccs_save(File, SaveFlag),
    eccs_sys_if_then_else(SaveFlag = 0, (eccs_global_variable(halt_on_save, true), halt; true),
		     call(RestoreGoal)).


eccs_save(File, Flag) :-
    eccs_sys_save_hook,
    eccs_sys_save(File, Flag).

*/

/*

eccs_fake_abort
eccs_fake_abort(Goal)

Provides a way of unwinding to the top level from arbitrarily far into 
prolog evaluation. 

The second form provides a way of restarting with a goal other than 
the presentation of the top-level menu.


*/

:- dynamic eccs_aborting/1.

eccs_fake_abort :-
    eccs_fake_abort(true).

eccs_fake_abort(Goal) :-
    eccs_sys_asserta(eccs_aborting(Goal)).

eccs_maybe_abort :-
    eccs_aborting(_), !, fail.
eccs_maybe_abort.


eccs_undo_abort :-
    eccs_sys_retract(eccs_aborting(Goal)), 
    eccs_sys_retractall(eccs_aborting(_)),
    eccs_sys_call(Goal).

eccs_maybe_abort_repeat.		% First time
eccs_maybe_abort_repeat :-
    eccs_maybe_abort,
    eccs_maybe_abort_repeat.

eccs_undo_abort_repeat.		% First time
eccs_undo_abort_repeat :-
    eccs_sys_if_then_else(eccs_undo_abort, true, true),
    eccs_undo_abort_repeat.

eccs_verify_file_state :-
    eccs_sys_if_then_else(eccs_windows_available(_), eccs_check_window_state, true),
    eccs_check_files_open_for_writing.

eccs_check_files_open_for_writing :-
    eccs_global_variable(eccs_system_state, State),
    eccs_sys_if_then_else(State = start_up, Mode = write, Mode = append),
    eccs_global_variable(eccs_output_file_handle, File),
    eccs_sys_if_then_else(eccs_file_is_open_for_writing(File), true, eccs_open_file(File, Mode)).


/*

eccs_call_command_in_directory(Dir, Command)

Command, which is assumed to succeed once and only once, 
is called with the working directory set to Dir

*/

eccs_call_command_in_directory(Dir, Command) :-
    eccs_sys_atomic(Dir),
    eccs_current_directory(Old),
    eccs_sys_cd(Dir), !,
    (eccs_sys_call(Command); true), !, 
    eccs_sys_cd(Old).

/* added by kwh: Fri Sep 13 15:33:04 BST 1991
Assumes failure of eccs_sys_cd/1 must be due to non-existent directory */

eccs_call_command_in_directory(Dir, _Command) :-
	eccs_error(['No', such, 'directory:', Dir]).

/*

statistics routines.

*/


eccs_get_stats(Heap, Runtime) :-
    eccs_sys_cputime(Runtime),
    eccs_sys_heapused(Heap).


/*

eccs_call_and_report_stats(Goal)

Goal is assumed to succeed at most once.

*/

eccs_call_and_report_stats(Goal, Message) :-
    eccs_get_stats(StartHeap, StartCPU),
    eccs_once(( eccs_sys_call(Goal); true)),
    !,
    eccs_get_stats(EndHeap, EndCPU),
    Heap is EndHeap - StartHeap,
    CPU is EndCPU - StartCPU,
    eccs_sys_if_then_else(CPU = 0, 
	CPUMess = [],
	CPUMess = [CPU, seconds]),
    eccs_sys_if_then_else(Heap = 0, 
	Mess = CPUMess,
	eccs_append(CPUMess, [Heap, bytes], Mess)),
    eccs_append(Message, Mess, Mess1),
    eccs_message(Mess1).

/*

interrupt handling for sicstus

*/

/* 

Thu Jan 28 11:30:30 1993 JC

eccs_critical_interrupt/0 

will be true at those points when an interrupt will cause real
problems.  In particular, under GM, if we interrupt while waiting for
a menu choice, we can never get back to the menu (because we will have
had to kill the GM subprocess, and prolog has a pointer relevant only
for the old process.

The same holds true for interrupts during the derivation checker.  If
we interrupt and ask for a trace, we will end up going back to
dc_loop/0, which polls the by-now non-existent windows for input.

*/

:- dynamic eccs_critical_interrupt/0.

eccs_handle_interrupt :-
    eccs_global_variable(prolog_type, sicstus),
    !,
    eccs_tidy_after_interrupt,
    eccs_int_init,
    (eccs_critical_interrupt -> 
	eccs_sys_throw(pleuk_exception(normal, [aborting]))
      ; eccs_continue_or_options).
eccs_handle_interrupt.

/* 

eccs_continue_or_options

After tidying up after an interrupt, we offer the choice of continuing
or something else. Valid choices for the latter are 

abort
exit
trace

Only in the second case will we ever get to the last clause below, so
we can call trace from there and get to whatever routines are of
interest more quickly.

*/

eccs_continue_or_options :-
    eccs_do_menu(confirm, [alert='Pleuk interrupted. Continue?']),
    !.					% User asked to continue 
eccs_continue_or_options :-
    eccs_do_menu(interrupt).
eccs_continue_or_options :- trace.



    

/*

If running GM we have to kill the subprocess, and then try 
and restart.  

*/

eccs_tidy_after_interrupt :-
    eccs_global_variable(eccs_input_mode,  gm), !,
    dc_tidy,
    (started -> end, eccs_gm_sorry; true).

eccs_tidy_after_interrupt.

eccs_gm_sorry :-
    eccs_message(['Interrupting', this, version, of, 'Pleuk', 
    		   results, in, the, window, system, being]),
    eccs_message([shut, down, and, restarted]),
    eccs_sys_if_then_else(eccs_windows_available(_), eccs_window_start_up, true).

/*

eccs_sys_init

A hook called by eccs_top_level

Under sicstus 2.1 and later, we reset a few things that seem to get
screwed up by interrupts, namely the notion of current i/o streams.


*/

eccs_sys_init :-
    eccs_global_variable(prolog_type, sicstus),
    eccs_global_variable(prolog_version, N), 
    N > 20105, !,
    eccs_int_init,
    prolog_flag(user_input, IStream),
    set_input(IStream),
    prolog_flag(user_output, OStream),
    set_output(OStream).
eccs_sys_init.  

