/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pprinting.pl,v $',
	'$State: Exp $').

$Log: pprinting.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:33  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:30:01  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:42:21  kwh
% file status information sent to separate window.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pprinting.pl
Date:	Fri May 11 11:18:10 1990
By:	Jonathan Calder

Generic output routines for pleuk

*/

eccs_display_object(Name, Type, Object) :-
    eccs_object_type(Type, _, Printer),
    \+ eccs_non_printing_type(Type),
    eccs_sys_if_then_else(Printer = 'DEFAULT', eccs_global_variable(default_printing_routine, Routine),
      Routine = Printer),
    eccs_global_variable(default_printing_args, Args),
    eccs_construct_and_call([Routine, Args, Name, Object]).

/*

eccs_list_objects(Type) 

List all objects of Type

*/


eccs_list_objects(Type) :-
    eccs_list_object(Type, _).

eccs_list_object(Type, ListAll) :-
    ListAll == '?',
   !,
   findall(Name, eccs_get_from_database(Type, Name, _Object), Names),
   eccs_sort(Names, NamesSorted),
   (eccs_output_file_goal((eccs_member(N, NamesSorted),eccs_sys_write(N), eccs_sys_nl, fail)); true).

/*

Mon Feb  8 14:56:39 1993 JC

Added variable 'group objects by name'

*/



eccs_list_object(Type, Name) :-
   eccs_sys_if_then_else(eccs_verify(eccs_get_from_database(Type, Name, Object)),
   			 true, 
			 (eccs_message([no, object, with, name, Name, of, type, Type]), fail)),
   eccs_printer(Type, Printer),
   findall(Name+Object, eccs_get_from_database(Type, Name, Object), Objects),
   (\+ eccs_global_variable('group objects by name', true) -> 
   	eccs_list_objects1(Printer, Type, Objects)
      ; eccs_print_objects_grouped_by_name(Printer, Type, Objects)).
eccs_list_object(_Type, _Name).

eccs_list_objects1(_Printer, _Type, []) :- fail.
eccs_list_objects1(Printer, Type, Os) :-
    Os = [_, _|_],
    eccs_known_predicate(eccs_select1_xmenu/2),	% we have select1 menus available
    !,
    eccs_sort(Os, OsSorted),
    eccs_list_objects_by_selection(Printer, Type, OsSorted).
eccs_list_objects1(Printer, Type, [Name+O|Os]) :-
    (eccs_format_and_print(Printer, Type, Name, O); true), !,
    eccs_length(Os, N),
    eccs_concat_list(['(', N, ' more to go)'], A),
    eccs_sys_if_then_else(Os = [],
	                  true,
			  eccs_do_menu(confirm, 
			               [alert = ['Show next', Type, A]])),
    eccs_list_objects1(Printer, Type, Os).

eccs_format_and_print(Printer, Type, Name, Object) :-
    Goal =.. [Printer, Type, Name, Object, Result],
    (eccs_sys_call(Goal) -> 
	eccs_output(Result)
      ; eccs_error([formatter, Printer, failed, for, object, Name])).

eccs_list_objects_by_selection(Printer, Type, Os) :-
    eccs_format_list_for_selection(Printer, Type, Os, List),
    'List objects by type' = Prompt,
    eccs_do_select1_menu_list(Prompt, Type, List).

eccs_format_list_for_selection(_, _, [], _) :-
    !.
eccs_format_list_for_selection(Printer, Type, [Name+Object|Os], [Name+Command|Cs]) :-
    Command = eccs_format_and_print(Printer, Type, Name, Object),
    eccs_format_list_for_selection(Printer, Type, Os, Cs).

eccs_do_select1_menu_list(Prompt, _Type, List) :-
    Args = [stayhere=true, prompt = Prompt, 
	    other_buttons = [hardcopy+eccs_ps_hardcopy]],
    eccs_select1_xmenu(Args, List).

eccs_print_objects_grouped_by_name(Printer, Type, Objects) :-
    eccs_group_by_name(Objects, Os),
    eccs_print_objects_grouped_by_name1(Printer, Type, Os).

eccs_group_by_name([], []).
eccs_group_by_name([Name+Def|Rest], [Name+[Def|Ds]|T]) :-
    eccs_group_by_name1(Rest, Name, Ds, Remainder),
    eccs_group_by_name(Remainder, T).

eccs_group_by_name1([], _, [], []).
eccs_group_by_name1([Name+Def|Rest], NameIn, [Def|Ds], T) :-
    NameIn == Name, !,
    eccs_group_by_name1(Rest, NameIn, Ds, T).
eccs_group_by_name1([ND|Rest], NameIn, Ds, [ND|T]) :-
    eccs_group_by_name1(Rest, NameIn, Ds, T).

eccs_print_objects_grouped_by_name1(Printer, Type, Os) :-
    Os = [_, _|_],
    eccs_known_predicate(eccs_select1_xmenu/2),	% we have select1 menus available
    !,
    eccs_sort(Os, OsSorted),
    eccs_list_grouped_objects_by_selection(Printer, Type, OsSorted).

eccs_list_grouped_objects_by_selection(Printer, Type, Os) :-
    eccs_format_grouped_list_for_selection(Printer, Type, Os, List),
    'List objects by type' = Prompt,
    eccs_do_select1_menu_list(Prompt, Type, List).

eccs_format_grouped_list_for_selection(_, _, [], []).
eccs_format_grouped_list_for_selection(Printer, Type, [N+Defs|Os], [N+C|Cs]) :-
    C = (eccs_defs_to_sfp(Printer, Type, N, Defs, SPFDefs), eccs_output(SPFDefs)),
    eccs_format_grouped_list_for_selection(Printer, Type, Os, Cs).

eccs_print_objects_grouped_by_name1(_, _, []) :- !.
eccs_print_objects_grouped_by_name1(Printer, Type, [Name+Defs|Rest]) :-
    eccs_defs_to_sfp(Printer, Type, Name, Defs, SPFDefs),
    eccs_output(SPFDefs),
    eccs_length(Rest, N),
    eccs_concat_list(['(', N, ' more to go)'], A),
    eccs_sys_if_then_else(Rest = [],
	                  true,
			  eccs_do_menu(confirm, 
			               [alert = ['Show next', Type, A]])),
    eccs_print_objects_grouped_by_name1(Printer, Type, Rest).

eccs_defs_to_sfp(Printer, Type, Name, Defs, SPFDefs) :-
    SPFDefs = captioned(Cap, stack(SPF1)),
    eccs_check_name_atomic(Name, Atom),
    eccs_concat_list([Type, ' "', Atom, '":'], Cap),
    eccs_defs_to_sfp1(Printer, Type, Name, Defs, SPF1).

eccs_defs_to_sfp1(_, _, _, [], []).
eccs_defs_to_sfp1(Printer, Type, Name, [D|Defs], SPFOut) :-
    Goal =.. [Printer, Type, Name, D, Result],
    (eccs_sys_call(Goal) -> SPFOut=[SPF|Ss];
    	(eccs_error([formatter, Printer, failed, on, Type, Name]) ; SPFOut=Ss)),
    (Result = captioned(_, R) -> SPF = R; SPF = Result),
    eccs_defs_to_sfp1(Printer, Type, Name, Defs, Ss).

eccs_check_name_atomic(X/Y, Atom) :-
    !,
    eccs_concat_list([X, (/), Y], Atom).
eccs_check_name_atomic(A, A).


eccs_list_named_object(Name) :-
   eccs_atom_to_functor(Name, FName),
   eccs_sys_if_then_else(eccs_verify(eccs_get_from_database(Type, FName, Object)),
   			 true, 
			 (eccs_message([no, object, with, name, Name]), fail)),
   findall(Type+Object, eccs_get_from_database(Type, FName, Object), Objects),
   eccs_list_named_object(Name, FName, Objects).
eccs_list_named_object(_Name).

eccs_list_named_object(_Name, _FName, []) :- fail.
eccs_list_named_object(Name, FName, [Type+Object | Rest]) :-
	eccs_printer(Type, Printer),
	Goal =.. [Printer, Type, FName, Object, Result],
	(eccs_sys_call(Goal) -> eccs_output(Result);
	    eccs_error([formatter, Printer, failed])),    
	eccs_length(Rest, N),
	eccs_concat_list(['(', N, ' more to go)'], A),
	eccs_sys_if_then_else(Rest = [],
	                      true,
			      eccs_do_menu(confirm, 
			                   [alert = ['Show next entry for', 
					             Name, A]]) ),
        eccs_list_named_object(Name, FName, Rest).

eccs_atom_to_functor(Name, FName) :-
	eccs_sys_name(Name, NameChars),
	eccs_string_to_functor(NameChars, FName), !.
eccs_atom_to_functor(Name, Name).

eccs_string_to_functor(Chars, FName) :-
	eccs_split(Chars, NameChars, ArityChars),
	eccs_sys_name(Name, NameChars),
	eccs_sys_name(Arity, ArityChars),
	FName =.. ['/', Name, Arity].

eccs_split([H|T], [], T) :- [H] = "/".
eccs_split([H|T], [H|R], Arity) :-
	eccs_split(T, R, Arity).


eccs_variables :-
    eccs_output_file_goal(eccs_enumerate_variables).


eccs_list_clauses(Type) :-
    eccs_output_file_goal(eccs_listing(Type)).


eccs_list_by_file(File) :-
    findall(Name+Type+Object,
	eccs_get_from_databaserf(_, Type, Name, [], Object, _, File), Os),
    eccs_list_by_file1(Os).

eccs_list_by_file1([]).
eccs_list_by_file1([Name+Type+Object|Os]) :-
    eccs_printer(Type, Printer),
    Goal =.. [Printer, Type, Name, Object, Result],
    (eccs_sys_call(Goal) -> eccs_output(Result);
    	eccs_error([formatter, Printer, failed])),    
    eccs_length(Os, N),
    eccs_concat_list(['(', N, ' more to go)'], A),
    (\+ Os = [] -> eccs_do_menu(confirm, [alert = ['Show next', Type, A]]), !; true),
    eccs_list_by_file1(Os).

    

eccs_list_files :-
    eccs_file_window_goal(eccs_file_status).

eccs_listing :-  eccs_listing(_), fail.
eccs_listing.


eccs_default_printing_routine(_Args, _Type, Name, Object) :-
    eccs_sys_write(Name), eccs_sys_write(': '), eccs_sys_write(Object), eccs_sys_nl.

eccs_print_result(L) :-
    \+ eccs_windows_available(_),
    !,
    eccs_print_result1(L).
eccs_print_result(L) :-
    eccs_output_file_goal(eccs_print_result1(L)).

eccs_print_result1(Caption, L) :-
    eccs_global_variable(parse_printer, Printer),
    eccs_global_variable(default_printing_args, Args),
    eccs_construct_and_call([Printer, Args, Caption, L, Output]),
    eccs_output(Output).




eccs_type_listing(File, Type) :-
    eccs_object_type(Type, _, Printer),
    eccs_sys_if_then_else(Printer = 'DEFAULT',
    			  eccs_global_variable(default_printing_routine, PrintPred), 
			  PrintPred = Printer),
    eccs_global_variable(default_printing_args, Args),
    eccs_get_from_databasef(Type, Name, Object, File),
    eccs_construct_and_call([PrintPred, Args, Type, Name, Object]),
    fail.
eccs_type_listing(_File, _Type).


/*

eccs_printer(Type, Printer)

Printer is used to format and output objects of Type

*/

eccs_printer(Type, Printer) :-
    eccs_object_type(Type, _, P),
    eccs_sys_if_then_else(P == 'DEFAULT', 
	eccs_global_variable(default_printing_routine, Printer),
	P = Printer).

eccs_default_printing_routine(Type, Name, Definition) :-
    eccs_sys_write(Type), eccs_sys_write(' '), 
    eccs_sys_write(Name), eccs_sys_write(' has the definition '),
    eccs_sys_nl, 
    eccs_sys_portray_clause(Definition). % Maybe SICStus specific


/*

eccs_dumb_symbol_name(Symbol, Print)

Print is the best representation we can get for the symbol named
Symbol.

*/

eccs_dumb_symbol_name(Symbol, Print) :-
    eccs_dumb_symbol_print(Symbol, Print), !.
eccs_dumb_symbol_name(Symbol, Symbol).

/*

eccs_dumb_symbol_print(PostScriptName, Symbol)

A symbol with a representation as an ascii string Symbol has the 
symbolic PostScriptName

Adapted from ghost.ps in the GhostScript distribution.

*/

eccs_dumb_symbol_print(space , ' ').
eccs_dumb_symbol_print(exclam , '!').
eccs_dumb_symbol_print(universal , 'forall').
eccs_dumb_symbol_print(numbersign, '#').
eccs_dumb_symbol_print(existential , 'exists').
eccs_dumb_symbol_print(percent , '%').
eccs_dumb_symbol_print(ampersand , '&').
eccs_dumb_symbol_print(suchthat, 's.t.').
eccs_dumb_symbol_print(parenleft , '(').
eccs_dumb_symbol_print(parenright , ')').
eccs_dumb_symbol_print(asteriskmath , '*').
eccs_dumb_symbol_print(plus, '+').
eccs_dumb_symbol_print(comma , ',').
eccs_dumb_symbol_print(minus , '-').
eccs_dumb_symbol_print(period , '.').
eccs_dumb_symbol_print(slash, '/').
eccs_dumb_symbol_print(zero , '0').
eccs_dumb_symbol_print(one , '1').
eccs_dumb_symbol_print(two , '2').
eccs_dumb_symbol_print(three, '3').
eccs_dumb_symbol_print(four , '4').
eccs_dumb_symbol_print(five , '5').
eccs_dumb_symbol_print(six , '6').
eccs_dumb_symbol_print(seven, '7').
eccs_dumb_symbol_print(eight , '8').
eccs_dumb_symbol_print(nine , '9').
eccs_dumb_symbol_print(colon , ':').
eccs_dumb_symbol_print(semicolon, ';').
eccs_dumb_symbol_print(less , '<').
eccs_dumb_symbol_print(equal , '=').
eccs_dumb_symbol_print(greater , '>').
eccs_dumb_symbol_print(question, '?').
eccs_dumb_symbol_print(congruent , '=~').
eccs_dumb_symbol_print('Alpha', 'Alpha').
eccs_dumb_symbol_print('Beta', 'Beta').
eccs_dumb_symbol_print('Chi', 'Chi').
eccs_dumb_symbol_print('Delta', 'Delta').
eccs_dumb_symbol_print('Epsilon', 'Epsilon').
eccs_dumb_symbol_print('Phi', 'Phi').
eccs_dumb_symbol_print('Gamma', 'Gamma').
eccs_dumb_symbol_print('Eta', 'Eta').
eccs_dumb_symbol_print('Iota', 'Iota').
eccs_dumb_symbol_print('theta1', 'theta1').
eccs_dumb_symbol_print('Kappa', 'Kappa').
eccs_dumb_symbol_print('Lambda', 'Lambda').
eccs_dumb_symbol_print('Mu', 'Mu').
eccs_dumb_symbol_print('Nu', 'Nu').
eccs_dumb_symbol_print('Omicron', 'Omicron').
eccs_dumb_symbol_print('Pi', 'Pi').
eccs_dumb_symbol_print('Theta', 'Theta').
eccs_dumb_symbol_print('Rho', 'Rho').
eccs_dumb_symbol_print('Sigma', 'Sigma').
eccs_dumb_symbol_print('Tau', 'Tau').
eccs_dumb_symbol_print('Upsilon', 'Upsilon').
eccs_dumb_symbol_print('sigma1', 'sigma1').
eccs_dumb_symbol_print('Omega', 'Omega').
eccs_dumb_symbol_print('Xi', 'Xi').
eccs_dumb_symbol_print('Psi', 'Psi').
eccs_dumb_symbol_print('Zeta', 'Zeta').
eccs_dumb_symbol_print(bracketleft, '[').
eccs_dumb_symbol_print(bracketright , ']').
eccs_dumb_symbol_print(underscore, '_').
eccs_dumb_symbol_print(radicalex , '-').
eccs_dumb_symbol_print(braceleft, '{').
eccs_dumb_symbol_print(bar , '|').
eccs_dumb_symbol_print(braceright , '}').
eccs_dumb_symbol_print(similar , '~').
eccs_dumb_symbol_print('Upsilon1', 'Upsilon1').
eccs_dumb_symbol_print(minute , '''').
eccs_dumb_symbol_print(lessequal, '=<').
eccs_dumb_symbol_print(fraction , '/').
eccs_dumb_symbol_print(arrowboth, '<->').
eccs_dumb_symbol_print(arrowleft , '<-').
eccs_dumb_symbol_print(arrowup , '^').
eccs_dumb_symbol_print(arrowright , '->').
eccs_dumb_symbol_print(arrowdown, 'v').
eccs_dumb_symbol_print(degree , 'o').
eccs_dumb_symbol_print(plusminus , '+-').
eccs_dumb_symbol_print(second , '"').
eccs_dumb_symbol_print(greaterequal, '>=').
eccs_dumb_symbol_print(multiply , 'x').
eccs_dumb_symbol_print(partialdiff , 'd').
eccs_dumb_symbol_print(bullet, '*').
eccs_dumb_symbol_print(divide , '/').
eccs_dumb_symbol_print(notequal , '\=').
eccs_dumb_symbol_print(equivalence , '==').
eccs_dumb_symbol_print(approxequal, '=~').
eccs_dumb_symbol_print(ellipsis , '...').
eccs_dumb_symbol_print(arrowvertex , '|').
eccs_dumb_symbol_print(arrowhorizex , '-').
eccs_dumb_symbol_print(carriagereturn, '<RETURN>').
eccs_dumb_symbol_print(circlemultiply , 'oXo').
eccs_dumb_symbol_print(circleplus , 'o+o').
eccs_dumb_symbol_print(emptyset , '0').
eccs_dumb_symbol_print(product, 'X').
eccs_dumb_symbol_print(radical , 'v/').
eccs_dumb_symbol_print(dotmath, '.').
eccs_dumb_symbol_print(logicalnot , '~').
eccs_dumb_symbol_print(logicaland , '&').
eccs_dumb_symbol_print(logicalor , 'v').
eccs_dumb_symbol_print(arrowdblboth, '<=>').
eccs_dumb_symbol_print(arrowdblleft , '<=').
eccs_dumb_symbol_print(arrowdblup , '^').
eccs_dumb_symbol_print(arrowdblright,'=>').
eccs_dumb_symbol_print(arrowdbldown, 'v').
eccs_dumb_symbol_print(lozenge , '<>').
eccs_dumb_symbol_print(angleleft , '<').
eccs_dumb_symbol_print(angleright, '>').
eccs_dumb_symbol_print(integral , 's').


