/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/ppostscript.pl,v $',
	'$State: Exp $').

$Log: ppostscript.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:13  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:29:49  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

All routines for the generation of PostScript data 
and interaction with the PostScript subprocess

*/

/*

PostScript subprocess

*/

:- dynamic eccs_sys_graphics_stream/1. 

eccs_postscript_available :-
	eccs_sys_graphics_stream(_).

eccs_open_postscript_device(S) :-
    (eccs_sys_graphics_stream(S), 
     eccs_sys_retract(eccs_sys_graphics_stream(S)), eccs_sys_close(S), fail; true),
    eccs_make_temporary_unique_filename(F),
    (eccs_global_variable(eccs_window_system, Wins), \+ (Wins = none);
     eccs_environment('DISPLAY', _), Wins = 'X'), !,
    eccs_global_variable(pleuk_etc, Dir),
    eccs_concat(Dir, '/gswindow', Command),
    eccs_unix_format_and_call([Command, Wins, F]),
    eccs_open(F, write, S),
    eccs_sys_assert(eccs_sys_graphics_stream(S)),
    eccs_attach_filter_to_stream(S, eccs_pl2ps_main).



eccs_start_postscript :-
    eccs_reset_postscript.

eccs_reset_postscript :-
    eccs_open_postscript_device(_S).

eccs_stop_postscript :-
    eccs_sys_graphics_stream(S),
    eccs_sys_close(S),
    eccs_sys_retract(eccs_sys_graphics_stream(S)),
    fail.
eccs_stop_postscript.

/*

How we make paper versions.

*/

/*

Wed Mar 17 16:29:25 1993 JC: What we have to print is now passed in as
the value of the key to_print.  See pmenudefs.pl 

*/

eccs_hardcopy_do_it(Args) :-
    eccs_memberchk(to_print=X, Args),
    (eccs_memberchk(outfile=FName, Args) ->
          eccs_hardcopy_to_file(FName, Args, X);
	  eccs_hardcopy_to_printer(Args, X)).



eccs_hardcopy_to_file(FName, Args, X) :-
    eccs_open(FName, write, Stream),
    !,
    eccs_current_output(Old),
    eccs_set_output(Stream),
    eccs_ps_file_header,
    eccs_memberchk(font=Font, Args),
    eccs_ps_font_table(Font, FontName),
    eccs_ps_literal(FontName),
    eccs_sys_write(' set_font'),
    eccs_sys_nl,
    eccs_pl2ps_hc_to_file(X),
    eccs_flush(Stream),
    eccs_sys_close(Stream),
    eccs_set_output(Old).

eccs_hardcopy_to_printer(Args, X) :-
    eccs_memberchk(scale = S, Args),
    eccs_memberchk(font = Font, Args),
    eccs_ps_font_table(Font, PSFontName),
    (PSFontName = 'CMR' -> A0 = []; A0 = ['-nocmr']),
    (eccs_memberchk(landscape, Args) -> A1 = ['-l'|A0]; A1 = A0),
    eccs_absolute_file_name(library('etc/hardcopy'), FName),
    eccs_append([FName], ['-s', S|A1], Command),
    eccs_unix_command_to_stdin(Command, 
    (eccs_ps_literal(PSFontName), eccs_sys_write(' set_font'),
     eccs_pl2ps_to_printer(X))).



/*

Tue Jul 28 13:36:22 1992 JC

To take account of the environment variable PLEUKPRINTHOST

*/

eccs_lpq :- 
    (eccs_environment('PLEUKPRINTHOST', Host) ->
    	 eccs_unix_format_and_call([rsh, Host, lpq]);
	 eccs_unix_format_and_call([lpq])).


eccs_get_line(S, L, Flag) :-
    eccs_sys_get0(S, X),
    eccs_get_line0(S, X, L, Flag).

eccs_get_line0(_, -1, [], end_of_file) :- !.  % end_of_file
eccs_get_line0(_, 10, [10], end_of_line) :- !.  % end_of_line
eccs_get_line0(Stream, Char, [Char|Cs], Flag) :-
    eccs_sys_get0(Stream, C1),
    eccs_get_line0(Stream, C1, Cs, Flag).


/*

Streams and PostScript

*/

eccs_write_to_postscript :-
    eccs_sys_prompt(_Old, ''),
    eccs_sys_if_then_else(eccs_sys_graphics_stream(OutStream), true,
    			  eccs_open_postscript_device(OutStream)),
    eccs_sys_nl(OutStream),			% clear the current page
    eccs_copy_stream_to_stream(user_input, OutStream).


eccs_put_line(_, []) :- !.
eccs_put_line(Stream, [C|Cs]) :-
    eccs_sys_put(Stream, C),
    eccs_put_line(Stream, Cs).

    
eccs_copy_stream_to_stream(InStream, OutStream) :-
    eccs_sys_repeat,
    eccs_get_line(InStream, Line, Flag),
    eccs_put_line(OutStream, Line),
    eccs_flush(OutStream),
    eccs_sys_if_then_else(Flag = end_of_file, true, fail),
    !.



eccs_string_to_postscript(Str) :-
    eccs_sys_graphics_stream(S),
    !,
    eccs_put_line(S, Str),
    eccs_flush(S),
    eccs_sys_nl(S).
eccs_string_to_postscript(_Str).

/*

Low level PostScript syntax definitions

*/


eccs_ps_literal(X) :-
    write('/'),
    write(X),
    write(' ').

eccs_ps_quote(X) :-
    write('('),
    write(X), 
    write(')'), nl.


eccs_ps_quote_string_or_atom(A) :-
    eccs_sys_atomic(A),  !,
    eccs_ps_quote(A). 
eccs_ps_quote_string_or_atom(Str) :-
    eccs_likely_string(Str), !,
    eccs_sys_write('('),
    eccs_print_string(Str),
    eccs_sys_write(') ').
eccs_ps_quote_string_or_atom(Umm) :-
    eccs_sys_write('('),
    eccs_sys_write(Umm),
    eccs_sys_write(') ').




/*

Transduction of prolog representation of feature structures, etc. to
PostScript with output to a named stream.

See the documentation on the PostScript program included with the 
rest of the system. 

PostScript types are

 atomic 
 variable *not used*
 uninstantiated
 sequence  
 set 
 sort 
 avm   
 tagged_avm 
 tagged
 tag
 disj 
 conj
 neg
 impl
 bicond
 relation
 infix
 parenth
 tree
 circle
 stack

We fake prefix and postfix as infixes with the 
appropriate element null.  This should get fixed!


*/


eccs_pl2ps_main(ToPrint) :-
    (ToPrint = captioned(Caption, Structure);
     ToPrint = Structure, Caption = ''), !,
    eccs_set_variable(eccs_last_output, captioned(Caption, Structure)),
    eccs_once(eccs_pl2ps(Structure)),
    eccs_sys_nl,
    eccs_sys_write(set_avm),
    eccs_sys_nl,
    eccs_ps_quote_string_or_atom(Caption),
    eccs_sys_nl,
    eccs_sys_write(set_caption),
    eccs_sys_nl,
    eccs_sys_write(draw_avm_main),
    eccs_sys_nl.


/*

The version to be used on printing to a file

We miss out the set_avm and draw_avm_main commands, as this will 
be supplied by a later filter. 


*/

eccs_pl2ps_hc_to_file(ToPrint) :-
    (ToPrint = captioned(Caption, Structure);
     ToPrint = Structure, Caption = ''), !,
    eccs_set_variable(eccs_last_output, captioned(Caption, Structure)),
    eccs_once(eccs_pl2ps(Structure)),
    eccs_sys_nl,
    eccs_ps_quote_string_or_atom(Caption),
    eccs_sys_nl,
    eccs_sys_write(set_caption),
    eccs_sys_nl.

/*

Ditto but direct to a printer


*/

eccs_pl2ps_to_printer(ToPrint) :-
    eccs_pl2ps_hc_to_file(ToPrint).

/* 

eccs_pl2ps(AVM)

The PostScript version of AVM is printed on the current stream.


*/


eccs_pl2ps(atomic(A)) :-
    !,
    eccs_sys_write('[ '),
    eccs_ps_literal(atomic),
    eccs_ps_quote(A),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(italic(A)) :-
    !,
    eccs_sys_write('[ '),
    eccs_ps_literal(italic),
    eccs_ps_quote(A),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(symbol(A)) :-
    !,
    (eccs_spf_symbol_encoding(A, _) -> true;
      eccs_warning(['PostScript', 'output:', A, is, not, a, valid, symbol, name])),
    eccs_sys_write('[ '),
    eccs_ps_literal(symbol),
    eccs_ps_literal(A),
    eccs_sys_write(' ]'),
    eccs_sys_nl.    
eccs_pl2ps(uninstantiated) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(uninstantiated),
    eccs_sys_write(' ]'),
    eccs_sys_nl.
eccs_pl2ps(sequence(S)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(sequence),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(S),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(set(S)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(set),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(S),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(sort(Sort)) :-
    !,
    eccs_sys_write('[ '),
    eccs_ps_literal(sort),
    eccs_ps_quote(Sort),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(avm(Fvpairs)) :-
    !,
    eccs_sys_write('[ '),
    eccs_ps_literal(avm),
    eccs_sys_write('[ '),
    eccs_reverse(Fvpairs, FV1),
    eccs_pl2ps_fvpairs(FV1),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(tagged_avm(Tag, Fvpairs)) :-
    !,
    (Fvpairs = avm(_) -> 
	Out = Fvpairs
       ; Out =avm(Fvpairs)),
    eccs_pl2ps(tagged(Tag, Out)).
eccs_pl2ps(tagged(Tag, Object)) :-
    !,
    eccs_sys_write('[ '),
    eccs_ps_literal(tagged),
    eccs_ps_quote(Tag),
    eccs_pl2ps(Object),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(tag(Tag)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(tag),
    eccs_ps_quote(Tag),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(disj(Ds)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(disj),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(Ds),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(conj(Ds)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(conj),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(Ds),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(neg(N)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(neg),
    eccs_pl2ps(N),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(impl(A, B)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(impl),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements([A, B]),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(bicond(A, B)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(bicond),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements([A, B]),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(relation(R, Args)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(relation),
    eccs_pl2ps_atomic(R),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(Args),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(infix(Operator, Arg1, Arg2)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(infix),
    eccs_pl2ps(Operator),
    eccs_pl2ps_elements([Arg1, Arg2]),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(prefix(Operator, Arg1)) :-
    eccs_pl2ps(infix(Operator, atomic(''), Arg1)).
eccs_pl2ps(postfix(Operator, Arg1)) :-
    eccs_pl2ps(infix(Operator, Arg1,  atomic(''))).
eccs_pl2ps(tree(Mother, Ds)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(tree),
    eccs_pl2ps(Mother),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(Ds),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(parenth(A)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(parenth),
    eccs_sys_write('[ '),
    eccs_pl2ps_elements(A),
    eccs_sys_write(']]'),
    eccs_sys_nl.
eccs_pl2ps(circle(A)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(circle),
    eccs_pl2ps(A),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(triangle(A)) :-
    eccs_sys_write('[ '),
    eccs_ps_literal(triangle),
    eccs_pl2ps(A),
    eccs_sys_write(']'),
    eccs_sys_nl.
eccs_pl2ps(stack(As)) :-
    eccs_pl2ps(vbox(left, As)).
/* 

Additions Wed Feb 17 13:37:31 1993 JC

*/

eccs_pl2ps(hbox(Es)) :-
    !,
    eccs_pl2ps(hbox(bottom, Es)).
eccs_pl2ps(hbox(Posn, Es)) :-
    (eccs_memberchk(Posn, [top, bottom, center]) -> 
	Posn = Position
      ; Position = bottom),
    eccs_sys_write('['),
    eccs_ps_literal(hbox),
    eccs_ps_literal(Position),
    eccs_sys_write('['),
    eccs_pl2ps_elements(Es),
    eccs_sys_write(']]'), eccs_sys_nl.
eccs_pl2ps(vbox(Es)) :-
    !,
    eccs_pl2ps(vbox(left, Es)).
eccs_pl2ps(vbox(Posn, Es)) :-
    (eccs_memberchk(Posn, [left, right, center]) -> 
	Posn = Position
      ; Position = left),
    eccs_sys_write('['),
    eccs_ps_literal(vbox),
    eccs_ps_literal(Position),
    eccs_reverse(Es, E1s),
    eccs_sys_write('['),
    eccs_pl2ps_elements(E1s),
    eccs_sys_write(']]'), eccs_sys_nl.
eccs_pl2ps(space(X, Y)) :-
    eccs_sys_write('['),
    eccs_ps_literal(space),
    (eccs_sys_number(X) -> 
	eccs_sys_write(X), eccs_sys_write(' ')
      ; eccs_pl2ps(X)),
    (eccs_sys_number(Y) -> 
	eccs_sys_write(Y), eccs_sys_write(' ')
      ; eccs_pl2ps(Y)),
    eccs_sys_write(']'), eccs_sys_nl.
eccs_pl2ps(box(X)) :-
    eccs_sys_write('['),
    eccs_ps_literal(box),
    eccs_pl2ps(X),
    eccs_sys_write(']'), eccs_sys_nl.

eccs_pl2ps(concat(Es)) :-
    eccs_sys_write('['),
    eccs_ps_literal(concat),
    eccs_sys_write('['),
    eccs_pl2ps_elements(Es),
    eccs_sys_write(']]'), eccs_sys_nl.

eccs_pl2ps(over(X, Y)) :-
    eccs_pl2ps(over(X, Y, atomic(''))).
eccs_pl2ps(over(X, Y, Tag)) :-
    eccs_sys_write('['),
    eccs_ps_literal(over),
    eccs_pl2ps_elements([X, Y, Tag]),
    eccs_sys_write(']'),
    eccs_sys_nl.

eccs_pl2ps(hpsg_sort(Sort, SPF)) :-
    eccs_sys_write('['),
    eccs_ps_literal(hpsg_sort),
    eccs_pl2ps(Sort),
    eccs_pl2ps(SPF),
    eccs_sys_write(']'), eccs_sys_nl.
eccs_pl2ps(prolog_list(H, T)) :-
    eccs_sys_write('['),
    eccs_ps_literal(prolog_list),
    eccs_pl2ps(H),
    (T == [] -> eccs_ps_literal(end_of_list);
	eccs_pl2ps(T)),
    eccs_sys_write(']'), eccs_sys_nl.

    



eccs_pl2ps_atomic(Term) :-
    eccs_memberchk(Term, [atomic(_), italic(_), symbol(_)]), !,
    eccs_pl2ps(Term).
eccs_pl2ps_atomic(Term) :-
    eccs_warning([Term, is, not, spf, atomic]),
    eccs_sys_write('['),
    eccs_ps_literal(atomic),
    eccs_ps_quote(Term),
    eccs_sys_write(']'), eccs_sys_nl.


eccs_pl2ps_elements([]).
eccs_pl2ps_elements([H|T]) :-
    eccs_pl2ps(H),
    eccs_pl2ps_elements(T).

eccs_pl2ps_fvpairs([]).
eccs_pl2ps_fvpairs([Feature = Value|R]) :-
    !,
    eccs_sys_write('[ '), 
    eccs_ps_quote(Feature),
    eccs_pl2ps(Value),
    eccs_sys_write(']'), 
    eccs_sys_nl,
    eccs_pl2ps_fvpairs(R).
eccs_pl2ps_fvpairs([H|T]) :-
    eccs_pl2ps(H),
    eccs_pl2ps_fvpairs(T).


/* environmental */

eccs_ps_font_table('Computer Modern Roman', 'CMR').
eccs_ps_font_table('Times Roman', 'Times-Roman').
eccs_ps_font_table('Avant Garde', 'AvantGarde').
eccs_ps_font_table('User', 'User').

eccs_ps_set_font(Font) :-
    eccs_ps_font_table(Font, FontName),
    "/" = [Slash],
    eccs_sys_name(FontName, L),
    eccs_string_to_postscript([Slash|L]),
    eccs_string_to_postscript("set_font"),
    eccs_note_ps_state(font, FontName).

eccs_ps_show_a4_borders :-
    eccs_string_to_postscript(
    "show_a4_borders {/show_a4_borders false def}  {/show_a4_borders true def} ifelse").

/* 
Portrait border facility added by kwh: Fri Jan 17 14:45:07 GMT 1992
*/

eccs_ps_show_a4_portrait_borders :-
    eccs_string_to_postscript(
    "show_a4_portrait_borders {/show_a4_portrait_borders false def}  {/show_a4_portrait_borders true def} ifelse").


eccs_ps_set_default_scale(NN) :-
    eccs_cast_to_number(NN, N),
    eccs_sys_name(N, L),
    eccs_string_to_postscript("/default_scale"),
    eccs_string_to_postscript(L),
    eccs_string_to_postscript("def"),
    eccs_note_ps_state(default_scale, N).
eccs_ps_set_absolute_scale(NN) :-
    eccs_cast_to_number(NN, N),
    eccs_sys_name(N, L),
    eccs_string_to_postscript("/absolute_scale"),
    eccs_string_to_postscript(L),
    eccs_string_to_postscript("def"),
    eccs_note_ps_state(absolute_scale, N).

eccs_ps_new_window :-
    eccs_string_to_postscript("new_window"),
    eccs_message(['The', new, window, will, appear, 
		  when, the, next, object, is, ready, to, be, drawn]).


eccs_ps_new_window(XNN, YNN) :-
    eccs_cast_to_number(XNN, X),
    eccs_cast_to_number(YNN, Y),
    eccs_sys_integer(X),
    eccs_sys_integer(Y),
    !,
    eccs_unix_command_to_stdin(['xrdb -merge'],
    	(eccs_sys_write('Ghostscript*geometry:    '), 
	 eccs_sys_write(X),
	 eccs_sys_write(x),
	 eccs_sys_write(Y),
	 eccs_sys_nl)),
    eccs_ps_new_window.

eccs_cast_to_number(N, N) :-
    eccs_sys_number(N), !.
eccs_cast_to_number(NN, N) :-
    eccs_sys_atomic(NN),
    eccs_sys_name(NN, L),
    eccs_sys_name(N, L),
    eccs_sys_number(N).


:- dynamic eccs_ps_state/2.

/*

We here trap for a few things that will be treated as default values.
i.e. absolute_scale =  0
*/

eccs_note_ps_state(Key, Value) :-
    (eccs_sys_retract(eccs_ps_state(Key, _)), fail; true),
    \+( (Key = absolute_scale, Value = 0)),
    eccs_sys_assert(eccs_ps_state(Key, Value)).

eccs_dump_ps_state(Params) :-
    eccs_memberchk(font, Params),
    eccs_ps_state(font, Font),
    eccs_ps_literal(Font),
    eccs_sys_write(' '),
    eccs_sys_write(set_font),
    eccs_sys_nl,
    fail.
eccs_dump_ps_state(Params)  :- 
    eccs_memberchk(scale, Params),
    eccs_ps_state(absolute_scale, Scale),
    eccs_ps_literal(fs_scale_factor), 
    eccs_sys_write(' '),
    eccs_sys_write(Scale),
    eccs_sys_write(' def'),
    eccs_sys_nl,
    fail.
eccs_dump_ps_state(_).

eccs_ps_file_header :-
    eccs_absolute_file_name(library('etc/hardcopy'), FName),
    eccs_sys_write('% Run this file through '),
    eccs_sys_write(FName),
    eccs_sys_nl,
    eccs_sys_write('% to produce hard copy or another file for inclusion'),
    eccs_sys_nl,
    eccs_sys_write('% in a document'),
    eccs_sys_nl.


/*

eccs_spf2ps(X)

write on standard out the PS form of SPF X.

*/

eccs_spf2ps(captioned(Caption, X)) :-
    !,
    eccs_ps_quote_string_or_atom(Caption),
    eccs_sys_nl,
    eccs_sys_write(set_caption),
    eccs_sys_nl,
    eccs_pl2ps(X).
eccs_spf2ps(X) :-
    eccs_pl2ps(X).
