/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pparser.pl,v $',
	'$State: Exp $').

$Log: pparser.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:13  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:56:08  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pparser.pl
Date:	Sat May 19 12:45:38 1990
By:	Jonathan Calder

Generic interface to parsers

*/

eccs_parse_from_menu(Input) :-
    eccs_global_variable(parser, PName),
    eccs_parser_spec(PName, Args),
    eccs_get_argument(input_format, Format, Args),
    eccs_get_argument(tokenizer, Tokenizer, Args),
    eccs_sys_if_then_else(Input = [], 
	                  eccs_get_selection(String), 
			  String = Input),
    eccs_massage_input(String, Format, Tokenizer, Massaged),
    eccs_get_argument(prehook, PreHook, Args),
    eccs_sys_call(PreHook),
    eccs_get_argument(all_parses, All_Parses, Args),
    eccs_zero(parse_no),
    eccs_call_parser(All_Parses, PName, Args, Massaged).


/*

Tue Apr  6 12:33:40 1993 JC  Added explicit call to garbage_collect after 
parsing.  Necessitated by the heavy memory turn over of HPSG-PL.  

*/

eccs_call_parser(All_Parses, Name, Args, String) :-
    eccs_message(['parsing:', String]),
    eccs_construct_and_call([Name, Args, String, Results]),
    (All_Parses = true -> !; true),
    (eccs_global_variable(prolog_type, sicstus) -> garbage_collect; true),
    eccs_do_analysis(All_Parses, Args, String, Results).




eccs_parser_spec(Name, Args) :-
    eccs_standard_parser_arguments(A1),
    eccs_sys_if_then_else(eccs_user_parser_spec(Name, A2), eccs_append(A2, A1, Args), Args = A1).


eccs_standard_parser_arguments([
	all_parses = true, 
	input_format = list, 
	tokenizer = eccs_generic_tokenizer]).


/*

eccs_massage_input(String, Format, Tokenizer, Massaged)

Attempt to coerce the input into what's expected

Format = list means a list of atoms
       = string means a list of character codes

The ordering of these clauses is important.  

*/

eccs_massage_input(Atom, Format, Tokenizer, Massaged) :-
    eccs_sys_atomic(Atom), !,
    eccs_sys_name(Atom, List),
    eccs_massage_input(List, Format, Tokenizer, Massaged).
eccs_massage_input(String, string, _Tokenizer, String) :-
    eccs_likely_string(String), !.
eccs_massage_input(String, list, Tokenizer, Massaged) :-
    eccs_likely_string(String),
    eccs_construct_and_call([Tokenizer, String, Massaged]), !.
eccs_massage_input(List, list, _Tokenizer, List) :-
    eccs_listp(List),
    eccs_forall( eccs_member(E, List), eccs_sys_atomic(E)).


/* 

eccs_post_last_sentence(List)

Called by the parser to record the sentence last entered.

*/



eccs_post_last_sentence(List) :-
	eccs_set_variable(eccs_last_sentence, List),
	eccs_global_variable(eccs_last_sentence_list, Last),
	(eccs_delete(List, Last, Remainder); Remainder = Last ), !,
	eccs_prune_last_setence_list(Remainder, Pruned),
	eccs_set_variable(eccs_last_sentence_list, [List|Pruned]).
	
eccs_prune_last_setence_list(List, List) :-
    eccs_length(List, N),
    eccs_global_variable(number_of_sentences_to_retain, M),
    N =< M, !.
eccs_prune_last_setence_list(List, List1) :-
    eccs_global_variable(number_of_sentences_to_retain, M),
    eccs_length(List1, M),
    eccs_append(List1, _, List).


/*

eccs_do_analysis(AllParses, Args, String, Results).

set things up so that we can produce output for the user.

In the case of parsers which have to backtrack for more results (i.e. AllParses = false)
we have to set up a mini-interpreter to print out results.

?? there may be some work needed here to get reasonable behaviour 
under both a windowing system and the dumb terminal set up.

*/

eccs_do_analysis(true, _, String, Results) :-
    eccs_length(Results, N),
    eccs_sys_if_then_else(N > 0, 
	(eccs_set_counter(parse_no, 1), eccs_message([N, 'parse(s)', found])),
	eccs_message([no, parses, found])),
    eccs_sys_if_then_else(eccs_likely_string(String), 
	eccs_generic_tokenizer(String, List), 
	String = List),
    eccs_append_all([['/*'], List, [has, N, 'parse(s)'], ['*/']], Message),
    eccs_message(Message),
    eccs_sys_assert(eccs_last_sentence_analysis(String, N, Results)), !,
% This code changed by chb to avoid movement to the all_parses_analysis 
% menu if there are no parses
    \+  Results = [],
    eccs_do_menu(all_parses_analysis).

eccs_do_analysis(false, _, String, Result) :-
    eccs_increment(parse_no, N),
    eccs_sys_if_then_else(eccs_likely_string(String), 
    	eccs_generic_tokenizer(String, List), 
	String = List),
    eccs_message([computed, the, N, th, parse, for|String]),
    eccs_mini_interpreter([
		eccs_show_current_parse = eccs_output_file_goal(eccs_print_result1([Result])),
		eccs_show_next_parse = exit(fail)]).


eccs_mini_interpreter(List) :-
    eccs_sys_repeat,
    eccs_sys_read(X),
    eccs_mini_interpreter_command(X, List, Command),
    !,
    eccs_sys_call(Command).

eccs_mini_interpreter_command(X, List, Command) :-
    eccs_memberchk(X = FirstCommand, List),
    eccs_sys_if_then_else(FirstCommand = exit(Command), true,
	(eccs_sys_call(FirstCommand), !, fail)).
eccs_mini_interpreter_command(X, _, _) :-
    eccs_error([the, command, X, is, not, available, at, this, time]).

:- dynamic eccs_last_sentence_analysis/3.


eccs_show_current_parse(_Results) :-
    eccs_counter(parse_no, N),
    eccs_last_sentence_analysis(_, Total, Results),
    eccs_length(Results, Total),
    eccs_nth_element(N, Results, Result), 
    eccs_construct_parse_caption(N, Total, Caption),
    eccs_output_file_goal(eccs_print_result1(Caption, Result)).

eccs_show_next_parse :-
    eccs_counter(parse_no, N),
    eccs_succ(N, M),
    eccs_last_sentence_analysis(_, I, Results),
    eccs_sys_if_then_else(M =< I, 
	(eccs_set_counter(parse_no, M), eccs_show_current_parse(Results)),
	eccs_message([no, more, parses])).

eccs_show_previous_parse :-
    eccs_counter(parse_no, N),
    eccs_succ(M, N),
    eccs_sys_if_then_else(M > 0, 
	(eccs_set_counter(parse_no, M), eccs_show_current_parse(_Results)),
	eccs_message([no, previous, parses])).

eccs_show_parse_n(N) :-
    eccs_last_sentence_analysis(_, M, Results),
    0 < N, N =< M,
    eccs_set_counter(parse_no, N),
    eccs_show_current_parse(Results).

eccs_construct_parse_caption(N, Total, Caption) :-
    eccs_interpolate_char(' ', ['parse', N, of, Total], L),
    eccs_global_variable(eccs_last_sentence, S),
    eccs_interpolate_char(' ', S, S1),
    eccs_append(['"'|S1], ['": '|L], C1),
    eccs_concat_list(C1, Caption).


/*

Display options


eccs_set_output_format(X)

where X is either tree or feature_structure

feature_structure is the default


*/

eccs_set_output_format(Format) :-
    eccs_sys_if_then_else(eccs_member(Format, [feature_structure, tree]),
    		true,
		eccs_error([Format, must, be, either, feature_structure, or, tree])),
    !,
    eccs_global_variable(parser, PName),
    eccs_sys_if_then_else(Format = feature_structure, 
		PrintRef = fs_drawer, 
		PrintRef = tree_drawer),
    eccs_parser_spec(PName, Args),
    eccs_sys_if_then_else(eccs_get_argument(PrintRef, Printer, Args),
    			  eccs_set_variable(parse_printer, Printer),
			  eccs_error([no, printing, routine, available, for, Format, format, 
			  	      with, parser, PName])).
