/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:15 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pmessages.pl,v $',
	'$State: Exp $').

$Log: pmessages.pl,v $
% Revision 1.0  1993/04/26  16:59:15  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:13  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:56:08  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/perror.pl
Date:	Wed May  9 10:42:58 1990
By:	Jonathan Calder

General messages to the user.

Five  basic categories:

user:      a message which goes to the user alone
messages:  general info on the progress of compilation, etc
warnings:  errors deemed non-serious
errors:    stuff that the user must see immediately
fatals:    things that are bad enough to make us want to quit prolog (very rare)

Messages go to the user only if there is no log window available.

*/

eccs_user_message(List) :-
    eccs_user_output(user, List).
eccs_message(List) :-
    eccs_user_output(message, List).
eccs_warning(List) :-
    eccs_user_output(warning, List).
eccs_error(List) :-
    eccs_user_output(error, List).
eccs_fatal(List) :-
    eccs_user_output(fatal, List).

eccs_user_output(user, List) :- !,
    eccs_format_message(List, Message),
    eccs_to_user(Message).
eccs_user_output(Type, List) :-
    eccs_format_message(List, Message),
    eccs_output_prefix(Type, Message, M1),
    eccs_session_log_message(M1),
    eccs_sys_if_then_else(Type = error, (eccs_global_variable(abort_on_error, true), eccs_abort), true),
    eccs_sys_if_then_else(Type = fatal, eccs_sys_halt, true).

eccs_output_prefix(message, Message, Message).
eccs_output_prefix(error, Message, ['ERROR:'| Message]).
eccs_output_prefix(warning, Message, ['WARNING:'|Message]).
eccs_output_prefix(fatal, Message, ['FATAL ERROR:'|Message]).

/*

Thu Oct 15 14:09:08 1992 JC

Removed the following routine.  It was only called by the 
file loading routine. 

eccs_debug(N, Goal) :-
    eccs_global_variable(debugging_level, M),
    N >= M, !,
    eccs_message(['debug:']), call(Goal).
eccs_debug(_, _).

*/

eccs_session_log_message(Message) :-
    eccs_log_file_goal(eccs_print_message(Message)).


eccs_to_user(Message) :-
    eccs_write_to_user(eccs_print_message(Message)).


/*

Attempt to find a reasonable format for a message, looking in particular 
for things that are really strings.
Also map between abbreviations for newline, etc.

Thu Oct 15 14:15:58 1992 JC Added the 2nd and 2nd to last clause, to
allow for aribtrary terms. As the ultimate outputting will be done by
write, even under GM, we should be OK.

*/

eccs_format_message([], []) :- !.
eccs_format_message([Var|R], [Var|R1]) :-
    eccs_sys_var(Var),
    !,
    eccs_format_message(R, R1).
eccs_format_message(['$nl$'|R], [NL|Rest]) :- % not much to do 
    !,
    eccs_global_variable(eccs_line_terminator, Char),
    eccs_sys_name(NL, [Char]),
    eccs_format_message(R, Rest).
eccs_format_message([F|R], [F|Rest]) :- % not much to do otherwise
    eccs_sys_atomic(F), !,
    eccs_format_message(R, Rest).
eccs_format_message([String|R], [F|Rest]) :- 
    eccs_likely_string(String),	!,	% attempt to guess 
    eccs_sys_name(F, String),
    eccs_format_message(R, Rest).
eccs_format_message([F|R], [F|R1]) :-
    !,
    eccs_format_message(R, R1).
eccs_format_message(Last, [Last]).	% In case something creeps 
					% into the last cdr

