/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:49:15 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pmenutty.pl,v $',
	'$State: Exp $').

$Log: pmenutty.pl,v $
% Revision 1.0  1993/04/26  16:49:15  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:09:51  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:28:45  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/


/* Original versions of menus removed and these added by kwh:
Wed Sep 18 18:57:39 BST 1991
pmenus.pl removed
dumb terminal specific menu definitions added here */



/*

Predicates for dealing with menus when we're just running on a glass teletype

*/


eccs_menu_prompt(Prompt) :- 
    eccs_write_to_user((eccs_sys_write(Prompt), eccs_sys_write('> '))).



/* POP-UP MENUS */

eccs_dumb_menu(['-heading',Heading, '-geometry',_Geom|Options], Selection) :-
	eccs_dumb_menu1(Heading, Options, Selection).

eccs_dumb_menu1(Heading, ['Exit Menu'|Options], Selection) :- !,
	eccs_dumb_menu1(Heading, Options, Selection).
eccs_dumb_menu1(Heading, Options, Selection) :-
	eccs_write_to_user(eccs_sys_nl),
	eccs_menu_prompt(Heading),
	eccs_read_line(String),
	eccs_find_menu_selection(String, Heading, Options, Selection).


eccs_find_menu_selection(String, Heading, Options, Selection) :-
	eccs_generic_tokenizer(String, ['?']), !,
	eccs_write_to_user(eccs_list_menu_items(Options)),
	eccs_dumb_menu1(Heading, Options, Selection).
eccs_find_menu_selection(String, Heading, Options, Selection) :-
	eccs_generic_tokenizer(String, []), !,
	eccs_find_menu_selection("Exit", Heading, Options, Selection).
eccs_find_menu_selection(String, Heading, Options, Selection) :-
	eccs_append(String, _Var, OpenString),
	findall(Match,
	        eccs_match_menu_selection(OpenString, Options, Match),
		Matches),
        eccs_sys_if_then_else(Matches = [Selection],
	    true,
	    eccs_sys_if_then_else(Matches = [],
	        (eccs_user_message([no, option, matches, String]),
		 eccs_dumb_menu1(Heading, Options, Selection)),
		(eccs_user_message([ambiguous, entry,':',String]),
		 eccs_dumb_menu1(Heading, Options, Selection)) ) ),
        !.


eccs_match_menu_selection([H|T], Options, Match) :-
	eccs_member(Match, Options),
	\+ (Match = line),
	(eccs_sys_name(Match, [H|T]);
	 (CH is H-32, eccs_sys_name(Match, [CH|T]))).    % capitalize first


eccs_list_menu_items([]) :- !.
eccs_list_menu_items([line | Rest]) :-
	eccs_list_menu_items(Rest).
eccs_list_menu_items([Option | Rest]) :-
	eccs_sys_write(Option), eccs_sys_nl,
	eccs_list_menu_items(Rest).



/* ALERT BOXES */

eccs_confirm(['-heading',Message|_]) :-
	eccs_write_to_user(eccs_sys_nl),
	eccs_to_user([Message]),
	eccs_to_user(['<y/n> ?']),
	eccs_read_line(InputString),
	(InputString = [121|_]; InputString = [89|_]).



/* DIALOG BOXES */

eccs_dialog(['-heading',Heading, '-default',Default, '-geometry',_Geometry], InputValue) :-
	eccs_sys_if_then_else(eccs_sys_name(Default, [35|Val]),  % ASCII '#'
	    eccs_sys_name(Default1, Val),
	    Default1 = Default),
	eccs_sys_if_then_else(Default1 = '',
	    DefaultMessage = ['(<.> = Cancel)'],
	    DefaultMessage = ['(<Return> =', Default1, ', <.> = Cancel)']),
	eccs_write_to_user(eccs_sys_nl),
	eccs_to_user([Heading | DefaultMessage]),
	eccs_read_line(InputString),
	eccs_sys_if_then_else((InputString = [46]; InputString = [-1]), % . or EOF
	                      (eccs_to_user(['Cancelled.']), fail),
			      true),
	eccs_sys_if_then_else(InputString = [],
	                      InputValue = Default1,
			      eccs_sys_name(InputValue, InputString)).




/* Dumb Terminal Specific MENU DEFINITIONS */

eccs_dumb_menu(parse, popup,
	       [ options = [ command('String', 
	                             eccs_do_menu(parse_from_menu, [])),
                             command('Previous string',
			             eccs_do_menu(reparse, [])) | Others ],
                 stayhere = true,
		 prompt = 'Parse Menu' ]) :-
        eccs_sys_if_then_else(eccs_global_variable(test_sentence_list, []),
            Others = Rest,
	    Others = [ command('Test string',
	                       eccs_do_menu(test_parse, [])) | Rest ]),
        Rest = [ command('Load changed files', eccs_load_from_menu),
	         '$$PROLOG' ].


eccs_dumb_menu(all_parses_analysis, popup,
	       [ options = [ command('Current parse',
	  	                     eccs_show_current_parse(_)),
			     command('PostScript',
		                     eccs_do_menu(postscript, [])),
	                     '$$PROLOG' ],
            prompt = 'Print Results Menu',
	    stayhere = true]) :-
    eccs_last_sentence_analysis(_, 1, _), !.
eccs_dumb_menu(all_parses_analysis, popup,
	       [ options = [ command('Current parse',
	  	                     eccs_show_current_parse(_)),
			     command('Next parse', 
				     eccs_show_next_parse),
			     command('Previous parse', 
				     eccs_show_previous_parse),
			     command('PostScript',
		                     eccs_do_menu(postscript, [])),
	                     '$$PROLOG' ],
            prompt = 'Print Results Menu',
	    stayhere = true]).


eccs_dumb_menu(hc, popup,
	       [ options = [ command('File', eccs_do_menu(hcf)),
	                     command('Printer', eccs_do_menu(hcs)) ],
                 prompt = 'Hardcopy'] ).

	
