/*

rcsid('$Id: pgmviews.pl,v 1.0 1993/04/26 16:41:43 pleuk Exp $').
$Log: pgmviews.pl,v $
% Revision 1.0  1993/04/26  16:41:43  pleuk
% Version 1.00beta from Jo
%

File:	/tmp_mnt/home/dk2/jcalder/Pleuk/Code/pgmviews.pl Date:	Thu
Aug 27 11:53:42 1992 By:	Jo Calder

Support for a graphical debugger

*/


eccs_open_view(Object, [X, Y], Caption, Handle) :-
    eccs_gm_window_size(X, Y, RealX, RealY, Scroll),
    eccs_gm_make_view(RealX, RealY, Caption, Handle, Scroll),
    Handle = gm_view_handle(W, _),
    gmsend(W, open),
    eccs_gm_add_record([RealX, RealY], Caption, Handle, Object).

eccs_gm_window_size(X, Y, RealX, RealY, Scroll) :-
    eccs_gm_max_window_size(XMax, YMax),
    eccs_gm_origin(XO, YO),
    OverallX is 2*XO + X,
    OverallY is 2*YO + Y,
    eccs_sys_min(XMax, OverallX, TempX),
    eccs_sys_min(YMax, OverallY, TempY),
    ((XMax < X ; YMax < Y) -> Scroll = yes; Scroll = no),
    eccs_gm_min_window_size(XMin, YMin),
    eccs_sys_max(XMin, TempX, RealX),
    eccs_sys_max(YMin, TempY, RealY).



eccs_gm_max_window_size(600, 400).

eccs_gm_min_window_size(100, 200).


eccs_gm_make_view(X, Y, Caption, gm_view_handle(Handle,VHandle), Scroll) :- 
    (Scroll == yes -> Contents = scroller(VHandle); Contents = VHandle), 
    gmcreate(VHandle, view(X, Y)), 
    gmcreate(Handle, window(Caption, Contents)).  


/*

eccs_gm_view_record(Dims, Caption, Handle, SPF).

*/

:- dynamic eccs_gm_view_record/4.



eccs_gm_add_record(Dims, Caption, Handle, Object) :-
    eccs_sys_assertz(eccs_gm_view_record(Dims, Caption, Handle, Object)).

eccs_gm_display_object(Object, _WHandle) :-
    (Object = captioned(Cap, O); Object = O, Cap = ''),
    eccs_dummy_window(_Window, Handle),
    eccs_gm_spf_metrics(O, Handle, Metrics, [X, Y]),
    eccs_view_string_measure(atomic, Cap, W),
    WReal is 45 + W,
    eccs_sys_max(WReal, X, X1),
    eccs_gm_draw_object(_NewHandle, [X1, Y], O, Metrics, _OHandle).


/*

eccs_gm_spf_metrics(Object, Handle, Metrics, Dims)

Dims = [X, Y] where X and Y and the width and height of object, drawn
in the current font.  Metrics is a binary tree containing the
dimensions of every sub object in Object.

*/

eccs_gm_spf_metrics(Object, _Handle, Metrics, Dim) :-
    eccs_gm_spf_metrics(Object, Metrics, Dim).

eccs_gm_spf_metrics(Object, Metrics, [X, Y]) :-
    eccs_gm_intree(Object, Metrics, AlreadyDone, Params),
    eccs_memberchk(x = X, Params), 
    eccs_memberchk(y = Y, Params),
    (AlreadyDone == true ->
	  true
	; eccs_gm_spf_measure(Object, Metrics, [X, Y])).


/*

eccs_gm_intree(Object, Tree, There?, Params)

Object appears in binary tree, Tree.  There? == true, if Object was in
tree prior to calling, false otherwise.  Params is a bunch of info
associated with object.

*/
eccs_gm_intree(Object, Tree, false, Params) :-
    eccs_sys_var(Tree), !,
    Tree = t(_L, Object, Params, _R).
eccs_gm_intree(Object, Tree, There, Params) :-
    Tree = t(L, O, P, R),
    eccs_sys_compare(Reln, Object, O),
    eccs_gm_intree1(Reln, Object, O, Params, P, L, R, There).

eccs_gm_intree1(=, O, O, P, P, _L, _R, true).
eccs_gm_intree1(<, Object, _O, Params, _P, L, _R, There) :-
    eccs_gm_intree(Object, L, There, Params).
eccs_gm_intree1(>, Object, _O, Params, _P, _L, R, There) :-
    eccs_gm_intree(Object, R, There, Params).

/*

eccs_gm_spf_measure(SPF, Metrics, [X, Y])

SPF object has X and Y as its dimensions.  Metrics is a binary tree of
other measured SPF objects.

*/

eccs_gm_spf_measure(atomic(Atom), _Metrics, [X, Y]) :-
    eccs_sys_atomic(Atom), !,
    eccs_spf2gm_get_param(view_point_size, Y),
    (Atom = [] -> String = "[]"; Atom = String),
    eccs_view_string_measure(atomic, String, AX),
    (Atom = [] ->
	eccs_spf2gm_get_param(inter_tag_space, ITS)
      ; ITS = 0),
    X is ITS+AX.
eccs_gm_spf_measure(symbol(Atom), _Metrics, [X, Y]) :-
    eccs_sys_atomic(Atom), !,
    eccs_gm_decode_symbol(Atom, Print),
    eccs_spf2gm_get_param(view_point_size, Y),
    eccs_view_string_measure(symbol, Print, X).
eccs_gm_spf_measure(italic(Atom), _Metrics, [X, Y]) :-
    eccs_sys_atomic(Atom), !,
    eccs_spf2gm_get_param(view_point_size, Y),
    eccs_view_string_measure(italic, Atom, X).
eccs_gm_spf_measure(uninstantiated, _Metrics, [X, Y]) :- !,
    eccs_spf2gm_interline_space(Y),
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_view_string_measure(atomic, format("~s", ["[]"]), W),
    X is W + BBS.
eccs_gm_spf_measure(sequence(S), Metrics, [X, Y]) :-
    eccs_max_y_extents(S, Metrics, SY), 
    eccs_spf2gm_interline_space(ILS),
    eccs_sys_max(SY, ILS, Y),
    eccs_sum_x_extents(S, Metrics, SumX),
    eccs_gm_angle_bracket_offset([_, Y], Off),
    eccs_view_separator_width(sequence, SSW),
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_sys_max(SumX, BBS, Width),
    eccs_length(S, N),
    X is (N -1)* SSW + Width + 2*Off + 2*BBS.
eccs_gm_spf_measure(set(S), Metrics, [X, Y]) :-
    eccs_max_y_extents(S, Metrics, Y), 
    eccs_sum_x_extents(S, Metrics, SumX),
    eccs_length(S, N),
    eccs_view_separator_width(set, SSW),
    eccs_gm_braces_size(Y, BX),
%    eccs_spf2gm_get_param(between_bracket_space, BBS),
    X is (N -1) * SSW + SumX + 2*BX. 
eccs_gm_spf_measure(sort(S), _Metrics, [X, Y]) :-
    eccs_spf2gm_get_param(view_point_size, Y),
    eccs_view_string_measure(sort, S, X).
eccs_gm_spf_measure(avm([]), Metrics, Dims) :-
    !,
    eccs_gm_spf_measure(uninstantiated, Metrics, Dims).
eccs_gm_spf_measure(avm(FVPairs), Metrics, Dims) :-
    eccs_gm_spf_measure_fv_pairs(avm(FVPairs), Metrics, Dims).
eccs_gm_spf_measure(tagged(Tag, Object), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_measure_tag(tag(Tag), Metrics, [TX, _TY]),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    eccs_gm_spf_metrics(Object, Metrics, [OX, Y]), 
    X is ITS + TX + OX.
eccs_gm_spf_measure(tagged_avm(Tag, FVPairs), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_metrics(tag(Tag), Metrics, [TX, _TY]),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    (FVPairs = avm(FVP) -> true; FVPairs = FVP),
    eccs_gm_spf_metrics(avm(FVP), Metrics, [AX, Y]), 
    X is ITS + TX + AX.
eccs_gm_spf_measure(tag(T), Metrics, [X, Y]) :-
    !, 
    eccs_gm_spf_measure_tag(T, Metrics, [X, Y]).
eccs_gm_spf_measure(disj(Ds), Metrics, [X, Y]) :-
    !,
    eccs_max_y_extents(Ds, Metrics, Y),
    eccs_sum_x_extents(Ds, Metrics, SumX),
    eccs_logic_char(disj, _Font, _C, CX),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_length(Ds, N),
    X is (2 * BAVS + CX) * (N -1) + SumX.
eccs_gm_spf_measure(conj(Ds), Metrics, [X, Y]) :-
    !,
    !,
    eccs_max_y_extents(Ds, Metrics, Y),
    eccs_sum_x_extents(Ds, Metrics, SumX),
    eccs_logic_char(conj, _Font, _C, CX),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_length(Ds, N),
    X is (2 * BAVS + CX) * (N -1) + SumX.
eccs_gm_spf_measure(neg(N), Metrics, [X, Y]) :-
    !, 
    eccs_gm_spf_metrics(N, Metrics, [OX, Y]), 
    eccs_logic_char(neg, _, _, CX),
    eccs_spf2gm_get_param(inter_tag_space, ITS), 
    X is OX + ITS + CX.

eccs_gm_spf_measure(impl(A, B), Metrics, [X, Y]) :-
    !, 
    eccs_gm_spf_metrics(A, Metrics, [AX, AY]), 
    eccs_gm_spf_metrics(B, Metrics, [BX, BY]), 
    eccs_logic_char(impl, _, _, CX),
    eccs_sys_max(AY, BY, Y), 
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    X is 2*BAVS + AX + BX + CX.

eccs_gm_spf_measure(bicond(A, B), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_metrics(A, Metrics, [AX, AY]), 
    eccs_gm_spf_metrics(B, Metrics, [BX, BY]), 
    eccs_logic_char(impl, _, _, CX),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_sys_max(AY, BY, Y), 
    X is 2*BAVS + AX + BX + CX.
eccs_gm_spf_measure(relation(R, Args), Metrics, [X, Y]) :-
    eccs_gm_spf_metrics(parenth(Args), Metrics, [PX, Y]), 
    eccs_gm_spf_metrics(R, Metrics, [RX, _]),
    X is PX+RX.
eccs_gm_spf_metrics(parenth([]), _Metrics, [X, Y]) :-
    eccs_spf2gm_interline_space(Y),
    eccs_gm_paren_width(Y, PX),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    X is 2*PX + BAVS.
eccs_gm_spf_measure(parenth(Args), Metrics, [X, Y]) :-
    !,
    eccs_max_y_extents(Args, Metrics, PY),
    eccs_sum_x_extents(Args, Metrics, SumX),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_spf2gm_interline_space(ILS),
    eccs_sys_max(ILS, PY, Y),
    eccs_gm_paren_width(Y, PX),
    eccs_view_string_measure(atomic, ',', CX),
    eccs_length(Args, N),
    X is (N -1) *(2 * BAVS + CX) + 2*BAVS + SumX + PX.

eccs_gm_spf_measure(circle(SPF), Metrics, [Rad, Rad]) :-
    !,
    eccs_gm_spf_metrics(SPF, Metrics, [X, Y]),
    eccs_sys_max(X, Y, InnerRad),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    Rad is InnerRad + ITS.
eccs_gm_spf_measure(triangle(SPF), Metrics, [X, Y]) :-
    eccs_gm_spf_metrics(SPF, Metrics, [X1, Y1]),
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    X is 2*(X1 + BBS),
    Y is 2*(Y1 + BBS).
eccs_gm_spf_measure(stack(Args), Metrics, [X, Y]) :-
    eccs_sum_y_extents(Args, Metrics, SumY), 
    eccs_max_x_extents(Args, Metrics, X),
    eccs_spf2gm_get_param(space_between_stack_elements, BS), 
    eccs_length(Args, N),
    Y is ((N -1) * BS) + SumY.
eccs_gm_spf_measure(postfix(Op, A), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_measure(infix(Op, A, atomic('')), Metrics, [X, Y]).
eccs_gm_spf_measure(prefix(Op, A), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_measure(infix(Op, atomic(''), A), Metrics, [X, Y]).
eccs_gm_spf_measure(infix(Operator, A, B), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_metrics(A, Metrics, [AX, AY]),
    eccs_gm_spf_metrics(B, Metrics, [BX, BY]),
    eccs_gm_spf_metrics(Operator, Metrics, [OpX, _OpY]), 
    eccs_sys_max(AY, BY, Y),
    X1 is AX + BX + OpX,
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    (eccs_member(atomic(''), [A, B]) ->
	AddX = ITS
      ; AddX is ITS*2),
    X is X1 +AddX.
eccs_gm_spf_measure(tree(M, Ds), Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_metrics(M, Metrics, [MX, MY]), 
    eccs_sum_x_extents(Ds, Metrics, SumX), 
    eccs_max_y_extents(Ds, Metrics, MaxY), 
    eccs_length(Ds, N), 
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    eccs_spf2gm_get_param(vertical_tree_sep, VTS), 
    DsWidth is (N + 1 ) * HTS + SumX, 
    eccs_sys_max(DsWidth, MX, X), 
    Y is VTS + MaxY + MY,
    eccs_gm_intree(tree(M, Ds), Metrics, _AlreadyDone, Params),
    (MX > DsWidth -> 
	TreeTop is MX/2
      ; eccs_gm_treetop(tree(M, Ds), Metrics, TreeTop)),
    eccs_memberchk(x = X, Params),
    eccs_memberchk(y = Y, Params),
    eccs_memberchk(treetop = TreeTop, Params).

eccs_gm_spf_measure(sensitize(Obj, _Action), Metrics, Dims) :-
    eccs_gm_spf_measure(Obj, Metrics, Dims).

/*

Tue Feb 16 15:57:37 1993 JC

Additions

hbox(Positioning, Elements)
hbox(Elements)

Positioning is in {top, bottom, center}: Elements are arrayed
horizontally and are aligned along their top, bottom or centre lines.
hbox(E) is equivalent to hbox(bottom, E).

vbox(Positioning, Elements)
vbox(Elements)

Positioning is in {left, right, center}: Elements are arrayed
vertically and are left or right-justified or centred. vbox(E) is
equivalent to vbox(left, E).

space(X, Y) where X, Y are either integers (= dimensions in points) or
arbitrary SPF (= relevant dimensions)

box(SPF) a box is drawn around SPF.

concat(Es) Es are drawn horizontally aligned along their bottoms with
minimal extra horizontal space.

over(Top, Bottom, Tag) 
over(Top, Bottom) the elements of Top are drawn horizontally as are
Bottom, separated by a line.  If Tag is present it is drawn centred on
the line.

hpsg_sort(SortSPF, BodySPF) typeset as bottom-aligned with minimal
horizontal separation.  Expected usage: hpsg_sort(italic(synsem), SPF).  

*/

eccs_gm_spf_measure(hbox(_Pos, Args), Metrics, [X, Y]) :-
    eccs_max_y_extents(Args, Metrics, Y),
    eccs_sum_x_extents(Args, Metrics, SumX),
    eccs_spf2gm_get_param(space_between_stack_elements, BS),
    eccs_length(Args, N),
    X is (N-1)*BS + SumX.
eccs_gm_spf_measure(hbox(Args), Metrics, Dims) :-
    eccs_gm_spf_measure(hbox(bottom, Args), Metrics, Dims).

eccs_gm_spf_measure(vbox(_Pos, Args), Metrics, [X, Y]) :-
    eccs_sum_y_extents(Args, Metrics, SumY),
    eccs_max_x_extents(Args, Metrics, X),
    eccs_spf2gm_get_param(space_between_stack_elements, BS),
    eccs_length(Args, N),
    Y is (N-1)*BS + SumY.
eccs_gm_spf_measure(vbox(Args), Metrics, Dims) :-
    eccs_gm_spf_measure(vbox(_, Args), Metrics, Dims).

eccs_gm_spf_measure(space(X, Y), Metrics, [DX, DY]) :-
    (eccs_sys_integer(X) -> 
	X = DX 
      ; eccs_gm_spf_measure(X, Metrics, [DX, _])),
    (eccs_sys_integer(Y) -> 
	Y = DY
      ; eccs_gm_spf_measure(Y, Metrics, [DY, _])).

eccs_gm_spf_measure(box(SPF), Metrics, [X, Y]) :-
    eccs_gm_spf_measure(SPF, Metrics, [CX, CY]),
    eccs_spf2gm_get_param(space_between_stack_elements, BS),
    X is CX+BS,
    Y is CY+BS.

eccs_gm_spf_measure(concat(Es), Metrics, [SumX, Y]) :-
    eccs_sum_x_extents(Es, Metrics, SumX),
    eccs_max_y_extents(Es, Metrics, Y).

eccs_gm_spf_measure(over(Top, Bottom), Metrics, [X, Y]) :-
    eccs_gm_spf_measure(Top, Metrics, [TX, TY]),
    eccs_gm_spf_measure(Bottom, Metrics, [BX, BY]),
    eccs_spf2gm_get_param(space_between_stack_elements, BS),
    eccs_sys_max(TX, BX, X),
    Y is TY+BY+BS.

eccs_gm_spf_measure(over(Top, Bottom, Tag), Metrics, [X, Y]) :-
    eccs_gm_spf_measure(over(Top, Bottom), Metrics, [OX, OY]),
    eccs_gm_spf_measure(Tag, Metrics, [TagX, TagY]),
    eccs_sys_max(OY, TagY, Y),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    X is OX+ITS+TagX.


eccs_gm_spf_measure(hpsg_sort(Sort, SPF), Metrics, [X, Y]) :-
    eccs_gm_spf_measure(Sort, Metrics, [SortX, SortY]),
    eccs_gm_spf_measure(SPF, Metrics, [SPFX, SPFY]),
    eccs_sys_max(SortY, SPFY, Y),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    X is SortX+SPFX+ITS.
eccs_gm_spf_measure(prolog_list(H, T), Metrics, [X, Y]) :-
    eccs_gm_spf_measure_pllist(prolog_list(H, T), Metrics, [LX, Y]),
    eccs_gm_spf_measure(atomic([]), Metrics, [BX, _]),
    X is LX+BX.

eccs_gm_spf_measure_pllist([], _Metrics, [0, 0]) :-    
    !.
eccs_gm_spf_measure_pllist(prolog_list(H, T), Metrics, [X, Y]) :-
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_view_string_measure(atomic, ',', CX),
    eccs_gm_spf_measure(H, Metrics, [HX, HY]),
    (T = prolog_list(_, _) ->
    	eccs_gm_spf_measure_pllist(T, Metrics, [TX, TY]),
	X is BBS+CX+TX+HX,
	eccs_sys_max(TY, HY, Y)
      ; (T = [] ->
	    X = HX, Y = HY
	  ; eccs_gm_spf_measure(T, Metrics, [TX, TY]),	% improper list
	    eccs_view_string_measure(atomic, '|', SX),
	    X is TX+SX+HX, 
	    eccs_sys_max(TY, HY, Y))).


eccs_gm_paren_width(Y, PX) :-
    eccs_spf2gm_interline_space(ILS),
    Y =< ILS,
    !,				% Use regular parens,
    eccs_view_string_measure(atomic, '()', PX).
eccs_gm_paren_width(_Y, PX) :-
    eccs_extender_char(left, paren, LC),
    eccs_extender_char(right, paren, RC),
    eccs_view_string_measure(symbol, LC, LCX),
    eccs_view_string_measure(symbol, RC, RCX),
    PX is LCX + RCX.
    
eccs_gm_braces_size(Y, BX) :-
    eccs_spf2gm_interline_space(ILS),
    Y =< ILS, !,
    eccs_view_string_measure(atomic, '{', BX).
eccs_gm_braces_size(_Y, BX) :-
    eccs_special_char(top, left, set, TChar),
    eccs_view_string_measure(symbol, TChar, TBX),
    eccs_special_char(middle, left, set, MChar),
    eccs_view_string_measure(symbol, MChar, MBX),
    BX is TBX+MBX-4. 		% 4 is a guess for the width of the down stroke


eccs_spf_atomic_type(atomic(_)).
eccs_spf_atomic_type(italic(_)).
eccs_spf_atomic_type(symbol(_)).

eccs_gm_spf_measure_fv_pairs(avm(FVP), Metrics, [X, Y]) :-
    eccs_gm_spf_metrics(avm(FVP), Metrics, [X, Y]),
    eccs_gm_intree(avm(FVP), Metrics, _, Params),
    eccs_memberchk(mlw = MLW, Params),
    (eccs_sys_nonvar(MLW) -> 
          true
        ; eccs_gm_measure_atts(FVP, Metrics, MLW),
	  eccs_gm_spf_measure_fv_pairs1(FVP, MLW, Metrics, [X, Y])).

eccs_gm_measure_atts(FVP, Metrics, MLW) :-
    eccs_maxlabel_width(FVP, Metrics, MLW).

eccs_maxlabel_width([], _Metrics, 0).
eccs_maxlabel_width([F = _V|FVPs], Metrics, MLW) :-
    !,
    eccs_gm_intree(attribute(F), Metrics, There, Params),
    eccs_memberchk(x = X, Params),
    (There == true -> true;
      eccs_gm_measure_att(F, X, Params)),
    eccs_maxlabel_width(FVPs, Metrics, MLW1),
    eccs_sys_max(X, MLW1, MLW).
eccs_maxlabel_width([_O|FVPs], Metrics, N) :-
    eccs_maxlabel_width(FVPs, Metrics, N).

eccs_gm_measure_att(F, X, Params) :-
    (eccs_global_variable('upcase_labels?', true) ->
        eccs_upcase(F, PrintF);
	F = PrintF),
    eccs_view_string_measure(attribute, PrintF, X),
    eccs_memberchk(printform = PrintF, Params).

eccs_upcase(Atom, UpCaseAtom) :-
    eccs_sys_name(Atom, L),
    eccs_upcase1(L, LUp),
    eccs_sys_name(UpCaseAtom, LUp).

eccs_upcase1([], []).
eccs_upcase1([C|Cs], [UpC|Cs1]) :-
    eccs_lc(C), !,			% From pread_in.pl
    UpC is C + ("A" - "a"),
    eccs_upcase1(Cs, Cs1).
eccs_upcase1([C|Cs], [C|Cs1]) :-
    eccs_upcase1(Cs, Cs1).

eccs_gm_spf_measure_fv_pairs1([], _, _, [0, Y]) :-
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    Y = BBS.
eccs_gm_spf_measure_fv_pairs1([_F = V|FVPs], MLW, Metrics, [X, Y]) :-
    !,
    eccs_gm_spf_metrics(V, Metrics, [VX, VY]),
    eccs_spf2gm_get_param(space_between_a_and_v, SAV),
    eccs_spf2gm_get_param(between_fv_pairs_space, BFVPS), 
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    FVW is MLW + SAV + VX + 2 * BBS,
    eccs_gm_spf_measure_fv_pairs1(FVPs, MLW, Metrics, [RX, RY]),
    eccs_sys_max(FVW, RX, X), 
    Y is RY + VY + BFVPS.
eccs_gm_spf_measure_fv_pairs1([ O|FVPs], MLW, Metrics, [X, Y]) :-
    !,
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_spf2gm_get_param(between_fv_pairs_space, BFVPS),
    eccs_gm_spf_metrics(O, Metrics, [OX, OY]), 
    eccs_gm_spf_measure_fv_pairs1(FVPs, MLW, Metrics, [RX, RY]), 
    OX1 is 2 * BBS + OX,
    eccs_sys_max(OX1, RX, X), 
    Y is RY + OY + BFVPS.


eccs_gm_spf_measure_tag(Tag, _Metrics, [X, Y]) :-
    eccs_spf2gm_interline_space(Y),
    eccs_view_string_measure(tag, Tag, W),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    X is W + 2*ITS.


eccs_logic_char(disj, symbol, format('~c', 218), Width) :-
    eccs_view_string_measure(symbol, format('~c', 218), Width).
eccs_logic_char(conj, symbol, format('~c', 217), Width) :-
    eccs_view_string_measure(symbol, format('~c', 217), Width).
eccs_logic_char(neg, symbol, format('~c', 216), Width) :-
    eccs_view_string_measure(symbol, format('~c', 216), Width).
eccs_logic_char(impl, symbol, format('~c', 174), Width) :-
    eccs_view_string_measure(symbol, format('~c', 174), Width).
eccs_logic_char(bicond, symbol, format('~c', 171), Width) :-
    eccs_view_string_measure(symbol, format('~c', 171), Width).

eccs_do_logic_connective(Char, Font, Origin, Ref) :-
    eccs_set_font(Font),
    gm_view_string(Char, Origin, Ref).


/*

Thu Feb 25 16:27:02 1993 JC

An attempt to improve tree drawing.

We use the following strategy

If the width of the mother is less than that of the daughters, we draw
the mother so that is it centred over the midpoint of the middle
daughter (if #(daughters) is odd) or over the midpoint of the 2 middle
daughters (otherwise).  Here ``midpoint'' does not mean half of the X
direction, except in the case of non-tree daughters.  In the case of
tree daughters, the midpoint of a daughter is defined as the point at
which the mother will be drawn.  (Given recursively by the spec
above).

If the width of the mother is greater than that of the daughters, we
centre the midpoint of the daughters on half of the X dimension of the
mother.

eccs_gm_treetop(SPF, Metrics, TreeTop) 

TreeTop is the x offset from the left of the apex of the tree or the
bottom end of a branch, if SPF occurs as the daughter in a tree.

*/

eccs_gm_treetop(SPF, Metrics, TreeTop) :-
    eccs_next_printing_spf_term(SPF, Term),
    (Term = tree(M, Ds) ->
       eccs_length(Ds, N),
       eccs_gm_compute_tree_top(M, N, Ds, Metrics, TreeTop)
     ; eccs_gm_spf_measure(Term, Metrics, [X, _]),
       TreeTop is X/2).

eccs_next_printing_spf_term(sensitize(SPF, _), Term) :-
    !,
    eccs_next_printing_spf_term(SPF, Term).
eccs_next_printing_spf_term(Term, Term).


/*

eccs_gm_compute_tree_top(M, N, Ds, Metrics, TreeTop)

called in case width of M is greater than width of Ds. 

*/


    

eccs_gm_get_treetop(SPF, Metrics, TreeTop) :-
    eccs_next_printing_spf_term(SPF, Tree),
    (Tree = tree(_, _) -> 
	eccs_gm_intree(Tree, Metrics, _AlreadyDone, Params),
	eccs_memberchk(treetop = TreeTop, Params),
	(eccs_sys_var(TreeTop) -> eccs_gm_spf_measure(Tree, Metrics, _); true)
      ; eccs_gm_spf_measure(Tree, Metrics, [X, _]),
        TreeTop is X/2).
	

eccs_gm_compute_tree_top(M, N, Ds, Metrics, TreeTop) :-
    eccs_gm_spf_measure(M, Metrics, [MX, _]), 
    eccs_sum_x_extents(Ds, Metrics, SumDXs),
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    DsWidth is SumDXs+(N+1)*HTS,
    (MX >= DsWidth -> 
	TreeTop is MX/2
      ; Odd is N mod 2,
        eccs_gm_compute_tree_top1(Odd, N, Ds, Metrics, TreeTop)).

eccs_gm_compute_tree_top1(1, N, Ds, Metrics, TreeTop) :-
    Half is (N // 2) + 1,
    eccs_split_daus(Half, Ds, [MidD|RestDs]), 
    eccs_sum_x_extents(RestDs, Metrics, SumDXs),
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    BeforeX is Half*HTS+SumDXs,
    eccs_gm_treetop(MidD, Metrics, DTreeTop),
    TreeTop is BeforeX+DTreeTop.
eccs_gm_compute_tree_top1(0, N, Ds, Metrics, TreeTop) :-
    Half is (N // 2)+1,
    eccs_split_daus(Half, Ds, [MidDR, MidDL|RestDs]), 
    eccs_sum_x_extents(RestDs, Metrics, SumDXs),
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    BeforeX is (Half-1)*HTS+SumDXs,
    eccs_gm_treetop(MidDR, Metrics, DRX),
    eccs_gm_spf_measure(MidDL, Metrics, [LX, _]),
    eccs_gm_treetop(MidDL, Metrics, DLX),
    TreeTop is BeforeX+DLX + ((LX-DLX)+ HTS+DRX)/2.

      

    

eccs_split_daus(N, Ds, Out) :-
    eccs_split_daus(N, Ds, [], Out).
eccs_split_daus(0, _, Out, Out).
eccs_split_daus(N, [D|Ds], Rest, Out) :-
    eccs_succ(M, N),
    eccs_split_daus(M, Ds, [D|Rest], Out).

    
:- dynamic eccs_dummy_window_handle/2.

eccs_dummy_window(Window, Handle) :-
    eccs_dummy_window_handle(Window, Handle), !.
eccs_dummy_window(Window, Handle) :-
    gmcreate(Handle, view(0, 0)),
    gmcreate(Window, window(Handle)), 
    gm_font_table(atomic, Font),
    gmsend(Handle, setfont(Font)),
    assert(eccs_dummy_window_handle(Window, Handle)).

eccs_view_string_measure(Type, String, Width) :-
    eccs_set_font(Type),
    dc_current_window(_WN, gm_view_handle(_, H)),
    gmsend(H, stringlength(String, Width)).

gm_font_table(atomic , '-*-times-medium-r-*-*-*-180-*-*-*-*-*-*').
gm_font_table(italic , '-*-times-medium-i-*-*-*-180-*-*-*-*-*-*').
gm_font_table(variable , '-*-times-medium-r-*-*-*-180-*-*-*-*-*-*').
gm_font_table(attribute, '-*-times-medium-r-*-*-*-140-*-*-*-*-*-*') :-
    eccs_global_variable('upcase_labels?', true), !.
gm_font_table(attribute, '-*-times-medium-r-*-*-*-180-*-*-*-*-*-*').
gm_font_table(index , '-*-times-medium-r-*-*-*-75-*-*-*-*-*-*').
gm_font_table(tag , '-*-times-medium-r-*-*-*-75-*-*-*-*-*-*').
gm_font_table(sort , '-*-times-bold-r-*-*-*-180-*-*-*-*-*-*').
gm_font_table(symbol , '-*-symbol-*-r-*-*-*-180-*-*-*-*-*-*').

eccs_set_font(Type) :- 
    (eccs_verify(gm_font_table(Type, _)) -> true ;
       eccs_error([invalid, font, Type])), 
    gm_font_table(Type, Font),
    dc_current_window(_WN, gm_view_handle(_, V)),
    gmsend(V, setfont(Font)).
    
testall :-
    test(N),
    write(N), 
    write('more? return to stop'), ttyflush,
    eccs_read_line([_|_]),
    fail.
testall.

testallwidths :-
    write('checking widths'), nl,
    pleuk_testfs(N, C, X),
    eccs_concat_list([N, '-', C], Cap),
    eccs_gm_display_object(captioned(Cap, avm([feature = X]))),
    fail.
testallwidths.

test(N) :- 
    pleuk_testfs(N, C, X), 
    dc_clear_window,
    eccs_concat_list([N, '-', C], Cap),
    eccs_gm_display_object(captioned(Cap, X)).


eccs_gm_draw_object(_, [X, Y], Object, Metrics, OHandle) :-
    dc_current_window(W, _),
    eccs_gm_window_size(X, Y, RealX, RealY, _Scroll),
    dc_make_view('?',  X, Y, RealX, RealY, _WHandle),
    dc_make_current_window('?'),
    eccs_gm_origin(XO, _YO),
    eccs_gm_draw_object([XO, Y], Object, Metrics, OHandle),
    dc_make_current_window(W).

/*

eccs_gm_draw_object(Origin, Object, Metrics, OHandle)

draw object described by Object, at Origin in view Handle.  Metrics is
a binary tree given measurements of subparts. OHandle is a graphics
identifier for Object.

*/

eccs_gm_draw_object(Origin, Object, Metrics, OHandle) :- 
    dc_current_window(_, gm_view_handle(_, VHandle)),
    gmsend(VHandle, batchmode),
    eccs_gm_draw_object1(Origin, Object, Metrics, OHandle), 
    gmsend(VHandle, update).


eccs_gm_draw_object1(Origin, Object, Metrics, OHandle) :- 
    eccs_spf2gm(Object, Origin, Metrics, OHandle).

eccs_gm_origin(15, 15).


/*

eccs_gm_close_all_views

*/

eccs_gm_close_all_views :- 
    eccs_gm_view_record(Dims, Caption, Handle, Object), 
    Handle = gm_view_handle(W, _),
    gmsend(W, close), 
    eccs_sys_retractall(eccs_gm_view_record(Dims, Caption, Handle, Object)),
    fail.  
eccs_gm_close_all_views.


/*

eccs_spf2gm(AVM, Origin, Metrics)

Compute and send to GM


*/


eccs_spf2gm(atomic(A), Origin, _BT, Ref) :-
    !,
    eccs_set_font(atomic),
    (A = [] -> 
    	eccs_view_string_measure(atomic, "[", BX),
	gm_view_string("[", Origin, RefLB),
	Origin = [XO, YO],
	eccs_spf2gm_get_param(inter_tag_space, ITS),
	RX is XO+ITS+BX,
	gm_view_string("]", [RX, YO], RefRB),
	gm_combine([RefLB, RefRB], Ref)
      ; gm_view_string(A, Origin, Ref)).
eccs_spf2gm(symbol(A), Origin, _BT, Ref) :-
    !,
    eccs_set_font(symbol),
    eccs_gm_decode_symbol(A, Print),
    gm_view_string(Print, Origin, Ref).
eccs_spf2gm(italic(A), Origin, _BT, Ref) :-
    !,
    eccs_set_font(italic),
    gm_view_string(A, Origin, Ref).
eccs_spf2gm(uninstantiated, [X, Y], _BT, Ref2) :-
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_view_string_measure(atomic, '[', BX),
    gm_view_string(format("~s", ["["]), [X, Y], Ref),
    RX is X+BX+BBS,
    gm_view_string(format("~s", ["]"]), [RX, Y], Ref1),
    gm_combine([Ref, Ref1], Ref2).
eccs_spf2gm(sequence(S), Origin, BT, Ref) :-
    eccs_gm_spf_metrics(sequence(S), BT, Extents),
    eccs_gm_angle_brackets(Origin, Extents, Width, Ref1),
    Origin = [X, Y],
    Extents = [_XMax, YMax],
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    NewX is X + Width + BBS,
    eccs_spf2gm_midpoint(Y, YMax, YMid),
    eccs_spf2gm_sequence(S, [NewX, Y], YMid, Extents, BT, Refs),
    gm_combine([Ref1|Refs], Ref).
eccs_spf2gm(set(S), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(set(S), BT, [XMax, YMax]),
    eccs_gm_braces_size(YMax, BX),
    eccs_gm_set_brackets(X, Y, XMax, YMax, Ref1),
    eccs_spf2gm_midpoint(Y, YMax, YMid),
    NewX is X + BX,
    eccs_spf2gm_set(S, [NewX, Y], YMid, [XMax, YMax], BT, Refs),
    gm_combine([Ref1|Refs], Ref).
eccs_spf2gm(sort(Sort), Origin, _BT, Ref) :-
    !,
    eccs_set_font(sort),
    gm_view_string(Sort, Origin, Ref).
eccs_spf2gm(avm([]), Origin, BT, Ref) :-
    !,
    eccs_spf2gm(uninstantiated, Origin, BT, Ref).
eccs_spf2gm(avm(Fvpairs), Origin, BT, Ref) :-
    eccs_gm_square_bs(avm(Fvpairs), Origin, BT, Ref1),
    eccs_get_max_label_width(avm(Fvpairs), BT, MLW),
    Origin = [X, Y],
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    NewX is X + BBS, NewY is Y + BBS,
    eccs_reverse(Fvpairs, FVsRev),
    eccs_spf2gm_fvpairs(FVsRev, MLW, [NewX, NewY], BT, Refs),
    gm_combine([Ref1|Refs], Ref).

eccs_get_max_label_width(avm(Fvpairs), BT, MLW) :-
    eccs_gm_intree(avm(Fvpairs), BT, _, Params),
    eccs_memberchk(mlw = MLW, Params).

eccs_spf2gm_fvpairs([], _MLW, _Origin, _BT, []).
eccs_spf2gm_fvpairs([F = V|Fvpairs], MLW, [X, Y], BT, [Ref|Refs]) :-
    !,
    eccs_gm_spf_metrics(V, BT, [_XMax, VY]),
    eccs_spf2gm_interline_space(ILS),
    eccs_spf2gm_get_param(space_between_a_and_v, SAV),
    eccs_sys_max(VY, ILS, FVY),
    eccs_spf2gm_midpoint(Y, FVY, YMid),
    AttY is YMid - ILS /2,
    eccs_view_do_attribute(F, BT, [X, AttY], Ref1),
    VX is X + MLW + SAV,
    eccs_view_do_value(V, [VX, Y], BT, Ref2),
    eccs_spf2gm_get_param(between_fv_pairs_space, BFVPS),
    NextY is Y + BFVPS + FVY,
    gm_combine([Ref1, Ref2], Ref),
    eccs_spf2gm_fvpairs(Fvpairs, MLW, [X, NextY], BT, Refs).
eccs_spf2gm_fvpairs([Object|Fvpairs], MLW, [X, Y], BT, [Ref|Refs]) :-
    eccs_spf2gm_get_param(between_fv_pairs_space, BFVPS),
    eccs_gm_spf_metrics(Object, BT, [_DX, DY]),
    eccs_view_do_value(Object, [X, Y], BT, Ref),
    NextY is Y + DY + BFVPS,
    eccs_spf2gm_fvpairs(Fvpairs, MLW, [X, NextY], BT, Refs).

eccs_view_do_attribute(F, BT, Posn, Ref) :-
    eccs_gm_intree(attribute(F), BT, _, Params),
    eccs_memberchk(printform = PrintF, Params),
    eccs_set_font(attribute),
    gm_view_string(PrintF, Posn, Ref).

eccs_view_do_value(V, Origin, BT, Ref) :-
    eccs_spf2gm(V, Origin, BT, Ref).


eccs_spf2gm_parenth([], _, _, _, _, []).
eccs_spf2gm_parenth([A|As], [X, Y], YMid, [XMax, YMax], BT, AllRefs) :-
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_spf2gm_interline_space(ILS),
    eccs_gm_spf_metrics(A, BT, [AX, AY]),
    NewY is YMid - AY/2,
    eccs_view_do_value(A, [X, NewY], BT, Ref1),
    (As = [] -> AllRefs = [Ref1];
     AllRefs = [Ref1, Ref2|Refs],
     eccs_view_string_measure(atomic, ',', CX),
     PSx is X + AX + BAVS,
     PSy is YMid - ILS/2,
     gm_view_string(',', [PSx, PSy], Ref2),
     NextX is X + 2*BAVS + CX + AX,
     eccs_spf2gm_parenth(As, [NextX, Y], YMid, [XMax, YMax], BT, Refs)).

eccs_spf2gm_sequence([], _O, _YMid, _Extents, _BT, []).
eccs_spf2gm_sequence([E|Es], [X, Y], YMid, Extent, BT, [Ref1, Ref2|Refs]) :-
    Extent = [_, SYMax],
    eccs_gm_spf_metrics(E, BT, [EXMax, EYMax]),
    LocalYO is Y + (SYMax - EYMax) /2,
    eccs_view_do_value(E, [X, LocalYO], BT, Ref1),
    (Es = [_|_] -> 
	(eccs_view_separator_width(sequence, SSW),
	 NewX is SSW + X + EXMax,
	 SSx is X + EXMax,
	 eccs_gm_do_separator(sequence, [SSx, YMid], Ref2),
	 eccs_spf2gm_sequence(Es, [NewX, Y], YMid, Extent, BT, Refs))
	; Refs = []).

eccs_spf2gm_set([], _, _, _, _, []).
eccs_spf2gm_set([E|Es], [X, Y], YMid, [XMax, YMax], BT, [Ref, Ref2|Refs]) :-
    eccs_gm_spf_metrics(E, BT, [EXMax, EYMax]),
    LocalYO is Y + (YMax - EYMax) /2,
    eccs_view_do_value(E, [X, LocalYO], BT, Ref),
    (Es = [_|_] -> 
	(eccs_view_separator_width(set, SSW),
	 NewX is SSW + X + EXMax,
	 SSx is X + EXMax,
	 eccs_gm_do_separator(set, [SSx, YMid], Ref2),
	 eccs_spf2gm_sequence(Es, [NewX, Y], YMid, [XMax, YMax], BT, Refs))
	 ; Refs = []).

	 
eccs_gm_do_separator(Type, [X, Y], Ref) :-
    (Type = sequence, Var = sequence_separator;
     Type = set, Var = set_separator), !,
    eccs_global_variable(Var, SS),
    eccs_spf2gm_interline_space(ILS),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    MidX is X + BAVS/2,
    MidY is Y - ILS/2,
    gm_view_string(SS, [MidX, MidY], Ref).

eccs_spf2gm(tagged_avm(Tag, Fvpairs), [X, Y], BT, Ref) :-
    !,
    eccs_gm_spf_metrics(tagged_avm(Tag, Fvpairs), BT, [_, EYMax]),    
    eccs_gm_spf_metrics(tag(Tag), BT, [TX, _TY]),
    eccs_spf2gm_midpoint(Y, EYMax, YMid),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    eccs_spf2gm_interline_space(ILS),
    TagY is YMid - ILS/2,
    eccs_spf2gm(tag(Tag), [X, TagY], BT, Ref1),
    (Fvpairs = avm(FVP) -> true; Fvpairs = FVP),
    AVMX is X + TX + ITS,
    eccs_spf2gm(avm(FVP), [AVMX, Y], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(tagged(Tag, Object), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(tagged(Tag, Object), BT, [_XMax, YMax]),
    eccs_gm_spf_metrics(tag(Tag), BT, [TX, _TY]),
    eccs_spf2gm_midpoint(Y, YMax, YMid),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    eccs_spf2gm_interline_space(ILS),
    TagY is YMid - ILS/2,
    ObjectX is X + TX +ITS,
    eccs_spf2gm(tag(Tag), [X, TagY], BT, Ref1),
    eccs_spf2gm(Object, [ObjectX, Y], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(tag(Tag), [XO, YO], BT, Ref) :-
    eccs_gm_spf_metrics(tag(Tag), BT, [XMax, YMax]),
    eccs_set_font(tag),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    TagX is XO+ITS,
    TagY is YO+ITS,
    gm_view_string(Tag, [TagX, TagY], Ref1),
    eccs_gm_box(XO, YO, XMax, YMax, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(disj(Ds), Origin, BT, Ref) :-
    eccs_gm_spf_metrics(disj(Ds), BT, [DX, DY]),
    eccs_spf2gm_logic(disj, Ds, Origin, BT, [DX, DY], Ref).
eccs_spf2gm(conj(Ds), Origin, BT, Ref) :-
    eccs_gm_spf_metrics(conj(Ds), BT, [DX, DY]),
    eccs_spf2gm_logic(conj, Ds, Origin, BT, [DX, DY], Ref).
eccs_spf2gm(neg(N), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(neg(N), BT, [_XMax, YMax]),
    eccs_spf2gm_midpoint(Y, YMax, YMid),
    eccs_spf2gm_interline_space(ILS),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_logic_char(neg, _Font, NChar, NCX),
    ValueX is X + NCX+ BAVS,
    StringY is YMid - ILS/2,
    gm_view_string(NChar, [X, StringY], Ref1),
    eccs_view_do_value(N, [ValueX, Y], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(impl(A, B), Origin, BT, Ref) :-
    eccs_gm_spf_metrics(impl(A, B), BT, [DX, DY]),
    eccs_spf2gm_logic(impl, [A, B], Origin, BT, [DX, DY], Ref).

eccs_spf2gm(bicond(A, B), Origin, BT, Ref) :-
    eccs_gm_spf_metrics(bicond(A, B), BT, [DX, DY]),
    eccs_spf2gm_logic(bicond, [A, B], Origin, BT, [DX, DY], Ref).

eccs_spf2gm(relation(R, Args), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(parenth(Args), BT, [_DX, DY]),
    eccs_spf2gm_interline_space(ILS),
    RY is  Y + (DY/2) - ILS/2,
    eccs_view_do_value(R, [X, RY], BT, Ref1),
    eccs_gm_spf_metrics(R, BT, [CX, _]),
    ParenX is X+CX,
    eccs_view_do_value(parenth(Args), [ParenX, Y], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(infix(Operator, Arg1, Arg2), [X, Y], BT, Ref) :-
    eccs_spf2gm_interline_space(ILS),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    eccs_gm_spf_metrics(infix(Operator, Arg1, Arg2), BT, [_DX, DY]),
    eccs_gm_spf_metrics(Operator, BT, [OpX, _OpY]),
    eccs_gm_spf_metrics(Arg1, BT, [AX, AY]),
    eccs_gm_spf_metrics(Arg2, BT, [_BX, BY]),
    A1Y is Y + (DY-AY)/2,
    eccs_view_do_value(Arg1, [X, A1Y], BT, Ref1),
    (Arg1 = atomic('') -> OpXo is X; OpXo is X +AX+ITS),
    OpYo is Y + DY/2 - ILS/2,
    eccs_view_do_value(Operator, [OpXo, OpYo], BT, Ref3),
    A2Y is  Y + (DY-BY)/2,
    eccs_view_do_value(Arg2, [OpXo+OpX+ITS, A2Y], BT, Ref2),
    gm_combine([Ref1, Ref2, Ref3], Ref).

/*

Thu Mar 18 10:32:12 1993 JC  Added space between op and args.

There is a little cheat in the above clause.  We don't check to see
whether the second arg is atomic('') (i.e. whether what we have is a
prefix.  We'll end up not drawing anything for arg2 in this case, and
so the fact that the x coordinate is too large is not a problem.

*/

eccs_spf2gm(prefix(Operator, Arg1), Origin, BT, Ref) :-
    eccs_spf2gm(infix(Operator, atomic(''), Arg1), Origin, BT, Ref).
eccs_spf2gm(postfix(Operator, Arg1), Origin, BT, Ref) :-
    eccs_spf2gm(infix(Operator, Arg1,  atomic('')), Origin, BT, Ref).
eccs_spf2gm(tree(Mother, Ds), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(tree(Mother, Ds), BT, [TX, TY]),
    eccs_gm_spf_metrics(Mother, BT, [MX, MY]),
    eccs_sum_x_extents(Ds, Metrics, DsX1),
    eccs_length(Ds, N),
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    DsX is (N + 1) * HTS + DsX1,
    eccs_max_y_extents(Ds, Metrics, DsY),
    eccs_spf2gm_get_param(vertical_tree_sep, VTS),
    TTY is Y + TY - MY,
    eccs_gm_get_treetop(tree(Mother, Ds), Metrics, TreeTopX), 
    Computed_TTX is X+TreeTopX,
    Computed_TTY is TTY - (0.2)*VTS,
    TreeTop = [Computed_TTX, Computed_TTY],
    (MX >=  DsX -> 
	MXO = X, DsXO is X+(TX-DsX)/2+HTS
      ; MXO = X+TreeTopX-(MX/2), DsXO is X+HTS),
    eccs_view_do_value(Mother, [MXO, TTY], BT, Ref1),
    DsYo is Y+DsY,
    eccs_do_ds(Ds, [DsXO, DsYo], BT, DsY, TTs, Refs),
    eccs_draw_branches(TTs, TreeTop, [DsXO, DsYo], BT, Ref2),
    gm_combine([Ref1, Ref2|Refs], Ref).
eccs_spf2gm(parenth([]), [X, Y], _, Ref) :-
    !,					% trap for cases with no args
    eccs_gm_paren_width(Y, PX),
    eccs_spf2gm_interline_space(ILS),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    ParenXr is (X+PX+BAVS),
    ParenYt is Y+ILS,
    eccs_draw_parens(X, Y, ParenXr, ParenYt, Ref).
eccs_spf2gm(parenth(A), [X, Y], BT, Ref) :-
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_gm_spf_metrics(parenth(A), BT, [XMax, YMax]),
    eccs_gm_paren_width(YMax, PX),
    eccs_spf2gm_midpoint(Y, YMax, YMid),
    ParenXr is X+XMax,
    ParenYt is Y+YMax,
    eccs_draw_parens(X, Y, ParenXr, ParenYt, Ref1),
    ParenInternalXo is X+PX/2+BBS,
    eccs_spf2gm_parenth(A, [ParenInternalXo, Y], YMid, [XMax, YMax], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(circle(A), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(circle(A), BT, [Dia, _]),
    Rad is Dia /2, 
    eccs_gm_spf_metrics(A, BT, [AX, AY]),
    CentreX is X + Rad,
    CentreY is Y + Rad,
    gm_view_circle(Ref1, CentreX, CentreY, Rad),
    AXo is X + Rad - AX/2,
    AYo is Y + Rad - AY/2,
    eccs_view_do_value(A, [AXo, AYo], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(triangle(A), [X, Y], BT, Ref) :-
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_gm_spf_metrics(A, BT, [AX, AY]),
    TriXr is X+2*(AX + BBS),
    TriYt is Y+2*(AY + BBS),
    eccs_spf2gm_triangle(X, Y, TriXr, TriYt, Ref1),
    AXo is X + BBS + AX/2,
    AYo is Y + BBS,
    eccs_view_do_value(A, [AXo, AYo], BT, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(stack(As), [X, Y], BT, Ref) :-
    eccs_reverse(As, RevAs),
    eccs_do_stack(RevAs, [X, Y], BT, Refs),
    gm_combine(Refs, Ref).

eccs_spf2gm(sensitize(Object, Action), [X, Y], BT, Ref) :-
    eccs_gm_spf_metrics(Object, BT, [OX, OY]),
    Xr is X+OX,
    Yt is Y+OY,
    dc_record_sensitive(X, Y, Xr, Yt, Action),
    eccs_spf2gm(Object, [X, Y], BT, Ref).

/*

Tue Feb 16 16:24:41 1993

additions by JC

*/

eccs_spf2gm(hbox(Es), Ori, BT, Ref) :-
    eccs_spf2gm(hbox(bottom, Es), Ori, BT, Ref).
eccs_spf2gm(hbox(Posn, Es), Ori, BT, Ref) :-
    (eccs_memberchk(Posn, [top, bottom, center]) ->
    	Posn = Position; Position = left),
    eccs_gm_spf_metrics(hbox(Posn, Es), BT, [_, MaxY]),
    eccs_spf2gm_get_param(space_between_stack_elements, OffX),
    Ori = [XO, YO],
    BoxXo is XO-OffX,
    eccs_spf2gm_hbox(Position, Es, [BoxXo, YO], MaxY, BT, Refs),
    gm_combine(Refs, Ref).
eccs_spf2gm(vbox(Args), Ori, BT, Ref) :-
    eccs_spf2gm(vbox(left, Args), Ori, BT, Ref).
eccs_spf2gm(vbox(Posn, Args), Ori, BT, Ref) :-
    (eccs_memberchk(Posn, [left, right, center]) ->
	Posn = Position
      ; Position = left),
    eccs_gm_spf_metrics(vbox(Position, Args), BT, [MaxX, _]),
    eccs_spf2gm_get_param(space_between_stack_elements, Space),
    Ori = [XO, YO],
    eccs_reverse(Args, Args1),
    BoxYo is YO-Space,
    eccs_spf2gm_vbox(Position, Args1, [XO, BoxYo], MaxX, BT, Refs),
    gm_combine(Refs, Ref).
eccs_spf2gm(space(_, _), Ori, BT, Ref) :-
    eccs_spf2gm(atomic(''), Ori, BT, Ref).
eccs_spf2gm(box(SPF), [XO, YO], BT, Ref) :-
    eccs_spf2gm_get_param(space_between_stack_elements, Space),
    eccs_gm_spf_metrics(box(SPF), BT, [BX, BY]),
    Border is Space/2,
    ObjectXo is XO+Border,
    ObjectYo is YO+Border,
    eccs_spf2gm(SPF, [ObjectXo, ObjectYo], BT, Ref1),
    eccs_gm_box(XO, YO, BX, BY, Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_spf2gm(over(Top, Bottom), [XO, YO], BT, Ref) :-
    eccs_gm_spf_metrics(over(Top, Bottom), BT, [MaxX, MaxY]),
    eccs_gm_spf_metrics(Top, BT, [TX, TY]),
    eccs_gm_spf_metrics(Bottom, BT, [BX, BY]),
    eccs_spf2gm_get_param(space_between_stack_elements, Space),
    TopXo is XO+(MaxX-TX)/2,
    TopYo is YO+(MaxY-TY),
    eccs_view_do_value(Top, [TopXo, TopYo], BT, TRef),
    BottomXo is XO+(MaxX-BX)/2,
    eccs_view_do_value(Bottom, [BottomXo, YO], BT, BRef),
    MidLine is YO+BY+Space/2,
    LineXr is XO+MaxX,
    gm_view_line(LRef, XO, MidLine, LineXr, MidLine),
    gm_combine([LRef, TRef, BRef], Ref).
eccs_spf2gm(over(Top, Bottom, Tag), [XO, YO], BT, Ref) :-
    eccs_view_do_value(over(Top, Bottom), [XO, YO], BT, ORef),
    eccs_gm_spf_metrics(over(Top, Bottom, Tag), BT, [MaxX, _]),
    eccs_gm_spf_metrics(Bottom, BT, [_, BY]),
    eccs_gm_spf_metrics(Tag, BT, [TagX, TagY]),
    eccs_spf2gm_get_param(space_between_stack_elements, Space),
    MidLine is YO+BY+Space/2,
    TagXo is XO+(MaxX-TagX),
    TagYo is MidLine-(TagY/2),
    eccs_view_do_value(Tag, [TagXo, TagYo], BT, TagRef),
    gm_combine([ORef, TagRef], Ref).
eccs_spf2gm(hpsg_sort(Sort, SPF), [XO, YO], BT, Ref) :-
    eccs_gm_spf_metrics(Sort, BT, [SX, _]),
    eccs_view_do_value(Sort, [XO, YO], BT, SRef),
    eccs_spf2gm_get_param(inter_tag_space, ITS),
    ObjectXo is XO+ITS+SX,
    eccs_view_do_value(SPF, [ObjectXo, YO], BT, SPFRef),
    gm_combine([SPFRef, SRef], Ref).
eccs_spf2gm(prolog_list(H, T), [XO, YO], BT, Ref) :-
    eccs_view_string_measure(atomic, "[", BX),
    gm_view_string('[', [XO, YO], RefLB),
    eccs_gm_spf_metrics(prolog_list(H, T), BT, [XMax, _]),
    PLXr is XO+XMax-BX,
    gm_view_string(']', [PLXr, YO], RefRB),
    ElementsXo is XO+BX,
    eccs_spf2gm_pllist(prolog_list(H, T), [ElementsXo, YO], BT, Refs),
    gm_combine([RefRB, RefLB|Refs], Ref).
eccs_spf2gm(concat(Es), [XO, YO], BT, Ref) :-
    eccs_spf2gm_concat(Es, [XO, YO], BT, Refs),
    gm_combine(Refs, Ref).


eccs_spf2gm_pllist([], _, _, []) :- !.
eccs_spf2gm_pllist(prolog_list(H, T), Ori, BT, Refs) :-
    Ori = [XO, YO],
    eccs_spf2gm_get_param(between_bracket_space, BBS),
    eccs_view_string_measure(atomic, ',', CX),
    eccs_gm_spf_metrics(H, BT, [HX, _]),
    eccs_view_do_value(H, Ori, BT, HRef),
    (T = [] -> 
	Refs = [HRef]
      ; (T = prolog_list(_, _) -> 
      	     CommaXo is XO+HX,
      	     gm_view_string(',', [CommaXo, YO], CRef),
	     NextElXo is CommaXo+CX+BBS,
	     eccs_spf2gm_pllist(T, [NextElXo, YO], BT, Refs1),
	     Refs = [HRef, CRef|Refs1]
	   ; eccs_view_string_measure(atomic, '|', SX),
	     PipeXo is XO+HX,
	     gm_view_string('|', [PipeXo, YO], CRef),
	     TailXo is PipeXo+SX,
	     eccs_view_do_value(T, [TailXo, YO], BT, TRef),
	     Refs = [HRef, CRef, TRef])).
	    
      	   
    

eccs_spf2gm_concat([], _, _, []).
eccs_spf2gm_concat([E|Es], [XO, YO], BT, [Ref|Refs]) :-
    eccs_view_do_value(E, [XO, YO], BT, Ref),
    eccs_gm_spf_metrics(E, BT, [EX, _]),
    NextXo is XO+EX,
    eccs_spf2gm_concat(Es, [NextXo, YO], BT, Refs).

eccs_spf2gm_vbox(_, [], _, _, _, []) :- !.
eccs_spf2gm_vbox(Position, [E|Es], [XO, YO], MaxX, BT, [Ref|Refs]) :-
    eccs_spf2gm_get_param(space_between_stack_elements, Space),
    eccs_gm_spf_metrics(E, BT, [EX, EY]),
    eccs_spf2gm_vbox_eposition(Position, XO, EX, MaxX, X),
    ThisYo is YO+Space,
    eccs_view_do_value(E, [X, ThisYo], BT, Ref),
    NextYo is ThisYo+EY,
    eccs_spf2gm_vbox(Position, Es, [XO, NextYo], MaxX, BT, Refs).


eccs_spf2gm_vbox_eposition(left, X, _, _, X).
eccs_spf2gm_vbox_eposition(right, XO, EX, MaxX, X) :-
    X is XO+(MaxX-EX).
eccs_spf2gm_vbox_eposition(center, XO, EX, MaxX, X) :-
    X is XO + (MaxX-EX)/2.

/*


eccs_spf2gm_hbox(Position, Es, Ori, MaxY, BT, Ref).

Position is one of top, bottom, center

Es are the elements in the box

Ori is the origin of the box
Rims its overall dimensions

*/

eccs_spf2gm_hbox(_, [], _, _, _, []) :- !.
eccs_spf2gm_hbox(Position, [E|Es], [XO, YO], MaxY, BT, [Ref|Refs]) :-
    eccs_spf2gm_get_param(space_between_stack_elements, OffX),
    eccs_gm_spf_metrics(E, BT, [EX, EY]),
    eccs_spf2gm_hbox_eposition(Position, YO, EY, MaxY, Y), 
    ThisXo is XO+OffX,
    eccs_view_do_value(E, [ThisXo, Y], BT, Ref),
    NextXo is ThisXo+EX,
    eccs_spf2gm_hbox(Position, Es, [NextXo, YO], MaxY, BT, Refs).

eccs_spf2gm_hbox_eposition(top, YO, EY, MaxY, Y) :-
    Y is YO+(MaxY-EY).
eccs_spf2gm_hbox_eposition(bottom, YO, _, _, YO).
eccs_spf2gm_hbox_eposition(center, YO, EY, MaxY, Y) :-
    Y is YO +(MaxY-EY)/2.

eccs_draw_parens(X, Y, XMax, YMax, Ref) :-
    eccs_spf2gm_interline_space(ILS),
    YMax - Y > ILS, !,
    eccs_set_font(symbol),
    eccs_build_parens(X, Y, XMax, YMax, Ref).
eccs_draw_parens(X, Y, XMax, _YMax, Ref) :-
    eccs_set_font(atomic),
    eccs_view_string_measure(atomic, ')', CX),
    gm_view_string('(', [X, Y], Ref1),
    ParensXr is XMax - CX,
    gm_view_string(')', [ParensXr, Y], Ref2),
    gm_combine([Ref1, Ref2], Ref).


eccs_build_parens(X, Y, XMax, YMax, Ref) :-
    eccs_spf2gm_interline_space(ILS),
    TopY is YMax - ILS,
    eccs_do_parens_corners(X, Y, XMax, TopY, Ylower, Yupper, ILS, Refs),
    eccs_build_paren(left, X, Ylower, Yupper, ILS, Ref1),
    eccs_build_paren(right, XMax, Ylower, Yupper, ILS, Ref2),
    gm_combine([Refs, Ref1, Ref2], Ref).

eccs_do_parens_corners(X, Y, XMax, YMax, Ylower, Yupper, ILS, Ref) :-
    eccs_special_char(top, left, paren, TLC),
    eccs_special_char(top, right, paren, TRC),
    eccs_special_char(bottom, left, paren, BLC),
    eccs_special_char(bottom, right, paren, BRC),
    gm_view_string(BLC, [X, Y], Ref1),
    gm_view_string(TLC, [X, YMax], Ref2),
    gm_view_string(BRC, [XMax, Y], Ref3),
    gm_view_string(TRC, [XMax, YMax], Ref4),
    Ylower is Y + (38/48)*ILS,
    Yupper is YMax - ILS,
    gm_combine([Ref1, Ref2, Ref3, Ref4], Ref).

eccs_build_paren(_LR, _X, Lower, Upper, _ILS, []) :-
    Lower > Upper, !.

eccs_build_paren(LR, X, Lower, Upper, ILS, [Ref|Refs]) :-
    Lower =< Upper,
    eccs_extender_char(LR, paren, Char),
    gm_view_string(Char, [X, Lower], Ref),
    NewLow is Lower + 0.5 * ILS,
    eccs_build_paren(LR, X, NewLow, Upper, ILS, Refs).

/*

The following data derived by inspection of Adobe's 
Symbol font and all figures are proportions of point size

-- Parentheses (used in parenth and relation)

Taking the bottom left character as the model, the corner characters
for parentheses descend by 10/48, the curve starts 18/48 above the
base line and the character's height above the baseline is 38/48.

The data for the extender is the same, but the curve is of course
irrelevant.

-- Braces (used for set)

%%%%% Braces
%
% Octal encoding
%
% /bracelefttp	\354
% /braceleftmid	\355
% /braceleftbt	\356
% 
% /bracerighttp   \374
% /bracerightmid  \375
% /bracerightbt   \376

% /braceex   \357
%

The descender is 10/48 for all characters.  The point on the bracket
middle char is 15/48 above the baseline. The curve starts at the
baseline for the bottom chars and at 28/48 above the baseline for the
top chars.  Overall height is 1.

*/


eccs_extender_char(left, paren, format('~c', [231])).
eccs_extender_char(right, paren, format('~c', [247])).

eccs_extender_char(_, set, format('~c', [239])).

eccs_special_char(top, left, paren, format('~c', [230])).
eccs_special_char(bottom, left, paren, format('~c', [232])).

eccs_special_char(top, right, paren, format('~c', [246])).
eccs_special_char(bottom, right, paren, format('~c', [248])).

eccs_special_char(top, left, set, format('~c', [236])).
eccs_special_char(middle, left, set, format('~c', [237])).
eccs_special_char(bottom, left, set, format('~c', [238])).


eccs_special_char(top, right, set, format('~c', [252])).
eccs_special_char(middle, right, set, format('~c', [253])).
eccs_special_char(bottom, right, set, format('~c', [254])).


eccs_do_stack([], _, _, []).
eccs_do_stack([A|As], [X, Y], BT, [Ref|Refs]) :-
    eccs_spf2gm_get_param(space_between_stack_elements, OffY),
    eccs_gm_spf_metrics(A, BT, [_, AY]),
    eccs_view_do_value(A, [X, Y], BT, Ref),
    NextYo is Y + AY + OffY,
    eccs_do_stack(As, [X, NextYo], BT, Refs).


eccs_spf2gm_logic(Type, Ds, Origin, BT, [DX, DY], Ref) :-
    eccs_logic_char(Type, Font, Char, Width),
    eccs_spf2gm_logic1(Ds, Origin, Char, Font, Width, BT, [DX, DY], Refs),
    gm_combine(Refs, Ref).

eccs_spf2gm_logic1([], _Origin, _Char, _Font,  _Width, _BT, [_DX, _DY], []).
eccs_spf2gm_logic1([D|Ds], [X, Y], Char, Font,  Width, BT, [DX, DY], [Ref1, Ref2|Refs]) :-
    eccs_gm_spf_metrics(D, BT, [ThisX, ThisY]),
    LocalY is Y + (DY - ThisY)/2,
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    eccs_spf2gm_interline_space(ILS),
    eccs_view_do_value(D, [X, LocalY], BT, Ref1),
    (Ds = [] -> 
	Refs = []
      ; ConnectXo is X + ThisX + BAVS,
        ConnectYo is Y + (DY-ILS)/2,
        eccs_do_logic_connective(Char, Font,  [ConnectXo, ConnectYo], Ref2)),
     NewX is X + ThisX + Width + 2*BAVS,
     eccs_spf2gm_logic1(Ds, [NewX, Y], Char, Font,  Width, BT, [DX, DY], Refs).

/*

Y in this case is the Y origin plus the height of the heighest
daughter.

*/

eccs_do_ds([], _, _, _, [], []).
eccs_do_ds([D|Ds], [X, Y], BT, MaxY, [[ThisTreeTopX, Y]|TTs], [Ref|Refs]) :-
    eccs_gm_spf_metrics(D, BT, [DX, DY]),
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    TTY is Y - DY,
    eccs_view_do_value(D, [X, TTY], BT, Ref),
    eccs_gm_treetop(D, BT, TTX),
    ThisTreeTopX is X+TTX,
    DsXo is X + HTS + DX,
    eccs_do_ds(Ds, [DsXo, Y], BT, MaxY, TTs, Refs).

eccs_draw_branches(Bottoms, Top, _, _, Refs) :-
    eccs_draw_branches1(Bottoms, Top, Refs).
    
eccs_draw_branches1([], _, []).
eccs_draw_branches1([[BX, BY]|Bs], [TX, TY], [Ref|Rs]) :-
    eccs_spf2gm_get_param(vertical_tree_sep, VTS),
    ThisLowerY is BY+(0.2*VTS),
    gm_view_line(Ref, BX, ThisLowerY, TX, TY),
    eccs_draw_branches1(Bs, [TX, TY], Rs).

/*

eccs_draw_branches([], [], _, _, _, []).
eccs_draw_branches([D|Ds], TreeTop, [X, Y], BT, [Ref|Refs]) :-
    TreeTop = [TTX, TTY],
    eccs_gm_spf_metrics(D, BT, [DX, _]),
    eccs_gm_treetop(D, BT, DTreeTop),
    eccs_spf2gm_get_param(horiz_tree_sep, HTS),
    eccs_spf2gm_get_param(vertical_tree_sep, VTS),
    gm_view_line(Ref, X+DTreeTop, Y + (0.2*VTS), TTX, TTY),
    eccs_draw_branches(Ds, TreeTop, [X+HTS+DX, Y], BT, Refs).
    
*/

eccs_gm_square_bs(Object, [XO, YO], BT, Ref) :-
    eccs_gm_spf_metrics(Object, BT, [XMax, YMax]),
    eccs_spf2gm_get_param(flange_length, N),
    RSide is XO+XMax,
    TSide is YO+YMax,
    XLIn is XO + N,
    XRIn is RSide - N,
    gm_view_line(Ref1, XO, YO, XO, TSide),
    gm_view_line(Ref2, RSide, YO, RSide, TSide),
    gm_view_line(Ref3, XO, YO, XLIn, YO),
    gm_view_line(Ref4, XO, TSide, XLIn, TSide),
    gm_view_line(Ref5, RSide, YO, XRIn, YO),
    gm_view_line(Ref6, RSide, TSide, XRIn, TSide),
    gm_combine([Ref1, Ref2, Ref3, Ref4, Ref5, Ref6], Ref).

eccs_gm_angle_brackets(Origin, [XMax, YMax], Width, Ref) :-
    eccs_spf2gm_interline_space(ILS),
    eccs_sys_max(ILS, YMax, Real),
    eccs_gm_angle_bracket_offset([XMax, Real], Width),
    eccs_gm_angle_brackets1(Origin, [XMax, Real], Width, Ref).

eccs_gm_angle_brackets1([XO, YO], [XMax, YMax], Width, Ref) :-
    eccs_spf2gm_midpoint(YO, YMax, YMid),
    Top is YO+YMax,
    Right is XO+XMax,
    X1 is XO+Width,
    X2 is Right-Width,
    gm_view_line(Ref1, X1, YO, XO, YMid),
    gm_view_line(Ref2, XO, YMid, X1, Top),
    gm_view_line(Ref3, X2, YO, Right, YMid),
    gm_view_line(Ref4, Right, YMid, X2, Top),
    gm_combine([Ref1, Ref2, Ref3, Ref4], Ref).


eccs_gm_set_brackets(X, Y, XMax, YMax, Ref) :-
    eccs_spf2gm_interline_space(ILS), 
    YMax =< ILS,
    !,
    eccs_view_string_measure(atomic, '{', BX),
    gm_view_string('{', [X, Y], Ref1),
    LBX is X+XMax-BX,
    gm_view_string('}', [LBX, Y], Ref2),
    gm_combine([Ref1, Ref2], Ref).
eccs_gm_set_brackets(X, Y, XMax, YMax, Ref) :-
    eccs_spf2gm_interline_space(ILS), 
    eccs_special_char(top, left, set, TLC),
    eccs_special_char(middle, left, set, MLC),
    eccs_special_char(bottom, left, set, BLC),
    eccs_special_char(top, right, set, TRC),
    eccs_special_char(middle, right, set, MRC),
    eccs_special_char(bottom, right, set, BRC),
    eccs_set_font(symbol),
    gm_view_string(BLC, [X, Y], Ref1),
    TCY is Y+YMax-ILS,
    MCY is Y+(YMax-ILS)/2,
    Xr is X+XMax,
    gm_view_string(TLC, [X, TCY], Ref2),
    gm_view_string(MLC, [X, MCY], Ref3),
    gm_view_string(BRC, [Xr, Y], Ref4),
    gm_view_string(MRC, [Xr, MCY], Ref5),
    gm_view_string(TRC, [Xr, TCY], Ref6),
    Y1 is Y+ILS,
    YBelowMid is Y+(YMax/2)-(ILS+10/48),
    YAboveMid is Y+(YMax/2)+ILS-10/48,
    YBelowTop is Y+YMax-(ILS+20/48),
    eccs_braces_extenders(X, Y1, YBelowMid, Ref7),
    eccs_braces_extenders(X, YAboveMid, YBelowTop, Ref8),
    eccs_braces_extenders(Xr, Y1, YBelowMid, Ref9),
    eccs_braces_extenders(Xr, YAboveMid, YBelowTop, Ref10),
    gm_combine([Ref1, Ref2, Ref3, Ref4, Ref5, Ref6, Ref7, Ref8, Ref9, Ref10], Ref).

eccs_braces_extenders(_X, YLower, YUpper, []) :-
    YLower + 10 > YUpper, !.
eccs_braces_extenders(X, YLower, YUpper, [Ref|Refs]) :-
    eccs_extender_char(_, set, Char),
    gm_view_string(Char, [X, YLower], Ref),
    eccs_braces_extenders(X, YLower+10, YUpper, Refs).


/*

Some generic routines

*/

gm_view_circle(Ref, X, Y, Rad) :-
    V is X,
    W is Y,
    R is Rad,
    dc_current_window(_WN, gm_view_handle(_, Handle)),
    gmsend(Handle, circle(Ref, V, W, R)).

gm_view_line(Ref, XO, YO, XMax, YMax) :-
    V is XO,
    W is YO,
    Z is XMax,
    U is YMax,
    dc_current_window(_WN, gm_view_handle(_, Handle)),
    gmsend(Handle, line(Ref, V, W, Z, U)).

eccs_spf2gm_midpoint(Origin, Extent, Mid) :-
    Mid is Origin + Extent/2.

eccs_gm_decode_symbol(Atom, format('~c', [N])) :-
    eccs_spf_symbol_encoding(Atom, N).

gm_combine(Refs, Ref) :-
    eccs_append_all(Refs, L),
    dc_current_window(_WN, gm_view_handle(_, V)),
    gmsend(V, picture(Ref, L)).

gm_view_string(Text, [X, Y], Ref) :-
    dc_current_window(_WN, gm_view_handle(_, V)),
    EX is X,
    EY is Y,
    gmsend(V, string(Ref, EX, EY, Text)).

eccs_gm_box(X, Y, XMax, YMax, Ref) :-
    Top is Y + YMax,
    Right is X + XMax,
    gm_view_line(Ref1, X, Y, Right, Y),
    gm_view_line(Ref2, Right, Y, Right, Top),
    gm_view_line(Ref3, Right, Top, X, Top),
    gm_view_line(Ref4, X, Top, X, Y),
    gm_combine([Ref1, Ref2, Ref3, Ref4], Ref).

eccs_spf2gm_triangle(X, Y, MaxX, MaxY, Ref) :-
    XMid is X + (MaxX   - X)/2,
    gm_view_line(Ref1, X, Y, XMid, MaxY),
    gm_view_line(Ref2, XMid, MaxY, MaxX, Y),
    gm_view_line(Ref3, X, Y, MaxX, Y),
    gm_combine([Ref1, Ref2, Ref3], Ref).

eccs_max_y_extents(List, BT, YMax) :-
    eccs_gm_spf_metrics_list(List, BT, Dims),
    eccs_max_y_extents1(Dims, YMax).

eccs_gm_spf_metrics_list([], _BT, []).
eccs_gm_spf_metrics_list([F|R], BT, [Dims|Ds]) :-
    eccs_gm_spf_metrics(F, BT, Dims),
    eccs_gm_spf_metrics_list(R, BT, Ds).

eccs_max_y_extents1([], 0).
eccs_max_y_extents1([[_X, Y]|Ds], YMax) :-
    eccs_max_y_extents1(Ds, SoFar),
    eccs_sys_max(Y, SoFar, YMax).

eccs_sum_y_extents(L, BT, SumX) :-
    eccs_gm_spf_metrics_list(L, BT, Dims),
    eccs_sum_y_extents1(Dims, SumX).

eccs_sum_y_extents1([], 0).
eccs_sum_y_extents1([[_X, Y]|Ds], Sum) :-
    eccs_sum_y_extents1(Ds, DsSum),
    Sum is DsSum + Y.



eccs_sum_x_extents(L, BT, SumX) :-
    eccs_gm_spf_metrics_list(L, BT, Dims),
    eccs_sum_x_extents1(Dims, SumX).

eccs_sum_x_extents1([], 0).
eccs_sum_x_extents1([[X, _Y]|Ds], Sum) :-
    eccs_sum_x_extents1(Ds, DsSum),
    Sum is DsSum + X.
    

eccs_max_x_extents(List, BT, YMax) :-
    eccs_gm_spf_metrics_list(List, BT, Dims),
    eccs_max_x_extents1(Dims, YMax).

eccs_max_x_extents1([], 0).
eccs_max_x_extents1([[X, _]|R], N) :-
    eccs_max_x_extents1(R, SoFar),
    eccs_sys_max(X, SoFar, N).

/*

The postscript version of the drawing algorithm assumes that
dimensions are given in points.  To work in pixels, we take all of the
parameters for the algorithm, compute out the vcalue in pixels and
cache the results in a table.  This part should, I guess, be sensitive
to screen resolution.

*/

eccs_spf2gm_param_list([
    view_point_size,
    between_bracket_space,
    between_fv_pairs_space,
    between_avm_space,
    space_between_a_and_v,
    space_between_stack_elements,
    horiz_tree_sep,
    vertical_tree_sep,
    inter_tag_space,
    flange_length]).

:- dynamic eccs_pixel_params/1.

eccs_spf2gm_params(Ps) :-
    eccs_pixel_params(Ps), !.
eccs_spf2gm_params(Ps) :-
    eccs_compute_pixel_params(Ps), 
    eccs_sys_assert(eccs_pixel_params(Ps)).

eccs_compute_pixel_params(Ps) :-
    eccs_spf2gm_param_list(L),
    eccs_compute_pixel_params1(L, Ps).

eccs_compute_pixel_params1([], []).
eccs_compute_pixel_params1([VarName|Vs], [VarName = Pxls|Ps]) :-
    eccs_global_variable(VarName, Value),
    eccs_sys_number(Value),
    eccs_points2pixels(Value, Pxls1),
    Pxls is round(ceiling(Pxls1)),
    eccs_compute_pixel_params1(Vs, Ps).

eccs_spf2gm_get_param(P, V) :-
    eccs_spf2gm_params(Ps),
    eccs_memberchk(P = V, Ps).

eccs_points2pixels(Value, Pxs) :-
    Pxs is (Value / 72) *100.


/*

Thu Oct 15 11:56:41 1992 JC

The variables taken from ../PS/epsdrawavm.ps are now in
penvironment.pl, and called graphics variables.

*/

eccs_view_tag_point_size(PS) :-
    eccs_spf2gm_get_param(view_point_size, VPS),
    PS is VPS/2.

/*

The width of the separator for sequences, sets, including .5 of
between_avm_space on either side.

*/

eccs_view_separator_width(Type, W) :-
    (Type = sequence, Var = sequence_separator;
     Type = set, Var = set_separator), !,
    eccs_global_variable(Var, Char),
    eccs_view_string_measure(atomic, Char, Width),
    eccs_spf2gm_get_param(between_avm_space, BAVS),
    W is Width + BAVS.
    

eccs_gm_angle_bracket_offset([_, Height], Off) :- 	
    eccs_global_variable(view_point_size, PS),
    Off1 is Height / 35,
    PS1 is  PS / 2,
    eccs_sys_max(Off1, PS1, OffPs),
    eccs_points2pixels(OffPs, Off).


eccs_spf2gm_interline_space(ILS) :-
    eccs_spf2gm_get_param(view_point_size, ILS).
