/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:33:52 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/penvironment.pl,v $',
	'$State: Exp $').

$Log: penvironment.pl,v $
% Revision 1.0  1993/04/26  16:33:52  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:41  pleuk
% *** empty log message ***
%
% Revision 0.4  1991/07/15  09:53:25  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.3  1991/05/21  14:07:18  kwh
% calls to 'new_variable' modified to include variable class.
%
% Revision 0.2  1991/03/06  21:44:18  pleuk
% Changes for X support
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/





/* Private Variables - not accessible to the user */

:- eccs_new_variable(eccs_system_state, install, private, run, 
	"Current state of system, i.e. install, configure, or compile.").

:- eccs_new_variable(eccs_batch_mode, false, private, run,
	"Are we just compiling and exiting?").

/* set but not used by anything in /Code */
:- eccs_new_variable(eccs_working_directory, '', private, start_up, 
	"The directory in which pleuk was invoked").

/* following three variables are immediately reset if output windows are in use */
:- eccs_new_variable(eccs_output_file_handle, 'PleukOutput', private, run, 
	"Temporary file to be used for output").

:- eccs_new_variable(eccs_file_window_handle, 'PleukFiles', private, run,
	"The handle to be used for file information").

:- eccs_new_variable(eccs_window_system, none, private, run,
	"The name of the window system available, if any.").

:- eccs_new_variable(eccs_unix_standard_env, cshrc, private, run, 
	"file that sets up a standard unix environment for invoking programs").

:- eccs_new_variable(eccs_safe_prefix, pleuk_, private, install,
	"Prefix to be used for the assertion of database entries.").

:- eccs_new_variable(eccs_safe_key, '$pleuk_$', private, install,
	"Prefix to be used for the assertion of intermediate results.").

:- eccs_new_variable(eccs_line_terminator, 10, private, install, 
	"end of line character code").

/*

Sun Mar 14 17:07:20 1993 JC

See pfiles for the consequence of the following variable. 

*/

:- eccs_new_variable(eccs_spec_names_untrustworthy, false, private, install,
	"If true, the specialization may not provide a name for an object immediately.").


/*

Thu Oct 15 14:14:10 1992 JC

:- eccs_new_variable(eccs_new_line_abbreviation, '$nl$', private, install, 
	"Abbreviation standing for new line in lists of items to be printed").

*/

:- eccs_new_variable(eccs_start_up_hook, eccs_runtime_welcome, private, run,
	"the procedure to call on invoking Pleuk").

:- eccs_new_variable(eccs_last_sentence, [], private, run,
	"Last sentence analyzed").

:- eccs_new_variable(eccs_last_sentence_list, [], private, run,
	"List of sentences entered by the user in the current session").

:- eccs_new_variable(eccs_last_output, "", private, run, 
	"the last structure to be displayed on an output stream").




/* System Variables */

:- eccs_new_variable(grammar_name, test, system, run, 
	"Name of the current grammar").

:- eccs_new_variable(grammar_directory, '', system, run, 
	"Name of the current grammar").

:- eccs_new_variable(customization_file, '.pleuk', system, run,
        "A file that sets Pleuk variables; may reside in the current directory or the user's home directory").

:- eccs_new_variable(editor, emacs, system, run, 
	"Name of an editor").

:- eccs_new_variable(use_windows, true, system, run,
	"Whether or not to use available windowing facilities.").

:- eccs_new_variable(read_compiled_versions, true, system, run, 
	"If true, read compiled definitions from disk").

/*

Mon Aug 10 10:53:16 1992 JC

Altered the default value of save_compiled_versions_to_file 
to false. 

*/
:- eccs_new_variable(save_compiled_versions_to_file, false, system, run, 
	"If true, save compiled definitions to disk").

:- eccs_new_variable(test_sentence_list, [], parsing, run,
	"List of test sentences provided by the user in .pleuk startup file").

:- eccs_new_variable(add_prolog_options_to_menu, false, system, run, 
	"Prolog operations (trace, break, etc). are added to menus").

:- eccs_new_variable(show_only_runtime_variables, true, system, run,
	"Only show the value of variables that may be changed at run time").

:- eccs_new_variable(show_only_user_variables, true, system, run,
	"Only show the value of variables that may be changed by the user").

/*

Mon Jan 25 15:02:58 1993 JC

Added the following.  See pmenudefs for details.

*/

:- eccs_new_variable(reload_after_deleting_all_defs, true, system, run,
	"If true, the user will be asked whether to reload the grammar after deleting all definitions").

/*

Thu Oct 15 14:11:59 1992 JC  The following removed, as the 
associated routines (eccs_debug/2) are not used


:- eccs_new_variable(debugging_level, 1, system, run, 
	"Amount of debugging information to be presented").

*/

/* Variables controlling printing behaviour */

:- eccs_new_variable(default_printing_routine, eccs_default_printing_routine, printing, run,
	"The routine that is called if no print routine is specified for an object").

:- eccs_new_variable(default_printing_args, [], printing, run,
	"Arguments to pass to print routines").

:- eccs_new_variable(check_output_syntax, false, printing, run,
	"pass terms through syntax checker before printing").

:- eccs_new_variable(parse_printer, eccs_default_printing_routine, printing, run, 
	"the routine to use to print analyses").

/*

Mon Feb  8 16:18:26 1993 JC

Added the following variable.

The default is false, so that behaviour is not changed too much. 

*/


:- eccs_new_variable('group objects by name', false, printing, run,
	"If true, group objects of the same type and name into single displays").



/* Variables controlling parsing behaviour */

:- eccs_new_variable(number_of_sentences_to_retain, 10, parsing, run,
	"Number of previous sentences to display under the Reparse Option").


/*

Wed Sep 30 10:15:38 1992 JC

Specialization-dependent variables

*/

:- eccs_new_variable(eccs_spec_supports_dc, false, system, run,
	"whether the specialization has appropriate hooks for the derivation checker").



/*

Graphics variables, used to be in ../PS/epsdrawavm.ps

*/

:- eccs_new_variable(view_point_size, 12, 
	graphics, run,
	"the point size to be used for text in the derivation checker").
:- eccs_new_variable(between_bracket_space, 3,
    graphics, run,
    "the distance between brackets in the derivation checker").

:- eccs_new_variable(between_fv_pairs_space, 3,
    graphics, run,
    "the distance between each attribute-value pair in the derivation checker").

:- eccs_new_variable(between_avm_space, 3,
    graphics, run,
    "the distance between adjacent attribute-value matrices in the derivation checker").

:- eccs_new_variable(space_between_a_and_v, 5,
    graphics, run,
    "the distance between an attribute and its value in the derivation checker").

:- eccs_new_variable(sequence_separator, ',', 
    graphics, run,
    "the character to use as the separator between elements of a sequence in the derivation checker").

:- eccs_new_variable(set_separator, ',',
        graphics, run,
    "the character to use as the separator between elements of a set in the derivation checker").


:- eccs_new_variable(space_between_stack_elements, 10,
	graphics, run,
	"the vertical distance between stacked elements").


:- eccs_new_variable(horiz_tree_sep, 5,
	graphics, run,
	"the separation between sisters in a tree").
:- eccs_new_variable(vertical_tree_sep, 20,
	graphics, run,
	"the separation between mother and daughters in a tree").

:- eccs_new_variable(inter_tag_space, 3,
	graphics, run,
	"the space between a tag and the following avm").

:- eccs_new_variable(flange_length, 3,
	graphics, run,
	"the length of the flanges in squanre brackets").

:- eccs_new_variable('upcase_labels?', true, 
	graphics, run,
	"whether or not to map attribute names to upper case").

:- eccs_new_variable(paper_size, 'A4', 
	graphics, run,
	"target paper size for printed output").

:- eccs_new_variable(orientation, portrait, 
	graphics, run,
	"orientation for printed output").
