/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:33:25 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pdump.pl,v $',
	'$State: Exp $').

$Log: pdump.pl,v $
% Revision 1.0  1993/04/26  16:33:25  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:41  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:27:10  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:23:32  kwh
% access to file attributes modified.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pdump.pl
Date:	Tue May 15 16:58:54 1990
By:	Jonathan Calder

Selectively write the contents of a database out to a file.

*/

eccs_compiled_file_suffix(',c').

/*

eccs_compiled_version_of_file(FName, CFName) 

true if CFName is the compiled version of FName and is newer.

*/

eccs_compiled_version_up_to_date(FName, CFName) :-
    eccs_compiled_file_name(FName, CFName),
    eccs_file_exists(CFName),
    eccs_newer_file(CFName, FName).

eccs_compiled_file_name(FName, CFName) :-
    eccs_compiled_file_suffix(X),
    eccs_concat(FName, X, CFName).

eccs_maybe_restore_compiled_version(File, Type) :-
    eccs_global_variable(read_compiled_versions, true), 
    eccs_compiled_version_up_to_date(File, CFile),
    eccs_expunge_file(File),
    eccs_call_and_report_stats(
	eccs_restore_compiled_file(File, CFile, Type),
	['Compiled', version, of, File, 'loaded:']),
    eccs_set_file_attributes(File, [state=loaded, compiled=compiled]), !.


eccs_restore_compiled_file(File, CompiledFile, Type) :-
    eccs_sys_seeing(Old),
    eccs_sys_see(CompiledFile),
    eccs_sys_repeat,
    eccs_sys_read(X),
    eccs_sys_if_then_else(X == end_of_file,
    			  true, (eccs_restore_obj(File, X, Type), fail)),
    !,
    seen,
    eccs_sys_see(Old).


eccs_restore_obj(_, (:- Goal), _) :- 
    !,
    eccs_sys_if_then_else(eccs_sys_call(Goal), true, eccs_error([error, in, calling, Goal])).
eccs_restore_obj(_, X, _) :- eccs_sys_assertz(X).

/*

Two changes of ``mtime'' to ``date'' following
SLE visit 11-12/7/91

*/

eccs_dump_to_compiled_file(File) :-
    eccs_compiled_file_name(File, CFName),
    eccs_get_file_attributes(File, [type=Type, date=MTime]),
    eccs_sys_telling(Old),
    eccs_sys_tell(CFName),
    eccs_compiled_file_header(File),
    eccs_write_prolog_directive(eccs_set_file_attributes(File, [state=loaded, date=MTime])), % Optimism!
    Goal = (eccs_load_file(FileToSource, none, Type), 
	    eccs_set_file_attributes(FileToSource, [source=File]),
	    eccs_once((eccs_sourced_file(FileToSource, File), !; 
    	       eccs_sys_assertz(eccs_sourced_file(FileToSource, File))))),
    (eccs_definition_in_file(File, Term), eccs_sys_writeq(Term), eccs_sys_write('.'), eccs_sys_nl, fail;
     eccs_sourced_file(FileToSource, File), % See note in pfiles.pl
     eccs_write_prolog_directive(Goal),
     fail;
     eccs_sys_told, eccs_sys_tell(Old)), !.


/* added by kwh: Fri Sep 13 15:33:04 BST 1991
Reporting of 'Write permission denied' errors - assumes this is the
only way in which 'eccs_sys_tell/1' can be made to fail */

eccs_dump_to_compiled_file(File) :-
    eccs_compiled_file_name(File, CFName),
    eccs_sys_telling(Old),
    eccs_sys_if_then_else(eccs_sys_tell(CFName),
	                  fail,
			  (eccs_message(['ERROR:', failed, to, write, compiled, version, of, File, ': Permission Denied']),
			   eccs_sys_told, 
			   eccs_sys_tell(Old)) ).

eccs_compiled_file_header(File) :-
    eccs_print_string(
"/* This file is automatically generated by the Pleuk system.
You are advised not to edit it by hand."), eccs_sys_nl, 
    eccs_datestamp(Date), 
    eccs_sys_write('Generated '),
    eccs_sys_write(Date),
    eccs_print_string(" from file "), eccs_sys_write(File), eccs_sys_nl,
    eccs_pleuk_version,
    eccs_print_string("*/"), eccs_sys_nl.

eccs_maybe_dump_compilation(File) :-
    eccs_global_variable(save_compiled_versions_to_file, true), !,
    eccs_dump_to_compiled_file(File).    % moved cut (SLE - 3/92)
eccs_maybe_dump_compilation(_).


/*

eccs_dump_all

Do a total dump of all currently loaded files.

*/

eccs_dump_all :-
    eccs_sys_if_then_else(eccs_global_variable(grammar_directory, Dir),
			  Goal = eccs_call_command_in_directory(Dir, eccs_dump_all1),
			  Goal = eccs_dump_all1),
    eccs_sys_call(Goal).

eccs_dump_all1 :-
    eccs_current_file(File, _),
    eccs_maybe_dump_compilation(File),
    fail.
eccs_dump_all1.

    	      

/*

Manipulation of saved states

*/

eccs_save_pleuk(FName) :-
    eccs_sys_save(FName, Restart),
    eccs_sys_if_then_else(Restart = 0, true, eccs_restore_saved_pleuk).

/*

A restore of a saved state is essentially the same as a general start up.  We 
do however get a command argument of -restore so that we know what's going on.

*/


eccs_restore_saved_pleuk :-
    eccs_set_variable(eccs_system_state, start_up),
    eccs_set_variable(eccs_output_file, 'PleukOutput'),
%    eccs_set_variable(eccs_log_file, 'PleukLog'),
    eccs_do_command_line,
    eccs_set_up_environment,
    eccs_sys_if_then_else(eccs_global_variable(eccs_start_up_hook, X), call(X), true).
















