/*

rcsid('$Author: pleuk $',
	'$Date: 1993/06/03 09:11:58 $',
	'$Revision: 1.1 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Code/RCS/pdumb_filter.pl,v $',
	'$State: Exp $').

$Log: pdumb_filter.pl,v $
% Revision 1.1  1993/06/03  09:11:58  pleuk
% bug fix from Jo
%
% Revision 1.0  1993/04/26  16:33:16  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:41  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:52:47  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 1.1  1991/07/15  09:48:06  pleuk
% Initial revision
%


File:	/home/user2/pleuk/Pleuk/Code/pdumb_filter.pl
Date:	Thu Jul  4 12:28:38 1991
By:	Jo Calder

The filter that goes from the internal print 
representation of objects to the external. 




*/

eccs_dumb_filter(ToPrint) :-
    (ToPrint = captioned(Caption, Structure);
     ToPrint = Structure, Caption = ''), !,
     eccs_set_variable(eccs_last_output, captioned(Caption, Structure)),
     eccs_dumb_draw_fs(Structure),
     eccs_dumb_draw_caption(Caption).

eccs_dumb_draw_caption(Caption) :-
    eccs_sys_nl,
    eccs_print_string("/* ------------------------- "),
    eccs_sys_nl,
    eccs_dumb_draw_caption1(Caption),
    eccs_print_string("   ------------------------- */"),
    eccs_sys_nl.

eccs_dumb_draw_caption1(Caption) :-
    eccs_sys_atomic(Caption), !,
    eccs_sys_write(Caption), eccs_sys_nl.
eccs_dumb_draw_caption1(Caption) :-
    eccs_likely_string(Caption), !,
    eccs_print_string(Caption), eccs_sys_nl.
eccs_dumb_draw_caption1(Caption) :-
    eccs_sys_write(Caption),
    eccs_sys_nl.


/* The following predicate draws a feature structure, but occasionally fails, 
   and we don't yet know why (SLE - 3/92) */
eccs_dumb_draw_fs(FS) :-
    eccs_dumb_draw_fs(FS, 0, 0).

eccs_dumb_draw_fs(Var, _, _) :-
    eccs_sys_var(Var), !,
    eccs_error([variable, in, output, for, printer]).
eccs_dumb_draw_fs(atomic(A), Tab, _) :-
    eccs_sys_tab(Tab),
    eccs_sys_write(A).
eccs_dumb_draw_fs(symbol(S), Tab, _) :-
    eccs_dumb_symbol_name(S, Print),
    eccs_sys_tab(Tab),
    eccs_sys_write(Print).
eccs_dumb_draw_fs(italic(A), Tab, _) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('"'), eccs_sys_write(A), eccs_sys_write('"').
eccs_dumb_draw_fs(uninstantiated, Tab, _) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('[]').
eccs_dumb_draw_fs(sequence(S), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('<'),
    Tab1 is Count +1,
    eccs_dumb_draw_sequence(S, 0, Tab1),
    eccs_sys_write('>').
eccs_dumb_draw_fs(set(S), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('{'),
    Count1 is Count +1,
    eccs_dumb_draw_set(S, 0, Count1),
    eccs_sys_write('}').
eccs_dumb_draw_fs(sort(S), Tab, _Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write(sort(S)).
eccs_dumb_draw_fs(avm(Fvpairs), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('['),
    Tab1 is Count+1,
    eccs_dumb_draw_fvpairs(Fvpairs, 0, Tab1),
    eccs_sys_write(']').

eccs_dumb_draw_fs(tagged(Tag, Object), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_prlength(Tag, N),
    eccs_sys_write(Tag),
    eccs_sys_write('#'),
    Count1 is N + Count + 1,
    eccs_dumb_draw_fs(Object, 0, Count1).
eccs_dumb_draw_fs(tagged_avm(Tag, Fvpairs), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_prlength(Tag, N),
    eccs_sys_write(Tag),
    eccs_sys_write('#['),
    Tab1 is Count+2+N,
    (Fvpairs = avm(X); Fvpairs = X), !,
    eccs_dumb_draw_fvpairs(X, 0, Tab1),
    eccs_sys_write(']').
eccs_dumb_draw_fs(tag(T), Tab, _) :-
    eccs_sys_tab(Tab),
    eccs_sys_write(' #'),
    eccs_sys_write(T).
eccs_dumb_draw_fs(disj(Ds), Tab, Count) :-
    eccs_dumb_draw_logic(disj, Ds, Tab, Count).
eccs_dumb_draw_fs(conj(Ds), Tab, Count) :-
    eccs_dumb_draw_logic(conj, Ds, Tab, Count).
eccs_dumb_draw_fs(neg(N), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('~'),
    Tab1 is Count+1,
    eccs_dumb_draw_fs(N, 0, Tab1).
eccs_dumb_draw_fs(impl(A, B), Tab, Count) :-
    eccs_dumb_draw_logic(impl, [A, B], Tab, Count).
eccs_dumb_draw_fs(bicond(A, B), Tab, Count) :-
    eccs_dumb_draw_logic(bicond, [A, B], Tab, Count).
eccs_dumb_draw_fs(relation(R, Args), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_dumb_draw_fs(R, 0, 0),
    eccs_spf_atomic_type_print_length(R, N),
    Tab1 is Count+1+N,
    eccs_dumb_draw_parenth(Args, 0, Tab1).
eccs_dumb_draw_fs(parenth(Args), Tab, Count) :-
    eccs_dumb_draw_parenth(Args, Tab, Count).
eccs_dumb_draw_fs(circle(Object), Tab, Count) :-
    eccs_dumb_draw_fs(Object, Tab, Count).
eccs_dumb_draw_fs(stack(Args), Tab, Count) :-
    eccs_dumb_draw_stack_els(Args, Tab, Count).
eccs_dumb_draw_fs(postfix(Op, Arg1), _Tab, _Count) :-
    eccs_dumb_draw_fs(infix(Op, Arg1, atomic(''))).
eccs_dumb_draw_fs(prefix(Op, Arg1), _Tab, _Count) :-
    eccs_dumb_draw_fs(infix(Op, atomic(''), Arg1)).
eccs_dumb_draw_fs(infix(Op, Arg1, Arg2), Tab, Count) :-
    eccs_dumb_draw_fs(Arg1, Tab, Count),
    eccs_spf_atomic_type_print_length(Op, N),
    eccs_dumb_draw_fs(Op, 0, Count),
    eccs_dumb_draw_fs(Arg2, 0, Count+N).
eccs_dumb_draw_fs(tree(M, Ds), Tab, Count) :-
    eccs_sys_tab(Tab),
    (eccs_atomic_type(M, Str) ->
	(eccs_dumb_draw_fs(M), eccs_prlength(Str, N),
	 Tab1 is Count+N,
	 eccs_dumb_draw_ds(Ds, 0, Tab1));
	 eccs_dumb_draw_fs(M), eccs_sys_nl,
	 eccs_dumb_draw_ds1(Ds, Count, Count)).

/*

Additions Mon Feb 22 11:25:37 1993 JC For enhancements to SPF.  In the
case of the dumb filter, we can't do very much for any of these.

*/

eccs_dumb_draw_fs(triangle(A), Tab, Count) :-
    eccs_dumb_draw_fs(A, Tab, Count). 
eccs_dumb_draw_fs(hbox(As), Tab, Count) :-
    eccs_dumb_draw_fs(stack(As), Tab, Count).
eccs_dumb_draw_fs(hbox(_Posn, Es), Tab, Count) :-
    eccs_dumb_draw_fs(stack(Es), Tab, Count).
eccs_dumb_draw_fs(vbox(Es), Tab, Count) :-
    eccs_dumb_draw_fs(stack(Es), Tab, Count).
eccs_dumb_draw_fs(vbox(_Posn, Es), Tab, Count) :-
    eccs_dumb_draw_fs(stack(Es), Tab, Count).
eccs_dumb_draw_fs(space(N, _), _, _) :- !,
    X is integer(round(ceiling(N/5))), 
    eccs_sys_tab(X).
eccs_dumb_draw_fs(box(X), Tab, Count) :-
    eccs_dumb_draw_fs(X, Tab, Count).
eccs_dumb_draw_fs(concat(Es), Tab, Count) :-
    eccs_dumb_draw_fs_concat(Es, Tab, Count).
eccs_dumb_draw_fs(over(X, Y), Tab, Count) :-
    eccs_dumb_draw_fs(over(X, Y, atomic('')), Tab, Count).
eccs_dumb_draw_fs(over(X, Y, Tag), Tab, Count) :-
    eccs_dumb_draw_fs(X, Tab, Count),
    eccs_sys_nl,
    eccs_sys_tab(Tab),
    eccs_sys_write('----------------------------------------'),
    eccs_dumb_draw_fs(Tag, 0, 0),
    eccs_sys_nl,
    eccs_dumb_draw_fs(Y, Tab, Count).
eccs_dumb_draw_fs(hpsg_sort(Sort, SPF), Tab, Count) :-
    eccs_atomic_type(Sort, A),
    eccs_prlength(A, Alength),
    eccs_dumb_draw_fs(Sort, Tab, Count),
    Tab1 is Tab+Alength,
    eccs_dumb_draw_fs(SPF, Tab1, Count).
eccs_dumb_draw_fs(prolog_list(H, T), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write('['),
    eccs_dumb_draw_pllist(prolog_list(H, T), 0, Count),
    eccs_sys_write(']').

eccs_dumb_draw_pllist(prolog_list(H, T), Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_dumb_draw_fs(H, 0, Count),
    (T = [] ->
	true
      ; (T = prolog_list(_, _) -> 
	    eccs_sys_write(', '),
	    eccs_dumb_draw_pllist(T, 0, Count+2)
	  ; eccs_sys_write('|'),
	    eccs_dumb_draw_fs(T))).


eccs_dumb_draw_fs_concat([], _Tab, _Count) :- !.
eccs_dumb_draw_fs_concat([E|Es], Tab, Count) :-
    eccs_dumb_draw_fs(E, _, _),
    eccs_dumb_draw_fs_concat(Es, Tab, Count).


eccs_dumb_draw_ds([], _, _).
eccs_dumb_draw_ds([H|R], Tab, Count) :-
    eccs_sys_tab(Tab),
    eccs_sys_write(' | '),
    Tab1 is Count+3,
    eccs_dumb_draw_fs(H, 0, Tab1),
    (R = [] -> true; 
     eccs_sys_nl),
    eccs_dumb_draw_ds(R, Count, Count).



eccs_atomic_type(tag(X), X) :- !.
eccs_atomic_type(symbol(X), Print) :- 
    eccs_dumb_symbol_name(X, Print).
eccs_atomic_type(atomic(X), X).
eccs_atomic_type(italic(X), I) :-
    eccs_concat_list(['"', X, '"'], I).
eccs_atomic_type(uninstantiated, []).

eccs_spf_atomic_type_print_length(symbol(S), N) :-
    !,
    eccs_dumb_symbol_name(S, Ascii),
    eccs_prlength(Ascii, N).
eccs_spf_atomic_type_print_length(atomic(A), N) :-
    eccs_prlength(A, N).
eccs_spf_atomic_type_print_length(italic(A), N) :-
    eccs_prlength(A, M),
    N is M + 2.

eccs_dumb_draw_fs_atomic_type(atomic(A)) :-
    eccs_sys_atomic(A), !,
    eccs_sys_write(A).
eccs_dumb_draw_fs_atomic(symbol(A)) :-
    eccs_dumb_symbol_name(A, Print),
    eccs_sys_write(Print).
eccs_dumb_draw_fs_atomic(italic(A)) :-
    eccs_sys_write('"'), eccs_sys_write(A), eccs_sys_write('"').

eccs_dumb_draw_fvpairs([], _Tab, _Count) :- !.
eccs_dumb_draw_fvpairs([F = V], Tab, Count) :-
    !,
    eccs_sys_tab(Tab),
    eccs_prlength(F, N),
    eccs_sys_write(F),
    eccs_sys_write(': '),
    Tab1 is Count+2+N,
    eccs_dumb_draw_fs(V, 0, Tab1).
eccs_dumb_draw_fvpairs([F = V|R], Tab, Count) :-
    !,
    eccs_sys_tab(Tab),
    eccs_prlength(F, N),
    eccs_sys_write(F),
    eccs_sys_write(': '),
    Tab1 is Count+2+N,
    eccs_dumb_draw_fs(V, 0, Tab1),
    eccs_sys_write(','),
    eccs_sys_nl,
    eccs_dumb_draw_fvpairs(R, Count, Count).
eccs_dumb_draw_fvpairs([H], Tab, Count) :- !,
    eccs_dumb_draw_fs(H, Tab, Count).
eccs_dumb_draw_fvpairs([H|R], Tab, Count) :-
    eccs_dumb_draw_fs(H, Tab, Count),
    eccs_sys_write(','),
    eccs_sys_nl,
    eccs_dumb_draw_fvpairs(R, Count, Count).

eccs_dumb_draw_sequence([], _Tab, _Count).
eccs_dumb_draw_sequence(S, Tab, Count) :-
    eccs_dumb_all_on_one_line(S), !, 
    eccs_dumb_draw_sequence1(S, Tab, Count).
eccs_dumb_draw_sequence(S, Tab, Count) :-
    eccs_dumb_draw_sequence2(S, Tab, Count).

eccs_dumb_draw_sequence1([S], Tab, Count) :-
    eccs_dumb_draw_fs(S, Tab, Count).
eccs_dumb_draw_sequence1([F|R], Tab, Count) :-
    eccs_dumb_draw_fs(F, Tab, Count), 
    write(', '),
    eccs_dumb_draw_sequence1(R, Tab, Count).

eccs_dumb_draw_sequence2([S], Tab, Count) :-
    !,
    eccs_dumb_draw_fs(S, Tab, Count).
eccs_dumb_draw_sequence2([F|R], Tab, Count) :-
    eccs_dumb_draw_fs(F, Tab, Count),
    eccs_sys_write(','),
    eccs_sys_nl,
    eccs_dumb_draw_sequence2(R, Count, Count).

eccs_dumb_draw_set(S, Tab, Count) :-
    eccs_dumb_draw_sequence(S, Tab, Count).

eccs_dumb_draw_logic(Type, Args, Tab, Count) :-
    eccs_dumb_symbol(Type, Symbol),
    eccs_prlength(Symbol, N),
    Sep is N+2,
    _Tab1 is Count+Sep,                   % What's this for? - pjw 19.11.91
    eccs_dumb_draw_logic1(Symbol, Args, Sep, Tab, Count).

eccs_dumb_draw_logic1(_Symbol, [Arg], _Sep, Tab, Count) :-
    !,
    eccs_dumb_draw_fs(Arg, Tab, Count).
eccs_dumb_draw_logic1(Symbol, [Arg|Args], Sep, Tab, Count) :-
    (eccs_dumb_all_on_one_line([Arg]) ->
	(eccs_prlength(Symbol, SLength),
	 eccs_atomic_type(Arg, A),
	 eccs_prlength(A, Alength),
	 Tab1 is Count + Alength + SLength +2,
	 eccs_dumb_draw_fs(Arg), eccs_sys_write(' '),
	 eccs_sys_write(Symbol), eccs_sys_write(' '),
	 eccs_dumb_draw_logic1(Symbol, Args, Sep, 0, Tab1));
	 (eccs_dumb_draw_fs(Arg, Tab, Count),
	 eccs_sys_nl,
	 eccs_sys_tab(Count),
	 eccs_sys_write(Symbol),
	 eccs_sys_nl,
	 eccs_dumb_draw_logic1(Symbol, Args, Sep, Count, Count))).

eccs_dumb_symbol(impl, '->').
eccs_dumb_symbol(bicond, '<->').
eccs_dumb_symbol(disj, 'v').
eccs_dumb_symbol(conj, '&').

eccs_dumb_draw_parenth(Args, Tab, Count) :-
    eccs_sys_write('('),
    Tab1 is Count+1,
    eccs_dumb_draw_sequence(Args, Tab, Tab1),
    eccs_sys_write(')').

eccs_dumb_draw_stack_els([], _, _).
eccs_dumb_draw_stack_els([H|T], Tab, Count) :-
    eccs_dumb_draw_fs(H, Tab, Count),
    eccs_sys_nl, 
    eccs_dumb_draw_stack_els(T, Tab, Count).



eccs_dumb_all_on_one_line([]).
eccs_dumb_all_on_one_line([F|R]) :-
    eccs_dumb_on_one_line(F),
    eccs_dumb_all_on_one_line(R).

eccs_dumb_on_one_line(X) :-
    eccs_atomic_type(X, _).
eccs_dumb_on_one_line(uninstantiated).
