/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:20:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pconfigure.pl,v $',
	'$State: Exp $').

$Log: pconfigure.pl,v $
% Revision 1.0  1993/04/26  16:20:44  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:05  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:54:26  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:35:18  kwh
% 'file_specification' database entries modified.
% 'module_dependency' routine generalised to take lists of files.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pconfigure.pl
Date:	Thu May 10 10:43:57 1990
By:	Jonathan Calder

Code for loading a configuration of the functional backbone.

% singleton vars. removed (from SLE - 3/92)

Configuration is assumed to take place in the directory 
containing the relevant code. 


*/



eccs_pleuk_configure(Config, Out) :-
    eccs_configure_welcome,
    eccs_set_variable(eccs_system_state, configure),
    eccs_load_config_file(Config),
    eccs_compute_configure_info,
    eccs_dump_configure_info(Out).


/* From SLE - 3/92 */

% eccs_pleuk_configure/1 -- no output file, load to memory, and
% keep track of whether we have configured already (CHB)

eccs_pleuk_configure(_) :-
    eccs_global_variable(already_configured,true),
    !,
    eccs_to_user(['Re-configuration', is, ineffective]),
    fail.
eccs_pleuk_configure(Config) :-
    eccs_configure_welcome,
    eccs_new_variable(already_configured, true, private, install,
                      "Has the system been configured?"),
    eccs_set_variable(eccs_system_state, configure),
    eccs_load_config_file(Config),
    eccs_compute_configure_info,
    eccs_dump_configure_to_memory.



eccs_load_config_file(Config) :-
    eccs_file_exists(Config),
    eccs_srcload([Config]).

:- dynamic eccs_object_type/3.

/* 

eccs_new_object_type(Type, Multi) 
eccs_new_object_type(Type, Multi, Printer) 

Declare a new object type to the system.  Type must figure in the list
of types introduced in a eccs_new_file_type statement.  Multi is one
of {single, multiple}.  In the first case definitions of this type may
only give rise to single compiled objects, in the second multiple
compiled objects may result.  The form with two arguments states that
the printer to be used is the default printer. The form with three
gives the name of a printing routine to be used for objects of this
type.

*/

eccs_new_object_type(Type, Multi) :-
    eccs_new_object_type(Type, Multi, 'DEFAULT').

eccs_new_object_type(Type, Multi, Printer) :-
    \+ eccs_object_type(Type, _, _), !,
    eccs_sys_assertz(eccs_object_type(Type, Multi, Printer)).
eccs_new_object_type(Type, _Multi, _Printer) :-
    eccs_error([object, type, Type, already, used]).

:- dynamic eccs_file_specification/2.

/*

A new file type is declared by the following statement:

eccs_new_file_type(FileType, Extension, Reader, Compiler, ObjectTypes,
		   PreHook, PostHook, Globality, Unique).

FileType is an atom which occurs elsewhere in a eccs_major_module or
eccs_minor_module directive.  Extension a string describing a
filename extension.  Reader is a predicate to call to read an object
from the file. Compiler is the compiler to call to compile an object.
ObjectTypes is a list of atoms, these being the object types that are
defined in the file.  PreHook is the name of a prolog procedure to
call before reading any item from the file, PostHook a procedure
called after the last object in the file has been compiled.  Globality
is one of ``global'' or ``local''.  In the former case, the user is
warned if the file is recompiled, as this is likely to provoke a
recompilation of a large part of the grammar.

(Not yet implemented: Dependencies are not tracked in this case.
In the latter, dependencies are tracked.)

Unique may be either ``unique'' or ``many''; if unique, only one file
of this type may be loaded at any one time. 

*/


eccs_new_file_type(Type, Extension, Reader, Compiler, ObjectTypes, PreHook, PostHook, Global, Unique) :-
    eccs_sys_if_then_else(eccs_current_file_type(Type),
    	eccs_error([file, type, Type, already, in, use]), true),
    eccs_sys_if_then_else(eccs_file_specification(Type, [Extension|_]),
    	eccs_error([file, name, extension, Extension, already, in, use]), true),
    eccs_sys_assertz(eccs_file_specification(Type, [Extension, Reader, ObjectTypes, Compiler, PreHook, PostHook, Global, Unique])).

eccs_current_file_type(Type) :-
    eccs_file_specification(Type, _).

eccs_file_gives_rise_to_objects(Type, ObjectTypes) :-
    eccs_file_specification(Type, [_, _, ObjectTypes|_]).


    
/* 

eccs_compute_configure_info

Calculate useful information from the configuration.

*/

eccs_compute_configure_info :-
    eccs_configure_make_object_list,
    eccs_make_object_table,
    eccs_make_load_ordering.
    

eccs_configure_make_object_list :-
    findall(Type, eccs_file_gives_rise_to_objects(_FileType, Type), Types),
    eccs_append_all(Types, Flattened),
    eccs_sort(Flattened, SortedTypes),
    eccs_sys_assert(eccs_current_object_types(SortedTypes)).

eccs_current_object_type(Type) :-
    eccs_current_object_types(Types),
    eccs_member(Type, Types).


/* the object_db_table consists of linkages between
 * lexical_rule(A,B,C,D) :- pleuk_lexical_rule(A,B,C,D).
 (SLE - 3/92) */


eccs_make_object_table :-
    eccs_current_object_types(Types),
    eccs_member(Type, Types),
    eccs_global_variable(eccs_safe_prefix, Prefix),
    eccs_concat(Prefix, Type, SafeType),
    eccs_sys_assertz(eccs_object_db_table(Type, SafeType)), fail.
eccs_make_object_table.

:- dynamic eccs_module/6.

/*

eccs_major_module(ModName, DS, Dir, File, FTypes) 

Declare the major module to be used by some specialization.

ModName is the (arbitrary) name of the major module.  DS is a 
string giving a little information about the module.  Dir is the directory in 
which the module is defined.  File is the file that is to be loaded 
to define the specialization.  FTypes is a list of file types to be expected 
in a particular module.  Each element in FTypes must have a corresponding 
eccs_new_file_type statement. 

*/

eccs_major_module(ModName, DS, Dir, File, FTypes) :-
    eccs_sys_if_then_else(eccs_module(M, _, major, _, _, _), 
	eccs_error([a, major, module, M, is, already, 'defined:']), true),
    eccs_sys_assertz(eccs_module(ModName, DS, major, Dir, File, FTypes)).
eccs_new_module(ModName, DocString, Dir, File, FTypes) :-
    eccs_sys_assertz(eccs_module(ModName, DocString, minor, Dir, File, FTypes)).

/*

eccs_module_dependency(X < Y) 

X, Y are file or module types. In the former case, definitions in
files of type Y may depend on definitions in files of type X.  In the
latter case, all file types in module Y may depend on file types from
module X.

*/

eccs_module_dependency(X < Y) :- 
    eccs_sys_if_then_else(eccs_module(X, _, _, _, _, XList), true, eccs_make_list(X,XList)),
    eccs_sys_if_then_else(eccs_module(Y, _, _, _, _, YList), true, eccs_make_list(Y,YList)),
    !,
    (eccs_member(W, XList), eccs_member(Z, YList), 
    	eccs_sys_assertz(eccs_load_before(W, Z)), fail; true).
eccs_module_dependency(X) :-
    eccs_sys_write('illegal dependency '), eccs_sys_write(X), eccs_sys_nl, fail.
		
eccs_make_list(X,X) :- eccs_listp(X), !.
eccs_make_list(X,[X]).

eccs_load_before_tc(X, Y) :-
    eccs_load_before(X, Y).
eccs_load_before_tc(X, Y) :-
     eccs_load_before(X, Z),
     eccs_load_before_tc(Z, Y).

eccs_make_load_ordering :-
    eccs_sys_abolish(eccs_load_order, 1),
    eccs_sort_files_by_load_order(X),
    eccs_reverse(X, Sorted),
    eccs_sys_write('Files will be loaded in the order'),
    eccs_sys_nl,
    (eccs_member(E, Sorted), eccs_sys_write(E), eccs_sys_nl, fail; true),
    !,
    eccs_sys_assertz(eccs_load_order(Sorted)).

eccs_sort_files_by_load_order(Sorted) :-
    eccs_dependencies_non_cyclic, 
    findall(T, eccs_file_specification(T, _), Types),
    eccs_sort_by_predicate(Types, eccs_load_before_tc, Sorted).
    
eccs_dependencies_non_cyclic :-
    eccs_cyclic_dependency(X, Y), !,
    eccs_sys_write('Fatal error: Dependencies are cyclic between '),
    eccs_sys_write(X), eccs_sys_write(' and '), eccs_sys_write(Y),
    eccs_sys_nl, fail.
eccs_dependencies_non_cyclic.

eccs_cyclic_dependency(X, Y) :-
    eccs_load_before_tc(X, Y), 
    eccs_load_before_tc(Y, X), 
    eccs_not_eq(X, Y).

eccs_defined_at_configure_time(
	[eccs_object_type/3,
	 eccs_file_specification/2,
	 eccs_module/6,
	 eccs_file_gives_rise_to_objects/2,
	 eccs_current_file_type/1,
	 eccs_non_printing_type/1,
	 eccs_submenu_type/1,
	 eccs_current_object_types/1,
	 eccs_current_object_type/1,
	 eccs_load_order/1]).


eccs_dump_configure_info(File) :-
    eccs_sys_telling(Old, File),
    eccs_dump_configure_info1,
    eccs_sys_told,
    eccs_sys_tell(Old).


% write out the predicates defined at configure time. (SLE - 3/92)

eccs_dump_configure_info1 :-
    eccs_defined_at_configure_time(L),
    eccs_member(Pred/Arity, L),
    eccs_sys_functor(T, Pred, Arity),
    eccs_sys_call(T),
    eccs_sys_writeq(T), eccs_sys_write('.'), eccs_sys_nl, fail.

% copy the object_db_table to the new file. (SLE - 3/92)

eccs_dump_configure_info1 :-
    eccs_object_db_table(Type, DBType),
    eccs_sys_writeq(eccs_object_db_table(Type, DBType)), 
    eccs_sys_write('.'), 
    eccs_sys_nl, 
    fail.

% given objects from the DB table, establish a linkage between them
% and database predicates which will be defined dynamically. (SLE - 3/92)

eccs_dump_configure_info1 :-
    eccs_object_db_table(Type, DBType),
    A = [_Key, _Name, _FileName, _Object],
    Head =.. [Type|A], Body =.. [DBType|A],
    eccs_sys_writeq((Head :- Body)), eccs_sys_write('.'),
    eccs_sys_nl, 
    eccs_sys_writeq((:- dynamic DBType/4)), eccs_sys_write('.'), eccs_sys_nl,
    eccs_sys_writeq((:- multifile DBType/4)), eccs_sys_write('.'), eccs_sys_nl,
    fail.

% this bit actually executes when we load the configure file.
%
% Mon Aug 17 15:01:24 1992 JC
% Quintus 3.0 doesn't succeed in changing directories even when it 
% should.  As a work around, because both sicstus and quintus do an 
% push to a directory, we can just fix up path names and load the 
% specialization file directly.

eccs_dump_configure_info1 :-
    eccs_module(ModName, DS, _Major, Dir, File, _),
    eccs_fix_dir_name(Dir, File, Absolute),
    eccs_sys_writeq((:- eccs_srcload([Absolute]))),
    eccs_sys_write('.'),
    eccs_sys_nl, fail.
eccs_dump_configure_info1.

eccs_fix_dir_name(_Dir, File, File) :-
    eccs_sys_name(File, [0'/ | _]), !.	% absolute path name
eccs_fix_dir_name(Dir, File, Absolute) :-
    eccs_concat_list([Dir, '/', File], Absolute).

/* From SLE - 3/92 */

% eccs_dump_configure_to_memory -- version for use when we are not
% having a separate configuration stage.

eccs_dump_configure_to_memory :-
        eccs_object_db_table(Type, DBType),
        A = [_Key, _Name, _FileName, _Object],
        Head =.. [Type|A], Body =.. [DBType|A],
        eccs_once(eccs_sys_assertz((Head :- Body))),
        /* The following lines take the place of the dynamic declarations */
        /* but do it at run time                                          */
        abolish(DBType,4),
        DBDummyInst =.. [DBType,dummy,dummy,dummy,dummy],
        eccs_once((eccs_sys_assertz(DBDummyInst),
                  eccs_sys_retract(DBDummyInst))),
        fail.
eccs_dump_configure_to_memory :-
        eccs_module(_ModName, _DS, _Major, Dir, File, _),
        eccs_once(eccs_call_command_in_directory(Dir, eccs_srcload([File]))),
        fail.
eccs_dump_configure_to_memory.




/*

eccs_hidden_types(ObjType) 

Object type ObjType is not to be presented to the user.

*/


eccs_hidden_types(X) :-
    eccs_sys_if_then_else(eccs_sys_atomic(X), List = [X], X = List),
    eccs_member(E, List),
    eccs_sys_assert(eccs_non_printing_type(E)),
    fail.
eccs_hidden_types(_X).

/*

eccs_profuse_definition(ObjType)

Declare object type ObjType (or list thereof) to have lots of
definitions and thereby not to attempt to list them all at once.

*/

eccs_profuse_definition(X) :-
    eccs_sys_if_then_else(eccs_sys_atomic(X), List = [X], X = List),
    eccs_member(E, List),
    eccs_sys_assert(eccs_submenu_type(E)),
    fail.
eccs_profuse_definition(_X).

