
/* 
rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 15:48:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/C/RCS/xinterface.c,v $',
	'$State: Exp $').

$Log: xinterface.c,v $
 * Revision 1.0  1993/04/26  15:48:44  pleuk
 * Version 1.00beta from Jo
 *
 * Revision 0.11  1992/04/16  13:25:19  pleuk
 * revisions from SLE - April 1992
 *
 * Revision 0.9  1991/10/07  14:02:52  pleuk
 * *** empty log message ***
 *
 * Revision 0.8  1991/09/25  12:56:26  pleuk
 * revisions up to SLE tape 27 September 1991
 *
 * Revision 0.7  1991/09/21  02:23:19  pleuk
 * version for Jo
 *
 * Revision 0.6  1991/09/02  13:01:55  pleuk
 * revisions up to SLE visit 20 August 1991
 *
 * Revision 0.5  1991/07/15  10:42:35  kwh
 * revisions up to SLE visit 11-12 July 1991
 *

*/


#include <stdio.h>


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>



#define MAX_STRING_LENGTH 200  /* for dialog box input and menu items */


static char string[MAX_STRING_LENGTH];  /* menu and dialog return value */
static int return_value;                /* confirm return value */
static Boolean ok_flag = FALSE;         /* button pressed? */




/* MENU VARS */

static String MTrans = "<EnterWindow>: highlight()\n\
        		<LeaveWindow>: unhighlight()\n\
	        	<MotionNotify>: highlight()\n\
		        <BtnUp>: notify() unhighlight()";
  
static XrmOptionDescRec menuoptions[] = {
  {"-heading", ".heading", XrmoptionSepArg, (XtPointer)NULL},
  {"-geometry", "*geometry", XrmoptionSepArg, (XtPointer)NULL}, };

static Display *menudpy;



/* DIALOG VARS */

static XrmOptionDescRec dialogoptions[] = {
  {"-heading", "*Dialog.label", XrmoptionSepArg, (XtPointer)NULL},
  {"-default", "*Dialog*value", XrmoptionSepArg, (XtPointer)NULL},
  {"-geometry", "*geometry", XrmoptionSepArg, (XtPointer)NULL},
};

static void Ok();
static XtActionsRec dialogactiontable[] = { {"Ok", Ok} };

static Display *dialogdpy;



/* CONFIRM VARS */

static XrmOptionDescRec confirmoptions[] = {
  {"-heading", "*Dialog.label", XrmoptionSepArg, (XtPointer)NULL},
  {"-geometry", "*geometry", XrmoptionSepArg, (XtPointer)NULL},
};

static Display *confirmdpy;




/* initialize -------------------------------------------------------------- */

void
initialize()
{
  int argc = 1;
  char **argv;
  XtAppContext dialogappcon;

  XtToolkitInitialize();

  menudpy = XtOpenDisplay(XtCreateApplicationContext(), NULL,
			  "xpleuk", "pleukmenu",
			  menuoptions, XtNumber(menuoptions),
			  &argc, argv);

  dialogappcon = XtCreateApplicationContext();
  dialogdpy = XtOpenDisplay(dialogappcon, NULL, 
			    "xpleuk", "pleukdialog", 
			    dialogoptions, XtNumber(dialogoptions), 
			    &argc, argv);
  XtAppAddActions(dialogappcon,dialogactiontable,XtNumber(dialogactiontable));

  confirmdpy = XtOpenDisplay(XtCreateApplicationContext(), NULL,
			     "xpleuk", "pleukconfirm",
			     NULL, 0,
			     &argc, argv);
}



/* MENU -------------------------------------------------------------------- */

/*
 * Copyright 1990 Richard Hesketh / rlh2@ukc.ac.uk
 *                Computing Lab. University of Kent at Canterbury, UK
 */

#define LINE (String)1
#define LINE_TOK "line"

static void
button_pressed(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	if (client_data != NULL) {
	        ok_flag = TRUE;
		strcpy(string, client_data);
        }
}


static String
get_prompt(str, out_val)
String str;
String *out_val;
{
	int s, t;
	char name[MAX_STRING_LENGTH];
	Boolean found_escape = FALSE;

	*out_val = NULL;

	if (strncmp(str, LINE_TOK, strlen(LINE_TOK)) == 0)
		return (LINE);

	for (t = s = 0; str[s] != '\0'; s++) {
		if (str[s] == '\\') {
			if (found_escape) {
				found_escape = FALSE;
				name[t++] = '\\';
			} else
				found_escape = TRUE;
		} else if (str[s] == '=') {
			if (found_escape) {
				found_escape = FALSE;
				name[t++] = '=';
			} else {
				*out_val = str + s + 1;
				break;
			}
		} else
			name[t++] = str[s];
	}
	name[t] = '\0';
	return (XtNewString(name));
}


static void 
xmenu_main(argc, argv)
int argc;
char **argv;
{
  Widget shell, button;
  Cardinal i;
  Position x, y;
  String out_val;
  String name, heading;
  char *blank;
  XrmValue value;
  XEvent event;

  XrmParseCommand(&menudpy->db, 
		  menuoptions, XtNumber(menuoptions), 
		  "xpleuk", &argc, argv);
  
  x = y = 400;

  if (XrmGetResource(menudpy->db, "xpleuk.heading", "", &blank, &value))
    heading = (char *)value.addr;
  else
    heading = NULL;
  
  shell = XtVaAppCreateShell("xpleuk", "pleukmenu",
			     simpleMenuWidgetClass, menudpy,
			     XtNx, x, XtNy, y,
			     XtNlabel, heading,
			     XtNtranslations,
			     XtParseTranslationTable(MTrans),
			     NULL);
  
  if (heading != NULL)
    button = XtVaCreateManagedWidget("menuLine", 
				     smeLineObjectClass, shell,
				     XtNlineWidth, 3,
				     NULL);
  
  for (i = 1; i < argc; i++) {
    name = get_prompt(argv[i], &out_val);
    
    if (name == LINE)
      button = XtVaCreateManagedWidget("menuLine",
				       smeLineObjectClass, shell,
				       NULL);
    else {
      button = XtVaCreateManagedWidget("menuButton",
				       smeBSBObjectClass, shell,
				       XtNlabel, name,
				       NULL);
      XtAddCallback(button, XtNcallback, button_pressed,
		    (XtPointer)out_val);
    }
  }
  
  ok_flag = FALSE;

  XtPopup(shell, XtGrabExclusive);
  
  while(ok_flag == FALSE) {
    XtAppNextEvent(XtWidgetToApplicationContext(shell), &event);
    XtDispatchEvent(&event);
  }
  
  XtPopdown(shell);

/* The following forces the pop-down to be carried out immediately -
without it the `dead' menu will stay on screen until the next menu
call, because the pop-down won't be carried out till then. (Some window 
managers may get upset with the dead menu - twm is ok but not tvtwm)
*/
  XSync(menudpy, False);

}



/* DIALOG ------------------------------------------------------------------ */


static void 
Ok(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  Widget dialog;
  dialog = XtParent(widget);
  strcpy(string, XawDialogGetValueString(dialog));
  ok_flag = TRUE;
}


static void 
Cancel(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  ok_flag = TRUE;
}



static void
xdialog_main(argc, argv)
int argc;
char **argv;
{
  Widget shell, dialog;
  Position x, y;
  XEvent event;

  XrmPutLineResource(&dialogdpy->db, "*input: True");
  XrmPutLineResource(&dialogdpy->db, "*allowShellResize: True");
  XrmPutLineResource(&dialogdpy->db, "*Dialog*value: ");
  XrmPutLineResource(&dialogdpy->db, 
		     "*Dialog*value.translations: #override \\n <Key>Return: Ok()");
  
  XrmParseCommand(&dialogdpy->db, 
		  dialogoptions, XtNumber(dialogoptions),
		  "xpleuk", &argc, argv);
  
  x = y = 400;
  
  shell = XtVaAppCreateShell("xpleuk", "pleukdialog",
			   transientShellWidgetClass, dialogdpy,
			   XtNx, x, XtNy, y, NULL);
  
  dialog = XtCreateManagedWidget("dialog", dialogWidgetClass, shell, 
				 NULL, 0);
  
  XawDialogAddButton(dialog, "ok", Ok, NULL);
  XawDialogAddButton(dialog, "cancel", Cancel, NULL);
  
  ok_flag = FALSE;

  XtPopup(shell, XtGrabExclusive);

  while(ok_flag == FALSE) {
    XtAppNextEvent(XtWidgetToApplicationContext(shell), &event);
    XtDispatchEvent(&event);
  }

  XtPopdown(shell);
  XSync(dialogdpy, False);

}



/* CONFIRM ----------------------------------------------------------------- */


static void
Yes(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  return_value = 1;
  ok_flag = TRUE;
}


static void
No(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  return_value = 0;
  ok_flag = TRUE;
}



static void
xconfirm_main(argc, argv)
int argc;
char **argv;
{
  Widget shell, dialog, button;
  Position x, y;
  String label;
  char *blank;
  XrmValue value;
  XEvent event;

  XrmParseCommand(&confirmdpy->db,
		  confirmoptions, XtNumber(confirmoptions),
		  "xpleuk", &argc, argv);

  x = y = 400;

  shell = XtVaAppCreateShell("xpleuk", "pleukconfirm",
			     transientShellWidgetClass, confirmdpy,
			     XtNx, x, XtNy, y, NULL);
  
  dialog = XtCreateManagedWidget("dialog", dialogWidgetClass, shell,
				 NULL, 0);
  
  button = XtVaCreateManagedWidget("Yes", commandWidgetClass, dialog,
				   XtNwidth, 50, XtNheight, 40, 
				   NULL);
  XtAddCallback(button, XtNcallback, Yes, NULL);
  
  button = XtVaCreateManagedWidget("No", commandWidgetClass, dialog,
				   XtNwidth, 50, XtNheight, 40,
				   NULL);
  XtAddCallback(button, XtNcallback, No, NULL);
  
  ok_flag = FALSE;
  
  XtPopup(shell, XtGrabExclusive);
  
  while (ok_flag == FALSE) {
    XtAppNextEvent(XtWidgetToApplicationContext(shell), &event);
    XtDispatchEvent(&event);
  }

  XtPopdown(shell);
  XSync(confirmdpy, False);

}




/* SICStus prolog interface ------------------------------------------------ */


static Boolean option = FALSE;

/* allocate space for argv[] */
char **allocate(argnum)
{
  int i;
  char **pointers = (char **) malloc(++argnum * sizeof(char *));
  /* allocate double space to allow for duplication of xmenu arguments */
  char *strings = (char *) calloc(argnum, (MAX_STRING_LENGTH * 2));

  for(i=0; i < argnum; i++)
      pointers[i] = strings + (i * (MAX_STRING_LENGTH * 2));

  return pointers;
}



/* enter single argument in argv[] */
void argument(location, position, string)
char **location;
int position;
char *string;
{
  int i = 0;
  int j = 0;
  int c = 0;

  if (string[0] == '#') c = 1;  /* digits are passed in as strings with '#' as
                                   prefix - skip over this in copy. */
  for(; 
      ((location[position][i] = string[c]) != '\0' && i < MAX_STRING_LENGTH);
      i++,c++);

  if (string[0] == '-' && option == FALSE) {
    location[position][i] = '\0';
    option = TRUE;
  }

  else {
    if (option == TRUE) {
      location[position][i] = '\0';
      option = FALSE;
    }

    /* if argument not '-*' or a corresponding value, duplicate for xmenu */
    else {
      location[position][i++] = '=';
      while((location[position][i++] = string[j++]) != '\0');
    }
  }
}




char *menu_call(location, length)
char **location;
int length;
{
  xmenu_main(++length, location);
  free(*location);
  free(location);
  return string;
}


char *dialog_call(location, length)
char **location;
int length;
{
  /* initialise return value to 'cancel' signal */
  string[0] = '-'; string[1] = '1'; string[2] = '\0';
  xdialog_main(++length, location);
  free(*location);
  free(location);
  return string;
}


int confirm_call(location, length)
char **location;
int length;
{
  xconfirm_main(++length, location);
  free(*location);
  free(location);
  return return_value;
}



