%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% PERIPHERY 
%%%
%%% (c) 1991, 1992, 1993  Sandiway Fong, NEC Research Institute, Inc.
%%%
%%% Language-particular operations + kludgey stuff

%%% S-STRUCTURE GRAMMAR ADDITIONS

% Have to be a bit picky in what we allow in [Spec,CP] for English
:- multifile spec/2.
spec(c1,exnp). 	
spec(c1,whadv).	

:- multifile (rule)/1.

rule empty c with Fs st mkFs([wh],Fs).		  % for head movement

rule exnp -> [np(NP)] st \+ ec(NP) if isMatrixLevel.
rule neg -> [neg] st blockILowering(es(i)).
rule whadv -> [adv(Adv)] st specCPWhAdv(Adv,es(i),es(o)).

rule adv -> trace.

rule head_adjoined v to neg adjoins_to_the left.  % in head movement

%%% GRAMMAR RULE RESTRICTIONS

:- multifile (add_goals)/2.

% Don't allow Q in matrix Comp when an Aux Verb can be used.
lhs c2 add_goals [matrixQException(ss(o))].

% Reduce non-determinism for adjunction
rhs [vsubcatvp,vp(VP)] add_goals [\+ adjoined(VP)].

% relClNP -> [overtNP] and np->[relClNP,CP[(+/-)wh]] 
rhs [overtNP] add_goals [push([selR(head(c2),addFeature(wh(_)))],es(i),es(o))].

% Relativized subjects with no overt relative pronoun are not allowed
% *[NP [NP the man][c2 Op [c1 [c] [i2 NP-e ...]]]]
rhs [relClNP,c2(CP)] add_goals [blockECSubjRelClause(CP)].

% Check for that obligatory adjuncts are present
rhs [i,vp(X)] add_goals [vpRequiresExt(X)].
rhs [neg,vp(X)] add_goals [vpRequiresExt(X)].

%%% SUPPORT FOR DETERMINER/N1 INTERACTION

%% Determiner and N1 interaction

rhs [n1(N1)]		add_goals [noDet(N1)].
rhs [det(Det),n1(N1)] 	add_goals [detAgreement(Det,N1)].

% Inherit [wh,op(+/-)] features from spec instead of head

rhs [det,n1] 		add_inherit plus(2,[1,[wh,op(_)]]).

%% no determiner option possible for: 
%%	1. non-common, or
%%	2. non-count, or
%%	3. plural count nouns only.

noDet(N1) :- \+ N1 has_feature count(_).
noDet(N1) :- N1 has_feature count(-).
noDet(N1) :- 
	N1 has_feature count(+),
	intersectAGR(N1,[[],pl,[]]).

detAgreement(Det,N1) :- 
	Det has_feature count(C),
	N1 has_feature count(C),
	agreeAGR(Det,N1),
	vowelMatch(Det,N1).

% a(n)
vowelMatch(Det,N1) :-
	(Type == '+' iff N1 has_feature vow) 
	if Det has_feature vow(Type).

%%% CASE THEORY

% compatibleCase(AssignedCase,MorphologicallyRealizedCase)

compatibleCase(X,X).
compatibleCase(gen,acc).   % for 'proud of him'
compatibleCase(obq,acc).   % for 'to him'

% Case Transmission
:- initialization(no caseTransmission(_,_,_)).

% Genitive Case realization (of/'s)
realizedAsMarker(gen).

caseRealizationMode(NP,Mode) :-
	NP has_feature compl
	-> Mode = case				  % of him
	;  Mode = caseMorphC.			  % John's, his

%%% EMPTY COMP

% To satisfy the WhInSyntax filter, 
%	matrix [C] is freely  [+/-Wh], e.g. who left, john left

emptyCompFeatures(Fs) :-
	isMatrixLevel
	-> mkFs([wh(_)],Fs)
	;  nullFeatures(Fs).

%%% Move-Alpha (D-structure to S-structure)

moves(CF,C) :- cat(CF,C), in(C,[np,adv]).

%%% MATRIX COMP AND WH-ELEMENTS

% Don't allow Q when there exists a [wh,aux] element that can be raised.
% Use this to temporarily block overgeneration in cases like:
%	who [c] was arrested
%	who [c c [i i [v was]]] t arrested

matrixQException([CP|_]) :-  \+ whQAuxConfig(CP) if isMatrixLevel.

whQAuxConfig(CP) :- whHeaded(CP), C0 head_of CP, q(C0), whAux(CP). 

whHeaded(CP) :-	Spec specifier_of CP, Spec has_feature wh.

q(C) :- ec(C), C has_feature wh(+).

whAux(Ci) :-
	IP complement_of Ci,
	I0 head_of IP,
	adjoined(I0,V),
	V has_feature aux.

%%% RELATIVE CLAUSE RESTRICTIONS

% block subject to empty operator extraction, e.g. *the man Op t saw me
% where there is nothing in Comp (cf. the man that saw me)

blockECSubjRelClause(CP) :- \+ ecSpecHeadSubj(CP).

% [c2 Op [c1 ... [i2 NP-e ... ]]]
ecSpecHeadSubj(CP) :-
	cat(CP,c2),
	Spec specifier_of CP,
	ec(Spec),
	Subj subject_of CP,
	ec(Subj),
	Head head_of CP,
	ec(Head).

%% Chain Formation conditions

chainLinkConditions(New,Head,L,UpPath,DownPath) :-
	cat(New,C),
	linkCondition(C,New,Head,L,UpPath,DownPath).

% 1. antecedent c-commanded traces
% 2. base position iff adjunct position

linkCondition(adv,_,Trace,L,_,[]) :-
	Trace has_feature adjunct if L == [].

linkCondition(np,Head,_,_,UpPath,DownPath) :-
	\+ vacuousTopicalization(Head,UpPath,DownPath).

vacuousTopicalization(Head,[i2,c1],[]) :- 
	cat(Head,np), \+ ec(Head), \+ Head has_feature wh.

%%% MISCELLANEOUS

%% Negation blocks I-lowering to V

blockILowering(ES) :- \+ popPTr(i,_,ES,_).	  % machine code

% Adv in [Spec,CP] st.
% Intermediate trace 	if empty category
% [Wh]Adv  		otherwise
% 
% NB. Assumes left to right

specCPWhAdv(Adv,ES,ESp) :-
	ec(Adv)
	-> make Adv have_feature ec(trace),
	   predictTrace(Adv,ES,ESp)
	;  Adv has_feature wh, 
	   predictTrace(Adv,ES,ESp).

:- dynamic shiftRequest/2.
