%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% PERIPHERY SPANISH
%%%
%%% (c) 1991, 1992, 1993  Sandiway Fong, NEC Research Institute, Inc.
%%%     1994 for Spanish (Martine Smets)
%%% Language-particular operations + kludgey stuff

%%% S-STRUCTURE GRAMMAR ADDITIONS

% Have to be a bit picky in what we allow in [Spec,CP] for English
:- multifile spec/2.
spec(c1,exnp). 	
spec(c1,whadv).	

:- multifile (rule)/1.

%  rule for empty c target of head movement
%  in Spanish, verbs raise to Comp in questions

rule empty c with Fs st mkFs([wh],Fs).   % for head movement

rule exnp -> [np(NP)] st (\+ ec(NP),NP has_feature wh) if isMatrixLevel.
rule whadv -> [adv(Adv)] st specCPWhAdv(Adv,es(i),es(o)).

rule adv -> trace.

:-multifile (adjunction)/1.

adjunction rule n -> [n,a] st lexicalProperty(a,grid([_],_)).


%%% GRAMMAR RULE RESTRICTIONS

:- multifile (add_goals)/2.


% Reduce non-determinism for adjunction
rhs [vsubcatvp,vp(VP)] add_goals [\+ adjoined(VP)].

% relClNP -> [overtNP] and np->[relClNP,CP[(+/-)wh]] 
rhs [overtNP] add_goals [push([selR(head(c2),addFeature(wh(_)))],es(i),es(o))].

% Relativized subjects with no overt relative pronoun are not allowed
% *[NP [NP the man][c2 Op [c1 [c] [i2 NP-e ...]]]]
rhs [relClNP,c2(CP)] add_goals [blockECSubjRelClause(CP)].

% Clitic doubling obligatory for pronominal objects
rhs [np,i1(I1)] add_goals [ensureCliticDoubling(I1)].

% Agreement between past participle/adjective and subject if verb is "to be"
rhs [np(NP),i1(I1)] add_goals [serAgr(NP,I1)].


%%Adjective and N interaction

rhs [agridtheme(A),n0(N)]  add_goals [adjAgreement(A,N)].
rhs [n0(N),agridtheme(A)]  add_goals [adjAgreement(N,A)].

%%% SUPPORT FOR DETERMINER/N1 INTERACTION

%% Determiner and N1 interaction

rhs [n1(N1)]		add_goals [noDet(N1)].
rhs [det(Det),n1(N1)] 	add_goals [detAgreement(Det,N1)].
rhs [np(NP),n1(N1)] 	add_goals [agreeAGR(NP,N1)].

% Inherit [wh,op(+/-)] features from spec instead of head

rhs [det,n1] 		add_inherit plus(2,[1,[wh,op(_)]]).

%% no determiner option possible for:
%% 1. non-common;
%% 2. non-count;
%% 3. plural indefinite count nouns.

noDet(N1) :- \+ N1 has_feature count(_). 
noDet(N1) :- N1 has_feature count(-).
noDet(N1) :- 
	N1 has_feature count(+),
	intersectAGR(N1,[[],pl,[]]).


detAgreement(Det,N1) :- 
	Det has_feature count(C),
	N1 has_feature count(C),
	agreeAGR(Det,N1).

adjAgreement(A,N) :-
	agreeAGR(A,N).

% Clitic doubling for personal pronouns.

ensureCliticDoubling(I1) :-
	identifyVP(I1,VP),
	V head_of VP,
	(XP complement_of VP ->
	    (XP has_feature p(+), \+ ec(XP)  ->
		(XP has_feature indirectObject ->
		    V has_feature indCl
		; V has_feature noCasemark(+))
	    ; true)
	; true).

% Agreement subject and predicative adjective/past participle
serAgr(NP,I1) :-
	identifyVP(I1,VP),
	serAgr1(NP,VP).

serAgr1(NP,VP) :-
	V head_of VP,
	(V has_feature transmitAgr
    -> ((XP complement_of VP,
	(XP has_feature morph(_,ed(2)); cat(XP,ap)))
    -> agreeAGR(NP,XP)
     ; (XP complement_of VP,
	cat(XP,vp)
    -> serAgr1(NP,XP))
     ; true)
 ;  true).








%%% CASE THEORY

% compatibleCase(AssignedCase,MorphologicallyRealizedCase)

compatibleCase(X,X).


% Vacuous: no Case transmission for English.
% :- initialization(no caseTransmission(_)).

% Dative Case is realized as a

realizedAsMarker(dat).
realizedAsMarker(gen).

caseRealizationMode(NP,Mode) :-
	NP has_feature compl
	-> Mode = case
	;  Mode = caseMorphC.

% Case Transmission
:- initialization(no caseTransmission(_,_,_)).

%%% EMPTY COMP

% To satisfy the WhInSyntax filter, 
%	matrix [C] is freely  [+/-Wh], e.g. who left, john left

emptyCompFeatures(Fs) :-
	isMatrixLevel
	-> mkFs([wh(_)],Fs)
	;  nullFeatures(Fs).

%%% Move-Alpha (D-structure to S-structure)

moves(CF,C) :- cat(CF,C), in(C,[np,adv]).


%%% RELATIVE CLAUSE RESTRICTIONS

% block subject to empty operator extraction, e.g. *the man Op t saw me
% where there is nothing in Comp (cf. the man that saw me)

blockECSubjRelClause(CP) :- \+ ecSpecHeadSubj(CP).

% [c2 Op [c1 ... [i2 NP-e ... ]]]
ecSpecHeadSubj(CP) :-
	cat(CP,c2),
	Spec specifier_of CP,
	ec(Spec),
	Subj subject_of CP,
	ec(Subj),
	Head head_of CP,
	ec(Head).

%% Chain Formation conditions

chainLinkConditions(New,Head,L,UpPath,DownPath) :-
	cat(New,C),
	linkCondition(C,New,Head,L,UpPath,DownPath).

% 1. antecedent c-commanded traces
% 2. base position iff adjunct position

linkCondition(adv,_,Trace,L,_,[]) :-
	Trace has_feature adjunct if L == [].

linkCondition(np,Head,_,_,UpPath,DownPath) :-
	\+ vacuousTopicalization(Head,UpPath,DownPath).

vacuousTopicalization(Head,[i2,c1],[]) :- 
	cat(Head,np), \+ ec(Head), \+ Head has_feature wh.

%%% MISCELLANEOUS

%% Negation blocks I-lowering to V

%%blockILowering(ES) :- \+ popPTr(i,_,ES,_).	  % machine code

% Adv in [Spec,CP] st.
% Intermediate trace 	if empty category
% [Wh]Adv  		otherwise
% 
% NB. Assumes left to right

specCPWhAdv(Adv,ES,ESp) :-
	ec(Adv)
	-> make Adv have_feature ec(trace),
	   predictTrace(Adv,ES,ESp)
	;  Adv has_feature wh, 
	   predictTrace(Adv,ES,ESp).


:- dynamic shiftRequest/2.
