%%%  -*- Package: PROLOG-USER; Mode: PROLOG -*-

%%% PERIPHERY FOR JAPANESE
%%%
%%% (c) 1991, 1992, 1993  Sandiway Fong, NEC Research Institute, Inc.
%%%
%%% Language-particular operations + kludgey stuff
%%%	1. case agreement
%%%	2. constrained scrambling
%%%

%%% S-STRUCTURE GRAMMAR ADDITIONS

% Experimental feature pushing
pushFeature(morphC(_)).

:- multifile (rule)/1.
rule ecNP     -> [np(NP)] st ec(NP).
rule opC2$c2  -> [ecNP,c1].

rule head_adjoined _ adjoins_to_the left.	  % in head movement

% Pushed features: Will be automatically generated...
 
rule dObjectNP  -> [np(NP)] st \+ C==nom if NP has_feature morphC(C).
rule ioObjectNP  -> [np(NP)] st C==dat if NP has_feature morphC(C).
rule overtONP -> [overtNP(NP)] st (C==acc;C==dat) if  NP has_feature morphC(C).
rule objectNP -> [np(NP)] st (C==acc;C==dat) if  NP has_feature morphC(C).
rule subjectNP -> [np(NP)] st \+ (C==acc ; C==dat) if NP has_feature morphC(C).
rule npSubjectNP -> [np(NP)] st C==gen if NP has_feature morphC(C).

:- multifile (adjunction)/1.
adjunction rule vp -> [overtONP,vp].		  % object scrambling (VP-int)
adjunction rule i2 -> [overtONP,i2].		  % no intermediate traces

% Base adjunction
adjunction rule np -> [overtNP,nq].		  % freely adjoin NQ to NP
adjunction rule np -> [nq,np].
adjunction rule np -> [pp,np] st lexicalProperty(pp,conj).

:- multifile add_goals/2.

rhs [overtONP(NP),vp] add_goals [aPos(NP)].	  % scramble object to A-pos
rhs [overtONP(NP),i2] add_goals [aPos(NP)].	  % A-pos (tentatively)

rhs [vp(VP),v] add_goals [\+ adjoined(VP)].	  % eliminate unnecessary
						  % non-determinism
% NQ NP Agreement
rhs [overtNP(NP),nq(NQ)] add_goals [agreeNPNQ(NP,NQ)]. % eliminate non-det.
rhs [nq(NQ),np(NP)] add_goals [agreeNPNQ(NP,NQ)].

% Scrambling 
lhs overtONP add_goals [pushReq(es(i),es(o))].
lhs dObjectNP & rhs [np(X)] add_goals [cReq(X,es(i),es(o))].
lhs ioObjectNP & rhs [np] add_goals [cReq(es(i),es(o))].
lhs subjectNP & rhs [np(X)] add_goals [ldReq(X,es(i))].
lhs leftvgridcsr1stnp add_goals [oneReq(es(i))].
lhs v0 add_goals [zeroReq(es(i))].

rhs [det,n1] add_inherit plus(2,[1,[wh,op(_)]]).

% rhs [pp,vp] replace_rhs [coPP,vp].
rhs [c2,relClNP] replace_rhs [opC2,relClNP].

% Experimental feature pushing, again...
rhs [np,vgrid] replace_rhs [dObjectNP,vgrid].	  % opt. direct object
rhs [np,v1] replace_rhs [ioObjectNP,v1].	  % opt. indirect object
rhs [np,i1] replace_rhs [subjectNP,i1].		  % opt. subject
rhs [np,pgrid] replace_rhs [overtNP,pgrid].	  % disallow post-pos stranding
rhs [np,n1] replace_rhs [npSubjectNP,n1].	  % genitive Case

:- multifile (left_bracket)/1.
left_bracket c2 substitute openReq for open.

%%% S-STRUCTURE GRAMMAR DELETIONS

%% kind of redundant, will not be needed in next version

block rule adv -> [adv(Adv)] st maybeSubcategorized(adv,Adv). 

%%% OTHER LANGUAGE-SPECIFIC AREAS

%%% EMPTY COMP

% null C is only permitted in matrix clauses and for A-bar clauses
emptyCompFeatures(Fs) :- 
	nullFeatures(Fs),
	addF(goal(apos,fail),Fs) if \+ isMatrixLevel.

%%% Move-Alpha (D-structure to S-structure)

moves(CF,np) :- cat(CF,np).

% compatibleCase(AssignedCase,MorphologicallyRealizedCase)

compatibleCase(X,X).
compatibleCase(_,topic).		  % deal with topicalization later

% Case Transmission: Need it for scrambling (complement to adjunct)
% NB. need to do [NP NQ NP-t], despite extraction, NQ-NP is overt

caseTransmission(Hd,NP,Case) :- 
	baseTrace(NP),
	headOfChain(Head,NP),
	Head has_feature adjunct,		  % scrambling
	NP has_feature compl,
	assignSCase(Hd,Case,Head),
	NP has_feature case(Case) if \+ ec(NP).	  % [NP NQ NP-t]

% Indicate all non-adjunct Case are realized using overt markers.

realizedAsMarker(X) :- X \== obq.

caseRealizationMode(_NP,morphC).

% NQ NP agreement

agreeNPNQ(NP,NQ) :-
	NQ has_feature classifier(Class),
	((\+ ec(NP) ; NP has_feature class(_))
	-> agreeClassifier(NP,Class)
	;  NP has_feature ec(trace),		  % force trace
	   transmitViaChain([],[goal(agreeClassifier1(X,Class),X)],NP)).

agreeClassifier1(NP,Class) :- agreeClassifier(NP,Class).

agreeClassifier(NP,Class1) :-
	NP has_feature class(Class)
	-> Class = Class1
	;  Class1 = default.

%% Chain Formation conditions

chainLinkConditions(Head,Trace,_,UpPath,DownPath) :-
	\+ vacuousScrambling(UpPath,DownPath)
	if Trace has_feature_set [apos,adjunct],  % scrambling
	longDistABarPos(Head,UpPath) 
	if Head has_feature_set [apos,adjunct].

vacuousScrambling([],_).			  % no topmost segment crossed
vacuousScrambling(_,Down) :- \+ Down == [].

% Long Distance scrambling is A-bar

longDistABarPos(Head,UpPath) :-
	addFeature(goal(apos,fail),Head) if in(c2,UpPath). % inter-clausal

%% SCRAMBLING
%%
%%	Must prevent vacuous scrambling

shiftRequest(n,es).

% request carrier r(State)
% State = Var or 1

%% pushReq(ES,ES')	start new req state 0
%% shiftReq(ES)		all requests state 0 -> 1
%% cReq(ES,ES')		ticks off a state 1 req
%% cReq(X,ES,ES')	X must be ec if req found
%% openReq(ES,ES') 	put in place of open, barf if state 0 req found

% initiates a request
pushReq(ES,[r(_)|ES]) :- kReq(ES).

% handles r([X])
kReq([X|ES]) :-
	open(X) 
	-> true
	;  (functor(X,r,_)
	   -> kReq1(ES)
	   ;  kReq(ES)).

% fails if we get to r(_) before an open
kReq1([X|ES]) :- open(X) -> true ;  \+ functor(X,r,_), kReq1(ES).

% change state of all open requests
% handles r([X])

shiftReq([X|ES]) :-	   
	open(X)
	-> true
	;  ((X = r(1) ; X = r([1]))		  % state <- 1
	   -> shiftReq(ES)
	   ;  shiftReq(ES)).

ldReq(Item,ES) :- ec(Item) -> ldReq(ES) ; true.	   
	
ldReq([X|ES]) :-	   
	open(X)
	-> true
	;  (X = r(V)
	   -> (var(V) -> V = [_] ; true),
	      shiftReq(ES)
	   ;  shiftReq(ES)).

%  consume one shifted request

cReq(ES,ESp) :-
	ES = [X|ES1],
	(open(X)
	-> ESp = ES
	;  (X = r(S)
	   -> (S == 1				  % consume
	      -> ESp = ES1
	      ;  ESp = [X|ESp1],
	         cReq(ES1,ESp1))
	   ;  ESp = [X|ESp1],
	      cReq(ES1,ESp1))).


% obligatory consume shifted request

cReq(Item,ES,ESp) :-
	ES = [X|ES1],
	(open(X)
	-> ESp = ES
	;  (X = r(S)
	   -> (S == 1				  % shifted
	      -> withEmpty(Item),
	         ESp = ES1
	      ;  ESp = [X|ESp1],
	         cReq(Item,ES1,ESp1))
	   ;  ESp = [X|ESp1],
	      cReq(Item,ES1,ESp1))).

withEmpty(X) :- ec(X) -> true ; adjoined(X,_,X1), withEmpty(X1).

% non-local request propagation
% ES = [...Rs...]
% ES' = [..Rs...,open,...]
% Translates r([1]) -> r(1)

openReq(ES,ESp) :-
	nlReq1(ES,ES1,Rs),
	append1(Rs,ES2,ESp),
	open(ES1,ES2).

% separates local requests Rs leaving ES'
nlReq1([],[],[]).
nlReq1([X|ES],ESp,Rs) :-
	open(X)
	-> ESp = [X|ES],
	   Rs = []
	;  (X = r(S)
	   -> (S == 1				  % already shifted
	      -> Rs = [X|Rsp],
	         nlReq1(ES,ESp,Rsp)
	      ;  S == [1],			  % shift, xform r([1])->r(1)
	         Rs = [r(1)|Rsp],
	         nlReq1(ES,ESp,Rsp))
	   ;  ESp = [X|ESp1],
	      nlReq1(ES,ESp1,Rs)).

% <= 1 state 1 req, no state 0 req
oneReq([X|ES]) :-
	open(X)
	-> true
	;  (X = r(S)
	   -> S == 1,
	      zeroReq(ES)
	   ;  oneReq(ES)).

% no reqs of any state allowed

zeroReq([X|ES]) :- open(X) -> true ;  \+ functor(X,r,_), zeroReq(ES).
	
%%% LEXICON SUPPORT

% Priority correct?

externalRolesForNi(X,Y) :-
	vpAllowExtL([goal,source],X)
	-> Y = goal
	;  unsaturatedExtRole(X,agent),
	   Y = agent.
