%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% PERIPHERY 
%%%
%%% Language-particular operations + kludgey stuff

%%% S-STRUCTURE GRAMMAR RULE ADDITIONS

:- multifile (adjunction)/1.

adjunction rule vp -> [overtONP,vp].		  % object scrambling (VP-int)
adjunction rule i2 -> [overtONP,i2].		  % no intermediate traces

% Adjective noun
adjunction rule n -> [n,a] st lexicalProperty(a, grid([_],_)).

:- multifile (rule)/1.

% Object NP and vacuous scrambling
rule idoNP -> [np(NP)] st cReq(NP,es(i),es(o)).
rule doNP -> [np(NP)] st cReqX(NP,es(i),es(o)).

%% Scrambling for objects

rule overtONP -> [overtNP(NP)] 
	st (matchCase([acc,dat,gen],C) if NP has_feature morphC(C)), 
	    pushReq(es(i),es(o)).

%%% EMPTY COMP

% Want to say: 
%
% 	At matrix level, empty comp always has to be filled by verb movement
%  	Otherwise truly empty comp has to occur if a wh(+) specifier is there,
%  	but if wh(-) (equivalent: no specifier) it has to be filled by verb
%	movement.
%
% Two rules to govern the distribution of:
%
% (1) Empty Comp for which verbs adjoin to (V2-movement)
% (2) "Bare" empty Comp

rule empty c with Fs 
	st (isMatrixLevel -> mkFs([wh(_)],Fs);  mkFs([wh(-)],Fs)).

emptyCompFeatures(Fs) :- \+ isMatrixLevel, mkFs([wh],Fs).

%%%
%%% S-STRUCTURE GRAMMAR RULE PATCHES
%%%

:- multifile add_goals/2.

%%% SPEC(CP) IS TOPIC POSITION
%  licenses expletive 'es' in German, should disallow 'it' in English

rhs [np(NP),c1] add_goals [ addFeature(topic,NP) if \+ NP has_feature ec(_) ].

% reduce non-determinism for adjunction
rhs [vp(VP),vsubcatvp] add_goals [\+ adjoined(VP)].

rhs [agridtheme(A), n0(N)] add_goals [adjAgreement(A,N)].

%%% ZERO EXPLETIVE IN SPEC(IP)

% triggers third person agreement, doesn't need a theta role, but
% needs case(nom)

% limitation of pro to and in subject position
rhs [np(NP), i1(I1)]    add_goals [proSubjRestriction(NP, I1)].

%% DETERMINER AND N1 INTERACTION

rhs [n1(N1)]		add_goals [noDet(N1)].
rhs [det(Det),n1(N1)] 	add_goals [detAgreement(Det,N1)].

%% CP WH(+/-) SPECIFICATION

rhs [c1(Cbar)]          add_goals [X = + if Cbar has_feature wh(X)].
rhs [np(Np),c1(Cbar)]   add_goals [checkEmptySpecCP(Np,Cbar)].

:- multifile replace_rhs/2.

rhs [c2,relClNP] replace_rhs [opC2,relClNP].	  % currently unused

rhs [np,vgrid] replace_rhs [doNP,vgrid].	  % direct object
rhs [np,v1] replace_rhs [idoNP,v1].		  % indirect object

% for the overt wh-movement I suppose [Uli]

:- multifile spec/2.
spec(c1,np). 	spec(c1,pp).

%%% PRO CAN ONLY BE EXPLETIVE SUBJECT

proSubjRestriction(NP,I1) :-
	(\+ identifyPassive(I1) 
	-> addNotProConstraint(NP))
	; (addFeature(nonarg(_),NP),
	   constrainAGR(NP,[3,sg,[]])
	  ; addNotProConstraint(NP))
	if ec(NP).

% Overrides standard definition for empty NPs

ecNPFeatures(Fs) :- 
	mkFs([agr(_),
	      goal(case(Slot),nomOnlyWithPro(Slot,A,P)),
	      theta(_),
	      goal(a(A),nomOnlyWithPro(Slot,A,P)),
	      p(P),
	      ec(_)],Fs).

constrainAGR(NP,AGR) :-
	NP has_feature agr(_)
	-> intersectAGR(NP,AGR)
	;  addFeature(agr(AGR),NP).

addNotProConstraint(NP) :-
	NP has_feature p(P),
	NP has_feature a(A) with_constraint notPro(A,P).

notPro(A,P) :-
	P == + 
	-> A = +
	;  (A == - 
	   -> P = -
	   ;  true).

% pro only goes with nominative Case (subjects)

nomOnlyWithPro(Slot,A,P) :-
	A == -,
	P == +
	-> assigned(Slot),
	   Slot == nom
	;  true.

identifyPassive(I1) :-
	identifyVP(I1,VP),
	identifyPassiveVP(VP).

identifyPassiveVP(VP) :-
	VP has_feature passive
	-> true
	;  VP subcategorizes_for LowerVP,
	   cat(LowerVP,vp),
	   identifyPassiveVP(LowerVP).
	   
% temporary measurement against relative clauses

block adjunction rule np -> [relClNP,c2] ordered _.


%%% SUPPORT FOR WH(+/-) CP SPECIFICATION

checkEmptySpecCP(Np,Cbar) :- 
	X = + 
	if (isMatrixLevel, Np has_feature ec(_), Cbar has_feature wh(X)).

% Inherit [wh,op(+/-)] features from spec instead of head

rhs [det,n1] 		add_inherit plus(2,[1,[wh,op(_)]]).

%%% CASE MATCHING

matchCase(Set,X) :-
	atom(X) ->  
	in1(X,Set)
    ;   intersect(Set,X).

%%% SUPPORT FOR DETERMINER/N1 INTERACTION

%% no determiner option possible for: 
%%	1. non-common, or
%%	2. non-count, or    <-- proper names in German under this category
%%	3. plural count nouns only.

noDet(N1) :- 
       N1 has_feature count(C)
       -> ( C = '-' 
	  ; C = '+', 
	    intersectAGR(N1,[[],pl,[]]))
       ;  true.

opposite(+,-).
opposite(-,+).

detAgreement(Det,N1) :- 
	Det has_feature count(C),
	N1 has_feature count(C),
        Det has_feature d(agr(AgrD)),  % det-agr is hidden under d(...)
        N1 has_feature agr(AgrN),
	agreeAGR1(AgrD,AgrN),
	compatibleMCase(Det,N1),
	Det has_feature strong(Value),
	oppositeStrength(N1,Value).

oppositeStrength(N1,_Value) :-
	\+ N1 has_feature strong(_).
oppositeStrength(N1,V) :-
	opposite(V,W),
	N1 has_feature strong(W).

% NB. Y[morphC(_)] gets updated if necessary

compatibleMCase(X,Y) :-
	X has_feature morphC(XK),
	Y has_feature morphC(YK),
	matchMCase(XK,YK,Y).

matchMCase(XK,YK,Y) :-
	atom(XK) 
        -> (atom(YK) 
	   -> XK = YK
	   ;  in1(XK,YK),
	      addFeature(morphC(XK),Y))
	;  (atom(YK) 
	   -> in1(YK,XK)
	   ;  intersect(XK,YK,ZK),
	      (ZK = [K] 
	      -> addFeature(morphC(K),Y)
	      ;  addFeature(morphC(ZK),Y))).

% Adjective and noun interaction, taken from French [uli]
% erased the clause for postnominal adjectives [uli]
% and added case agreement

adjAgreement(A,N) :- 
	agreeAGR(A,N),
	compatibleMCase(A,N),
	sameStrength(N,V) if A has_feature strong(V).

sameStrength(N1,V) :-
	N1 has_feature strong(V1)
	-> V = V1
	;  true.
	
% compatibleCase(AssignedCase,MorphologicallyRealizedCase)
% mediates between morphC(case) and case(case)

compatibleCase(X,Y) :- 
	atom(Y) 
	-> X = Y
	;  (\+ atom(Y) -> in(X,Y)).

%% Case Transmission

% nothing special for German

:- initialization(no caseTransmission(_,_,_)).

:- initialization(no realizedAsMarker(_)).

%% Chain Formation conditions

% Can't scramble across C2
% NB. Too strong, should allow it for nonfinite clauses

chainLinkConditions(New,Head,_L,UpPath,_DownPath) :-
	\+ in(c2,UpPath)
	if (cat(Head,np), cat(New,np), New has_feature adjunct).

%% Must prevent vacuous scrambling

shiftRequest(n,es).

%%% Move-Alpha (D-structure to S-structure)

moves(CF,C) :- cat(CF,C), in(C,[np,adv]). % add i2,c2 later

%%%
%%% APPENDIX
%%%

%% Machine Code for non-vacuous scrambling
%
% NB. To be eliminated in the next release

% request state: 0 (Var) -> 1 (1)

shiftReq([X|ES]) :-
	open(X)
	-> true
	;  (X = r(1)
	   -> shiftReq(ES)
	   ;  shiftReq(ES)).

% consume one request

cReq(Item,ES,ESp) :-
	ES = [X|ES1],
	(open(X)
	-> ESp = ES
	;  (X = r(S)
	   -> (S == 1
	      -> ec(Item),
	         ESp = ES1
	      ;  ESp = [X|ES1p],
	         cReq(Item,ES1,ES1p))
	   ;  ESp = [X|ES1p],
	      cReq(Item,ES1,ES1p))).

% consume one (state 1) request and:
% (1) there can't be more than one
% (2) there can't be any state 0 requests

cReqX(Item,ES,ESp) :-
	ES = [X|ES1],
	(open(X)
	-> ESp = ES
	;  (X = r(S)
	   -> S == 1,
	      ec(Item),
	      noReq(ES1),
	      ESp = ES1
	   ;  ESp = [X|ES1p],
	      cReqX(Item,ES1,ES1p))).

noReq([X|ES]) :-
	open(X)
	-> true
	;  \+ X = r(_),
	   noReq(ES).
	

pushReq(ES,[r(_)|ES]).
