%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% PERIPHERY FRENCH
%%%
%%% (c) 1991, 1992, 1993, 1994  Sandiway Fong, NEC Research Institute, Inc.
%%%     1994 Martine Smets
%%% Language-particular operations + kludgey stuff

%%% S-STRUCTURE GRAMMAR ADDITIONS

% Have to be a bit picky in what we allow in [Spec,CP] for English
:- multifile spec/2.
spec(c1,exnp). 	
spec(c1,whadv).


:- multifile (rule)/1.

% no rule for empty c target of head movement
% i.e. in French, verbs don't raise to Comp

rule exnp -> [np(NP)] st (\+ ec(NP),NP has_feature wh) if isMatrixLevel.
rule whadv -> [adv(Adv)] st specCPWhAdv(Adv,es(i),es(o)).

rule adv -> trace.

:- multifile (adjunction)/1.

adjunction rule n -> [n,a] st lexicalProperty(a,grid([_],_)).


%       %% GRAMMAR RULE RESTRICTIONS

:- multifile (add_goals)/2.

% Inversion in French
rhs [c(C),i2(IP)] add_goals [whIfInv(C,IP)].

% Agreement between inverted clitic and NP spec of I2 in French
rhs [c,i2(IP)] add_goals [ensureAgr(IP)].

% No subjunctive in matrix clause
rhs [c(C),i2(IP)] add_goals [noSubjc(C,IP)].

% Agreement between past participle and preceding direct object (French)
rhs [v,vp(VP)] add_goals [pastPartAgr(VP)].

% Agreement between past participle/adjective and subject if verb is "to be"
rhs [np(NP),i1(I1)] add_goals [etreAgr(NP,I1)].

% Limitation of the use of subjunctive in clauses complement of verbs that 
% require it.
rhs [v(V),c2(C2)] add_goals [limitSubjc(V,C2)].

% Reduce non-determinism for adjunction
rhs [vsubcatvp,vp(VP)] add_goals [\+ adjoined(VP)].


% relClNP -> [overtNP] and np->[relClNP,CP[(+/-)wh]] 
rhs [overtNP] add_goals [push([selR(head(c2),addFeature(wh(_)))],es(i),es(o))].

% Relativized subjects with no overt relative pronoun are not allowed
% *[NP [NP the man][c2 Op [c1 [c] [i2 NP-e ...]]]]
rhs [relClNP,c2(CP)] add_goals [blockECSubjRelClause(CP)].

%%Adjective and N interaction

rhs [agridtheme(A),n0(N)]  add_goals [adjAgreement(A,N)].
rhs [n0(N),agridtheme(A)]  add_goals [adjAgreement(N,A)].

%%% SUPPORT FOR DETERMINER/N1 INTERACTION

%% Determiner and N1 interaction

rhs [n1(N1)]		add_goals [noDet(N1)].
rhs [det(Det),n1(N1)] 	add_goals [detAgreement(Det,N1)].
rhs [np(NP),n1(N1)] 	add_goals [npSpecHeadAgr(NP,N1)].

% limitation of pro in subject position
rhs [np(NP), i1(I1)]    add_goals [proRestriction(NP, I1)].

% to allow pro without theta-role
rhs [np(NP), i1(I1)]      add_goals [proExpletiveLink(NP,I1)].

% Inherit [wh,op(+/-)] features from spec instead of head

rhs [det,n1] 		add_inherit plus(2,[1,[wh,op(_)]]).

%% no determiner option possible for non-common nouns only.

noDet(N1) :- \+ N1 has_feature count(_). 

detAgreement(Det,N1) :- 
	Det has_feature count(C),
	N1 has_feature count(C),
	agreeAGR(Det,N1).

adjAgreement(A,N) :-
	agreeAGR(A,N).

npSpecHeadAgr(Spec,Head) :-
	Spec has_feature agr1(_)
	-> agreeAGR(Spec,agr1(_),Head,agr(_))
	;  agreeAGR(Spec,Head).

proRestriction(NP,I1) :-
	addNotProConstraint(NP) 
    if (ec(NP), \+ I1 has_feature noCasemark(+), \+ inverted(I1)).

addNotProConstraint(NP) :-
	NP has_feature p(P),
	NP has_feature a(A) with_constraint notPro(A,P).

notPro(A,P) :- \+ (A == -, P == + ).

% pro without theta-role (for expletive linking)

proExpletiveLink(NP,I1) :-
	I0 head_of I1,
    	(adjoined(I0,Cl) ->
	    (cat(Cl,cl),
	    Cl has_feature nonarg(+) ->
	    ensureProNonArg(NP)
	; true)
    ; true).


ensureProNonArg(NP) :-
	    ec(NP) ->
	    addFeatures([nonarg(+),noCoindex,linkTo(c2)],NP)
	; true.

% Inversion has taken place
inverted(I1) :-
	I0 head_of I1,
	identifyAdjoined(v,I0,V0),		  % defined in principles
	V0 has_feature wh.

% Past participle agrees with compl NP if ec(NP)
pastPartAgr(VP) :-
	V1 head_of VP,
	(V1 has_feature morph(_,ed(2)),NP complement_of VP, 
	\+ NP has_feature indirectObject
    ->  (ec(NP) ->
        agreeAGR(V1,NP)
    ;   true)
   ; true).
	

% Past participle/adj agrees with subject if aux "etre"
etreAgr(NP,I1) :-
	identifyVP(I1,VP),
	etreAgr1(NP,VP).

etreAgr1(NP,VP) :-
	V head_of VP,
	(V has_feature transmitAgr
    ->  ((XP complement_of VP,
   	(XP has_feature morph(_,ed(2)); cat(XP,ap)))
    ->  agreeAGR(NP,XP)
      ; (XP complement_of VP,
	 cat(XP,vp)
    ->  etreAgr1(NP,XP))
      ; true)
  ;   true).

limitSubjc(V,C2) :-
	IP complement_of C2,
	cat(IP,i2),
	(\+ V has_feature selR(goal(ensureSubj(X),X))
    -> (IP has_feature subj(-);IP has_feature inf([]))
    ;  true).

%%% CASE THEORY

% compatibleCase(AssignedCase,MorphologicallyRealizedCase)

compatibleCase(X,X).
compatibleCase(X,nonNom) :- X \== nom.
compatibleCase(X,nonAcc) :- X \== acc.

% Vacuous: no Case transmission for English.
% :- initialization(no caseTransmission(_)).

% Dative Case is realized as a`

realizedAsMarker(dat).
realizedAsMarker(gen).

caseRealizationMode(NP,Mode) :-
	NP has_feature compl
	-> Mode = case
	;  Mode = caseMorphC.

% Case Transmission
:- initialization(no caseTransmission(_,_,_)).

%%% EMPTY COMP

% To satisfy the WhInSyntax filter, 
%	empty matrix [C] is [+Wh] if inversion has taken place.
%	A feature licensed(wh) is added to Head of Comp 
%	if inversion has taken place.

emptyCompFeatures(Fs) :-
	isMatrixLevel
	-> mkFs([wh(_)],Fs)
	;  nullFeatures(Fs).

whIfInv(C,IP) :- whIfInvMatrix(C,IP) if IP has_feature matrix.

whIfInvMatrix(C,IP) :-
	I0 head_of IP,
	identifyAdjoined(v,I0,V0),
	(whPlus(C), addFeature(licensed(wh),C), addFeature(inversion,IP)) 
         if V0 has_feature wh.

ensureAgr(IP) :-
	I0 head_of IP,
	(\+ I0 has_feature matrix -> true
    ;   identifyAdjoined(v,I0,V0),
	(V0 has_feature wh
    ->	identifyAdjoined(cl,V0,Cl),
	Cl has_feature morphC(nom),
        Spec specifier_of IP,
	agreeAGR(Cl,Spec),
	coindex(Cl,Spec)
    ;    true)).

noSubjc(C,IP) :-
	ec(C) ->
	    (IP has_feature subj(-); IP has_feature inf([]))
	; true.

%%% Move-Alpha (D-structure to S-structure)

moves(CF,C) :- cat(CF,C), in(C,[np,adv]).


%%% RELATIVE CLAUSE RESTRICTIONS

% block subject to empty operator extraction, e.g. *the man Op t saw me
% where there is nothing in Comp (cf. the man that saw me)

blockECSubjRelClause(CP) :- \+ ecSpecHeadSubj(CP).

% [c2 Op [c1 ... [i2 NP-e ... ]]]
ecSpecHeadSubj(CP) :-
	cat(CP,c2),
	Spec specifier_of CP,
	ec(Spec),
	Subj subject_of CP,
	ec(Subj),
	Head head_of CP,
	ec(Head).

%% Chain Formation conditions

chainLinkConditions(New,Head,L,UpPath,DownPath) :-
	cat(New,C),
	linkCondition(C,New,Head,L,UpPath,DownPath).

% 1. antecedent c-commanded traces
% 2. base position iff adjunct position

linkCondition(adv,_,Trace,L,_,[]) :-
	Trace has_feature adjunct if L == [].

% Note: Case is (recursively) transmitted up the chain 
%	(from base trace towards head)
%	if Case is present on the original head.
%
%	This implies that Case assignment must be done before
%	chain formation.

linkCondition(np,Head,Old,_,UpPath,DownPath) :-
	Old has_feature case(Case),
	Head has_feature case(Case) if nonvar(Case),
	\+ vacuousTopicalization(Head,UpPath,DownPath).

vacuousTopicalization(Head,[i2,c1],[]) :- 
	cat(Head,np), \+ ec(Head), \+ Head has_feature wh.

%%% MISCELLANEOUS

%% Negation blocks I-lowering to V

%%blockILowering(ES) :- \+ popPTr(i,_,ES,_).	  % machine code

% Adv in [Spec,CP] st.
% Intermediate trace 	if empty category
% [Wh]Adv  		otherwise
% 
% NB. Assumes left to right

specCPWhAdv(Adv,ES,ESp) :-
	ec(Adv)
	-> make Adv have_feature ec(trace),
	   predictTrace(Adv,ES,ESp)
	;  Adv has_feature wh, 
	   predictTrace(Adv,ES,ESp).


% Enable lexical insertion constraints to be checked

shiftRequest(n,input).

shiftReq(Noun) :- call(G) if Noun has_feature lexInGoal(G).




