%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% PERIPHERY 
%%%
%%% Language-particular operations + kludgey stuff

%%% S-STRUCTURE GRAMMAR ADDITIONS

:- multifile spec/2.
spec(c1,np). 	spec(c1,pp).   

% Dutch Verb Raising

hmrule v with Fs -> [] add_option raiseV(Fs,input(i),es(i),es(o)).
right_bracket i2 idominated_by v1 substitute closeNL for close.

:- multifile (left_bracket)/1.
left_bracket i2 idominated_by v1 substitute openNL for open.
left_bracket xpdIP idominated_by i2 add_goals [verifyLookahead(input(i))].

:- multifile (bracket)/1.

bracket xpdIP idominated_by i2.

:- multifile (rule)/1.
% Availability of empty Comp 
rule empty c with Fs st isMatrixLevel, mkFs([wh(_)],Fs). 

% Allow the option of local rightwards CP/IP Extraposition
rule xpCP$c2 with Fs -> [] st rwmTrace(c2,Fs,input(i),es(i),es(o)).
rule xpCP -> [c2] st true.
rule xpIP$i2 with Fs -> [] st rwmTrace(i2,Fs,es(i),es(o)).
rule xpIP -> [i2] st true.

rule xIP -> [i2] st cpExtpd(es(i)).		  % for efficiency only
rule xpdCP -> [c2(CP)] st rwmChain(CP,es(i),es(o)), licenseXpdCP(CP).
rule xpdIP -> [i2(IP)] st rwmChainOpen(IP,es(i),es(o)).

% rule adv -> trace.

:- multifile (adjunction)/1.
adjunction rule i(IVV) -> [i(IV),v(VR)] st verbRaising(IV,VR,es(i),es(o),IVV).

adjunction rule i2 -> [xIP,xpdCP].
adjunction rule i2 -> [xIP,xpdIP].

rhs [c2,vgrid] replace_rhs [xpCP,vgrid].	  % option of CP extraposition
rhs [i2,vgrid] replace_rhs [xpIP,vgrid].	  % option of IP extraposition

:- multifile (app_goals)/2.

rhs [c2(CP),vgrid] app_goals [antiCaseCP(CP)]. % Dutch no Case for CP/IP
rhs [i2(IP),vgrid] app_goals [antiCaseIP(IP)]. % restriction

:- multifile (add_goals)/2.

% reduce non-determinism for adjunction
rhs [vp(VP),vsubcatvp] add_goals [\+ adjoined(VP)].

%% Determiner and N1 interaction

rhs [n1(N1)]		add_goals [noDet(N1)].
rhs [det(Det),n1(N1)] 	add_goals [detAgreement(Det,N1)].

% Inherit [wh,op(+/-)] features from spec instead of head
rhs [det,n1] 		add_inherit plus(2,[1,[wh,op(_)]]).


%%% SUPPORT FOR DETERMINER/N1 INTERACTION

%% no determiner option possible for: 
%%	1. non-common, or
%%	2. non-count, or
%%	3. plural count nouns only.

noDet(N1) :- \+ N1 has_feature count(_).
noDet(N1) :- N1 has_feature count(-).
noDet(N1) :- 
	N1 has_feature count(+),
	intersectAGR(N1,[[],pl,[]]).

detAgreement(Det,N1) :- 
	Det has_feature count(C),
	N1 has_feature count(C),
	agreeAGR(Det,N1).

% compatibleCase(AssignedCase,MorphologicallyRealizedCase)

compatibleCase(X,X).
compatibleCase(gen,acc).   % for 'proud of him'

% Case Transmission
:- initialization(no caseTransmission(_,_,_)).

:- initialization(no realizedAsMarker(_)).

%% Chain Formation conditions

chainLinkConditions(_New,_Head,_L,_UpPath,_DownPath).

%%% EMPTY COMP

% Empty C is Q only
emptyCompFeatures(Fs) :- mkFs([wh],Fs).

%%% Move-Alpha (D-structure to S-structure)

moves(CF,C) :- cat(CF,C), in(C,[np,adv]). % add i2,c2 later

%% Dutch differs from German (and archaic Dutch) in that the base
%% order is not possible. Traced to Case reasons.

antiCaseCP(CP) :- CP has_feature case(block) if \+ ec(CP).
antiCaseIP(IP) :- IP has_feature case(block) if \+ evacuated(IP).

evacuated(IP) :- ec(IP).
evacuated(IP) :-
	cat(IP,i2),
	IP has_feature ec(trace),
	VP complement_of IP,
	VP has_feature ec(trace).

%%% Verb Raising
%%% 
%%% NB.	1. Non-local movement, problematic for the compiler
%%%	2. Problematic for the ECP - use noECP(_) feature
%%% 	3. Low-level "assembly language" routines used

% basically adjoins V[inf(_)] to V producing [V[1] [V[1]] [I[I][V[inf(_)]]]]
verbRaising(IV,Vr,ES,ESp,IVIVr) :-
	adjoined(IV,V,I),
	popNL(I1,ES,ESp),
	Vr has_feature vRaising,
	hAdj(Vr,I1,IVr),
	hAdj(IVr,V,VIVr),
	hAdj(VIVr,I,IVIVr).
	

% Fs' = Trace features of the raised V
raiseV(Fsp,Input,ES,ESp) :-
	kOpen(ES,K),
	ithTr(v,K,[inf(_)],vRaising,Fs,Input),
	consFeature(noECP(_),Fs,Fsp),
	mkEC(v,Fs,V),				  % dummy
	recoverIfromV(I,V),
	addFeature(noECP(_),I),
	pushTr(I,ES,ES1),
	pushNL(I,ES1,ESp),			  % non-local push
	!.					  % green

% trace of rightwards movement
% push rw(i2/c2,ChainItem) onto environment stack
%
% Lemma: Extraposition not required in matrix clauses.

rwmTrace(C,Fs,ES,ESp) :-
	\+ isMatrixLevel,
	mkFs([ec(_)],Fs),
	mkEC(C,Fs,CP),
	phraseToChainItem(CP,Item),
	push([rw(C,Item)],ES,ESp).

rwmTrace(C,Fs,Input,ES,ESp) :-
	\+ isMatrixLevel,
	unboundedLookaheadTest(Input),
	mkFs([ec(_)],Fs),
	mkEC(C,Fs,CP),
	phraseToChainItem(CP,Item),
	push([rw(C,Item)],ES,ESp).

cpExtpd(ES) :-
	\+ \+ pop(rw(_,_),ES,_).

% extraposed clause
% form chain with trace

rwmChain(CP,ES,ESp) :-
	cat(CP,C),
	pop(rw(C,Trace),ES,ESp),
	phraseToChainItem(CP,Head),
	chainLink(Head,Trace,_,_),
	coindex(Head,Trace),
	instantiateChain([Head,Trace]).

rwmChainOpen(CP,ES,ESp) :-
	cat(CP,C),
	popUpOne(rw(C,Trace),ES,ESp),
	phraseToChainItem(CP,Head),
	chainLink(Head,Trace,_,_),
	coindex(Head,Trace),
	instantiateChain([Head,Trace]).

licenseXpdCP(CP) :-
	notEmptyOperator(NP) if NP specifier_of CP.

:- dynamic shiftRequest/2.
