:- ensure_loaded(opDecls).

:- multifile term_expansion/2.
:- dynamic term_expansion/2.

% Data

translate(if,2,(X if Y),[X,A,Y,B],(B -> A ; true)).
translate(iff,2,(X iff Y),[X,A,Y,B],(A -> B ; \+ B)).
translate(unless,2,(X unless Y),[X,A,Y,B],(B -> true ; A)).

translate(in_all_configurations,2,
	  in_all_configurations(X,where(CF,CONDS)),
	  in_all_configurations(X,where(CF,CONDSp))) :-
	expandSugarCs(CONDS,CONDSp,Z),
	Z == y.

translate(collect_all_configurations,2,
	  collect_all_configurations(Name,where(CF,CONDS)),
	  collect_all_configurations(Name,where(CF,CONDSp))) :-
	expandSugarCs(CONDS,CONDSp,Z),
	Z == y.

translate(collect,2,
	  collect(Name,in_all_configurations(X,where(CF,CONDS))),
	  collect(Name,in_all_configurations(X,where(CF,CONDSp)))) :-
	expandSugarCs(CONDS,CONDSp,Z),
	Z == y.

translate(exists_some_configuration,2,
	  exists_some_configuration(Name,where(CF,CONDS)),
	  exists_some_configuration(Name,where(CF,CONDSp))) :-
	expandSugarCs(CONDS,CONDSp,Z),
	Z == y.

translate(those,2,
	  those(Call,satisfying(in_list(X,List),Goals)),
	  those(Call,satisfying(in_list(X,List),Goalsp))) :-
	expandSugar(Goals,Goalsp,Z),
	Z == y.

translate(each,2,
	  each(Call,satisfies(in_list(X,List),Goals)),
	  each(Call,satisfies(in_list(X,List),Goalsp))) :-
	expandSugar(Goals,Goalsp,Z),
	Z == y.

translate(each,2,
	  each(Call,satisfying(in_list(X,List),Goals)),
	  each(Call,satisfying(in_list(X,List),Goalsp))) :-
	expandSugar(Goals,Goalsp,Z),
	Z == y.

translate(exists,2,
	  exists(Call,satisfies(in_list(X,List),Goals)),
	  exists(Call,satisfies(in_list(X,List),Goalsp))) :-
	expandSugar(Goals,Goalsp,Z),
	Z == y.

translate(exists,2,
	  exists(Call,satisfying(in_list(X,List),Goals)),
	  exists(Call,satisfying(in_list(X,List),Goalsp))) :-
	expandSugar(Goals,Goalsp,Z),
	Z == y.

translate(append_lists,2,
	  append_lists(Call,produced_by(Lp,satisfying(in_list(X,List),Goals))),
	  append_lists(Call,produced_by(Lp,satisfying(in_list(X,List),Goalsp)))) :-
	expandSugar(Goals,Goalsp,Z),
	Z == y.

expandSugarCs(else(Cond,Conds),else(Condp,Condsp),Z) :-
	!,					  % red
	expandSugarC(Cond,Condp,X),
	expandSugarCs(Conds,Condsp,Y),
	propagate(X,Y,Z).
expandSugarCs(Cond,Condp,X) :-
	expandSugarC(Cond,Condp,X).

expandSugarC(then(P,Q),then(Pp,Qp),Z) :-
	expandSugar(P,Pp,X),
	expandSugar(Q,Qp,Y),
	propagate(X,Y,Z).

expandSugar(A,call(A),y) :-
	var(A),
	!,					  % red
	write('Warning: variable used instead of call!'),
	nl.

expandSugar((A,B),(Ap,Bp),Z) :-
	!,
	expandSugar(A,Ap,X),	
	expandSugar(B,Bp,Y),
	propagate(X,Y,Z).

expandSugar((A;B),(Ap;Bp),Z) :-
	!,
	expandSugar(A,Ap,X),	
	expandSugar(B,Bp,Y),
	propagate(X,Y,Z).

expandSugar((A->B),(Ap->Bp),Z) :-
	!,
	expandSugar(A,Ap,X),	
	expandSugar(B,Bp,Y),
	propagate(X,Y,Z).

expandSugar((\+ A),(\+ Ap),X) :-
	!,
	expandSugar(A,Ap,X).

expandSugar(A,Ap,y) :-
	functor(A,F,Arity),
	translate(F,Arity,A,Args,Ap),
	!,
	expandSugarP(Args).

expandSugar(A,Ap,X) :-
	expandSugarF(A,Ap,X).

expandSugar(A,A,n).

expandSugarP([]).
expandSugarP([A,B|Args]) :-
	expandSugar(A,Ap,X),
	(X == y 
	-> B = Ap
	;  B = A),
	!,					  % green
	expandSugarP(Args).
	
expandSugarF(A,Ap,y) :-
	functor(A,F,Arity),
	translate(F,Arity,A,Ap),
	!.

propagate(X,Y,Z) :-
	X == y
	-> Z = y
	;  (Y == y
	   -> Z = y
	   ;  Z = n).

macro_expansion((H :- B),[(H :- Bp)]) :-
	!,					  % red
%	trace,
	expandSugar(B,Bp,Z),
	Z == y.
%	write('Expanded Rule: '),
%	functor(H,F,Arity),
%	write(F/Arity),
%	nl.
%	portray_clause((H :- Bp)),
%	nl.

macro_expansion(F,[Fp]) :-
	expandSugarF(F,Fp,X),
	X == y.
%	write('Expanded Fact: '),
%	functor(F,Fn,Arity),
%	write(Fn/Arity),
%	nl.
%	portray_clause(Fp),
%	nl.

defineTermExpansionHook :-
	assertz((term_expansion(T,Tp) :- macro_expansion(T,Tp))).

term_expansion(T,Tp) :-
	macro_expansion(T,Tp).

