:- initialization((no lexFeature(_,_))).

% 9/5/92  Tim 
% 4/19/94 Sandiway	Added bunch of lexical items
%			Merged lexical ambiguity except for:
%				om, moeilijk,elke,verlaten,ontmoet
% 21/6/94 Uli           adopted Dutch settings for German

%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% EXPORT
%%%	term(C)				terminals
%%%	lexicon(Word,C,Fs)		Word has category label C and feature list Fs
%%%	probeLexicon(Word)		Word is in lexicon
%%%	vMorphToFs(Base,Form,Features)	TNS/AGR features
%%%	inf(Verb,Type)
%%%	relevant(C)			constraints imposed by markers apply to C
%%% REFERENCES
%%%	(list processing)		utilities

term(n). term(a). term(v). term(p). term(c).
term(adv). term(det). term(neg). term($).

%%% 	Most lexical entries are stored directly as lex(Word,Category,Features)
%%%	Non-base forms require inference: 
%%%	1. plural nouns		all features except agr(_) inherited from the sg. form
%%%	2. nominalized verbs	inherits verb features except morph(_,_)
%%%	3. non-base verb forms	all features except morph(_,_) inherited from the base form

lexicon(Word,C,Fs) :- lex(Word,C,Fs).		% directly available
lexicon(Form,v,Fs) :-				% non-base verb forms
	lex(Form,v,Base,F1),
	verbFeatures(Base,F2),
	append1(F1,F2,Fs).
lexicon(Form,v,Fs) :-
	lex(Form,v,Base,F1,Oneof),
        verbFeatures(Base,F2),
        append1(F1,F2,Fts),
        append1(Fts,[oneof(_,Oneof)],Fs).

probeLexicon(Word) :- lex(Word,_,_) ; lex(Word,_,_,_).

%%% NEGATION

lex(nicht,neg,[polarity(-)]).

%% Prepositions
lex(von,p,[grid([],[agent]),adjR([goal(unsaturatedExtRole(X,agent),X)]),
	  predicate(agent),doCase(acc)]).
lex(in,p,[grid([],[location]),predicate(location),doCase(dat)]).
lex(ohne,p,[grid([],[reducedProp]),selR([not(feature(inf([])))]),predicate(manner),selR(addFeature(case(acc)))]). % use+ing 
lex(nach,p,[grid([],[reducedProp]),selR([not(feature(inf([])))]),predicate(manner),doCase(acc)]). % use+ing
lex(fr,p,[grid([],[reducedProp]),selR([not(feature(inf([])))]),predicate(manner),doCase(acc)]). % use+ing
lex(an,p,[grid([],[location]),predicate(time),doCase(acc)]).


%% Adverbs

lex(wie,adv,[adjoin(right),wh]).
lex(warum,adv,[adjoin(right),wh]).
lex(vollstndig,adv,[adjoin(left),predicate(manner)]).
lex(wach,adv,[adjoin(left),predicate(manner)]).
lex(aufrecht,adv,[adjoin(left),predicate(manner)]).
lex(hier,adv,[adjoin(right),predicate(location)]).
lex(spt,adv,[adjoin(right),predicate(time)]).
lex(gestern,adv,[adjoin(right),predicate(time)]).
lex(mglich,adv,[adjoin(right),predicate(manner)]).


%% Determiners
%%	Can combine with nouns as long as the count( )-features agree
%%      d(agr(...)) introduced because possesive pronouns show agr.
%%      with their heads and the gender of their antecedent
%%	Six classes of determiners:
%%	Class Examples                     Features
%%	1     der, die, welch-             count(_) d(agr([3,[],[]]))
%%	2     einige, alle                 count(_) d(agr([3,[pl,m],[]]))
%%	3                                  count(_) d(agr([3,[sg,m],[]])
%%	4     manche                       count(+) d(agr([3,pl,[]]))
%%	5     ein,                         count(+) d(agr(([3,sg,[]]))
%%	6                                  count(-) d(agr(([3,m,[]]))
%%	Determiners and quantifier types [Hornstein]:
%%	Type	Examples	Features
%%	1	der, die, das	op(-)
%%	2	jeder, einige	op(+)
%%	op(+) elements that are moved by QR and form operator-variable structures
%%	op(-) not moved by QR
%%      indefinites are somewhat problematic, we let them do QR


%% German determiners agree in case with their nominal heads

% The indefinite determiner

lex(eine,det,[count(+),d(agr([3,sg,f])),op(-),strong(-),morphC([acc,nom])]).
lex(einer,det,[count(+),d(agr([3,sg,f])),op(-),strong(-),morphC([dat,gen])]).
lex(ein,det,[count(+),d(agr([3,sg,[m,n]])),morphC(nom),op(-),strong(-)]).
lex(eines,det,[count(+),d(agr([3,sg,[m,n]])),morphC(gen),op(-),strong(-)]).
lex(einem,det,[count(+),d(agr([3,sg,[m,n]])),morphC(dat),op(-),strong(-)]).
lex(einen,det,[count(+),d(agr([3,sg,[m,n]])),morphC(acc),op(-),strong(-)]).

% 'enough'

lex(genug,det,[count(_),d(agr([3,[pl,m],[]])),morphC([nom,acc,dat,gen]),op(+),strong(+)]).


% Possesive pronouns
% masculine and neuter

lex(sein,det,[count(_),d(agr([3,sg,[m,n]])),morphC(nom),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seine,det,[count(_),d(agr([3,sg,f])),agr([3,sg,[m,n]]),op(-),strong(-),morphC([nom,acc])]).
lex(seines,det,[count(_),d(agr([3,sg,[m,n]])),morphC(gen),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seinem,det,[count(_),d(agr([3,sg,[m,n]])),morphC(dat),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seinen,det,[count(_),d(agr([3,sg,m])),morphC(acc),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seiner,det,[count(_),d(agr([3,sg,f])),agr([3,sg,[m,n]]),op(-),strong(-),morphC([gen,dat])]).
lex(sein,det,[count(_),d(agr([3,sg,n])),morphC(acc),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seine,det,[count(_),d(agr([3,pl,[]])),agr([3,sg,[m,n]]),op(-),strong(-),morphC([acc,nom])]).
lex(seiner,det,[count(_),d(agr([3,pl,[]])),morphC(gen),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seinen,det,[count(_),d(agr([3,pl,[]])),morphC(dat),agr([3,sg,[m,n]]),op(-),strong(-)]).
lex(seine,det,[count(_),d(agr([3,pl,[]])),morphC(acc),agr([3,sg,[m,n]]),op(-),strong(-)]).

% feminine

lex(ihr,det,[count(_),a(-),p(+),d(agr([3,sg,[m,n]])),morphC(nom),agr([3,sg,f]),op(-),strong(-)]).
lex(ihre,det,[count(_),a(-),p(+),d(agr([3,sg,f])),agr([3,sg,f]),op(-),strong(-),morphC([nom,acc])]).
lex(ihres,det,[count(_),a(-),p(+),d(agr([3,sg,[m,n]])),morphC(gen),agr([3,sg,f]),op(-),strong(-)]).
lex(ihrer,det,[count(_),a(-),p(+),d(agr([3,sg,f])),agr([3,sg,f]),op(-),strong(-),morphC([gen,dat])]).
lex(ihrem,det,[count(_),a(-),p(+),d(agr([3,sg,[m,n]])),morphC(dat),agr([3,sg,f]),op(-),strong(-)]).
lex(ihren,det,[count(_),a(-),p(+),d(agr([3,sg,m])),morphC(acc),agr([3,sg,f]),op(-),strong(-)]).
lex(ihr,det,[count(_),a(-),p(+),d(agr([3,sg,n])),morphC(acc),agr([3,sg,f]),op(-),strong(-)]).
lex(ihre,det,[count(_),a(-),p(+),d(agr([3,pl,[]])),agr([3,sg,f]),op(-),strong(-),morphC([acc,nom])]).
lex(ihrer,det,[count(_),a(-),p(+),d(agr([3,pl,[]])),morphC(gen),agr([3,sg,f]),op(-),strong(-)]).
lex(ihren,det,[count(_),a(-),p(+),d(agr([3,pl,[]])),morphC(dat),agr([3,sg,f]),op(-),strong(-)]).

% the definite determiner

%lex(der,det,[count(_),d(agr([3,sg,m])),morphC(nom),op(-),strong(+)]).
%lex(der,det,[count(_),d(agr([3,sg,f])),op(-),strong(+),morphC([gen,dat])]).
%lex(der,det,[count(_),d(agr([3,pl,[]])),morphC(gen),op(-),strong(+)]).
%lex(das,det,[count(_),d(agr([3,sg,n])),op(-),strong(+),morphC([acc,nom])]).
%lex(des,det,[count(_),d(agr([3,sg,[m,n]])),morphC(gen),op(-),strong(+)]).
%lex(dem,det,[count(_),d(agr([3,sg,[m,n]])),morphC(dat),op(-),strong(+)]).
%lex(den,det,[count(_),d(agr([3,sg,m])),morphC(acc),op(-),strong(+)]).
%lex(den,det,[count(_),d(agr([3,pl,[]])),morphC(dat),op(-),strong(+)]).
%lex(die,det,[count(_),d(agr([3,sg,f])),op(-),strong(+),morphC([acc,nom])]).
%lex(die,det,[count(_),d(agr([3,pl,[]])),op(-),strong(+),morphC([acc,nom])]).

lex(der,det,[count(_),op(-),strong(+),
	oneof(_,[[d(agr([3,sg,m])),morphC(nom)],
	[d(agr([3,sg,f])),morphC([gen,dat])],
	[d(agr([3,pl,[]])),morphC(gen)]])]).
lex(die,det,[count(_),op(-),strong(+),
	oneof(_,[[d(agr([3,sg,f])),morphC([nom,acc])],
	[d(agr([3,pl,[]])),morphC([nom,acc])]])]).
lex(das,det,[count(_),d(agr([3,sg,n])),op(-),morphC([nom,acc])]).
lex(des,det,[count(_),d(agr([3,sg,[m,n]])),morphC(gen),op(-),strong(+)]).
% lex(der,det,[count(_),d(agr([3,sg,f])),morphC(gen),op(-),strong(+)]).
% lex(des,det,[count(_),d(agr([3,sg,n])),morphC(gen),op(-),strong(+)]).
lex(dem,det,[count(_),d(agr([3,sg,[m,n]])),morphC(dat),op(-),strong(+)]).
% lex(der,det,[count(_),d(agr([3,sg,f])),morphC(dat),op(-),strong(+)]).
% lex(dem,det,[count(_),d(agr([3,sg,n])),morphC(dat),op(-),strong(+)]).
lex(den,det,[count(_),op(-),strong(+),
	oneof(_,[[d(agr([3,sg,m])),morphC(acc)],
		 [d(agr([3,pl,[]])),morphC(dat)]])]).
% lex(die,det,[count(_),d(agr([3,sg,f])),morphC(acc),op(-),strong(+)]).
% lex(das,det,[count(_),d(agr([3,sg,n])),morphC(acc),op(-),strong(+)]).
% lex(die,det,[count(_),d(agr([3,pl,[]])),morphC(nom),op(-),strong(+)]).
% lex(der,det,[count(_),d(agr([3,pl,[]])),morphC(gen),op(-),strong(+)]).
% lex(den,det,[count(_),d(agr([3,pl,[]])),morphC(dat),op(-),strong(+)]).
% lex(die,det,[count(_),d(agr([3,pl,[]])),morphC(acc),op(-),strong(+)]).

% wh-determiner
 
lex(welcher,det,[count(_),d(agr([3,sg,m])),wh,morphC(nom),strong(+)]).
lex(welche,det,[count(_),d(agr([3,sg,f])),wh,strong(+),morphC([nom,acc])]).
lex(welchen,det,[count(_),d(agr([3,sg,m])),wh,strong(+),morphC([gen,acc])]).
lex(welcher,det,[count(_),d(agr([3,sg,f])),wh,strong(+),morphC([gen,dat])]).
lex(welchem,det,[count(_),d(agr([3,sg,[m,n]])),wh,morphC(dat),strong(+)]).
lex(welches,det,[count(_),d(agr([3,sg,n])),wh,strong(+),morphC([nom,acc])]).
lex(welche,det,[count(_),d(agr([3,pl,[]])),morphC(nom),strong(+)]).
lex(welcher,det,[count(_),d(agr([3,pl,[]])),morphC(gen),strong(+)]).
lex(welchen,det,[count(_),d(agr([3,pl,[]])),morphC(dat),strong(+)]).
lex(welche,det,[count(_),d(agr([3,pl,[]])),morphC(acc),strong(+)]).


%% Nouns
%% 	Obligatory features
%% 	1. Anaphoric: a(+/-), Pronominal: p(+/-) for Binding Theory
%% 	2. Agreement: agr([Per,Num,Gen]) 
%%	3. O-grid: grid(Ext,Int) 
%% 	Optional features
%% 	1. Morphologically realized Case: morphC(C)
%% 	2. Common nouns: count(+/-/_) (not present for proper nouns)
%%	3. Quantifiers: op(+/-) 
%%	4. Wh-nouns: wh

% Pleonastic elements
% 'es' can occur in many functions, weather 'es', V2-'es' in passives, middles
% and with some Psych Verbs

lex(es,n,[grid([],[]),agr([3,[],[]]),morphC(nom),nonarg(+)]).

% for partial wh-movement, has to link to wh(+) element in
% the Spec of a CP, that is the Complement of next Verbs down
% then 'was' becomes wh(+), and the lower wh(+) disappears
% Can be recursive

lex(was,n,[grid([],[]),a(_),p(_),morphC(_),linkTo(wh),nonarg(+)]).

% Proper nouns, occur optionally with determiner, count(-) should do the job
lex(irene,n,[grid([],[]),a(-),p(-),agr([3,sg,f]),count(-),morphC([nom,acc,dat])]).
lex(irenes,n,[grid([],[]),a(-),p(-),agr([3,sg,f]),count(-), morphC(gen)]).

lex(uli,n,[grid([],[]),a(-),p(-),agr([3,sg,m]), count(-),morphC([nom,acc,dat])]).
lex(ulis,n,[grid([],[]),a(-),p(-),agr([3,sg,m]), morphC(gen), count(-)]).

lex(klaus,n,[grid([],[]),a(-),p(-),agr([3,sg,m]), count(-), morphC([nom,acc,dat,gen])]).
lex(klausens,n,[grid([],[]),a(-),p(-),agr([3,sg,m]), morphC(gen), count(-)]).

lex(hans,n,[grid([],[]),a(-),p(-),agr([3,sg,m]), count(-), morphC([nom,acc,dat,gen])]).
lex(hansens,n,[grid([],[]),a(-),p(-),agr([3,sg,m]), morphC(gen), count(-)]).

% lex(zeit,n,[grid([],[]),a(-),p(-),agr([3,sg,f]), morphC(nom),count(_),nonarg,predicate(time)]).
       
% Anaphors and pronominals
% for German a distinction between the phi-features and
% agreement is needed
% the polite use of Pl. 3rd Person 'sie' for 2nd person Sg/Pl isn't implemented
% for non-3rd Person pronoun and anaphor are not distinct

lex(einander,n,[grid([],[]),a(+),p(-),agr([3,pl,[m,f]]), morphC([dat,acc])]).

lex(sich,n,[grid([],[]),a(+),p(-),agr([3,[],[]]), morphC([dat,acc])]).

lex(ich,n,[grid([],[]),morphC(nom),a(_),p(_),agr([1,sg,[m,f]])]).
lex(mich,n,[grid([],[]),morphC(acc),a(_),p(_),agr([1,sg,[m,f]])]).
lex(meiner,n,[grid([],[]),morphC(gen),a(_),p(_),agr([1,sg,[m,f]])]).
lex(mir,n,[grid([],[]),morphC(dat),a(_),p(_),agr([1,sg,[m,f]])]).

lex(du,n,[grid([],[]),morphC(nom),a(-),p(+),agr([2,sg,[m,f]])]).
lex(deiner,n,[grid([],[]),morphC(gen),a(-),p(+),agr([2,sg,[m,f]])]).
lex(dir,n,[grid([],[]),morphC(dat),a(-),p(+),agr([2,sg,[m,f]])]).
lex(dich,n,[grid([],[]),morphC(acc),a(-),p(+),agr([2,sg,[m,f]])]).

lex(er,n,[grid([],[]),morphC(nom),a(-),p(+),agr([3,sg,m])]).
lex(seiner,n,[grid([],[]),morphC(get),a(-),p(+),agr([3,sg,m])]).
lex(ihm,n,[grid([],[]),morphC(dat),a(-),p(+),agr([3,sg,m])]).
lex(ihn,n,[grid([],[]),morphC(acc),a(-),p(+),agr([3,sg,m])]).

lex(sie,n,[grid([],[]),morphC(nom),a(-),p(+),agr([3,sg,f])]).
lex(ihrer,n,[grid([],[]),morphC(get),a(-),p(+),agr([3,sg,f])]).
lex(ihr,n,[grid([],[]),a(-),p(+),agr([3,sg,f]),morphC([dat,acc])]).

lex(es,n,[grid([],[]),a(-),p(+),agr([3,sg,n]),morphC([nom,acc])]).
lex(seiner,n,[grid([],[]),morphC(get),a(-),p(+),agr([3,sg,n])]).
lex(ihm,n,[grid([],[]),morphC(dat),a(-),p(+),agr([3,sg,n])]).

lex(wir,n,[grid([],[]),morphC(nom),a(-),p(+),agr([1,pl,[m,f]])]).
lex(unser,n,[grid([],[]),morphC(gen),a(-),p(+),agr([1,pl,[m,f]])]).
lex(uns,n,[grid([],[]),a(-),p(+),agr([1,pl,[m,f]]),morphC([dat,acc])]).

lex(ihr,n,[grid([],[]),morphC(nom),a(-),p(+),agr([2,pl,[m,f]])]).
lex(euer,n,[grid([],[]),morphC(gen),a(-),p(+),agr([2,pl,[m,f]])]).
lex(euch,n,[grid([],[]),a(-),p(+),agr([2,pl,[m,f]]),morphC([dat,acc])]).

lex(sie,n,[grid([],[]),a(-),p(+),agr([3,pl,[m,f,n]]),morphC([nom,acc])]).
lex(ihrer,n,[grid([],[]),morphC(get),a(-),p(+),agr([3,pl,[m,f,n]])]).
lex(ihnen,n,[grid([],[]),morphC(dat),a(-),p(+),agr([3,pl,[m,f,n]])]).


% Quantifier nouns
lex(jeder,n,[grid([],[]),a(-),p(-),agr([3,sg,m]),op(+)]).
lex(jemand,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),op(+)]).

% Wh-nouns
lex(wer,n,[grid([],[]),a(-),p(-),agr([3,[],[m,f]]),wh,morphC(nom)]).
lex(wessen,n,[grid([],[]),a(-),p(-),agr([3,[],[m,f,n]]),wh,morphC(gen)]).
lex(wem,n,[grid([],[]),a(-),p(-),agr([3,[],[m,f]]),wh,morphC(dat)]).
lex(wen,n,[grid([],[]),a(-),p(-),agr([3,[],[m,f]]),wh,morphC(acc)]).
lex(was,n,[grid([],[]),a(-),p(-),agr([3,[],n]),wh,morphC([nom,acc])]).
%lex(wem,n,[grid([],[]),a(-),p(-),agr([3,[],n]),wh,morphC(dat)]). %semantically impossible?




% Common nouns
lex(student,n,[grid([],[]),a(-),p(-),agr([3,sg,m]),count(+), morphC(nom)]).
lex(studenten,n,[grid([],[]),a(-),p(-),agr([3,sg,m]),count(+), morphC([gen,dat,acc])]).
lex(studenten,n,[grid([],[]),a(-),p(-),agr([3,pl,m]),count(_), morphC([nom,gen,dat,acc])]).

lex(studentin,n,[grid([],[]),a(-),p(-),agr([3,sg,f]),count(+),morphC([nom,gen,dat,acc])]).
lex(studentinnen,n,[grid([],[]),a(-),p(-),agr([3,pl,f]),count(_), morphC([nom,acc,dat,gen])]).

lex(beamter,n,[grid([],[]),a(-),p(-),agr([3,sg,m]),count(+),morphC(nom),strong(+)]).
lex(beamte,n,[grid([],[]),a(-),p(-),agr([3,sg,m]),count(+),morphC(nom),strong(-)]).
lex(beamten,n,[grid([],[]),a(-),p(-),agr([3,sg,m]),count(+),morphC([gen,acc,dat])]).
lex(beamten,n,[grid([],[]),a(-),p(-),agr([3,pl,m]),count(+),morphC([nom,gen,acc,dat])]).

lex(note,n,[grid([],[]),a(-),p(-),agr([3,sg,f]),count(+),morphC([nom,gen,dat,acc])]).
lex(noten,n,[grid([],[]),a(-),p(-),agr([3,pl,f]),count(_), morphC([nom,acc,dat,gen])]).


lex(artikel,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC([nom,acc,dat])]).
lex(artikels,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC([gen])]).
lex(auto,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC([nom,acc,dat])]).
lex(autos,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC([gen])]).
lex(milchmann,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC([nom,acc,dat])]).
lex(milchmanne,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC([dat])]).
lex(milchmanns,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC([gen])]).
lex(junge,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(gebude,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(nom)]).
lex(bus,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(kuchen,n,[grid([],[]),a(-),p(-),count(_),agr([3,[],m]), morphC(nom)]).
lex(katze,n,[grid([],[]),a(-),p(-),count(+),agr([3,[],f]), morphC(nom)]).
lex(kse,n,[grid([],[]),a(-),p(-),count(+),agr([3,[],m]), morphC(nom)]).
lex(dieb,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,[m,f]]), morphC(nom)]).
lex(schuster,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(stadt,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(demonstration,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]).
lex(explosion,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]).
lex(brand,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(feuer,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(nom)]).
lex(eis,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n]), morphC(nom)]).
lex(anwltin,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]).
lex(lgner,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(mann,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(nec,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,m]), morphC(nom)]).
lex(spielplatz,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(polizei,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,f]), morphC(nom)]).
lex(polizist,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(polizistin,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]).
lex(problem,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(nom)]).
lex(plan,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(rennen,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(nom)]).
lex(ratte,n,[grid([],[]),a(-),p(-),count(+),agr([3,[],f]), morphC(nom)]).
lex(bericht,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(geschichte,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]). % story
lex(zeit,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,f]), morphC(nom)]).
lex(dies,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n]), morphC(nom)]).
lex(frau,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]).
lex(oma,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]). % grandma
lex(opa,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]). % grandma
lex(wettkampf,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(arbeiter,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(film,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).

% Nouns with O-grids
lex(buch,n,[grid([[possessor]],[]),a(-),p(-),count(+),agr([3,sg,n]),morphC(nom,acc,dat)]).
lex(buchs,n,[grid([[possessor]],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(gen)]).
lex(buche,n,[grid([[possessor]],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(dat)]).
lex(buches,n,[grid([[possessor]],[]),a(-),p(-),count(+),agr([3,sg,n]), morphC(gen)]).
lex(bier,n,[grid([[possessor]],[]),a(-),p(-),count(_),agr([3,sg,n]), morphC(nom)]).
lex(vater,n,[grid([[possessor]],[]),a(-),p(-),count(_),agr([3,sg,m]), morphC(nom)]).
lex(mbel,n,[grid([possessor],[]),a(-),p(-),count(-),agr([3,pl,n]), morphC(nom)]).
lex(mutter,n,[grid([possessor],[]),a(-),p(-),count(_),agr([3,sg,f]), morphC(nom)]).
lex(schild,n,[grid([possessor],[theme]),a(-),p(-),count(+),agr([3,sg,n]), morphC(nom)]).
lex(lehrer,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,m]), morphC(nom)]).
lex(lehrerin,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,f]), morphC(nom)]).

% Non-base noun forms
% TRANSLATE
lex(flaschen,n,[grid([],[]),a(-),p(-),count(+),agr([3,pl,n]), morphC(nom)]). % bottles
%lex(geloven,n,[agr([3,pl,n])|F]) :- nounFeatures(geloof,F).
lex(bcher,n,[agr([3,pl,n])|F]) :- nounFeatures(buch,F).
%lex(gebouwen,n,[agr([3,pl,n])|F]) :- nounFeatures(gebouw,F).
%lex(bussem,n,[agr([3,pl,n])|F]) :- nounFeatures(bus,F).
%lex(steden,n,[agr([3,pl,n])|F]) :- nounFeatures(stad,F).
%lex(vertrekken,n,[agr([3,pl,n])|F]) :- nounFeatures(vertrek,F).
%lex(mannen,n,[agr([3,pl,m])|F]):- nounFeatures(man,F).
%lex(moeders,n,[agr([3,pl,f])|F]) :- nounFeatures(moeder,F).
%lex(schilderijen,n,[agr([3,pl,n])|F]) :- nounFeatures(schilderij,F).
%lex(leraren,n,[agr([3,pl,[m,f]])|F]) :- nounFeatures(leraar,F).

% Nominalized verbs
% TRANSLATE
lex(geloof,n,[count(+),agr([3,sg,[]]),a(-),p(-)|F]) :- 
	verbToNounFeatures(geloven,F).
lex(claim,n,[count(+),agr([3,sg,[]]),a(-),p(-)|F]) :- 
	verbToNounFeatures(claimen,F).
lex(vertrek,n,[count(+),agr([3,sg,n]),a(-),p(-)|F]) :- 
	verbToNounFeatures(vertrekken,F).
lex(vernietiging,n,[count(-),agr([3,m,n]),a(-),p(-)|F]) :- 
	verbToNounFeatures(vernietigen,F).
lex(vernietiging,n,[count(-),agr([3,m,n]),a(-),p(-),grid([],[patient])]).
lex(gevecht,n,[count(+),agr([3,sg,[]]),a(-),p(-)|F]) :- 
	verbToNounFeatures(vechten,F).

% Verbs - base forms
%
% Obligatory elements
% 1. grid(Ext,Int) denotes the O-grid
% 2. morph(Base,[]/ing/s/ed(1)/ed(2)) 
% Optional features
% 1. ecm(opt/oblig) for ECM verbs
% 2. noCasemark(+) for technically intransitive verbs
% 3. subcat(C$Fs,Fs1) subcategorizes for an element of category C 
%    with feature restriction list Fs.
%    feature list Fs1 will be appended to the feature list of C

lex(essen,v,[morph(essen,[]),grid([agent],[patient]),auxSelect(haben)]).
lex(glauben,v,[morph(glauben,[]),grid([agent],[proposition]),auxSelect(haben)]).
lex(lesen,v,[morph(lesen,[]),grid([agent],[patient]),auxSelect(haben)]).
lex(strzen,v,[morph(strzen,[]),grid([],[theme]),noCasemark(+),auxSelect(sein)]).
lex(helfen,v,[morph(helfen,[]),grid([agent],[recipient]),doCase(dat),auxSelect(haben)]).
lex(lachen,v,[morph(lachen,[]),grid([agent],[]),auxSelect(haben)]).
lex(mgen,v,[morph(mgen,[]),grid([agent],[patient]),auxSelect(haben)]).
lex(fragen,v,[morph(fragen,[]),grid([agent],[proposition]),
	      selR(head(c2),goal(ensureWhComp(X),X)),auxSelect(haben)]).
lex(geben,v,[morph(geben,[]),grid([agent],[theme,goal]),idoCase(dat),auxSelect(haben)]).
lex(sehen,v,[morph(sehen,[]),grid([agent],[proposition]),ecm(oblig),auxSelect(haben)]).
lex(haben,v,[morph(haben,[]),grid([agent],[theme]),auxSelect(haben)]).

lex(regnen,v,[morph(regnen,[]),grid([],[]),blockTheta,auxSelect(haben)]).
% the parser admits only zero-NPs in SpecIP, if there's no theta role
% restricts the use of this

% Auxiliaries
lex(sein,v,[morph(sein,[]),aux,perf,subcat(vp$[morph(_,ge),auxSelect(sein)],[perf])]).
%lex(sein,v,[morph(sein,[]),aux,grid([pHolder(P)],subcat),subcat(adv$[predicate(P)],[])]).
lex(sein,v,[morph(sein,[]),aux,subcat(ap$[grid(_,_)],[])]).
%lex(sein,v,[morph(sein,[]),aux,grid([pHolder(P)],subcat),subcat(prednp$[predicate(P)],[])]).
lex(werden,v,[morph(werden,[]),aux,passive,noCasemark(+),blockTheta,auxSelect(sein),subcat(vp$[morph(_,ge),grid([_],_)],[noCasemark(+)])]).

lex(haben,v,[morph(haben,[]),aux,perf,subcat(vp$[morph(_,ge),auxSelect(haben)],[perf])]).
lex(tun,v,[morph(tun,[]),aux,subcat(vp$[morph(_,[])],[])]).

lex(knnen,v,[morph(knnen,def(past(-))),aux,modal,wh,subcat(vp$[morph(_,[])],[])]).
%lex(can_t,v,[morph(can_t,def(past(-))),aux,modal,wh,neg,subcat(vp$[morph(_,[])],[])]).
%lex(could,v,[morph(could,def(past(+))),aux,modal,wh,subcat(vp$[morph(_,[])],[])]).

%lex(should,v,[morph(should,def(past(+))),aux,wh,modal,subcat(vp$[morph(_,[])],[])]).
lex(zullen,v,[morph(zullen,def(past(-))),aux,wh,modal,subcat(vp$[morph(_,[])],[])]).


% Adjectives
% S-Bar deletion properties,not ecm
% adjective declension either weak of strong,strong without
% a definite determiner,weak with one
% declension table Duden Grammatik,rule 475,p.288

lex(gute,a,[grid([theme],[]),morphC(nom),agr([3,sg,[]]),strong(-),adjR([addFeature(strong(-))])]).
lex(guten,a,[grid([theme],[]),agr([3,sg,[]]),strong(-),adjR([addFeature(strong(-))]),morphC([gen,dat])]).
lex(guten,a,[grid([theme],[]),morphC(acc),agr([3,sg,m]),strong(-),adjR([addFeature(strong(-))])]).
lex(gute,a,[grid([theme],[]),morphC(acc),agr([3,sg,[f,n]]),strong(-),adjR([addFeature(strong(-))])]).
lex(guten,a,[grid([theme],[]),morphC([nom,acc,gen,dat]),agr([3,pl,[]]),strong(-),adjR([addFeature(strong(-))])]).

lex(guter,a,[grid([theme],[]),morphC(nom),agr([3,sg,m]),strong(+),adjR([addFeature(strong(+))])]).
lex(gute,a,[grid([theme],[]),agr([3,sg,f]),strong(+),adjR([addFeature(strong(+))]),morphC([nom,acc])]).
lex(gutes,a,[grid([theme],[]),agr([3,sg,n]),strong(+),adjR([addFeature(strong(+))]),morphC([nom,acc])]).
lex(guter,a,[grid([theme],[]),agr([3,sg,f]),strong(+),adjR([addFeature(strong(+))]),morphC([gen,dat])]).
lex(guten,a,[grid([theme],[]),morphC(gen),agr([3,sg,[m,n]]),strong(+),adjR([addFeature(strong(+))])]).
lex(gutem,a,[grid([theme],[]),morphC(dat),agr([3,sg,[m,n]]),strong(+),adjR([addFeature(strong(+))])]).
lex(guten,a,[grid([theme],[]),morphC(acc),agr([3,sg,m]),strong(+),adjR([addFeature(strong(+))])]).
lex(gute,a,[grid([theme],[]),agr([3,pl,[]]),strong(+),adjR([addFeature(strong(+))]),morphC([nom,acc])]).
lex(guter,a,[grid([theme],[]),morphC(gen),agr([3,pl,[]]),strong(+),adjR([addFeature(strong(+))])]).
lex(guten,a,[grid([theme],[]),morphC(dat),agr([3,pl,[]]),strong(+),adjR([addFeature(strong(+))])]).


lex(aaaaa,a,[grid([],[patient])]).		% too complicated to explain
lex(certain,a,[grid([],[proposition]),ecm(oblig)]).
lex(slim,a,[grid([theme],[])]).
lex(gek,a,[grid([theme],[])]).
lex(oude,a,[grid([theme],[])]).			  % old
lex(cruciaal,a,[grid([],[proposition])]).
lex(te_stom,a,[grid([theme],[attribute])]).
lex(eager,a,[grid([theme],[proposition])]).
lex(eenvoudig,a,[grid([],[proposition])]).
lex(gelukkig,a,[grid([theme],[])]).
lex(illegaal,a,[grid([],[proposition]),ecm(opt)]).
lex(belangrijk,a,[grid([],[proposition])]).
lex(intelligent,a,[grid([theme],[])]).
lex(likely,a,[grid([],[proposition]),ecm(oblig)]).
lex(leuk,a,[grid([theme],[])]).
lex(te_koop,a,[grid([theme],[])]).
lex(trots,a,[grid([theme],[proposition])]).
lex(pathologisch,a,[grid([theme],[])]).
lex(bedorven,a,[grid([theme],[])]).
lex(verdrietig,a,[grid([theme],[])]).
lex(moeilijk,a,[grid([],[proposition])]).

% Complementizers
% lex(om,c,[ecm,selR([feature(inf([]))])]).
lex(da,c,[selR([not(feature(inf(_)))]),specR([feature(ec(_))]),compltizer]). 
% lex(die,c,[selR([not(feature(inf(_)))]),specR([goal(intersectAGR(X,[[],[],[m,f]]),X),
%   addFeature(invisible)]),compltizer]). % new feature added
% lex(of,c,[selR([not(feature(inf(_)))]),specR(addFeature(invisible)),compltizer]). % new feature added
% lex(welke,c,[wh]).
%lex(was,c,[wh]).
lex(ob,c,[wh,selR([not(feature(matrix))])]).

% Markers: morphological realizations of particular features
% nearest V to the right must be morph(_,[])
% lex(te,mrkr,[right(v,morph(_,[]),inf([]))]).
% lex(te1,mrkr,[rightnr(v,if(morph(_,[])),inf([]))]).
% lex(van,mrkr,[right(n,case(gen),[])]).
% lex(s,mrkr,[left(n,case(gen),[])]).

% relevant for marker constraints
relevant(n).
relevant(v).

% Non-base verb forms:
%
% Form x Category x Base x Features

%% lex(arresting,v,arrest,[morph(arrest,ing)]). % we don't have this in Dutch
lex(kann,v,knnen,[],[[morph(knnen,e)],[morph(knnen,t1)]]).
lex(kannst,v,knnen,[morph(knnen,st)]).
%lex(kann,v,knnen,[morph(knnen,t1)]).
lex(knnen,v,knnen,[morph(knnen,en)]).
lex(knnt,v,knnen,[morph(knnen,t2)]).

lex(konnte,v,knnen,[],[[morph(knnen,te)],[morph(knnen,tt1)]]).
lex(konntest,v,knnen,[morph(knnen,tst)]).
%lex(konnte,v,knnen,[morph(knnen,tt1)]).
lex(konnten,v,knnen,[morph(knnen,ten)]).
lex(konntet,v,knnen,[morph(knnen,tt2)]).

lex(gekonnt,v,knnen,[morph(knnen,ge)]).

lex(esse,v,essen,[morph(essen,e)]).
lex(it,v,essen,[],[[morph(essen,st)],[morph(essen,t1)]]).
%lex(it,v,essen,[morph(essen,t1)]).
lex(essen,v,essen,[morph(essen,en)]).
lex(esst,v,essen,[morph(essen,t2)]).

lex(a,v,essen,[],[[morph(essen,te)],[morph(essen,tt1)]]).
lex(aest,v,essen,[morph(essen,tst)]).
% lex(a,v,essen,[morph(essen,tt1)]).
lex(aen,v,essen,[morph(essen,ten)]).
lex(aet,v,essen,[morph(essen,tt2)]).

lex(gegessen,v,essen,[morph(essen,ge)]).
%lex(essen,v,essen,[morph(essen,ing)]). % ?

lex(glaube,v,glauben,[morph(glauben,e)]).
lex(glaubst,v,glauben,[morph(glauben,st)]).
lex(glaubt,v,glauben,[],[[morph(glauben,t1)],[morph(glauben,t2)]]).
lex(glauben,v,glauben,[morph(glauben,en)]).
%lex(glaubt,v,glauben,[morph(glauben,t2)]).

lex(glaubte,v,glauben,[],[[morph(glauben,te)],[morph(glauben,tt1)]]).
lex(glaubtest,v,glauben,[morph(glauben,tst)]).
%lex(glaubte,v,glauben,[morph(glauben,tt1)]).
lex(glaubten,v,glauben,[morph(glauben,ten)]).
lex(glaubtet,v,glauben,[morph(glauben,tt2)]).

lex(geglaubt,v,glauben,[morph(glauben,ge)]).

lex(gebe,v,geben,[morph(geben,e)]).
lex(gibst,v,geben,[morph(geben,st)]).
lex(gibt,v,geben,[morph(geben,t1)]).
lex(geben,v,geben,[morph(geben,en)]).
lex(gebt,v,geben,[morph(geben,t2)]).

lex(gab,v,geben,[],[[morph(geben,te)],[morph(geben,tt1)]]).
lex(gabst,v,geben,[morph(geben,tst)]).
%lex(gab,v,geben,[morph(geben,tt1)]).
lex(gaben,v,geben,[morph(geben,ten)]).
lex(gabt,v,geben,[morph(geben,tt2)]).

lex(gegeben,v,geben,[morph(geben,ge)]).

lex(habe,v,haben,[morph(haben,e)]).
lex(hast,v,haben,[morph(haben,st)]).
lex(hat,v,haben,[morph(haben,t1)]).
lex(haben,v,haben,[morph(haben,en)]).
lex(habt,v,haben,[morph(haben,t2)]).

lex(hatte,v,haben,[],[[morph(haben,te)],[morph(haben,tt1)]]).
lex(hattest,v,haben,[morph(haben,tst)]).
%lex(hatte,v,haben,[morph(haben,tt1)]).
lex(hatten,v,haben,[morph(haben,ten)]).
lex(hattet,v,haben,[morph(haben,tt2)]).

lex(gehabt,v,haben,[morph(haben,ge)]).

lex(werde,v,werden,[morph(werden,e)]).
lex(wirst,v,werden,[morph(werden,st)]).
lex(wird,v,werden,[morph(werden,t1)]).
lex(werden,v,werden,[morph(werden,en)]).
lex(werdet,v,werden,[morph(werden,t2)]).

lex(wurde,v,werden,[],[[morph(werden,te)],[morph(werden,tt1)]]).
lex(wurdest,v,werden,[morph(werden,tst)]).
%lex(wurde,v,werden,[morph(werden,tt1)]).
lex(wurden,v,werden,[morph(werden,ten)]).
lex(wurdet,v,werden,[morph(werden,tt2)]).

lex(worden,v,werden,[morph(werden,ge)]). % for the passive perfect

lex(bin,v,sein,[morph(sein,e)]).
lex(bist,v,sein,[morph(sein,st)]).
lex(ist,v,sein,[morph(sein,t1)]).
lex(sind,v,sein,[morph(sein,en)]).
lex(seid,v,sein,[morph(sein,t2)]).

lex(war,v,sein,[],[[morph(sein,te)],[morph(sein,tt1)]]).
lex(warst,v,sein,[morph(sein,tst)]).
%lex(war,v,sein,[morph(sein,tt1)]).
lex(waren,v,sein,[morph(sein,ten)]).
lex(waret,v,sein,[morph(sein,tt2)]).

lex(gewesen,v,sein,[morph(sein,ge)]).

lex(sehe,v,sehen,[morph(sehen,e)]).
lex(siehst,v,sehen,[morph(sehen,st)]).
lex(sieht,v,sehen,[morph(sehen,t1)]).
lex(sehen,v,sehen,[morph(sehen,en)]).
lex(seht,v,sehen,[morph(sehen,t2)]).

lex(sah,v,sehen,[],[[morph(sehen,te)],[morph(sehen,tt1)]]).
lex(sahst,v,sehen,[morph(sehen,tst)]).
%lex(sah,v,sehen,[morph(sehen,tt1)]).
lex(sahen,v,sehen,[morph(sehen,ten)]).
lex(saht,v,sehen,[morph(sehen,tt2)]).

lex(gesehen,v,sehen,[morph(sehen,ge)]).

lex(helfe,v,helfen,[morph(helfen,e)]).
lex(hilfst,v,helfen,[morph(helfen,st)]).
lex(hilft,v,helfen,[morph(helfen,t1)]).
lex(helfen,v,helfen,[morph(helfen,en)]).
lex(helft,v,helfen,[morph(helfen,t2)]).

lex(half,v,helfen,[],[[morph(helfen,te)],[morph(helfen,tt1)]]).
lex(halfst,v,helfen,[morph(helfen,tst)]).
lex(half,v,helfen,[morph(helfen,tt1)]).
lex(halfen,v,helfen,[morph(helfen,ten)]).
lex(halfet,v,helfen,[morph(helfen,tt2)]).

lex(geholfen,v,helfen,[morph(helfen,ge)]).


lex(lese,v,lesen,[morph(lesen,e)]).
lex(liest,v,lesen,[],[[morph(lesen,st)],[morph(lesen,t1)]]).
%lex(liest,v,lesen,[morph(lesen,t1)]).
lex(lesen,v,lesen,[morph(lesen,en)]).
lex(lest,v,lesen,[morph(lesen,t2)]).

lex(las,v,lesen,[],[[morph(lesen,te)],[morph(lesen,tt1)]]).
lex(last,v,lesen,[morph(lesen,tst)]).
%lex(las,v,lesen,[morph(lesen,tt1)]).
lex(lasen,v,lesen,[morph(lesen,ten)]).
lex(last,v,lesen,[morph(lesen,tt2)]).

lex(gelesen,v,lesen,[morph(lesen,ge)]).


lex(mag,v,mgen,[],[[morph(mgen,e)],[morph(mgen,t1)]]).
lex(magst,v,mgen,[morph(mgen,st)]).
%lex(mag,v,mgen,[morph(mgen,t1)]).
lex(mgen,v,mgen,[morph(mgen,en)]).
lex(mgt,v,mgen,[morph(mgen,t2)]).


lex(mochte,v,mgen,[],[[morph(mgen,te)],[morph(mgen,tt1)]]).
lex(mochtest,v,mgen,[morph(mgen,tst)]).
%lex(mochte,v,mgen,[morph(mgen,tt1)]).
lex(mochten,v,mgen,[morph(mgen,ten)]).
lex(mochtet,v,mgen,[morph(mgen,tt2)]).


lex(gemocht,v,mgen,[morph(mgen,ge)]).
%lex(mgen,v,mgen,[morph(mgen,ing)]). % ?


lex(strze,v,strzen,[morph(strzen,e)]).
lex(strzt,v,strzen,[],[[morph(strzen,st)],[morph(strzen,t1)],[morph(strzen,t2)]]).
%lex(strzt,v,strzen,[morph(strzen,t1)]).
lex(strzen,v,strzen,[morph(strzen,en)]).
%lex(strzt,v,strzen,[morph(strzen,t2)]).

lex(strzte,v,strzen,[],[[morph(strzen,te)],[morph(strzen,tt1)]]).
lex(strztest,v,strzen,[morph(strzen,tst)]).
%lex(strzte,v,strzen,[morph(strzen,tt1)]).
lex(strzten,v,strzen,[morph(strzen,ten)]).
lex(strztet,v,strzen,[morph(strzen,tt2)]).

lex(gestrzt,v,strzen,[morph(strzen,ge)]).


lex(lache,v,lachen,[morph(lachen,e)]).
lex(lachst,v,lachen,[morph(lachen,st)]).
lex(lacht,v,lachen,[],[[morph(lachen,t1)],[morph(lachen,t2)]]).
lex(lachen,v,lachen,[morph(lachen,en)]).
% lex(lacht,v,lachen,[morph(lachen,t2)]).

lex(lachte,v,lachen,[],[[morph(lachen,te)],[morph(lachen,tt1)]]).
lex(lachtest,v,lachen,[morph(lachen,tst)]).
%lex(lachte,v,lachen,[morph(lachen,tt1)]).
lex(lachten,v,lachen,[morph(lachen,ten)]).
lex(lachtet,v,lachen,[morph(lachen,tt2)]).

lex(gelacht,v,lachen,[morph(lachen,ge)]).


% weather-verb need only 3rd singular form
% because the subject is always expletive

lex(regnet,v,regnen,[morph(regnen,t1)]).

lex(regnete,v,regnen,[morph(regnen,tt1)]).

lex(geregnet,v,regnen,[morph(regnen,ge)]).



%% lex(asking,v,ask,[morph(ask,ing)]).
lex(frage,v,fragen,[morph(fragen,e)]).
lex(fragst,v,fragen,[morph(fragen,st)]).
lex(fragt,v,fragen,[],[[morph(fragen,t1)],[morph(fragen,t2)]]).
lex(fragen,v,fragen,[morph(fragen,en)]).
%lex(fragt,v,fragen,[morph(fragen,t2)]).

lex(fragte,v,fragen,[],[[morph(fragen,te)],[morph(fragen,tt1)]]).
lex(fragtest,v,fragen,[morph(fragen,tst)]).
%lex(fragte,v,fragen,[morph(fragen,tt1)]).
lex(fragten,v,fragen,[morph(fragen,ten)]).
lex(fragtet,v,fragen,[morph(fragen,tt2)]).

lex(gefragt,v,fragen,[morph(fragen,ge)]).

% CONTRACTIONS

contraction(X$[percep],[X,te1]).
:- initialization(no contraction(_,_,_)).

% MISCELLANEOUS

irregular(_) :- fail.

nounFeatures(Base,F) :-	lex(Base,n,F1),	pick1(agr(_),F1,F).

verbFeatures(Base,F) :-
	lex(Base,v,F1),
	pick1(morph(Base,_),F1,F).

verbToNounFeatures(Base,F) :-
	lex(Base,v,F1),
	pick1(morph(Base,_),F1,F).
%	pickNF1(ecm(_),F2,F).	% proper government for nominalized forms

%% MAPS VERBAL MORPHOLOGY INTO SYNTACTIC FEATURES
%%	Verb morphology and Agreement
%% 
%%	Form	Tense		AGR			    NEW
%%	base 	infinitival
%%	base 	past(-) 	agr(not 1,2,3,sg)
%%	-nil	past(-)		agr(1,sg)		    ***
%%	-t	past(-) 	agr(2,3,sg)
%%	-ed(1) 	past(+)		agr(1,2,3,sg)
%%	-ed(3)	past(+)		agr(1,2,3,pl)               ***
%% 	-ing	prog, infinitival   % don't need this one
%%	-ed(2)	perf, passive
%%	ben	past(-) 	agr(1,sg)
%%	bent	past(-)		agr(2,sg)
%%	was	past(+)		agr(1,2,3,sg)
%%	waren	past(+) 	agr(not 1,2,3,sg)

% non-deterministic
vMorphToFs(_,def(F),[F,agr(_)]) :-		% defective: modal auxiliaries
	!.
vMorphToFs(_,[],[]).				% infinitival form
vMorphToFs(Base,Form,Features) :-
	\+ irregular(Base,Form),
	tns(Form,F1),
	agr(Form,F2),
	append(F1,F2,Features).

% base form is irregular: (regular [] -> past(-) not 3sg) 
% the above is quite inappropiate for German
irregular(Base,[]) :- irregular(Base).

% verb form <-> AGR feature
% agr([],[agr([[],pl,[]])]).
agr(e,[agr([1,sg,[]])]).
agr(st,[agr([2,sg,[]])]). 	
agr(t1,[agr([3,sg,[]])]).	
agr(t2,[agr([2,pl,[]])]).
agr(en,[agr([[1,3],pl,[]])]).	
agr(te,[agr([1,sg,[]])]).
agr(tst,[agr([2,sg,[]])]). 	
agr(tt1,[agr([3,sg,[]])]).	
agr(tt2,[agr([2,pl,[]])]).	
agr(ten,[agr([[1,3],pl,[]])]).	
agr(ge,[]).
% agr(ed(1),[agr([[],[sg,m],[]])]).

% verb form <-> Tense feature
% tns([],[past(-)]).		
tns(e,[past(-)]).
tns(st,[past(-)]).
tns(en,[past(-)]).
tns(t1,[past(-)]).
tns(t2,[past(-)]).				  % composite
tns(te,[past(+)]).
tns(tst,[past(+)]).
tns(tt1,[past(+)]).
tns(tt2,[past(+)]).
tns(ten,[past(+)]).

:- dynamic inf/2.


addInf(IP) :-
	cat(IP,i2)
	-> VP complement_of IP,
	   VP has_feature morph(_,[]),
	   addFeature(inf([]),IP)
	;  true.

% agrConstraint(X) :- intersectAGR([[],[],[n]],X) if cat(X,np).
agrConstraint(_) :- fail.
