:- initialization((no lexFeature(_,_))).

% 9/5/92  Tim 
% 4/19/94 Sandiway	Added bunch of lexical items
%			Merged lexical ambiguity except for:
%				om, moeilijk,elke,verlaten,ontmoet

%%%  -*- Mode: PROLOG; Package: PROLOG-USER -*-

%%% EXPORT
%%%	term(C)				terminals
%%%	lexicon(Word,C,Fs)		Word has category label C and feature list Fs
%%%	probeLexicon(Word)		Word is in lexicon
%%%	vMorphToFs(Base,Form,Features)	TNS/AGR features
%%%	inf(Verb,Type)
%%%	relevant(C)			constraints imposed by markers apply to C
%%% REFERENCES
%%%	(list processing)		utilities

term(n). term(a). term(v). term(p). term(c).
term(adv). term(det). term(neg). term($).

%%% 	Most lexical entries are stored directly as lex(Word,Category,Features)
%%%	Non-base forms require inference: 
%%%	1. plural nouns		all features except agr(_) inherited from the sg. form
%%%	2. nominalized verbs	inherits verb features except morph(_,_)
%%%	3. non-base verb forms	all features except morph(_,_) inherited from the base form

lexicon(Word,C,Fs) :- lex(Word,C,Fs).		% directly available
lexicon(Form,v,Fs) :-				% non-base verb forms
	lex(Form,v,Base,F1),
	verbFeatures(Base,F2),
	append1(F1,F2,Fs).

probeLexicon(Word) :- lex(Word,_,_) ; lex(Word,_,_,_).

%%% NEGATION

lex(niet,neg,[polarity(-)]).

%% Prepositions
lex(door,p,[grid([],[agent]),adjR([goal(extRoleToAssign(XP,agent),XP),feature(passive)]),predicate(agent)]).
lex(in,p,[grid([],[location]),predicate(location)]).
lex(zonder,p,[grid([],[reducedProp]),selR([not(feature(inf([])))]),predicate(manner)]). % use+ing 
lex(na,p,[grid([],[reducedProp]),selR([not(feature(inf([])))]),predicate(manner)]). % use+ing
lex(voor,p,[grid([],[reducedProp]),selR([not(feature(inf([])))]),predicate(manner)]). % use+ing
lex(om,p,[grid([],[location]),predicate(time)]).

%% Adverbs

lex(hoe,adv,[adjoin(right),wh]).
lex(waarom,adv,[adjoin(right),wh]).
lex(volledig,adv,[adjoin(left),predicate(manner)]).
lex(vaak,adv,[adjoin(left),predicate(manner)]).
lex(oprecht,adv,[adjoin(left),predicate(manner)]).
lex(hier,adv,[adjoin(right),predicate(location)]).
lex(laat,adv,[adjoin(right),predicate(time)]).
lex(gisteren,adv,[adjoin(right),predicate(time)]).
lex(moeilijk,adv,[adjoin(right),predicate(manner)]).


%% Determiners
%%	Combine only with nouns that have the count(+/-/_) feature (common nouns) 
%%	Six classes of determiners:
%%	Class Examples                     Features
%%	1     the,my,our,whose,which,what  count(_) agr([3,[],[]])
%%	2     some,any,enough              count(_) agr([3,[pl,m],[]])
%%	3     this,that                    count(_) agr([3,[sg,m],[]])
%%	4     few,these,those              count(+) agr([3,pl,[]])
%%	5     a,every,each,either,neither  count(+) agr(([3,sg,[]])
%%	6     much                         count(-) agr(([3,m,[]])
%%	Determiners and quantifier types [Hornstein]:
%%	Type	Examples	Features
%%	1	any, a certain	op(-)
%%	2	every,some,a	op(+)
%%	op(+) elements that are moved by QR and form operator-variable structures
%%	op(-) not moved by QR

lex(een,det,[count(+),agr([3,sg,[]]),op(+)]).
lex(een_zekere,det,[count(+),agr([3,sg,[]]),op(-)]).
lex(elke,det,[count(_),agr([3,[pl,m],[]]),op(-)]). % difficult one
lex(elke,det,[count(+),agr([3,sg,[]]),op(+)]).
%lex(elke,det,[count(+),agr([3,sg,[]]),op(-)]).
lex(genoeg,det,[count(_),agr([3,[pl,m],[]]),op(+)]).
lex(elke,det,[count(+),agr([3,sg,[]]),op(+)]).
% lex(enkele,det,[count(+),agr([3,pl,[]]),op(+)]). % need this?
% lex(enkele,det,[count(_),agr([3,pl,[]]),op(+)]).
lex(enkele,det,[count(_),agr([3,pl,[]]),op(+)]).
lex(vele,det,[count(+),agr([3,pl,[]]),op(+)]).
lex(veel,det,[count(-),agr([3,m,[]]),op(+)]).
lex(mijn,det,[count(_),agr([3,[],[]]),op(-)]).
lex(onze,det,[count(_),agr([3,[],[]]),op(-)]).
lex(geen,det,[count(+),agr([3,sg,[]]),op(-)]).
lex(de,det,[count(_),agr([3,[],[]]),op(-)]).
lex(deze,det,[count(+),agr([3,pl,[]]),op(-)]).		% m. & f. forms
lex(die,det,[count(_),agr([3,[sg,m],[]]),op(-)]).
lex(die,det,[count(+),agr([3,pl,[]]),op(-)]).
% lex(welke,det,[count(_),agr([3,[],[]]),wh]).
lex(welke,det,[count(_),agr([3,[],[]]),wh]).
lex(wiens,det,[count(_),agr([3,[],[]]),wh]).
lex(het,det,[count(_),agr([3,[],n]),op(-)]).	  % added

%% Nouns
%% 	Obligatory features
%% 	1. Anaphoric: a(+/-), Pronominal: p(+/-) for Binding Theory
%% 	2. Agreement: agr([Per,Num,Gen]) 
%%	3. O-grid: grid(Ext,Int) 
%% 	Optional features
%% 	1. Morphologically realized Case: morphC(C)
%% 	2. Common nouns: count(+/-/_) (not present for proper nouns)
%%	3. Quantifiers: op(+/-) 
%%	4. Wh-nouns: wh

% Pleonastic elements

% lex(het,n,[grid([],[]),agr([3,sg,[]]),nonarg]).
% lex(het,n,[grid([],[]),a(-),p(+),agr([3,sg,n])]).
lex(het,n,[grid([],[]),oneof(_,[[agr([3,sg,[]]),nonarg],
				[agr([3,sg,n]),a(-),p(+)]])]).

lex(er,n,[grid([],[]),agr([3,[],[]]),nonarg]).
lex(nu,n,[grid([],[]),agr([3,[],[]]),nonarg]). % probably not used in Dutch

% Proper nouns
lex(hilde,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(adje,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(anita,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(ellen,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(hanneke,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(nicola,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(henry,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(jan,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(janneke,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(lex,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(peter,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(piet,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(marie,n,[grid([],[]),a(-),p(-),agr([3,sg,f])]).
lex(rome,n,[grid([],[]),a(-),p(-),agr([3,sg,m])]).
lex(student,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),count(_)]).
lex(studenten,n,[grid([],[]),a(-),p(-),agr([3,pl,[m,f]]),count(_)]).
lex(tijd,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),count(_),nonarg,predicate(time)]).

% Anaphors and pronominals 
lex(each_other,n,[grid([],[]),a(+),p(-),agr([3,pl,[m,f]])]).

lex(hij,n,[grid([],[]),morphC(nom),a(-),p(+),agr([3,sg,m])]).
lex(hem,n,[grid([],[]),morphC(acc),a(-),p(+),agr([3,sg,m])]).

% lex(zichzelf,n,[grid([],[]),a(+),p(-),agr([3,sg,m])]).
% lex(zichzelf,n,[grid([],[]),a(+),p(-),agr([3,pl,[m,f]])]). 
% lex(zichzelf,n,[grid([],[]),a(+),p(-),agr([3,sg,n])]).

lex(zichzelf,n,[grid([],[]),a(+),p(-),oneof(_,[[agr([3,pl,[m,f]])],
					       [agr([3,sg,[m,n]])]])]). 

lex(zijn,n,[grid([],[]),morphC(gen),a(-),p(+),agr([3,sg,m])]).

lex(hun,n,[grid([],[]),morphC(gen),a(-),p(+),agr([3,pl,[m,f]])]).
lex(hen,n,[grid([],[]),morphC(acc),a(-),p(+),agr([3,pl,[m,f]])]).
% lex(zichzelf,n,[grid([],[]),a(+),p(-),agr([3,pl,[m,f]])]). merged
lex(zij,n,[grid([],[]),morphC(nom),a(-),p(+),agr([3,pl,[m,f]])]).

lex(ik,n,[grid([],[]),morphC(nom),a(-),p(+),agr([1,sg,[m,f]])]).
lex(mij,n,[grid([],[]),morphC(acc),a(-),p(+),agr([1,sg,[m,f]])]).
lex(mijn,n,[grid([],[]),morphC(gen),a(-),p(+),agr([1,sg,[m,f]])]).
lex(mezelf,n,[grid([],[]),a(+),p(-),agr([1,sg,[m,f]])]).

lex(wij,n,[grid([],[]),morphC(nom),a(-),p(+),agr([1,pl,[m,f]])]).
lex(ons,n,[grid([],[]),morphC(acc),a(-),p(+),agr([1,pl,[m,f]])]).

lex(je,n,[grid([],[]),a(-),p(+),agr([2,[],[m,f]])]).
lex(jij,n,[grid([],[]),morphC(nom),a(-),p(+),agr([2,sg,[m,f]])]).
lex(jou,n,[grid([],[]),a(-),p(+),agr([2,sg,[m,f]]),
	   oneof(_,[[morphC(acc)],[morphC(dat)]])]).
lex(jouw,n,[grid([],[]),morphC(gen),a(-),p(+),agr([2,sg,[m,f]])]).
lex(jullie,n,[grid([],[]),a(-),p(+),agr([2,pl,[m,f]])]).

lex(haar,n,[grid([],[]),a(-),p(+),agr([3,sg,f])]).
lex(haar,n,[grid([],[]),a(+),p(-),agr([3,sg,f])]).

% lex(het,n,[grid([],[]),a(-),p(+),agr([3,sg,n])]). % merged
% lex(zichzelf,n,[grid([],[]),a(+),p(-),agr([3,sg,n])]). % merged

% Quantifier nouns
lex(iedereen,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),op(+)]).
lex(iemand,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),op(+)]).

% Wh-nouns
% lex(wie,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),wh]).
% lex(wie,n,[grid([],[]),morphC(acc),a(-),p(-),agr([3,sg,[m,f]]),wh]).
lex(wie,n,[grid([],[]),a(-),p(-),agr([3,sg,[m,f]]),wh]).
lex(wat,n,[grid([],[]),a(-),p(-),agr([3,[],n]),wh]).

% Common nouns
lex(artikel,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(auto,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(klootzak,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,[m,f]]),epithet]).
lex(melkman,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m])]).
lex(jongen,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m])]).
lex(gebouw,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(bus,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(cake,n,[grid([],[]),a(-),p(-),count(_),agr([3,[],n])]).
lex(kat,n,[grid([],[]),a(-),p(-),count(+),agr([3,[],[m,f]])]).
lex(kaas,n,[grid([],[]),a(-),p(-),count(+),agr([3,[],n])]).
lex(dief,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,[m,f]])]).
lex(schoonmaker,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,[m,f]])]).
lex(stad,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(demonstratie,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(explosie,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(brand,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(vloer,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(ijsje,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n])]).
lex(advocaat,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,[m,f]])]).
lex(leugenaar,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,[m,f]])]).
lex(man,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m])]).
lex(nec,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n])]). % NEC
lex(speelplaats,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(politie,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n])]).
lex(politieman,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,m])]).
lex(probleem,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(plan,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(race,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(rat,n,[grid([],[]),a(-),p(-),count(+),agr([3,[],[m,f]])]).
lex(rapport,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(verhaal,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]). % story
lex(vlek,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(tijd,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n])]).
lex(this,n,[grid([],[]),a(-),p(-),count(-),agr([3,m,n])]).
lex(vrouw,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,f])]).
lex(oma,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,f])]). % grandma
lex(wedstrijd,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]). % game
lex(arbeider,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(film,n,[grid([],[]),a(-),p(-),count(+),agr([3,sg,n])]).

% Nouns with O-grids
lex(boek,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(vader,n,[grid([possessor],[]),a(-),p(-),count(_),agr([3,sg,f])]).
lex(furniture,n,[grid([possessor],[]),a(-),p(-),count(-),agr([3,m,n])]).
lex(moeder,n,[grid([possessor],[]),a(-),p(-),count(_),agr([3,sg,f])]).
lex(schilderij,n,[grid([possessor],[theme]),a(-),p(-),count(+),agr([3,sg,n])]).
lex(leraar,n,[grid([possessor],[]),a(-),p(-),count(+),agr([3,sg,[m,f]])]).

% Non-base noun forms
lex(flessen,n,[grid([],[]),a(-),p(-),count(+),agr([3,pl,n])]). % bottles
lex(geloven,n,[agr([3,pl,n])|F]) :- nounFeatures(geloof,F).
lex(boeken,n,[agr([3,pl,n])|F]) :- nounFeatures(boek,F).
lex(gebouwen,n,[agr([3,pl,n])|F]) :- nounFeatures(gebouw,F).
lex(bussem,n,[agr([3,pl,n])|F]) :- nounFeatures(bus,F).
lex(steden,n,[agr([3,pl,n])|F]) :- nounFeatures(stad,F).
lex(vertrekken,n,[agr([3,pl,n])|F]) :- nounFeatures(vertrek,F).
lex(mannen,n,[agr([3,pl,m])|F]):- nounFeatures(man,F).
lex(moeders,n,[agr([3,pl,f])|F]) :- nounFeatures(moeder,F).
lex(schilderijen,n,[agr([3,pl,n])|F]) :- nounFeatures(schilderij,F).
lex(leraren,n,[agr([3,pl,[m,f]])|F]) :- nounFeatures(leraar,F).

% Nominalized verbs
lex(geloof,n,[count(+),agr([3,sg,[]]),a(-),p(-)|F]) :- 
	verbToNounFeatures(geloven,F).
lex(claim,n,[count(+),agr([3,sg,[]]),a(-),p(-)|F]) :- 
	verbToNounFeatures(claimen,F).
lex(vertrek,n,[count(+),agr([3,sg,n]),a(-),p(-)|F]) :- 
	verbToNounFeatures(vertrekken,F).
lex(vernietiging,n,[count(-),agr([3,m,n]),a(-),p(-)|F]) :- 
	verbToNounFeatures(vernietigen,F).
lex(vernietiging,n,[count(-),agr([3,m,n]),a(-),p(-),grid([],[patient])]).
lex(gevecht,n,[count(+),agr([3,sg,[]]),a(-),p(-)|F]) :- 
	verbToNounFeatures(vechten,F).

% Verbs - base forms
%
% Obligatory elements
% 1. grid(Ext,Int) denotes the O-grid
% 2. morph(Base,[]/ing/s/ed(1)/ed(2)) 
% Optional features
% 1. ecm(opt/oblig) for ECM verbs
% 2. noCasemark(+) for technically intransitive verbs
% 3. subcat(C$Fs,Fs1) subcategorizes for an element of category C 
%    with feature restriction list Fs.
%    feature list Fs1 will be appended to the feature list of C

lex(arresteren,v,[morph(arresteren,[]),grid([agent],[patient])]).
lex(arriveren,v,[morph(arriveren,[]),grid([theme],[])]).
lex(besturen,v,[morph(besturen,[]),grid([agent],[patient])]). % drive
lex(vragen,v,[morph(vragen,[]),grid([agent],[proposition]),
	      selR(head(c2),goal(ensureWhComp(X),X))]).
lex(geloven,v,[morph(geloven,[]),grid([agent],[proposition])]). % 
lex(roepen,v,[morph(roepen,[]),grid([agent],[patient])]).
lex(verzorgen,v,[morph(verzorgen,[]),grid([agent],[proposition]),
		 noCasemark(+),selR(head(c2),goal(ensureWhComp(X),X))]).
lex(claimen,v,[morph(claimen,[]),grid([agent],[proposition]),ecm(oblig)]).
lex(vertrekken,v,[morph(vertrekken,[]),grid([theme],[])]).
lex(vernietigen,v,[morph(vernietigen,[]),grid([agent],[patient])]).
lex(verdwijnen,v,[morph(verdwijnen,[]),grid([theme],[])]).
lex(eten,v,[morph(eten,[]),grid([agent],[[patient]])]).
lex(vallen_op,v,[morph(vallen_op,[]),grid([theme],[location])]).
lex(vechten,v,[morph(vechten,[]),grid([agent],[[patient]])]).
lex(archiveren,v,[morph(archiveren,[]),grid([agent],[patient])]).
lex(ontslaan,v,[morph(ontslaan,[]),grid([agent],[patient])]).
lex(slaan,v,[morph(slaan,[]),grid([agent],[patient])]).
lex(kussen,v,[morph(kussen,[]),grid([agent],[patient])]).
lex(verslaan,v,[morph(verslaan,[]),grid([agent],[patient])]).
lex(instrueren,v,[morph(instrueren,[]),grid([agent],[patient])]).
lex(houden,v,[morph(houden,[]),grid([agent],[patient])]).
lex(naderen,v,[morph(naderen,[]),grid([agent],[[patient]])]). % approach
lex(horen,v,[morph(horen,[]),grid([agent],[propositionD]),ecm(oblig),percep]). % hear
lex(doden,v,[morph(doden,[]),grid([agent],[patient])]).
lex(denken,v,[morph(denken,[]),grid([agent],[proposition1])]). % think
lex(weten,v,[morph(weten,[]),grid([agent],[proposition1]),
	    selR(head(c2),goal(optWhComp(X),X))]).

lex(verlaten,v,[morph(verlaten,[]),grid([theme],[])]).
lex(leiden,v,[morph(leiden,[]),grid([agent],[patient])]).
lex(verleiden,v,[morph(verleiden,[]),grid([agent],[patient])]). % seduce
lex(mogen,v,[morph(mogen,[]),grid([agent],[patient])]).
lex(ontmoeten,v,[morph(ontmoeten,[]),grid([agent],[patient])]).
lex(noemen,v,[morph(noemen,[]),grid([agent],[proposition])]).
lex(parkeren,v,[morph(parkeren,[]),grid([agent],[])]).
lex(overtuigen,v,[morph(overtuigen,[]),grid([agent],[patient,proposition])]).
lex(ontwikkelen,v,[morph(ontwikkelen,[]),grid([agent],[patient])]). % develop (un-wrap)
%lex(welgevallen,v,[morph(welgevallen,[]),grid([agent],[patient])]).   % problem!
lex(beloven,v,[morph(beloven,[]),grid([agent],[patient$noControl,proposition])]).
lex(regenen,v,[morph(regenen,[]),grid([],[])]).
lex(repareren,v,[morph(repareren,[]),grid([agent],[patient])]). % repair
lex(rondbrengen,v,[morph(rondbrengen,[]),grid([agent],[patient])]). % deliver (bring round)
lex(lezen,v,[morph(lezen,[]),grid([agent],[proposition])]).
lex(verwijderen,v,[morph(verwijderen,[]),grid([agent],[patient])]).
lex(terugtrekken,v,[morph(terugtrekken,[]),grid([theme],[])]).
lex(zeggen,v,[morph(zeggen,[]),grid([agent],[proposition])]).
lex(zien,v,[morph(zien,[]),grid([agent],[patient])]). % see
lex(schijnen,v,[morph(schijnen,[]),grid([],[reducedProp])]).
lex(slapen,v,[morph(slapen,[]),grid([agent],[])]).
lex(oplossen,v,[morph(oplossen,[]),grid([agent],[patient])]).
lex(staan,v,[morph(staan,[]),grid([agent],[proposition])]).
lex(starten,v,[morph(starten,[]),grid([agent],[patient])]).
lex(praten_met,v,[morph(praten_met,[]),grid([agent],[patient])]).
lex(vertellen,v,[morph(vertellen,[]),
		 oneof(_,[[grid([agent],[theme])],
			  [grid([agent],[patient,proposition])]])]).
lex(proberen,v,[morph(proberen,[]),grid([agent],[reducedProp])]).
lex(begrijpen,v,[morph(begrijpen,[]),grid([agent],[patient])]).
lex(bezoeken,v,[morph(bezoeken,[]),grid([agent],[patient])]).
lex(willen,v,[morph(willen,[]),grid([agent],[proposition]),ecm(opt)]).
lex(winnen,v,[morph(winnen,[]),grid([agent],[[patient]])]).
lex(zich_afvragen,v,[morph(afvragen,[]),grid([agent],[proposition]),
		     noCasemark(+),selR(head(c2),goal(ensureWhComp(X),X))]).

lex(werken,v,[morph(werken,[]),grid([theme],[])]).

% Auxiliaries
%lex(zijn,v,[morph(zijn,[]),aux,grid([pHolder(P)],subcat),subcat(adv$[predicate(P)],[])]).
%lex(zijn,v,[morph(zijn,[]),aux,subcat(ap$[grid(_,_)],[])]).  % wh removed for Dutch
%lex(zijn,v,[morph(zijn,[]),aux,grid([pHolder(P)],subcat),subcat(prednp$[predicate(P)],[])]).
lex(zijn,v,[morph(zijn,[]),aux,passive,blockTheta,subcat(vp$[morph(_,ed(2))],[noCasemark(+)])]).
%lex(zijn,v,[morph(zijn,[]),aux,prog,subcat(vp$[morph(_,ing)],[prog])]).

lex(hebben,v,[morph(hebben,[]),aux,wh,perf,subcat(vp$[morph(_,ed(2))],[perf])]).
lex(doen,v,[morph(doen,[]),aux,wh,subcat(vp$[morph(_,[])],[])]).

lex(kunnen,v,[morph(kunnen,def(past(-))),aux,modal,wh,subcat(vp$[morph(_,[])],[])]).
%lex(can_t,v,[morph(can_t,def(past(-))),aux,modal,wh,neg,subcat(vp$[morph(_,[])],[])]).
%lex(could,v,[morph(could,def(past(+))),aux,modal,wh,subcat(vp$[morph(_,[])],[])]).

%lex(should,v,[morph(should,def(past(+))),aux,wh,modal,subcat(vp$[morph(_,[])],[])]).
lex(zullen,v,[morph(zullen,def(past(-))),aux,wh,modal,subcat(vp$[morph(_,[])],[])]).

% Adjectives
% S-Bar deletion properties, not ecm

lex(aaaaa,a,[grid([],[patient])]).		% too complicated to explain
lex(certain,a,[grid([],[proposition]),ecm(oblig)]).
lex(slim,a,[grid([theme],[])]).
lex(gek,a,[grid([theme],[])]).
lex(oude,a,[grid([theme],[])]).			  % old
lex(cruciaal,a,[grid([],[proposition])]).
lex(te_stom,a,[grid([theme],[attribute])]).
lex(eager,a,[grid([theme],[proposition])]).
lex(eenvoudig,a,[grid([],[proposition])]).
lex(gelukkig,a,[grid([theme],[])]).
lex(illegaal,a,[grid([],[proposition]),ecm(opt)]).
lex(belangrijk,a,[grid([],[proposition])]).
lex(intelligent,a,[grid([theme],[])]).
lex(likely,a,[grid([],[proposition]),ecm(oblig)]).
lex(leuk,a,[grid([theme],[])]).
lex(te_koop,a,[grid([theme],[])]).
lex(trots,a,[grid([theme],[proposition])]).
lex(pathologisch,a,[grid([theme],[])]).
lex(bedorven,a,[grid([theme],[])]).
lex(verdrietig,a,[grid([theme],[])]).
lex(moeilijk,a,[grid([],[proposition])]).

% Complementizers
lex(om,c,[ecm,selR([feature(inf([]))])]).
lex(dat,c,[selR([not(feature(inf(_)))]),compltizer]). 
lex(die,c,[selR([not(feature(inf(_)))]),specR([goal(intersectAGR(X,[[],[],[m,f]]),X),addFeature(invisible)]),compltizer]). % new feature added
lex(of,c,[selR([not(feature(inf(_)))]),specR(addFeature(invisible)),compltizer]). % new feature added
lex(welke,c,[wh]).

% Markers: morphological realizations of particular features
% nearest V to the right must be morph(_,[])
lex(te,mrkr,[right(v,morph(_,[]),inf([]))]).
lex(te1,mrkr,[rightnr(v,if(morph(_,[])),inf([]))]).
lex(van,mrkr,[right(n,case(gen),[])]).
lex(s,mrkr,[left(n,case(gen),[])]).

% relevant for marker constraints
relevant(n).
relevant(v).

irregular(zijn).

% Non-base verb forms:
%
% Form x Category x Base x Features

%% lex(arresting,v,arrest,[morph(arrest,ing)]). % we don't have this in Dutch
lex(arresteert,v,arresteren,[morph(arresteren,t)]).
lex(arresteerde,v,arresteren,[morph(arresteren,ed(1))]).
lex(gearresteerd,v,arresteren,[morph(arresteren,ed(2))]).
lex(arresteer,v,arresteren,[morph(arresteren,n)]).
lex(arresteerden,v,arresteren,[morph(arresteren,ed(3))]).

%%lex(arriving,v,arrive,[morph(arrive,ing)]).
lex(arriveert,v,arriveren,[morph(arriveren,t)]).
lex(arriveerde,v,arriveren,[morph(arriveren,ed(1))]).
lex(gearriveerd,v,arriveren,[morph(arriveren,ed(2))]).
lex(arriveer,v,arriveren,[morph(arriveren,n)]).
lex(arriveerden,v,arriveren,[morph(arriveren,ed(3))]).

%% lex(asking,v,ask,[morph(ask,ing)]).
lex(vraagt,v,vragen,[morph(vragen,t)]).
lex(vroeg,v,vragen,[morph(vragen,ed(1))]).
lex(gevraagd,v,vragen,[morph(vragen,ed(2))]).
lex(vraag,v,vragen,[morph(vragen,n)]).
lex(vroegen,v,vragen,[morph(vragen,ed(3))]).


% drive
lex(bestuurt,v,besturen,[morph(besturen,t)]).
lex(bestuur,v,besturen,[morph(besturen,n)]).
lex(bestuurde,v,besturen,[morph(besturen,ed(1))]).
lex(bestuurd,v,besturen,[morph(besturen,ed(2))]).
lex(bestuurden,v,besturen,[morph(besturen,ed(3))]).

lex(ben,_,zijn,[morph(zijn,n)]).  % Cat=mrkr, aux
lex(bent,_,zijn,[morph(zijn,bent)]).
lex(geweest,_,zijn,[morph(zijn,ed(2))]).
%lex(being,_,be,[morph(be,ing)]).
lex(is,_,zijn,[morph(zijn,t)]).
lex(was,_,zijn,[morph(zijn,was)]).
lex(waren,_,zijn,[morph(zijn,waren)]).

%%lex(believing,v,believe,[morph(believe,ing)]).
lex(gelooft,v,geloven,[morph(geloven,t)]).
lex(geloofde,v,geloven,[morph(geloven,ed(1))]).
lex(geloofd,v,geloven,[morph(geloven,ed(2))]).

% deliver (bring round)
lex(breng_rond,v,rondbrengen,[morph(rondbrengen,n)]).
lex(brengt_rond,v,rondbrengen,[morph(rondbrengen,t)]).
lex(bracht_rond,v,rondbrengen,[morph(rondbrengen,ed(1))]).
lex(brachten_rond,v,rondbrengen,[morph(rondbrengen,ed(3))]).
lex(rondgebracht,v,rondbrengen,[morph(rondbrengen,ed(2))]).

%%lex(calling,v,call,[morph(call,ing)]).
lex(roept,v,roepen,[morph(roepen,t)]).
lex(riep,v,roepen,[morph(roepen,ed(1))]).
lex(geroepen,v,roepen,[morph(roepen,ed(2))]).

%lex(caring,v,care,[morph(care,ing)]).
lex(verzorgt,v,verzorgen,[morph(verzorgen,t)]).
lex(verzorgde,v,verzorgen,[morph(verzorgen,ed(1))]).
lex(verzorgd,v,verzorgen,[morph(verzorgen,ed(2))]).

%%lex(claiming,v,claim,[morph(claim,ing)]).
lex(claimt,v,claimen,[morph(claimen,t)]).
lex(claimde,v,claimen,[morph(claimen,ed(1))]).
lex(geclaimd,v,claimen,[morph(claimen,ed(2))]).

%%lex(departing,v,depart,[morph(depart,ing)]).
lex(vertrekt,v,vertrekken,[morph(vertrekken,t)]).
lex(vertrok,v,vertrekken,[morph(vertrekken,ed(1))]).
lex(vertrokken,v,vertrekken,[morph(vertrekken,ed(2))]).


%lex(destroying,v,destroy,[morph(destroy,ing)]).
lex(vernietigt,v,vernietigen,[morph(vernietigen,t)]).
lex(vernietigde,v,vernietigen,[morph(vernietigen,ed(1))]).
lex(vernietigd,v,vernietigen,[morph(vernietigen,ed(2))]).

%%lex(disappearing,v,disappear,[morph(disappear,ing)]).
lex(verdwijnt,v,verdwijnen,[morph(verdwijnen,t)]).
lex(verdween,v,verdwijnen,[morph(verdwijnen,ed(1))]).
lex(verdwenen,v,verdwijnen,[morph(verdwijnen,ed(2))]).

%lex(doing,_,do,[morph(do,ing)]).
lex(doet,_,doen,[morph(doen,t)]).
lex(deed,_,doen,[morph(doen,ed(1))]).
lex(gedaan,_,doen,[morph(doen,ed(2))]).

%lex(eating,v,eat,[morph(eat,ing)]).
lex(eet,v,eten,[morph(eten,t)]).
lex(at,v,eten,[morph(eten,ed(1))]).
lex(gegeten,v,eten,[morph(eten,ed(2))]).

%lex(falling_on,v,fall_on,[morph(fall_on,ing)]).
lex(valt_op,v,vallen_op,[morph(vallen_op,t)]).
lex(viel_op,v,vallen_op,[morph(vallen_op,ed(1))]).
lex(gevallen_op,v,vallen_op,[morph(vallen_op,ed(2))]).

%%lex(fighting,v,fight,[morph(fight,ing)]).
lex(vecht,v,vechten,[morph(vechten,t)]).
lex(vocht,v,vechten,[morph(vechten,ed(1))]).
lex(gevochten,v,vechten,[morph(vechten,ed(2))]).

lex(archiveert,v,archiveren,[morph(archiveren,t)]).
lex(archiveerde,v,archiveren,[morph(archiveren,ed(1))]).
lex(gearchiveerd,v,archiveren,[morph(archiveren,ed(2))]).

%lex(firing,v,fire,[morph(fire,ing)]).
lex(ontslaat,v,ontslaan,[morph(ontslaan,nt)]).	  % modified
lex(ontsloeg,v,ontslaan,[morph(ontslaan,ed(1))]).
lex(ontslagen,v,ontslaan,[morph(ontslaan,ed(2))]).


%lex(having,_,have,[morph(have,ing)]).
lex(heeft,_,hebben,[morph(hebben,t)]).
lex(had,_,hebben,[morph(hebben,ed(1))]).
lex(gehad,_,hebben,[morph(hebben,ed(2))]).


%lex(hitting,v,hit,[morph(hit,ing)]).
% lex(slaat,v,slaan,[morph(slaat,nt)]).
lex(sla,v,slaan,[morph(slaan,n)]).
lex(slaat,v,slaan,[morph(slaan,t)]). 

lex(sloeg,v,slaan,[morph(slaan,ed(1))]).
lex(geslagen,v,slaan,[morph(slaan,ed(2))]).
% lex(slaat,v,slaan,[morph(slaan,n)]). % merged
lex(sloegen,v,slaan,[morph(slaan,ed(3))]).

% defeat
lex(verslaat,v,verslaan,[morph(verslaat,t)]).
lex(versla,v,verslaan,[morph(verslaat,n)]).
lex(versloeg,v,verslaan,[morph(verslaan,ed(1))]).
lex(verslagen,v,verslaan,[morph(verslaan,ed(2))]).
lex(versloegen,v,verslaan,[morph(verslaan,ed(3))]).

%lex(instructing,v,instruct,[morph(instruct,ing)]).
lex(instrueert,v,instrueren,[morph(instrueren,t)]).
lex(instrueerde,v,instrueren,[morph(instrueren,ed(1))]).
lex(geinstrueerd,v,instrueren,[morph(instrueren,ed(2))]).

%lex(keeping,v,keep,[morph(keep,ing)]).
lex(houdt,v,houden,[morph(houden,t)]).
lex(hield,v,houden,[morph(houden,ed(1))]).
lex(gehouden,v,houden,[morph(houden,ed(2))]).

% hear
lex(hoor,v,horen,[morph(horen,n)]).
lex(hoort,v,horen,[morph(horen,t)]).
lex(hoorde,v,horen,[morph(horen,ed(1))]).
lex(hoorden,v,horen,[morph(horen,ed(3))]).
lex(gehoord,v,horen,[morph(horen,ed(2))]).

% approach
lex(nader,v,naderen,[morph(naderen,n)]).
lex(nadert,v,naderen,[morph(naderen,t)]).
lex(naderde,v,naderen,[morph(naderen,ed(1))]).
lex(nadeorden,v,naderen,[morph(naderen,ed(3))]).
lex(genaderd,v,naderen,[morph(naderen,ed(2))]).

%lex(killing,v,kill,[morph(kill,ing)]).
lex(doodt,v,doden,[morph(doden,t)]).
lex(doodde,v,doden,[morph(doden,ed(1))]).
lex(gedood,v,doden,[morph(doden,ed(2))]).

%lex(knowing,v,know,[morph(know,ing)]).
% lex(weet,v,weten,[morph(weten,t)]).
% lex(weet,v,weten,[morph(weten,n)]).
lex(weet,v,weten,[morph(weten,nt)]).

lex(wist,v,weten,[morph(weten,ed(1))]).
lex(geweten,v,weten,[morph(weten,ed(2))]).
% lex(weet,v,weten,[morph(weten,n)]). % merged
lex(wisten,v,weten,[morph(weten,ed(3))]).

% kiss
lex(kus,v,kussen,[morph(kussen,n)]).
lex(kust,v,kussen,[morph(kussen,t)]).
lex(kuste,v,kussen,[morph(kussen,ed(1))]).
lex(kusten,v,kussen,[morph(kussen,ed(3))]).
lex(gekust,v,kussen,[morph(kussen,ed(2))]).

%%lex(leaving,v,leave,[morph(leave,ing)]).
lex(verlaat,v,verlaten,[morph(verlaten,t)]).
lex(verliet,v,verlaten,[morph(verlaten,ed(1))]).
lex(verlaten,v,verlaten,[morph(verlaten,ed(2))]).

%lex(leading,v,lead,[morph(lead,ing)]).
lex(leidt,v,leiden,[morph(leiden,t)]).
lex(leid,v,leiden,[morph(leiden,n)]).
lex(leidde,v,leiden,[morph(leiden,ed(1))]).
lex(geleid,v,leiden,[morph(leiden,ed(2))]).

% seduce
lex(verleidt,v,verleiden,[morph(verleiden,t)]).
lex(verleid,v,verleiden,[morph(verleiden,n)]).
lex(verleidde,v,verleiden,[morph(verleiden,ed(1))]).
lex(verleid,v,verleiden,[morph(verleiden,ed(2))]).

%lex(liking,v,like,[morph(like,ing)]).
lex(mag,v,mogen,[morph(mogen,t)]).
lex(mocht,v,mogen,[morph(mogen,ed(1))]).
lex(gemogen,v,mogen,[morph(mogen,ed(2))]).

%lex(meeting,v,meet,[morph(meet,ing)]).
lex(ontmoet,v,ontmoeten,[morph(ontmoeten,t)]).
lex(ontmoette,v,ontmoeten,[morph(ontmoeten,ed(1))]).
lex(ontmoet,v,ontmoeten,[morph(ontmoeten,ed(2))]).

% develop (un-wrap)
lex(ontwikkel,v,ontwikkelen,[morph(ontwikkelen,n)]).
lex(ontwikkelt,v,ontwikkelen,[morph(ontwikkelen,t)]).
lex(ontwikkelde,v,ontwikkelen,[morph(ontwikkelen,ed(1))]).
lex(ontwikkelden,v,ontwikkelen,[morph(ontwikkelen,ed(3))]).
lex(ontwikkeld,v,ontwikkelen,[morph(ontwikkelen,ed(2))]).

%lex(mentioning,v,mention,[morph(mention,ing)]).
lex(noemt,v,noemen,[morph(noemen,t)]).
lex(noemde,v,noemen,[morph(noemen,ed(1))]).
lex(genoemd,v,noemen,[morph(noemen,ed(2))]).

%lex(parking,v,park,[morph(park,ing)]).
lex(parkeert,v,parkeren,[morph(parkeren,t)]).
lex(parkeerde,v,parkeren,[morph(parkeren,ed(1))]).
lex(geparkeerd,v,parkeren,[morph(parkeren,ed(2))]).

%%lex(persuading,v,persuade,[morph(persuade,ing)]).
lex(overtuigt,v,overtuigen,[morph(overtuigen,t)]).
lex(overtuigde,v,overtuigen,[morph(overtuigen,ed(1))]).
lex(overtuigd,v,overtuigen,[morph(overtuigen,ed(2))]).

%lex(pleasing,v,please,[morph(please,ing)]). % Hmmm.... %lex(pleases,v,please,[morph(please,s)]).
%lex(pleased,v,please,[morph(please,ed(_))]).

%lex(promising,v,promise,[morph(promise,ing)]).
lex(belooft,v,beloven,[morph(beloven,t)]).
lex(beloofde,v,beloven,[morph(beloven,ed(1))]).
lex(beloofd,v,beloven,[morph(beloven,ed(2))]).

%lex(raining,v,rain,[morph(rain,ing)]).
lex(regent,v,regenen,[morph(regenen,t)]).
lex(regende,v,regenen,[morph(regenen,ed(1))]).
lex(geregend,v,regenen,[morph(regenen,ed(2))]).

%lex(reading,v,read,[morph(read,ing)]).
lex(leest,v,lezen,[morph(lezen,t)]).
lex(las,v,lezen,[morph(lezen,ed(1))]).
lex(gelezen,v,lezen,[morph(lezen,ed(2))]).

lex(repareer,v,repareren,[morph(repareren,n)]).
lex(repareert,v,repareren,[morph(repareren,t)]).
lex(repareerde,v,repareren,[morph(repareren,ed(1))]).
lex(repareerden,v,repareren,[morph(repareren,ed(3))]).
lex(gerepareerd,v,repareren,[morph(repareren,ed(2))]).

%lex(removing,v,remove,[morph(remove,ing)]).
lex(verwijdert,v,verwijderen,[morph(verwijderen,t)]).
lex(verwijderde,v,verwijderen,[morph(verwijderen,ed(1))]).
lex(verwijderd,v,verwijderen,[morph(verwijderen,ed(2))]).

%lex(resigning,v,resign,[morph(resign,ing)]).  %% is reflexive in Dutch
%lex(resigns,v,resign,[morph(resign,s)]).
%lex(resigned,v,resign,[morph(resign,ed(_))]).

%lex(saying,v,say,[morph(say,ing)]).
lex(zegt,v,zeggen,[morph(zeggen,t)]).
lex(zei,v,zeggen,[morph(zeggen,ed(1))]).
lex(gezegd,v,zeggen,[morph(zeggen,ed(2))]).

%lex(seeing,v,see,[morph(see,ing)]).
lex(ziet,v,zien,[morph(zien,t)]).
lex(zag,v,zien,[morph(zien,ed(1))]).
lex(gezien,v,zien,[morph(zien,ed(2))]).

%lex(seeming,v,seem,[morph(seem,ing)]).
lex(schijnt,v,schijnen,[morph(schijnen,t)]).
lex(scheen,v,schijnen,[morph(schijnen,ed(1))]).
%lex(scheen,v,schijnen,[morph(schijnen,ed(1))]). % ed(2) does not exist 

%lex(sleeping,v,sleep,[morph(sleep,ing)]).
lex(slaapt,v,slapen,[morph(slapen,t)]).
lex(sliep,v,slapen,[morph(slapen,ed(1))]).
lex(geslapen,v,slapen,[morph(slapen,ed(2))]).

%lex(solving,v,solve,[morph(solve,ing)]).
lex(lost_op,v,oplossen,[morph(oplossen,t)]).
lex(loste_op,v,oplossen,[morph(oplossen,ed(1))]).
lex(opgelost,v,oplossen,[morph(oplossen,ed(2))]).

%lex(standing,v,stand,[morph(stand,ing)]).
lex(staat,v,staan,[morph(staan,t)]).
lex(stond,v,staan,[morph(staan,ed(1))]).
lex(gestaan,v,staan,[morph(staan,ed(2))]).

%lex(starting,v,start,[morph(start,ing)]).  %% ???
%lex(starts,v,start,[morph(start,s)]).
%lex(started,v,start,[morph(start,ed(_))]).

%lex(talking_to,v,talk_to,[morph(talk_to,ing)]).
lex(praat_met,v,praten_met,[morph(praten_met,t)]).
lex(praatte_met,v,praten_met,[morph(praten_met,ed(1))]).
lex(gepraat_met,v,praten_met,[morph(praten_met,ed(2))]).

%lex(telling,v,tell,[morph(tell,ing)]).
lex(vertelt,v,vertellen,[morph(vertellen,t)]).
lex(vertelde,v,vertellen,[morph(vertellen,ed(1))]).
lex(verteld,v,vertellen,[morph(vertellen,ed(2))]).

%lex(trying,v,try,[morph(try,ing)]).
lex(probeert,v,proberen,[morph(proberen,t)]).
lex(probeer,v,proberen,[morph(proberen,n)]).
lex(probeerde,v,proberen,[morph(proberen,ed(1))]).
lex(geprobeerd,v,proberen,[morph(proberen,ed(2))]).

%lex(thinking,v,think,[morph(think,ing)]).
lex(denk,v,denken,[morph(denken,n)]).
lex(denkt,v,denken,[morph(denken,t)]).
lex(dacht,v,denken,[morph(denken,ed(1))]).
lex(gedacht,v,denken,[morph(denken,ed(2))]).

%lex(understanding,v,understand,[morph(understand,ing)]).
lex(begijpt,v,begrijpen,[morph(begrijpen,t)]).
lex(begreep,v,begrijpen,[morph(begrijpen,ed(1))]).
lex(begrepen,v,begrijpen,[morph(begrijpen,ed(2))]).

%lex(visiting,v,visit,[morph(visit,ing)]).
lex(bezoekt,v,bezoeken,[morph(bezoeken,t)]).
lex(bezocht,v,bezoeken,[morph(bezoeken,ed(_))]).

%lex(wanting,v,want,[morph(want,ing)]).
lex(wil,v,willen,[morph(willen,t)]).
lex(wilde,v,willen,[morph(willen,ed(1))]).
lex(gewild,v,willen,[morph(willen,ed(2))]).

%lex(winning,v,win,[morph(win,ing)]).
lex(wint,v,winnen,[morph(winnen,t)]).
lex(won,v,winnen,[morph(winnen,ed(1))]).
lex(gewonnen,v,winnen,[morph(winnen,ed(2))]).

%lex(wondering,v,wonder,[morph(wonder,ing)]).  %% reflexive in Dutch
%lex(wonders,v,wonder,[morph(wonder,s)]).
%lex(wondered,v,wonder,[morph(wonder,ed(_))]).

%lex(working,v,work,[morph(work,ing)]).

lex(werkt,v,werken,[morph(werken,t)]).
lex(werkte,v,werken,[morph(werken,ed(1))]).
lex(gewerkt,v,werken,[morph(werken,ed(2))]).

% CONTRACTIONS

contraction(X$[percep],[X,te1]).
:- initialization(no contraction(_,_,_)).

% MISCELLANEOUS

nounFeatures(Base,F) :-	lex(Base,n,F1),	pick1(agr(_),F1,F).

verbFeatures(Base,F) :-
	lex(Base,v,F1),
	pick1(morph(Base,_),F1,F).

verbToNounFeatures(Base,F) :-
	lex(Base,v,F1),
	pick1(morph(Base,_),F1,F).
%	pickNF1(ecm(_),F2,F).	% proper government for nominalized forms

%% MAPS MORPHOLOGY INTO SYNTACTIC FEATURES
%%	Verb morphology and Agreement
%% 
%%	Form	Tense		AGR			    NEW
%%	base 	infinitival
%%	base 	past(-) 	agr(not 1,2,3,sg)
%%	-nil	past(-)		agr(1,sg)		    ***
%%	-t	past(-) 	agr(2,3,sg)
%%	-ed(1) 	past(+)		agr(1,2,3,sg)
%%	-ed(3)	past(+)		agr(1,2,3,pl)               ***
%% 	-ing	prog, infinitival   % don't need this one
%%	-ed(2)	perf, passive
%%	ben	past(-) 	agr(1,sg)
%%	bent	past(-)		agr(2,sg)
%%	was	past(+)		agr(1,2,3,sg)
%%	waren	past(+) 	agr(not 1,2,3,sg)

% non-deterministic
vMorphToFs(_,def(F),[F,agr(_)]) :-		% defective: modal auxiliaries
	!.
vMorphToFs(_,[],[]).				% infinitival form
vMorphToFs(Base,Form,Features) :-
	\+ irregular(Base,Form),
	tns(Form,F1),
	agr(Form,F2),
	append(F1,F2,Features).

% base form is irregular: (regular [] -> past(-) not 3sg) 
irregular(Base,[]) :- irregular(Base).

% verb form <-> AGR feature
agr([],[agr([[],pl,[]])]).
agr(t,[agr([[2,3],[sg,m],[]])]).
agr(n,[agr([1,sg,[]])]). 		% n for NULL
agr(nt,[agr([[],[sg,m],[]])]).			  % composite
agr(ed(3),[agr([],pl,[])]).
agr(ed(2),[]).
agr(ed(1),[agr([[],[sg,m],[]])]).

agr(ben,[agr([1,[sg],[]])]).
agr(zijn,[agr(not([[1,2,3],[sg,m],[m,f,n]]))]). 
agr(was,[agr([[],[sg,m],[]])]).
agr(waren,[agr(not([[1,2,3],[sg,m],[m,f,n]]))]).			
agr(bent,[agr([2,sg,[]])]).

% verb form <-> Tense feature
tns([],[past(-)]).		
tns(t,[past(-)]).		
tns(n,[past(-)]).
tns(nt,[past(-)]).				  % composite

tns(ed(1),[past(+)]).	
tns(ed(3),[past(+)]).
tns(ed(2),[]).			
tns(ben,[past(-)]).	
tns(bent,[past(-)]).
tns(zijn,[past(-)]).		
tns(was,[past(+)]).		
tns(waren,[past(+)]).	

:- dynamic inf/2.


addInf(IP) :-
	cat(IP,i2)
	-> VP complement_of IP,
	   VP has_feature morph(_,[]),
	   addFeature(inf([]),IP)
	;  true.

agrConstraint(X) :- intersectAGR([[],[],[n]],X) if cat(X,np).
