%%% Canonical Structural Realization (CSR)
%%%
%%% (c) 1991, 1992, 1993  Sandiway Fong, NEC Research Institute, Inc.
%%%

%%% EXPORTS
%%%	csr(Role,C)			Canonical Structure Realization (CSR)
%%%	ensureWhComp(Ci)		used in lexicon
%%%	optWhComp(Ci)			used in lexicon

csr(agent,np).
csr(experiencer,np).
csr(recipient,np).
csr(patient,np).
csr(source,np).
csr(destination,np).
csr(theme,np).
csr(themeNA,np).
csr(themeA,np).
csr(weakTheme,np).
csr(instrument,np).
csr(state,np).
csr(location,np).
csr(possessor,np).
csr(goal,np).
csr(eq,np).
csr(reducedProp,i2).				  % control verbs etc.
csr(propositionD,i2).				  % temporary
csr(propositionD,c2).
csr(proposition1,c2).
csr(proposition,c2).
csr(proposition,np).
csr(pHolder(_),np). 
csr(predicate(X),X). 
csr(role(_),np).				  % short-hand

csr(Role$_,C) :- csr(Role,C).
csr([Role],C) :- csr(Role,C).

csrRestriction(weakTheme,goal(priorityNonArg(X),X)).
csrRestriction(themeA,goal(intersectAGR(X,[[],[],[m,f]]),X)).
csrRestriction(themeNA,goal(intersectAGR(X,[[],[],n]),X)).

% i.e. fail if nonarg(+)
priorityNonArg(X) :- \+ X has_feature nonarg(+).


ensureWhComp(CP) :-				 
	C head_of CP,
	(ec(C) 
	-> make C have_feature wh		  % Q
	;  C has_feature wh).

optWhComp(CP) :-  
	C head_of CP,
	make C have_feature wh(_) if ec(C).

% allow search for feature allowExt(Role) to be transparent
% wrt. VP subcategorization

vpAllowExt(Y,VP) :-
	(VP has_feature allowExt(X)
	-> X = Y
	;  VP subcategorizes_for VPp,
	   cat(VPp,vp), 
	   vpAllowExt(Y,VPp)) if cat(VP,vp).

% allow search for feature allowExt(Role) to be transparent
% wrt. VP subcategorization

vpAllowExtL(L,VP) :-
	(VP has_feature allowExt(X)
	-> in1(X,L)
	;  VP subcategorizes_for VPp,
	   cat(VPp,vp), 
	   vpAllowExtL(L,VPp)) if cat(VP,vp).

vpRequiresExt(VP) :-
	(VP has_feature requiresExt(X)
	-> Y adjunct_of VP,
	   Y has_feature predicate(X),
	   !
	;  ((VP subcategorizes_for VPp, cat(VPp,vp))
	   -> vpRequiresExt(VPp,VP)
	   ;  true)) if cat(VP,vp).

vpRequiresExt(VP,MaxVP) :-
	VP has_feature requiresExt(X)
	-> Y adjunct_of MaxVP,
	   Y has_feature predicate(X),
	   !
	;  ((VP subcategorizes_for VPp, cat(VPp,vp))
	   -> vpRequiresExt(VPp,MaxVP)
	   ;  true).

%%
roleNotPresent(VP,Role) :-
	VP has_feature grid(Rs1,Rs2)
	-> \+ (in(Role,Rs1), in(Role,Rs2))
	;  (roleNotPresent(VPp,Role) if cat(VPp,vp)) 
	   if VP subcategorizes_for VPp.
	   

