/* UFOPEN.C - user friendly (?) wrapper for fopen()
 ***************************************************************************
 *	EDIT HISTORY
 *	17-MAY-82	D. Weber/Bob Kasper
 *	07-MAR-85	hab
 *	11-Oct-85	SRMc - port to Unix & MSDOS
 *	20-Feb-86	SRMc - reformat & edit comments
 *	15-Dec-86	SRMc - allow append ("a") mode
 *	16-Jan-87	SRMc - check whether output file already exists
 *	28-Mar-87	SRMc - remove RT-11 stuff (now have MACRO-11 source)
 *	13-Apr-87	SRMc - fix bug in scanning table of valid output
 *				devices
 *	17-Jan-91	SRMc - use <string.h>/<strings.h>
 *			     - replace index() with strchr()
 *			     - add ANSI-fied function prototypes
 *	 9-Mar-91	SRMc - use #ifdef TTY around fopen(TTY,...)
 *			     - replace fgetss() with fgets() and explicit
 *				zapping of the trailing '\n'
 ***************************************************************************
 * Copyright 1982, 1991 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#include <stdio.h>
#ifdef BSD
#include <strings.h>
#define strchr index
#else
#include <string.h>
#endif
#ifdef THINK_C
#include <unix.h>
#define MACINTOSH
#endif
#ifdef unix
#define TTY "/dev/tty"
#define FILENAMESIZE 80
#define GOOD_MODES "rwa"
#endif
#ifdef MSDOS
#define TTY "CON"
#define FILENAMESIZE 80
#define GOOD_MODES "rwa"
#endif
#ifdef MACINTOSH
#define FILENAMESIZE 80
#define GOOD_MODES "rwa"
#endif

#ifdef __STDC__
#define P(s) s
#else
#define P(s) ()
#endif

FILE *ufopen P((char *fname, char *mode));

/* standard library functions */
#ifndef isatty
extern int isatty P((int fd ));
#endif

/* local functions */
static int out_okay P((char *name ));

#undef P

static char *okayout[] =
    {
#ifdef unix
    "/dev/null",
#endif
#ifdef MSDOS
    "NUL", "nul", "AUX", "aux", "COM1", "com1", "COM2", "com2", "PRN", "prn",
#endif
    NULL
    };

/************************************************************************
 * NAME
 *    ufopen
 * ARGUMENTS
 *    fname - filename to try, or null if a prompt is desired
 *    mode  - file mode for fopen() ("r", "w", or "a")
 * DESCRIPTION
 *    Open a file, retrying until successful.  `fname' is updated to
 *    contain the name of the file actually opened (unless the NULL
 *    pointer is passed).
 * RETURN VALUE
 *    FILE pointer
 */
FILE *ufopen(fname, mode)
char *fname;
char *mode;
{
char new_name[FILENAMESIZE];	/* space for new file name */
register FILE *fp;		/* file pointer to return */
register char *pnn;		/* pointer to new_name */
char *p;

pnn = new_name;
/*
 *  establish working mode for opening file
 */
if (strchr(GOOD_MODES,*mode) == (char *)NULL)
    {
    fprintf(stderr, "\nUFOPEN-W-BAD MODE--opening file for reading.\n");
    mode = "r";
    }
/*
 *  get filename if not provided by caller
 */
if ((fname == (char *)NULL) || (*fname == '\0'))
    {
    fprintf(stderr, "\n\t%s file: ", (*mode=='r') ? "Input" : "Output");
    fgets(pnn, FILENAMESIZE, stdin);
    if ((p=strchr(pnn,'\n')) != (char *)NULL)
	*p = '\0';
    if (!isatty(fileno(stdin)))
	fprintf(stderr, "%s\n", pnn);
    }
else
    strcpy(pnn, fname);
/*
 *  retry until successful
 */
for (;;)
    {
    if (    (*pnn != '\0') &&		/* skip over null filenames */
	    (*pnn != '\n') &&
	    ((mode[0] != 'w') || out_okay(pnn)) &&
	    ((fp = fopen(pnn,mode)) != NULL))
	break;				/* file opened okay */
    /*
     *  get a new filename from the user at the keyboard
     */
    fprintf(stderr, "\nCan't open %s file, %s\n\t\tRetry: ",
		((mode[0] == 'r') ? "input" : "output"), pnn);
#ifdef TTY
    fp = fopen(TTY, "r");
    fgets(pnn, FILENAMESIZE, fp);
    fclose(fp);
#else
    fgets(pnn, FILENAMESIZE, stdin);
#endif
    if ((p=strchr(pnn,'\n')) != (char *)NULL)
	*p = '\0';
    }
/*
 *  return the actual filename opened as fname if possible
 */
if (fname != NULL)
    strcpy(fname, pnn);
return(fp);
}

/************************************************************************
 * NAME
 *    out_okay
 * ARGUMENTS
 *    name - filename to try
 * DESCRIPTION
 *    Check whether or not it's okay to open the file for output.
 * RETURN VALUE
 *    nonzero if it's okay to open the file for output, zero if it should
 *    not be opened for output
 */
static int out_okay(name)
register char *name;
{
register char **table;
char response[4];		/* space for keyboard response */
FILE *fp;

if ((fp = fopen(name,"r")) == NULL)
    return( 1 );		/* okay if file doesn't exist */

if (isatty(fileno(fp)))
    {
    fclose(fp);
    return( 1 );		/* okay if file is TTY device */
    }
fclose(fp);
for ( table = okayout ; *table ; ++table )
    {
    if (strcmp(name,*table)==0)
	return( 1 );		/* okay if file on approved list */
    }
/*
 *  file exists -- check with user for what to do
 */
fprintf(stderr, "\n\"%s\" already exists.  Overwrite it? [n] ", name );
#ifdef TTY
fp = fopen(TTY, "r");
fgets(response, 4, fp);
fclose(fp);
#else
fgets(response, 4, stdin);
#endif
return( (response[0] == 'Y') || (response[0] == 'y') );
}
