/*	FILE:		STRPOS.C
 *	DATE WRITTEN:	31-Mar-87	BY: Steve McConnel
 *	DATE MODIFIED:
 *
 *	FUNCTIONS:	strpos - as defined by Harbison & Steele
 */

#define NULL ((char *)0)
#define NUL '\0'

/************************************************************************
 * NAME
 *    strpos
 * ARGUMENTS
 *    s - address of NUL-terminated character string
 *    c - character to search for
 * DESCRIPTION
 *    Search for the first occurrence of the character c in the string s.
 *    If the character c is found in the string, the position
 *    of the first occurrence is returned (where the first character of s
 *    is considered to be at position 0).  If the character is not found,
 *    the value -1 is returned.  The terminating NUL character is considered
 *    to be part of s for the purposes of the search, so searching for NUL
 *    returns the position of the terminated NUL (which is equal to the
 *    length of the string), not the value -1.  strpos(s,'\0') is therefore
 *    equivalent to strlen(s).
 * RETURN VALUE
 *    position of the first occurrence of c in s, or -1 if c does not
 *    occur in s
 */
int strpos(s,c)
char *s;
register char c;
{
register char *p;

if ((p = s) == NULL)
    return( -1 );
do  {
    if (*p == c)
	return( p - s );
    } while (*p++ != NUL);
return( -1 );
}
