/*	STRLIST.H - definition of strlist structure
 ***************************************************************************
 *
 *	struct strlist
 *
 ***************************************************************************
 *	EDIT HISTORY
 *	 8-May-89	SRMc - extract from AMPLE's defs.h file
 ***************************************************************************
 * Copyright 1989 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */

/***************************************************************************
 *  structure for a linked list of NUL-terminated character strings
 */
struct strlist
    {
    char *stri;			/* pointer to string */
    struct strlist *slink;	/* pointer to next node in linked list */
   };

/*
 *  functions provided in strlist.c for handling lists of strings
 */
extern struct strlist *add_to_strlist();	/* add a string to a list */
extern struct strlist *remove_from_strlist();	/* remove a string from a list */
extern int member_strlist();		/* is string a member of a list? */
extern int size_of_strlist();		/* how many members in the list ? */
extern void write_strlist();		/* write a list to a file */
extern void delete_strlist();		/* erase a list, freeing space */
