/*	FILE:		STCMP.C
 *	DATE WRITTEN:	24-Sep-85	BY: SRMc
 *	DATE MODIFIED:	31-Mar-87	BY: SRMc - reformat & edit comments
 *
 *	FUNCTIONS:	stcmp - as developed for CADA
 */
#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

int stcmp P((char *s, char *t));
#undef P

/************************************************************************
 * NAME
 *    stcmp
 * ARGUMENTS
 *    s - pointer to the first string
 *    t - pointer to the second string
 * DESCRIPTION
 *    Compare two strings, using the end of the second string as the
 *    cutoff point for the comparison.
 * RETURN VALUE
 *    nonzero if the two strings are equal up to the end of the second
 *    string, zero otherwise
 */
int stcmp(s,t)
char *s, *t;
{
register char *s1, *t1;
register char c;

if (!(t1 = t) || !*t1)
    return(1);		/* null string matches any string */
if (!(s1 = s) || !*s1)
    return(0);		/* nothing else matches a null string */
while (c = *t1++)
    {
    if (*s1++ != c)
	return(0);	/* signal failure */
    }
return(1);		/* signal success */
}
