/*      SPLITL.C - split a line into pieces for changes and rules
 ***************************************************************************
 *
 *      char *split_line(line,p_rep,p_marks,p_env)
 *      char *line;
 *      char **p_rep;
 *      char **p_marks;
 *      char **p_env;
 *
 ***************************************************************************
 *      EDIT HISTORY
 *      20-May-89       Steve McConnel
 * 1.1c 29-Jun-90 ALB Fix bug of 8-bit fail in envir, add myisspace
 *	27-Dec-90	SRMc - replace stcmp() with match_begin() [new name]
 *			     - add #define index #ifndef BSD
 *	11-Mar-91	SRMc - add #include <string(s).h>
 *			     - replace index() with strchr() throughout
 ***************************************************************************
 * Copyright 1989, 1990, 1991 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#include <stdio.h>
#include <ctype.h>
#ifndef isascii
#define isascii(x) (!(x & ~0177))
#endif
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "opaclib.h"

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

/* splitl.c */
char *split_line P((char *line , char **p_rep , char **p_marks , char **p_env ));

/* myalloc.c */
void myalloc_fail P((void ));
char *mystrdup P((char *str ));
char *myrealloc P((char *s , unsigned size ));
char *myshrink P((char *s ));
void myfree P((char *s ));

/* getwd.c */
char *skipwhite P((char *cp ));
char *getwd P((char *cp ));

extern int match_begin P((char *str, char *sub));

#undef P

extern int do_debug;

/***************************************************************************
 * NAME
 *    split_line
 * ARGUMENTS
 *    line
 *    p_rep
 *    p_marks
 *    p_env
 * DESCRIPTION
 *    Parse a line of input which has the following fields:
 *	1) an initial delimited string
 *	2) if p_rep is not NULL, a second delimited string
 *	3) if p_marks is not NULL, an optional list of items before any
 *	   environment
 *	4) if p_env is not NULL, an optional environment
 *    The delimiter at the end of the initial string is replaced by a NUL.
 *    The second delimited string is treated similarly, with the address
 *    of the string being stored through p_rep.  If an environment is found,
 *    a pointer to it is stored through p_env.  If any tokens are found
 *    between the end of the strings and the beginning of an environment,
 *    the address of the initial token is stored through p_marks.
 * RETURN VALUE
 *    pointer to the initial delimited string in the input line
 *    (p_rep, p_marks, and p_env are pointers to values which may be
 *    changed as a side effect of this function)
 *    NULL if a required string is not found
 */
char *split_line(line,p_rep,p_marks,p_env)
char *line;
char **p_rep;
char **p_marks;
char **p_env;
{
register char *p;
char *match, *replace, *marks, *env;
char delim;
/*
 *  find the initial (match) string, and terminate it with a NUL
 */
match = skipwhite(line);
if ((delim = *match++) == NUL)
    return((char *)NULL);
if ((p = strchr(match,delim)) == (char *)NULL)
    return((char *)NULL);
*p++ = NUL;
/*
 *  if requested, find the second (replace) string, and terminate it likewise
 */
if (p_rep != (char **)NULL)
    {
    if ((replace = strchr(p,delim)) == (char *)NULL)
	return((char *)NULL);
    if ((p = strchr(++replace,delim)) == (char *)NULL)	/* (adjust replace) */
	return((char *)NULL);
    *p++ = NUL;
    }
/*
 *  isolate any markers or environment
 */
env = (char *)NULL;
marks = skipwhite(p);
if ((*marks != NUL) && (p_env != (char **)NULL))
    {
    if ((*marks == '/') || match_begin(marks,"+/"))
	{
	env = marks;
	marks = (char *)NULL;
	}
    else
	{
	/*
	 *  look for an environment marker (/ or +/) preceded by whitespace
	 */
	p = marks;
	while ((env = strchr(p,'/')) != (char *)NULL)
	    {
	    p = env+1;			/* advance start of search */
	    if (*(env-1) == '+')
		--env;			/* back up to leading + if +/ */
	    if (myisspace(*(env-1)))
		{
		*(env-1) = NUL;		/* terminate markers */
		break;
		}
	    }
	}
    }
if (marks && (*marks == NUL))
    marks = (char *)NULL;		/* convert empty string to NULL */
/*
 *  check for unwanted clutter
 */
if ((marks != (char *)NULL) && (p_marks == (char **)NULL))
    return((char *)NULL);		/* unwanted markers */
if ((env != (char *)NULL) && (p_env == (char **)NULL))
    return((char *)NULL);		/* unwanted environment */
/*
 *  we've collected everything safely, so stuff the return values and return
 */
if (p_rep != (char **)NULL)
    *p_rep = replace;
if (p_marks != (char **)NULL)
    *p_marks = marks;
if (p_env != (char **)NULL)
    *p_env = env;
return( match );
}
