/*	OPACLIB.H - general definitions for OPAC library functions
 ***************************************************************************
 *	EDIT HISTORY
 *	26-APR-82	D. Weber/Bob Kasper
 *	 7-MAR-85	H.A. Black
 *	 7-APR-85	DW
 *	13-Nov-85	SRMc
 *	 3-SEP-86	hab
 *	15-Jan-87	hab - gen'ld surface allos
 *	17-Feb-87	hab - gen'ld categories
 *	12-Mar-87	hab - maxnumpfx now user-defined
 *	10-Apr-87	hab - version 3.0
 *	16-Sep-87	hab - removed titles to titles.h
 *	18-Mar-88	hab - change FIELDTERM to \
 *	12-Apr-88	hab - removed ALDEFAULT & MAXMORPH
 *	15-Apr-88	hab - removed RECSIZE
 *	 1-Jun-88	SRMc - add orig_word field to template structure
 *	 2-Jun-88	SRMc - remove new_word[256] field from template
 *				structure
 *	28-Jul-88	SRMc - replace ssalloc() with malloc() and realloc()
 *	26-Aug-88	SRMc - remove definitions for CADA, ANALONLY,
 *				TXT_INPUT, NFILES, FORMINIT, BREAKC, ORTHOTAB,
 *				NAME_SIZE
 *	 7-Sep-88	SRMc - remove extern declarations
 *	21-Oct-88	SRMc - reorganize the file header comments
 *			     - change #ifdef MSDOS to #ifdef AZTEC for agetc()
 *			     - add ct_first field to struct code_table
 *	26-Jul-89	hab  - removed strlist struct; replaced by STAMP's
 *					strlist.h
 *			       removed code_table struct; replaced by STAMP's
 *					codetab.h
 *	27-Jul-89	hab  - add Copyright 1989
 *			       remove #define FIELDTERM '\\'; it is in record.c
 *	31-Jul-89	rk   - mods for MacIntosh Lightspeed's Think_C
 *	01-Aug-89	ab/hab - Define myisspace(), myisdigit(), myispunct()
 *				 to handle 8-bit characters
 *	19-Jan-91	SRMc - remove struct definition, since TEMPLATE.H
 *				exists separately
 *	 2-Mar-91	SRMc - rename from DEFS.H to OPACLIB.H, since this is
 *				now associated with a function library rather
 *				than a particular program
 *			     - remove AMPLE-specific constants
 *	11-Mar-91	SRMc - #define strchr and strrchr for #ifdef BSD
 ***************************************************************************
 * Copyright 1989, 1991 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#ifndef _OPACLIB_DOT_H_ALREADY_LOADED_
#define _OPACLIB_DOT_H_ALREADY_LOADED_

#ifndef TRUE
#define TRUE (1)		/* not every system defines these elsewhere */
#define FALSE (0)
#endif
#define NUL '\0'		/* the ASCII NUL character */
#define READ  "r"		/* for ufopen */
#define WRITE "w"
#define BUFSIZE 300		/* general size for internal buffers */

			/* record definitions */

#define EOR '\030'		/* magic code value (CTRL/X) */

/*
 *  make up as best we can for brain-damaged getc() & putc() in Aztec C
 */
#ifdef AZTEC
#define getc agetc
#define putc aputc
#endif
/*
 *  cover for BSD using index() and rindex()
 */
#ifdef BSD
#define strchr index
#define strrchr rindex
#endif
/*
 *	Define myisspace(), myisdigit(), and myispunct() in order to
 *	properly deal with 8-bit characters
 */
#define myisspace(x) (isascii(x) ? isspace(x) : FALSE)
#define myisdigit(x) (isascii(x) ? isdigit(x) : FALSE)
#define myispunct(x) (isascii(x) ? ispunct(x) : FALSE)
/*
 *  allocate memory for a specified struct
 */
#ifndef NO_STRUCTALLOC
#ifndef THINK_C
#if __STDC__
#if defined(BSD) && !defined (__GNUC__)
extern char *myalloc(unsigned size);
#else
extern void *myalloc(unsigned size);
#endif
#else
extern char *myalloc();
#endif
#endif
#define structalloc(x) (struct x *) myalloc( sizeof(struct x) )
#endif

#endif /* _OPACLIB_DOT_H_ALREADY_LOADED_ */
