/*      MYCTYPE.C - ctype-like routines to deal with upper ASCII
 *		    Used in both AMPLE and STAMP
 ***************************************************************************
 *
 *	int myisalpha( c )
 *	int c;
 *
 *	int myislower( c )
 *	int c;
 *
 *	int myisupper( c )
 *	int c;
 *
 *	int mytolower( c )
 *	int c;
 *
 *	int mytoupper( c )
 *	int c;
 *
 ***************************************************************************
 *      EDIT HISTORY
 * 1.6e 02-Aug-90 hab - Original creation
 * 1.6e 02-Aug-90 hab Change index to strchr and rindex to strrchr
 ***************************************************************************
 * Copyright 1990 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#include <stdio.h>
#include <ctype.h>
#ifndef isascii
#define isascii(x) (!(x & ~0177))
#endif
#include <string.h>
#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

/* myctype.c */
int myisalpha P((int c ));
int myislower P((int c ));
int myisupper P((int c ));
int mytolower P((int c ));
int mytoupper P((int c ));

#undef P

				/* special lower/upper case lists */
extern char *loweralpha;
extern char *upperalpha;

/***************************************************************************
 * NAME
 *    myisalpha
 * ARGUMENTS
 *    c     - integer character to check for 'alphabetic' status:
 *		i.e. it has a lower or upper case equivalent
 * DESCRIPTION
 *    Check to see if the character has either a lower or upper case
 *	equivalent
 * RETURN VALUE
 *    TRUE  if there is an equivalent
 *    FALSE otherwise
 */
int myisalpha( c )
int c;
{
return((upperalpha && strchr(upperalpha, c)) || /* can be in upper case list or */
	(loweralpha && strchr(loweralpha, c)) ||/* can be in lower case list or */
	(isascii(c) && isalpha(c)) );      /* is lower-ASCII alpha */
}

/***************************************************************************
 * NAME
 *    myislower
 * ARGUMENTS
 *    c     - integer character to check for lower case status
 * DESCRIPTION
 *    Check to see if the character is considered to be lower case
 * RETURN VALUE
 *    TRUE  if the character is considered to be lower case
 *    FALSE otherwise
 */
int myislower( c )
int c;
{
return((loweralpha && strchr(loweralpha, c)) || /* can be in lower case list or */
	  (isascii(c) && islower(c)) );     /* is lower-ASCII lower case */
}

/***************************************************************************
 * NAME
 *    myisupper
 * ARGUMENTS
 *    c     - integer character to check for upper case status
 * DESCRIPTION
 *    Check to see if the character is considered to be upper case
 * RETURN VALUE
 *    TRUE  if the character is considered to be upper case
 *    FALSE otherwise
 */
int myisupper( c )
int c;
{
return((upperalpha && strchr(upperalpha, c)) || /* can be in upper case list or */
	  (isascii(c) && isupper(c)) );     /* is lower-ASCII uppercase */
}

/***************************************************************************
 * NAME
 *    mytolower
 * ARGUMENTS
 *    c     - integer character to (possibly) lower
 * DESCRIPTION
 *    Convert character in c to its lower-case equivalent
 * RETURN VALUE
 *    lowercase equivalent of c
 */
int mytolower( c )
int c;
{
  char *cp;
					/* look for char in upper case list */
  if (upperalpha && (cp = strchr(upperalpha, c)))
    					/* return its lower case equivalent */
      return((int) *(loweralpha + (cp - upperalpha)));
  else
      if (isascii(c) && isupper(c))
	   return( tolower(c));
      else
	return( c );
}

/***************************************************************************
 * NAME
 *    mytoupper
 * ARGUMENTS
 *    c     - integer character to (possibly) upper
 * DESCRIPTION
 *    Convert character in c to its upper-case equivalent
 * RETURN VALUE
 *    uppercase equivalent of c
 */
int mytoupper( c )
int c;
{
  char *cp;
					/* look for char in lower case list */
  if (loweralpha && (cp = strchr(loweralpha, c)))
    					/* return its upper case equivalent */
      return((int) *(upperalpha + (cp - loweralpha)));
  else
      if (isascii(c) && islower(c))
	   return( toupper(c));
      else
	return( c );
}
