/*  MATCHBEGIN.C - check if one string begins identically to another string
 ******************************************************************************
 *
 *	int match_begin(s, t)
 *	char *s;
 *	char *t;
 *
 ******************************************************************************
 *	EDIT HISTORY
 *	24-Sep-85	Steve McConnel - write stcmp() to support CQAP programs
 *	31-Mar-87	SRMc - reformat & edit comments
 *	21-Dec-90	SRMc - rename stcmp() to match_begin(), reformat header
 *			     - reformat file header
 *			     - rewrite slightly for simplicity
 ******************************************************************************
 * Copyright 1991 by the Summer Institute of Linguistics, Inc.
 */
#ifndef NULL
#define NULL (char *)0
#endif
#define NUL '\0'
#ifndef TRUE
#define TRUE (1)
#define FALSE (0)
#endif

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

int match_begin P((char *s, char *t));
#undef P

/******************************************************************************
 * NAME
 *    match_begin
 * ARGUMENTS
 *    s - pointer to the first string
 *    t - pointer to the second string
 * DESCRIPTION
 *    Compare two strings, using the end of the second string as the
 *    cutoff point for the comparison.
 * RETURN VALUE
 *    nonzero if the two strings are equal up to the end of the second
 *    string, zero otherwise
 */
int match_begin(s,t)
register char *s, *t;
{
if (t == NULL)
    return(TRUE);	/* null string matches any string */
if (s == NULL)
    return(FALSE);	/* nothing else matches a null string */
while ( *t != NUL )
    {
    if (*s++ != *t++)
	return(FALSE);	/* signal failure */
    }
return(TRUE);		/* signal success */
}
