/*      LUWFC.C -    handle \luwfc fields during processing of
 *                   either the xxINTX.CTL  file (AMPLE)
 *                   or     the xxOUTTX.CTL file (STAMP)
 ***************************************************************************
 *
 *      void init_luwfc()
 *
 *      char *add_luwfc(rp, ap)
 *      char *rp, *ap;
 *
 *      void set_luwfc()
 *
 ***************************************************************************
 *      EDIT HISTORY
 * 1.6e 02-Aug-90       hab - original creation
 ***************************************************************************
 * Copyright 1990 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#include <stdio.h>
#include <ctype.h>
#ifndef isascii
#define isascii(x) (!(x & ~0177))
#endif
#include <string.h>
#include "opaclib.h"

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

/* luwfc.c */
void init_luwfc P((void ));
char *add_luwfc P((char *rp , char *ap ));
void set_luwfc P((void ));

/* myalloc.c */
void myalloc_fail P((void ));
/* char *myalloc P((unsigned size )); */
char *mystrdup P((char *str ));
char *myrealloc P((char *s , unsigned size ));
char *myshrink P((char *s ));
void myfree P((char *s ));

#undef P

				/* special lower/upper case lists */
extern char *loweralpha;
extern char *upperalpha;

/****************************************************************************
 *  data used for lower-upper case lists
 *
 *  notice that the lists per se are invisible outside this file
 */
static char lower_chars[256];	/* list of 'lower case' special chars       */
static char upper_chars[256];	/* list of corresponding 'upper case' forms */
static char *lp;		/* 'lower-case' list pointer */
static char *up;		/* 'upper-case' list pointer */

/*************************************************************************
 * NAME
 *    init_luwfc
 * ARGUMENTS
 *    none
 * DESCRIPTION
 *    Initialize the lower-upper case lists.
 * RETURN VALUE
 *    none
 */
void init_luwfc()
{
lp  = lower_chars;	/* init upper/lower arrays */
up  = upper_chars;
*lp = *up = NUL;
}

/*************************************************************************
 * NAME
 *    add_luwfc
 * ARGUMENTS
 *    rp - pointer to record contents
 *    ap - pointer to word formation characters (used only by AMPLE)
 * DESCRIPTION
 *    Scan record contents for character pairs.  The first member
 *    is added to the lower case list, the second is added to the
 *    upper case list.
 *    This assumes that init_luwfc has been called.
 * RETURN VALUE
 *    none
 */
char *add_luwfc(rp, ap)
char *rp;
char *ap;
{
int k;
static char errhead[] = "\nWarning: ";
short next_is_lower;

next_is_lower = TRUE;

if (*rp == NUL)
    printf("%sEmpty lower-upper word formation character field ",
	   errhead );
else
    {
    while (*rp != NUL)
        {
	k = (*rp++) & 0377;
	if (!myisspace(k))
	    {
	    if (next_is_lower)
	        {
		if (strchr(lower_chars,k)==(char *)NULL)
		    {
		    *lp++ = k;	/* add lower-case character */
		    *lp = NUL;
#ifndef SYNTHESIS
		    *ap++ = k;	/* add alphabetic character */
		    *ap = NUL;
#endif
		    next_is_lower = FALSE;
		    }
		else
		   {	  	/* lowercase char already defined */
		    		/* skip to next character, if any */
		    while (*rp != NUL && myisspace(*rp))
		                    rp++;
		    printf("%sLower case character %c already used in a ",
			   errhead, k );
		    printf("\\luwfc field:\n\t\t\twill ignore it ");
		    if (*rp)
		        {
			k = (*rp) & 0377;
			rp++;		/* skip over next char */
			printf("and its uppercase mate %c.", k);
		        }
		    }
	        }
	    else
	        {
		if (strchr(upper_chars,k)==(char *)NULL)
		    {
		    *up++ = k;	/* add upper-case character */
		    *up = NUL;
#ifndef SYNTHESIS
		    *ap++ = k;	/* add alphabetic character */
		    *ap = NUL;
#endif
		    }
		else
		    {		/* uppercase char already defined */
		    		/* skip it and its lowercase mate */
		    printf("%sUpper case character %c already used in a ",
			   errhead, k );
		    printf("\\luwfc field:\n\t\t\twill ignore it");
		    k = *(--lp) & 0377;
		    printf(" and its lowercase mate %c.", k);
		    *lp     = NUL;	/* remove lowercase mate from lower */
#ifndef SYNTHESIS
		    *(ap--) = NUL;	/* list and word formation list */
#endif
		    }
		next_is_lower = TRUE;
	        }
	    }
        }
    if (!next_is_lower)
        {
	k = *(--lp) & 0377;	/* remember last character */
	*lp = NUL;	/* remove last lower case character from lower */
	printf("%sMismatched lower-upper word formation character pair:",
	       errhead );
	printf("\n\t\t\twill ignore character %c.", k);
        }
    }
return(ap);
}

/*************************************************************************
 * NAME
 *    set_luwfc
 * ARGUMENTS
 *    none
 * DESCRIPTION
 *    If lower-upper case lists are non-empty, display the pairs
 *    and allocate memory for them
 * RETURN VALUE
 *    none
 */
void set_luwfc()
{

if (strlen(lower_chars))
    {
    loweralpha = myalloc( (unsigned)strlen(lower_chars)+1);
    strcpy(loweralpha, lower_chars);
    upperalpha = myalloc( (unsigned)strlen(upper_chars)+1);
    strcpy(upperalpha, upper_chars);
    fprintf(stderr, "\n\t      Special lowercase alphas = %s", loweralpha );
    fprintf(stderr, "\n\tCorresponding uppercase alphas = %s", upperalpha );
    }
else
    {
    loweralpha = upperalpha = (char *) NULL;	/* weren't any */
    }
}
