/*	GETWD.C - get next sequence of non-whitespace characters
 ***************************************************************************
 *
 *	char *skipwhite(cp)
 *	char *cp;
 *
 *	char *getwd(cp)
 *	char *cp;
 *
 ***************************************************************************
 *	EDIT HISTORY
 *	26-Feb-87	H.A. Black
 *	27-Feb-87	H.A. Black
 *	14-Jun-88	SRMc - use <ctype.h> macros
 *	 1-Aug-88	SRMc - rewrite to get it to work with MSDOS Aztec C
 *	21-Oct-88	SRMc - reorganize the file header comments
 *	27-Jul-89	hab  - add Copyright 1989
 *	01-Aug-89	ab/hab - Define myisspace() to handle 8-bit characters
 ***************************************************************************
 * Copyright 1988, 1989 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */
#include <stdio.h>
#include <ctype.h>
#ifndef isascii
#define isascii(x) (!(x & ~0177))
#endif
#define NUL '\0'		/* the ASCII NUL character */
#define myisspace(x) (isascii(x) ? isspace(x) : 0)

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

/* getwd.c */
char *skipwhite P((char *cp ));
char *getwd P((char *cp ));

#undef P

/****************************************************************************
 * NAME
 *    skipwhite
 * ARGUMENTS
 *    cp - pointer to NUL-terminated character string
 * DESCRIPTION
 *    Skip over any leading white space.
 * RETURN VALUE
 *    pointer to the first nonwhitespace character
 */
char *skipwhite(cp)
char *cp;
{
register char *p;

if ((cp == (char *)NULL) || (*cp == NUL))
    return(cp);

for ( p = cp ; myisspace(*p) ; ++p )
    ;
return(p);
}

/****************************************************************************
 * NAME
 *    getwd
 * ARGUMENTS
 *    cp - pointer to NUL-terminated character string
 * DESCRIPTION
 *    Get the next "word' of the input by 
 * RETURN VALUE
 *    pointer to the first character beyond the end of the word, or on the
 *    end of the word if there is only one word left in the line.
 */
char *getwd(cp)
char *cp;
{
register char *p;

if ((cp == (char *)NULL) || (*cp == NUL))
    return(cp);

p = skipwhite(cp);		/* skip leading white space */
while( (*p != NUL) && !myisspace(*p))
    p++;			/* skip over nonwhitespace */
if (*p != NUL)
    {
    *p++ = NUL;		/* terminate this lexical item */
    p = skipwhite(p);		/* skip forward to the next item */
    }
return(p);
}
