/*	CLASS.H - define class structures for AMPLE and STAMP programs
 ***************************************************************************
 *
 *	struct string_class
 *	struct morph_class
 *	struct cat_class
 *
 ***************************************************************************
 *	EDIT HISTORY
 *	 3-May-88	Steve McConnel
 *	21-Oct-88	SRMc - reorganize the file header comments
 *	17-May-89	SRMc - define struct morph_class for real
 ***************************************************************************
 * Copyright 1988, 1989 by the Summer Institute of Linguistics, Inc.
 * All rights reserved.
 */

/*************************************************************************
 * structure for string classes
 *
 *  All of the string classes are stored in a single linked list.
 *  Each node of this list has a pointer to the class name, and a pointer
 *  to a linked list of strings which comprise the members of the class.
 */
struct string_class
    {
    char *		 sc_name;	/* name of the string class */
    struct strlist *	 sc_members;	/* members of the string class */
    struct string_class *sc_next;	/* pointer to next string class */
    };

/*************************************************************************
 * structure for morpheme classes
 *
 *  All of the morpheme classes are stored in a single linked list.
 *  (Morpheme classes are currently stored the same as string classes.)
 */
struct morph_class
    {
    char *		mc_name;	/* name of the morpheme class */
    struct strlist *	mc_members;	/* members of the morpheme class */
    struct morph_class *mc_next;	/* pointer to next morpheme class */
    };

/*************************************************************************
 * structure for category classes
 *
 *  All of the category classes are stored in a single linked list.
 *  Each node of this list has a pointer to the class name, and a pointer
 *  to a NUL-terminated array of bytes which comprise the members of the
 *  class.
 */
struct cat_class
    {
    char *	      cc_name;		/* name of the category class */
    char *	      cc_members;	/* NUL-terminated byte string */
    struct cat_class *cc_next;		/* pointer to next category class */
    };
