
# line 2 "kgen.y"
/*
 *  This is the YACC syntax for the PC kimmo table generator program.
 *  
 *  04/18/91  Version 0.2
 *
 *            Do not strip blanks from rule description field.
 *            Allow multiple underscores.
 *            Change DEFAULT keyword to PAIRS.
 *            Allow optional new line after PAIRS and RULE.
 *            Allow optional END keyword which terminates parse.
 */

#ifdef PC
#include <alloc.h>
#endif

#include <stdio.h>
#include <ctype.h>

#define EXTERN extern
#include "kgen.h"


#define YYDEBUG 1
EXTERN int yydebug = 0;

int subset_section = 1;    /* true whenever an undefined subset name should
                              be treated as the start of a definition */

char segstr[128];          /* temporary holder for strings of segments */
char savesegstr[128];
int segstrusd = 0;         /* next available location in segstr */

int altusd = 0;            /* index of alternate set we are filling */

#define MAXALT 40

struct altset {               /* zero terminated strings of segments/SUBSETs */
   short alts[MAXSTR];
} altset[2];

int first_rule = 1;        /* true until first RULE seen */


# line 47 "kgen.y"
typedef union  {
   int ival;
   struct lstr *lval;
} YYSTYPE;
# define SEGMENT 257
# define SUBSET_KEYWORD 258
# define SUBSET_NAME 259
# define PAIRS 260
# define RULE 261
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 224 "kgen.y"


/*
 *  Yylex is called by Yacc whenever it is ready to scan the next token
 *  from the input stream.
 *  We return:
 *
 *      0            on end of file
 *      SEGMENT      a lexical or surface segment
 *      SUBSET_NAME  a subset name
 *      RULE, PAIRS, SUBSET   the corresponding keyword
 *      c            an ascii delimeter ( _ < > ... )
 */

yylex()
{
   int c;
   static int lastc = 0;

   if (lastc == '\n') {
      curlineind = 0;
      curline[0] = 0;
   }

   /*  Skip leading blanks
    */
   while ((c = getchar()) == ' ')
      if (curlineind+1 < sizeof(curline)) {
         curline[curlineind++] = ' ';
         curline[curlineind] = 0;
      }
   if (c == EOF)
      return 0;

   while (c == ';' || c == '!' || c == ' ') {
      /*  Skip comment characters
       */
      if (c == ';') {
         do {
            c = getchar();
            if (c == EOF)
               return 0;
         } while (c != '\n');
         break;
      } 
      else if (c == '!') {
         do {
            c = getchar();
            putchar(c);
            if (c == EOF)
               return 0;
         } while (c != '\n');
         c = getchar();
      }
      else
         c = getchar();
   }

   lastc = c;
   yylval.ival = c;
   if (curlineind+1 < sizeof(curline)) {
      curline[curlineind++] = c;
      curline[curlineind] = 0;
   }

   if ( c >= 'A' && c <= 'Z')
      return get_subset_name(c);
   else
      if ( index("=<>/:|_*[]{}(),\n", c) != NULL)
         return(c);

   return(SEGMENT);
}


index(str, c)
char *str;
int c;
{
   for (; *str; ++str)
      if (*str == c)
         return 1;

   return NULL;
}



/*
 *   At this point a subset name (or the keyord SUBSET or PAIRS)
 *   appears in the input.  Gather all the characters up to the first
 *   blank.
 *
 *   If we are in the subset definition section we must not have seen this
 *   identifier previously.  If we are not in the subset section we
 *   must have already seen it.
 *
 *   Set lval to the index of the identifier and return token type
 *   SUBSET.
 */

get_subset_name(c)
char c;              /* first character in token */
{
   char name[MAXSTR];
   int nameind = 0;

   memset(name, 0, MAXSTR);
   name[nameind++] = c;

   while ( isalpha(c = getchar()) ) {
      if (curlineind+1 < sizeof(curline)) {
         curline[curlineind++] = c;
         curline[curlineind] = 0;
      }

      if (nameind < MAXSTR-1) 
         name[nameind++] = c;
      else {
         fprintf(stderr, "\n\nSubset name (%s) too long...\n", name);
         exit(1);
      }
   }
   name[nameind] = 0;
   ungetc(c, stdin);    /* push back character that is not part of name */

   if (strcmp(name, "SUBSET") == 0)
      return SUBSET_KEYWORD;

   if (strcmp(name, "PAIRS") == 0)
      return PAIRS;

   if (strcmp(name, "RULE") == 0)
      return RULE;

   if (strcmp(name, "END") == 0)
      return 0;

   yylval.ival = check_subset_name(name);
   if (debug >= 3)
      printf("check_subset_name(%x) = %d\n", name, yylval.ival);

   return yylval.ival & SUBSET ? SUBSET_NAME : SEGMENT;
}


/*
 *   If we are in subset section and named subset is not defined
 *   setup to define subset.
 *   If we are in subset section and named subset is already defined
 *   then we have a duplicate subset defintion.
 *
 *   If we are NOT in subset section and named subset is not defined
 *   then we have a reference to an undefined subset name.
 *   If we are NOT is subset section and named subset is defined then
 *   return the subset index.
 */

check_subset_name(name)
char *name;
{
   int i;

   for (i=0; i<subsetusd; ++i) 
      if (strcmp(name, subset[i].subname) == 0)
         break;

   if (i == subsetusd) {
      /*  Subset name not found
       */
      if ( subset_section ) {
         if (subsetusd >= MAXSUBSET) {
            fprintf(stderr, "\n\nToo many sets defined...\n");
            exit(1);
         }
         ++subsetusd;
         strcpy(subset[i].subname, name);
         return i | SUBSET;
      }
      else {
         /*  Undefined single character names are assumed to represent
          *  capital letters and not undefined subsets.
          */
         if (strlen(name) == 1) 
            return name[0];
         fprintf(stderr, "\n\nUndefined subset (%s) referenced...\n", name);
         exit(1);
      }
   }
   else {
      /* Subset name found.
       */
      if ( subset_section ) {
         fprintf(stderr, "\n\nDuplicate definition for subset (%s) ...\n", name);
         exit(1);
      }
      else {
         return i | SUBSET;
      }
   }
}



/*
 *  Add a single character the 'segstr' array and check for overflow.
 */

add_to_segstr(c)
char c;
{
   if (segstrusd+1 >= sizeof(segstr)) {
      fprintf(stderr, "\nToo many characters in set...\n");
      exit(1);
   }

   segstr[segstrusd] = c;
   ++segstrusd;
   segstr[segstrusd] = 0;
}



/*
 *  This routine is called from the parser immediately after it recoginizes
 *  that this is an optional ( => ) rule.
 *  It modifies the segset index (possibly more than one if {}'s)
 *  to all mark the current point as the COMMIT point.
 */

add_opt_lhs(str)
struct lstr *str;
{
   short *txt = str->text;

   while (*txt) {     /* examine all alaternates */
      *txt |= COMMIT;          /* set COMMIT flag */
      add_column(*txt, 1);     /* create column and mark default transition
                                  for this column to be to FAIL state */
      ++txt;
   }
   if (debug >= 2)
      dumplstr("after add_opt_lhs", str);
}



/*
 *  This routine is called by parser immediately after it recognizes that
 *  it has an obligatory rule ( <= ).
 *  It modifies the lists of pairs pointed to by lhs.
 */

add_obl_lhs(str)
struct lstr *str;
{
   short *txt = str->text;
   int alt_flag;

   while (*txt) {
      /*  Within an obligatory rule 0:X is a special case.
       *  We translate
       *      0:x <= a _ b
       *  To
       *      Forbid  a b
       *  SEE R49 in PC-KIMMO book 
       *  Also the generator cannot handle the following:
       *    {x,y}:{0,z} <= _ b
       *  so we forbid it.
       */
      if (segset[*txt & INDEXMASK].lexseg == '0') {
         short *q = txt+1;
         for (; *q; ++q)
            if (segset[*q & INDEXMASK].lexseg != '0') {
               fprintf(stderr, "Cannot mix X:0 and X:Y in alternate...\n");
               exit(1);
	    }
         *txt = 0;   
         break;
      }

      /*  Within an obligatory rule we change the specified pair into
       *  a string that looks for any other mapping.
       *  We also make sure that the original pair is one of the columns
       *  so that it can be used to match on the OK case.
       */
      add_column(*txt, 0);
      alt_flag = *txt & ALTERNATIVE;
      *txt = create_segset(segset[*txt & INDEXMASK].lexseg,
                       segset[*txt & INDEXMASK].surfseg | COMPLEMENT);
      *txt |= alt_flag;
      add_column(*txt, 0);
      ++txt;
   }

   if (debug >= 2)
      dumplstr("after add_obl_lhs", str);
}



/*
 *  Add a set of lexical/surface default pairs to table.
 */

add_to_defaults(lex, surf)
char *lex;
char *surf;
{
   if (strlen(lex) != strlen(surf)) {
      fprintf(stderr, "Number of lexical and surface characters does not match...\n");
      exit(1);
   }

   if (strlen(lex) + strlen(all_lex) >= MAXALL) {
      fprintf(stderr, "Too many default pairs defined...\n");
      exit(1);
   }

   strcat(all_lex, lex);
   strcat(all_surf, surf);
   allusd = strlen(all_lex);
}



/*
 *  Add a segment which is either a character or a subset index to
 *  a set of such characters.
 */

add_to_alternate(seg)
int seg;
{
   int len;

   len = tstrlen(altset[altusd].alts);
   if (len+1 >= MAXALT) {
      fprintf(stderr, "Too many characters within {}'s...\n");
      exit(1);
   }

   altset[altusd].alts[len] = seg;
}



/*
 *  A segment specification has been found of the form x:y where at least
 *  one of the entries has been specified using the {} notation.
 *  Expand this into a single lstr.
 */

struct lstr *
expand_alternate(is_alt1, alt1, is_alt2, alt2)
int is_alt1;
int alt1;
int is_alt2;
int alt2;
{
   struct lstr *tmp;
   int cnt;

   /*  If lexical and surface forms were both alternates we just verify
    *  that they contain the same number of choices.
    */
   if (is_alt1 && is_alt2) {
      if (alt2 == 0)
         tstrcpy(altset[1].alts, altset[0].alts);
      if (tstrlen(altset[0].alts) != tstrlen(altset[1].alts)) {
         fprintf(stderr, "Unmatched lengths in {}:{} ...\n");
         exit(1);
      }
   }

   /*  If the lexical form only is alternate we make N copies of the
    *  surface form so that there is a 1-1 match.
    */
   else if (is_alt1) {
      for (cnt=0; cnt<tstrlen(altset[0].alts); ++cnt)
         altset[1].alts[cnt] = alt2;
      altset[1].alts[cnt] = 0;
   }

   /*  If the surface form only is an alternate we make N copies
    *  of the lexical form.
    */
   else {
      for (cnt=0; cnt<tstrlen(altset[0].alts); ++cnt) {
         altset[1].alts[cnt] = altset[0].alts[cnt];
         altset[0].alts[cnt] = alt1;   
      }
      altset[1].alts[cnt] = 0;
   }

   tmp = crtpair(altset[0].alts[0], altset[1].alts[0]);
   tmp->text[0] |= ALTERNATIVE;
   for (cnt=1; altset[0].alts[cnt]; ++cnt) {
      tmp->text[cnt] = create_segset(altset[0].alts[cnt], altset[1].alts[cnt]);
      if (altset[0].alts[cnt+1])
         tmp->text[cnt] |= ALTERNATIVE;
   }
   if (debug >= 2)
      dumpstr("Expand alternate", tmp->text);

   memset(altset, 0, sizeof(altset));
   altusd = 0;
   return tmp;
}



/*
 *  Return the index of a segment set containing all lex/surface pairs
 *  which match lex/surf.
 *  Arguments to this routine can either be single segment ascii values
 *  or subset indices.   Subset indices have the SUBSET bit set on.
 */

create_segset(lex, surf)
int lex;
int surf;
{
   struct segset sset;
   int ind;
   int all;

   /*  If we already have a segset which has the correct name,
    *  return its index.   (also fills in name into sset if not found)
    */
   ind = findsegset(lex, surf, &sset);
   if (ind < segsetusd)
      return ind;

   if (segsetusd >= MAXSUBSET) {
      fprintf(stderr, "Too many segments defined...\n");
      exit(1);
   }

   /*  Find all lex/surf pairs which match the passed description
    *  and add them to a segset.
    */
   ind = 0;
   for (all=1; all<allusd; ++all)
      if (matches(all_lex[all], lex) && matches(all_surf[all], surf)) {
         if (ind >= MAXSUBSET) {
            fprintf(stderr, "Segset overflow...\n");
            exit(1);
         }
         sset.segs[ind++] = all;
      }

   /*  If we couldn't find any matching pairs and one of the segments
    *  was a subset, we abort with an error.
    *  Otherwise we add the new pair to the default pair array.
    */
   if (ind == 0) {
      if ((lex & SUBSET) || (surf & SUBSET) || (surf & COMPLEMENT)) {
         fprintf(stderr, "No pairs match %s:", segment_name(lex));
         fprintf(stderr, "%s...\n", segment_name(surf));
         exit(1);
      }
      if (debug > 2)
         printf("add pair %c:%c\n", lex, surf);
      all_lex[allusd] = lex;
      all_surf[allusd] = surf;
      sset.segs[ind++] = allusd++;
      if (allusd >= MAXALL) {
         fprintf(stderr, "Too many pairs defined...\n");
         exit(1);
      }
   }

   sset.segs[ind] = 0;

   memcpy(&segset[segsetusd], &sset, sizeof(sset));
   if (debug >= 2) {
      printf("Create_segset (%x) %s, ", segsetusd, segment_name(lex));
      printf("%s ", segment_name(surf));
      dumppairs("", sset.segs);
   }

   return segsetusd++;
}



/*
 *  Determine if there is already a segment set representing the
 *  passed pair.   If so return its index, otherwise return
 *  segsetusd.
 */

findsegset(lex, surf, sset)
int lex;
int surf;
struct segset *sset;
{
   int ind;

   memset(sset, 0, sizeof(struct segset));
   sset->lexseg = lex;
   sset->surfseg = surf;

   for (ind=0; ind<segsetusd; ++ind)
      if (sset->lexseg == segset[ind].lexseg &&
          sset->surfseg == segset[ind].surfseg)
               break;

   if (debug >= 3) {
      printf("findsegset (%x) %s, ", ind, segment_name(lex));
      printf("%s\n ", segment_name(surf));
   }

   return ind;
}



/*
 *  Create an lstr which contains a single pair of lex/surface segments.
 */

struct lstr *
crtpair(lex, surf)
int lex;
int surf;
{
   struct lstr *tmp = NULL;
   static int empty[2] = {0, 0};

   lstradd(&tmp, empty);
   memset(tmp->text, 0, MAXSTR * sizeof(short));
   tmp->text[0] = create_segset(lex, surf);

   return tmp;
}



/*
 *  Determine if an ascii character is
 *     1) equal to chk if it is single character
 *     2) a member of the subset of which chk is the index (chk & SUBSET)
 *     3) anything if chk == @
 *
 *  Note: if complement bit is set we invert the sense of the match.
 */

matches(seg, chk)
int seg;
int chk;
{
   char *p;
   int ans = 0;

   if (chk & SUBSET) {
      p = subset[chk & INDEXMASK].subs;
      for (; *p; p++)
         if (*p == seg)
            break;
      if (*p)
         ans = 1;
   }
   else if (chk == '@')
      ans = 1;
   else
      ans = ( seg == (chk & INDEXMASK) );

   if (chk & COMPLEMENT)
      ans = (! ans);

   if (debug >= 4) {
      printf("Matches  %s, ", segment_name(seg));
      printf("%s = %d\n ", segment_name(chk), ans);
   }

   return ans;
}




int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 63
# define YYLAST 263
int yyact[]={

    41,    82,    16,    41,    16,    27,    41,    41,    51,    25,
    52,    26,    41,    29,     4,    55,    10,    32,    43,    97,
    56,    43,    93,    35,    43,    43,    50,     3,    47,    88,
    43,    30,    37,    87,    70,    68,    31,    69,    67,    90,
    65,    46,    45,    49,    48,    34,     6,     4,    62,    75,
    77,    40,    12,    94,    40,    36,    53,    40,    40,     2,
    60,    61,    38,    40,    63,    64,    13,    54,    59,     9,
    18,    11,    42,     8,    20,     7,    44,    28,    19,     5,
     1,    39,    79,    27,    80,    76,    27,    81,    23,    27,
    27,    58,    24,    59,    33,    27,    59,    59,    89,    22,
    96,    21,    15,    78,    91,    95,     0,     0,     0,    92,
     0,     0,    59,    54,     0,     0,    66,    98,   100,     0,
    99,    71,    73,     0,   101,    72,    74,     0,    59,    54,
     0,     0,     0,    59,    57,     0,     0,     0,    83,    25,
    85,    26,    84,     0,    86,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    25,     0,    26,
    25,     0,    26,    25,    25,    26,    26,     0,     0,    25,
     0,    26,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    14,    17,     0,    17,     0,     0,     0,     0,
     0,    32,    32 };
int yypact[]={

    37, -1000, -1000,    36, -1000, -1000, -1000,  -242,    -8, -1000,
    37,    -6, -1000, -1000,    37,  -118, -1000,    37,  -246, -1000,
  -240,   -33,   -19,   -14,   -15, -1000, -1000,  -249, -1000, -1000,
     5, -1000, -1000,    10, -1000,   -33,   -34, -1000, -1000,     6,
   -28,   -28,   -18,  -248,   -20,   -27,   -24,   -26,  -118,  -118,
 -1000, -1000, -1000,  -240, -1000, -1000, -1000,   -33,   -34, -1000,
   -28, -1000, -1000,   -37,   -40,  -118, -1000,  -118, -1000,   -29,
   -32, -1000, -1000, -1000, -1000,    -5,     4,  -240, -1000,   -28,
   -71,   -28, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -25,
  -249,    36,     4, -1000,   -28,   -28, -1000,  -249, -1000,    36,
   -28, -1000 };
int yypgo[]={

     0,    66,   102,   101,    99,    72,    98,    26,    36,    76,
    94,    23,    32,    84,    81,    45,    80,    59,    79,    75,
    73,    71,    69,    56,    31,    27,    52,    50,    55,    49 };
int yyr1[]={

     0,    18,    16,    19,    19,    23,    22,    25,    25,    17,
    17,    24,    24,     8,    20,    20,    27,    26,    21,    21,
     1,     1,     2,     3,     3,     3,     3,     4,     4,     4,
     4,    10,    10,    15,    15,    15,    28,    28,    11,    11,
    12,    12,    12,    12,    13,    13,    14,    14,    14,    14,
    14,    14,    14,    14,    14,     5,     5,    29,     9,     6,
     6,     7,     7 };
int yyr2[]={

     0,     1,    10,     0,     4,     1,    13,     2,     4,     0,
     2,     3,     5,     3,     1,     4,     1,    15,     2,     4,
     9,     3,     5,     7,     7,     9,     9,     7,     7,     7,
     7,     3,     7,     5,     7,     5,     2,     4,     3,     5,
     3,     5,     9,     7,     5,     7,     7,     5,     5,     3,
     7,     7,     7,     5,     3,     3,     3,     1,    11,     5,
     7,     3,     3 };
int yychk[]={

 -1000,   -16,   -17,   -25,    10,   -18,    10,   -19,   -20,   -22,
   258,   -21,   -26,    -1,   260,    -2,    10,   261,   -17,    -1,
   -17,    -3,    -4,    -5,    -9,   257,   259,   123,   -17,   259,
   -24,    -8,   257,   -10,   -15,   -11,   -28,   -12,    95,   -14,
    91,    40,    -5,    58,    -9,    61,    60,    47,    58,    58,
    -7,   257,   259,   -23,    -8,    10,    10,   124,   -28,   -12,
   -11,    95,    42,   -11,   -11,    58,    -5,    58,    62,    61,
    60,    -5,    -9,    -5,    -9,   -29,   -24,   -27,   -15,   -11,
   -13,   124,    41,    -5,    -9,    -5,    -9,    62,    61,    -6,
    44,   -25,   -24,    93,   124,   -11,   125,    44,    -7,   -25,
   -11,    -7 };
int yydef[]={

     9,    -2,     1,    10,     7,     3,     8,    14,     0,     4,
     9,     2,    15,    18,     9,     0,    21,     9,     0,    19,
     0,     0,     0,     0,     0,    55,    56,     0,    22,     5,
     0,    11,    13,     0,    31,     0,     0,    38,    36,    40,
     0,     0,    49,     0,    54,     0,     0,     0,     0,     0,
    57,    61,    62,     0,    12,    16,    20,     0,    33,    39,
    35,    37,    41,     0,     0,    47,    48,    53,    23,    24,
     0,    27,    29,    28,    30,     0,     0,     0,    32,    34,
     0,     0,    43,    46,    51,    50,    52,    26,    25,     0,
     0,     6,     0,    42,     0,    44,    58,     0,    59,    17,
    45,    60 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"SEGMENT",	257,
	"SUBSET_KEYWORD",	258,
	"SUBSET_NAME",	259,
	"PAIRS",	260,
	"RULE",	261,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"ruleset : opt_eol",
	"ruleset : opt_eol subsets pairs rules",
	"subsets : /* empty */",
	"subsets : subsets subset",
	"subset : SUBSET_KEYWORD opt_eol SUBSET_NAME",
	"subset : SUBSET_KEYWORD opt_eol SUBSET_NAME segment_string eol",
	"eol : '\n'",
	"eol : eol '\n'",
	"opt_eol : /* empty */",
	"opt_eol : eol",
	"segment_string : oneseg",
	"segment_string : segment_string oneseg",
	"oneseg : SEGMENT",
	"pairs : /* empty */",
	"pairs : pairs pairlist",
	"pairlist : PAIRS opt_eol segment_string '\n'",
	"pairlist : PAIRS opt_eol segment_string '\n' segment_string eol",
	"rules : rule",
	"rules : rules rule",
	"rule : rule_keyword lhs rhs '\n'",
	"rule : '\n'",
	"rule_keyword : RULE opt_eol",
	"lhs : lhs_pair '=' '>'",
	"lhs : lhs_pair '<' '='",
	"lhs : lhs_pair '/' '<' '='",
	"lhs : lhs_pair '<' '=' '>'",
	"lhs_pair : segment ':' segment",
	"lhs_pair : alternate ':' segment",
	"lhs_pair : segment ':' alternate",
	"lhs_pair : alternate ':' alternate",
	"rhs : rhs_elm",
	"rhs : rhs '|' rhs_elm",
	"rhs_elm : pattern_list under",
	"rhs_elm : pattern_list under pattern_list",
	"rhs_elm : under pattern_list",
	"under : '_'",
	"under : under '_'",
	"pattern_list : pattern_element",
	"pattern_list : pattern_list pattern_element",
	"pattern_element : segment_pair",
	"pattern_element : segment_pair '*'",
	"pattern_element : '[' pattern_list alternative_list ']'",
	"pattern_element : '(' pattern_list ')'",
	"alternative_list : '|' pattern_list",
	"alternative_list : alternative_list '|' pattern_list",
	"segment_pair : segment ':' segment",
	"segment_pair : segment ':'",
	"segment_pair : ':' segment",
	"segment_pair : segment",
	"segment_pair : alternate ':' segment",
	"segment_pair : segment ':' alternate",
	"segment_pair : alternate ':' alternate",
	"segment_pair : alternate ':'",
	"segment_pair : alternate",
	"segment : SEGMENT",
	"segment : SUBSET_NAME",
	"alternate : '{' segment_or_subset",
	"alternate : '{' segment_or_subset alternates '}'",
	"alternates : ',' segment_or_subset",
	"alternates : alternates ',' segment_or_subset",
	"segment_or_subset : SEGMENT",
	"segment_or_subset : SUBSET_NAME",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 80 "kgen.y"
{ if (debug >= 5) yydebug = 1; } break;
case 5:
# line 88 "kgen.y"
{ subset_section = 0; } break;
case 6:
# line 89 "kgen.y"
{ if (strlen(segstr) >= MAXMEMBERS) {
                                          fprintf(stderr, 
                                              "SUBSET too long...\n");
                                          exit(1);
				       }
                                       strcpy(subset[subsetusd-1].subs,
                                              segstr);
                                       if (debug > 1)
                                          printf("%d [%s] %s\n", 
                                                 subsetusd-1,
                                                 subset[subsetusd-1].subname,
                                                 segstr);
                                       subset_section = 1;
                                     } break;
case 11:
# line 112 "kgen.y"
{ segstrusd = 0;
                                       add_to_segstr(yypvt[-0].ival); } break;
case 12:
# line 114 "kgen.y"
{ add_to_segstr(yypvt[-0].ival); } break;
case 13:
# line 116 "kgen.y"
{ yyval.ival = yylval.ival; } break;
case 14:
# line 122 "kgen.y"
{ subset_section = 0; } break;
case 16:
# line 126 "kgen.y"
{ strcpy(savesegstr, segstr); } break;
case 17:
# line 127 "kgen.y"
{ add_to_defaults(savesegstr, segstr); } break;
case 20:
# line 138 "kgen.y"
{ build_table(yypvt[-1].lval); } break;
case 21:
# line 139 "kgen.y"
{ yyval.ival = 0;          } break;
case 22:
# line 141 "kgen.y"
{ if (first_rule) {
                                         dump_kimmo_header();
                                         first_rule = 0;
				      }
                                      yyval.ival = 0;
                                    } break;
case 23:
# line 149 "kgen.y"
{ add_opt_lhs(lhs); } break;
case 24:
# line 150 "kgen.y"
{ add_obl_lhs(lhs); } break;
case 25:
# line 151 "kgen.y"
{ yyval.ival = 1; } break;
case 26:
# line 152 "kgen.y"
{ lstradd(&lhs, lhs->text);
                                      add_opt_lhs(lhs->nextstr);
                                      add_obl_lhs(lhs); } break;
case 27:
# line 157 "kgen.y"
{ lhs = crtpair(yypvt[-2].ival, yypvt[-0].ival); } break;
case 28:
# line 158 "kgen.y"
{ lhs = expand_alternate(1,  0, 0, yypvt[-0].ival); } break;
case 29:
# line 159 "kgen.y"
{ lhs = expand_alternate(0, yypvt[-2].ival, 1, 0); } break;
case 30:
# line 160 "kgen.y"
{ lhs = expand_alternate(1,  0, 1, 1); } break;
case 31:
# line 164 "kgen.y"
{ yyval.lval = yypvt[-0].lval; } break;
case 32:
# line 165 "kgen.y"
{ yyval.lval = lstrapp(yypvt[-2].lval, yypvt[-0].lval); } break;
case 33:
# line 169 "kgen.y"
{ yyval.lval = lstralt(yypvt[-1].lval, lhs, 0); } break;
case 34:
# line 170 "kgen.y"
{ yyval.lval = lstralt(yypvt[-2].lval, 
                                                    lstralt(lhs, yypvt[-0].lval, 0),
                                                    0); } break;
case 35:
# line 173 "kgen.y"
{ yyval.lval = lstralt(lhs, yypvt[-0].lval, 0); } break;
case 38:
# line 180 "kgen.y"
{ yyval.lval = yypvt[-0].lval; } break;
case 39:
# line 181 "kgen.y"
{ yyval.lval = lstralt(yypvt[-1].lval, yypvt[-0].lval, 1); } break;
case 40:
# line 184 "kgen.y"
{ yyval.lval = yypvt[-0].lval; } break;
case 41:
# line 185 "kgen.y"
{ yypvt[-1].lval->text[0] |= REPEAT; 
                                                    yyval.lval = yypvt[-1].lval;
                                                  } break;
case 42:
# line 189 "kgen.y"
{ yyval.lval = lstrapp(yypvt[-2].lval, yypvt[-1].lval); } break;
case 43:
# line 190 "kgen.y"
{ yyval.lval = lstropt(yypvt[-1].lval); } break;
case 44:
# line 193 "kgen.y"
{ yyval.lval = yypvt[-0].lval; } break;
case 45:
# line 195 "kgen.y"
{ yyval.lval = lstrapp(yypvt[-2].lval, yypvt[-0].lval); } break;
case 46:
# line 198 "kgen.y"
{ yyval.lval = crtpair(yypvt[-2].ival, yypvt[-0].ival); } break;
case 47:
# line 199 "kgen.y"
{ yyval.lval = crtpair(yypvt[-1].ival, '@'); } break;
case 48:
# line 200 "kgen.y"
{ yyval.lval = crtpair('@', yypvt[-0].ival); } break;
case 49:
# line 201 "kgen.y"
{ yyval.lval = crtpair(yypvt[-0].ival, yypvt[-0].ival); } break;
case 50:
# line 202 "kgen.y"
{ yyval.lval = expand_alternate(1,  0, 0, yypvt[-0].ival); } break;
case 51:
# line 203 "kgen.y"
{ yyval.lval = expand_alternate(0, yypvt[-2].ival, 1, 0); } break;
case 52:
# line 204 "kgen.y"
{ yyval.lval = expand_alternate(1,  0, 1, 1); } break;
case 53:
# line 205 "kgen.y"
{ yyval.lval = expand_alternate(1,  0, 0, '@');} break;
case 54:
# line 206 "kgen.y"
{ yyval.lval = expand_alternate(1,  0, 1, 0); } break;
case 55:
# line 209 "kgen.y"
{ yyval.ival = yylval.ival; } break;
case 56:
# line 210 "kgen.y"
{ yyval.ival = yylval.ival; } break;
case 57:
# line 213 "kgen.y"
{ add_to_alternate(yypvt[-0].ival); } break;
case 58:
# line 214 "kgen.y"
{ yyval.ival = altusd++; } break;
case 59:
# line 216 "kgen.y"
{ add_to_alternate(yypvt[-0].ival); } break;
case 60:
# line 217 "kgen.y"
{ add_to_alternate(yypvt[-0].ival); } break;
case 61:
# line 220 "kgen.y"
{ yyval.ival = yylval.ival; } break;
case 62:
# line 221 "kgen.y"
{ yyval.ival = yylval.ival; } break;
	}
	goto yystack;		/* reset registers in driver code */
}
