/*  The following defines are used to mark segment types.
 *  When consecutive segsets form a group of alternative ( {}'s )
 *  all except the last are flagged with the alternative marker.
 *  These flags are used within the text field of lstr's.
 *
 *  COMMIT marks a place in a string of segments at which if we have
 *  match up to this point we must continue to match for the remainder
 *  of the string or else cause the FSM to halt in a failed state.
 *  For example:  x:y => a _ c d,  If we see a:a x:y in the input we
 *  "commit" and will fail unless we see c:c d:d immediately following.
 */
#define ALTERNATIVE  0x4000
#define REPEAT       0x2000    /* mark an *'ed segset */
#define COMMIT       0x1000
#define INDEXMASK    0x00ff

/*   Lstr's are strings of references to segsets.
 *   Lstr's may be linked into linear lists via nextstr.
 */
#define MAXSTR 40

struct lstr {
   short text[MAXSTR];          /* zero terminated array of segset indices */
   struct lstr *nextstr;        /* next string in list */
};


/*  The following areas contain all the the lexical/surface
 *  pairs present in the tables.
 */
#define MAXALL 256

EXTERN int allusd;               /* number of lex/surf pairs defined */
EXTERN char all_lex[MAXALL];
EXTERN char all_surf[MAXALL];


/*  The following variables describe the generated state transition
 *  table.
 */
#define MAXCOL 64
#define MAXSTATE 64

EXTERN int stateusd;          /* number of states in use */
EXTERN int colusd;            /* number of columns in use */
EXTERN short colseg[MAXCOL];  /* segset index of column header */

EXTERN struct state {
   short context[MAXSTR]; /* segset indices we transversed to reach state */
   int commit;            /* true if we are past the COMMIT flagged segment */
   short next[MAXSTATE];  /* next state for each column */
} state[MAXSTATE];

EXTERN int default_to_fail[MAXCOL];   /* when true any entry in the corresponding
                                  column will be defaulted to the failure
                                  transition if no other transition is
                                  provided */

#define FAIL -1    /* marks transition to a failure state */


#define MAXSUBSET 63
#define MAXNAME 8
#define MAXMEMBERS 64


EXTERN int subsetusd;          /* number of subsets defined */

EXTERN struct subset {
   char subname[MAXNAME];            /* subset name */
   char subs[MAXMEMBERS];            /* subset members, null terminated */
} subset[MAXSUBSET];



/*
 *  The following flags may be present in the lexseg/surfseg fields.
 *  SUBSET indicates the lower 8 bits contains a subset index
 *  insetad of a single ascii character.
 *  COMPLEMENT indicates that we should match everything which is not
 *  in the subset or segment.
 */

#define SUBSET      0x4000
#define COMPLEMENT  0x2000

EXTERN int segsetusd;           /* number of segment sets used */

EXTERN struct segset {
   short lexseg;                 /* lexical segment or subset */
   short surfseg;                /* surface segment or subset */
   int modified;                 /* true if we have made a modified copy */
   short segs[MAXSUBSET];        /* lexical/surface character pairs */
} segset[MAXSUBSET];




struct lstr *lstropt(), *lstralt(), *crtpair(), *lstrapp();
char *segset_name(), *segment_name();

EXTERN struct lstr *lhs;         /* this is a list of strings containing the
                             pairs defined on the left hand side of the
                             current rule */

EXTERN int debug;     /* global debug output flag */


EXTERN char curline[256];      /* current text line */
EXTERN int curlineind;         /* position in current line */