/* put4.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * $Id$
 *
 */

#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"

#include <stdio.h>
#include <fcntl.h>
#include "emalloc.h"
#include "blkheader.h"

char *progname = "put4";
int AsciiTrace = 0;

/** Unix system calls: **/
extern void exit();

/** Unix Library Functions: **/

/** liblqtext Library Functions: **/

/** Routines in this file which need declaring: **/

/** **/

static int ErrorCount = 0;

#define N_LONG 64

INLINE void Test(p, L)
    unsigned char *p;
    unsigned long L;
{
    unsigned char sentinel = 37;
    unsigned long R;

    p[4] = sentinel;

    Put4(p, L);

    if (p[4] != sentinel) {
	Error(E_WARN, "Put4 Overwrote sentinel value %d with %d",
		sentinel, p[4]);
	p[4] = sentinel;
    }

    R = Get4(p);

    if (p[4] != sentinel) {
	Error(E_WARN, "Put4 Overwrote sentinel value %d with %d",
		sentinel, p[4]);
    }

    if (R != L) {
	Error(E_WARN, "Wrote %ld, Read %ld, should be the same", L, R);
	++ErrorCount;
    }
}

int
main(ac, av)
    int ac;
    char *av[];
{
    int i;
    unsigned long L;
    unsigned char *buf;
    unsigned char **bufp;

    if (ac != 1) {
	Error(E_FATAL|E_USAGE, "Usage: %s\n", av[0]);
    }

    fprintf(stderr, "%s: ** testing put4 and get4 **\n", progname);

    buf = (unsigned char *) emalloc(4 * N_LONG);

    /* Test pattern: want to try some special cases:
     * 0L
     * -1L
     * powers of 2 from 2^0 to 2^30 plus or minus one
     * then try a few others.  Try each number in two
     * places to make sure we don't over-run.
     */

    Test(buf, 0L);
    Test(buf, (unsigned long) -1L);
    L = 1L;
    for (i = 0; i < 32; i++) {
	Test(buf, L - 1);
	Test(buf, L);
	Test(buf, L + 1);
	L *= 2;
    }

    for (i = 6; i < 500; i++) {
	int j;

	L = 17 * i + 37;
	for (j = 0; j < 64; j++) {
	    Test(&buf[j], L);
	    bufp = &buf;
	    Test(&(*bufp)[j + 3], L);
	}
    }

    if (ErrorCount == 0) {
	fprintf(stderr, "%s: ** test passed.\n", progname);
	exit(0);
    } else {
	Error(E_FATAL, "**** ALERT **** Total of %d errors, should be 0",
			ErrorCount);
    }
    /*NOTREACHED*/
    exit(1);
}
