/* lqadmin.c -- Copyright 1992 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* Tell the lq-text database that files have moved.
 *
 * $Id: lqrename.c,v 1.1 92/02/15 04:03:36 lee Exp $
 */

#include "globals.h" /* defines and declarations for database filenames */

#include <stdio.h>
#include <sys/types.h>
#include <malloc.h>
#include "emalloc.h"
#include "fileinfo.h"

#define FIRST_ARCHVE_CHAR '('
#define LAST_ARCHIVE_CHAR ')'

static char *Revision = "$Id: lqrename.c,v 1.1 92/02/15 04:03:36 lee Exp $";

/* The position of the \n in the 26-char string returned by ctime(3): */
#define DATENEWLINE 24

char *progname;
int AsciiTrace = 0;

/** System calls and library functions used in this file: **/

/** Unix System calls: **/
extern void exit();
/** System Library Functions: **/

/** external lqtext functions: **/
extern void cleanupdb(), SetDefaults();
extern lqWriteAccess(); /* Allow write access to the database */
extern lqRenameFile();
int SaveFileInfo(), GetFilterType();
#ifndef efree
 extern void efree();
#endif
/** Functions defined within this file: **/
static void ReName();

int
main(argc, argv)
    int argc;
    char *argv[];
{
    extern int optind, getopt();
    /** extern char *optarg; (unused at the moment) **/
    int ch;
    int ErrorFlag = 0;
    char FileNameContainingChanges = 0;

    progname = argv[0];

    SetDefaults(argc, argv);

    /* All programs take Zz:Vv */
    while ((ch = getopt(argc, argv, "Zz:VvAax")) != EOF) {
	switch (ch) {
	case 'z':
	case 'Z':
	    break; /* done by SetDefaults(); */
	case 'V':
	    fprintf(stderr, "%s version %s\n", progname, Revision);
	    break;
	case 'x':
	    ErrorFlag = (-1);
	    break;
	case 'f':
	    if (FileNameContainingChanges) {
		fprintf(stderr, "%s: you must only use -f once; see -xv\n",
			progname);
		exit(1);
	    }
	case '?':
	    ErrorFlag = 1;
	    break;
	}
    }

    /* Normally put call to lrqError here to give a helpful message,
     * but not yet ready to ship the error handling package, sorry
     */
    if (ErrorFlag) {
	fprintf(stderr, "%s: usage: %s [options] [files]\n",progname,progname);
	fprintf(stderr, "%s: options are:\n", progname);
	fprintf(stderr, "\
	-d dir  -- use the lq-text database in the directory \"dir\"\n\
	-f file -- file contains old-file new-file pairs\n\
	-t N    -- set trace level to N [default: 0]\n\
	-V      -- print version information\n\
	-v      -- be verbose (same as -t 1)\n\
	-x      -- print %s explanation\n\
	-xv      -- print %s explanation\n\
\n\
Remaining options are paired: oldfilename newfilename\n",
	    AsciiTrace ? "a simpler" : "this",
	    AsciiTrace ? "this" : "a simpler"
	);
	if (AsciiTrace) {
	    fprintf(stderr, "\
Archives are described as ArchiveName%cMember%c\n\
Files ending in .Z are assumed to be compressed.\n",
		FIRST_ARCHVE_CHAR, 
		LAST_ARCHIVE_CHAR ? LAST_ARCHIVE_CHAR : ' '
	    );
	}
	exit((ErrorFlag > 0) ? 1 : 0);
    }

    if (optind >= argc && !FileNameContainingChanges) {
	fprintf(stderr,
	"%s: You must either give the -f option or specify file name pairs.\n",
		progname);
	fprintf(stderr, "\tuse %s -xv for further explanation.\n", progname);
	exit(1);
    } else if ((argc - optind) & 01) {
	fprintf(stderr, "%s: you must rename files in pairs.\n", progname);
	exit(1);
    }

    lqWriteAccess();

    /* Rename files */
    while (optind < argc) {
	ReName(argv[optind], argv[optind + 1]);
	optind += 2;
    }

    if (FileNameContainingChanges) {
	FILE *f = fopen(FileNameContainingChanges, "r");
	char buf[2000];

	if (!f) {
	    fprintf(stderr, "%s: Can't open list file \"%s\"\n",
		progname, FileNameContainingChanges);
	    exit(1);
	}
    }

    cleanupdb(); /* close dbm files */
    exit(0);
    /*NOTREACHED*/
    return 1; /* for lint and gcc... */
}

static void
ReName(OldName, NewName)
    char *OldName;
    char *NewName;
{
    extern t_FileInfo *GetFileInfo();
    long FID;
    extern long atol();
    extern t_FID Name2FID();

    t_FileInfo *FileInfo;

    if ((FID = Name2FID(OldName)) == (t_FID) 0) {
	fprintf(stderr, "%s: %s: not found in database\n", progname, OldName);
	return;
    }

    lqRenameFile(OldName, NewName);
}

