/* lines.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* lines - make a blocks-to-line-numbers map
 *
 * $Id: lines.c,v 1.1 92/03/30 21:37:27 lee Exp $
 */

#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"

#include <stdio.h>
#include <fcntl.h>
#include "wordrules.h"

/*** Declarations: ***/
/** System calls and library routines: **/
extern void exit();

/** System calls: **/

/** Unix Library Functions: **/

/** lqtext library functions: **/

/** functions defined within this file: */
static void Process(/*int fd; char *FileName*/);

/** Macros and variable definitions **/

char *progname = "lqlines"; /* Used for error messages */
int AsciiTrace = 0; /* required by liblq* for debugging/verbose */

static char *Revision = "$Id";

/** end of declarations... **/


int
main(argc, argv)
    int argc;
    char *argv[];
{
    extern int optind, getopt();  /* For getopt(3) */
    extern char *optarg;	  /* For getopt(3) */
    int ch;			  /* For getopt(3) */
    int ErrorFlag = 0;		  /* For getopt(3) */
    progname = argv[0];
	/* I see this as a library program, so I am leaving the full
	 * path.  lqaddfile(1L) and lqphrase(1L) set progname to be
	 * the filename of the command, rather than the full pathname.
	 */

    SetDefaults(argc, argv);
	/* Deal with any arguments that are understood by all lqtext
	 * programs.
	 */

    while ((ch = getopt(argc, argv, "VxZz:")) != EOF) {
	switch (ch) {
	case 'V':
	    fprintf(stderr, "%s version %s\n", progname, Revision);
	    break;
	case 'x':
	    ErrorFlag++;
	    break;
	case '?':
	    ErrorFlag++;
	    break;
	case 'z':
	case 'Z':
	    break; /* done by SetDefaults(); */
	}
    }

    /* Normally put call to lrqError here to give a helpful message,
     * but not yet ready to ship the full error handling package, sorry
     */
    if (ErrorFlag) {
	fprintf(stderr, "%s: options are:\n", progname);
	DefaultUsage();
	    /* DefaultUsage() prints the list of the standard options. */
	exit(1);
    }

    if (optind >= argc) {
	Error(E_FATAL|E_USAGE|E_XHINT, "usage: %s file [...]", progname);
    } else {
	while (optind < argc) {
	    int fd = open(argv[optind], O_RDONLY, 0);

	    if (fd < 0) {
		Error(E_WARN|E_SYS,
		    "couldn't open \"%s\" for reading - not processed",
		    argv[optind]
		);
		optind++;
		continue;
	    }

	    Process(fd, argv[optind]);

	    if (close(fd) < 0) {
		Error(E_WARN|E_SYS,
		    "problem closing input file \"%s\"",
		    argv[optind]
		);
	    }

	    ++optind;
	}
    }

    exit(0);
}

static void
Process(fd, FileName)
    int fd;
    char *FileName;
{
    /* read the file a line at a time and mark the line at which each
     * block starts.
     */
    char Block[FileBlockSize];
    unsigned long LineNumber = 1L; /* first line is numbered 1 usually */
    int i;

    while ((i = read(fd, Block, sizeof Block)) > 0) {
	register char *p;

	printf("%ld\n", LineNumber);
	for (p = Block; p - Block <= i; p++) {
	    if (*p == '\n') ++LineNumber;
	}
    }
    if (i < 0) {
	Error(E_WARN|E_SYS,
	    "failed to read %d bytes from fd %d = \"%s\"",
	    (int) sizeof Block, 
	    fd,
	    FileName
	);
    }
}

